% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberOfPWLsPerVerticalLevel.R
\name{numberOfPWLsPerVerticalLevel}
\alias{numberOfPWLsPerVerticalLevel}
\title{Count number of PWLs per vertical level}
\usage{
numberOfPWLsPerVerticalLevel(x, pwl_idx, depth_breaks = c(0, 30, 80, 150, Inf))
}
\arguments{
\item{x}{\link{snowprofile} or \link{snowprofileLayers} object}

\item{pwl_idx}{an index vector that corresponds to the layers of interest. Tip: this can also be a call to \link{findPWL}, see examples.}

\item{depth_breaks}{a vector of break points referring to absolute depth values. \code{Inf} is a placeholder for max depth.}
}
\value{
This function returns a \code{table} object
}
\description{
This is a wrapper function to bin several weak layers (or crusts) into vertical levels.
The layers to be binned can be controled with a provided index vector for full customization.
}
\examples{
SH_idx <- findPWL(SPpairs$C_day1, pwl_gtype = "SH")
numberOfPWLsPerVerticalLevel(SPpairs$C_day1, SH_idx)

numberOfPWLsPerVerticalLevel(SPpairs$C_day2, findPWL(SPpairs$C_day2))

}
\author{
fherla
}
