% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofileCaaml.R
\name{snowprofileCaaml}
\alias{snowprofileCaaml}
\title{Read a Caaml file into a snowprofile object}
\usage{
snowprofileCaaml(caamlFile, sourceType = NA)
}
\arguments{
\item{caamlFile}{'path/to/file.caaml'}

\item{sourceType}{choose 'manual', 'modeled', 'vstation', 'aggregate' or 'whiteboard'; if NA, the default will be chosen by \link{snowprofile}.}
}
\value{
snowprofile object
}
\description{
Read a Caaml file into a snowprofile object
}
\examples{

## load example caaml file that ships with package:
caamlFile <- system.file('extdata', 'example.caaml', package = 'sarp.snowprofile')

## read caaml file:
profile <- snowprofileCaaml(caamlFile, sourceType = 'vstation')


}
\author{
fherla
}
