% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_cat_freq_plot_docx.R,
%   R/prep_cat_freq_plot_docx.R
\name{embed_cat_freq_plot_docx}
\alias{embed_cat_freq_plot_docx}
\title{Create Word Report with Univariates for Categorical Columns Sharing Same Categories}
\usage{
embed_cat_freq_plot_docx(
  data,
  ...,
  inverse = FALSE,
  dep = tidyselect::everything(),
  indep = NULL,
  colour_palette = NULL,
  mesos_group = NULL,
  call = rlang::caller_env()
)

embed_cat_freq_plot_docx(
  data,
  ...,
  inverse = FALSE,
  dep = tidyselect::everything(),
  indep = NULL,
  colour_palette = NULL,
  mesos_group = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{inverse}{Flag, defaults to FALSE. If TRUE, swaps x-axis and faceting.}

\item{dep, indep}{\emph{Variable selections}

<\code{tidyselect}> // \emph{Default:} \code{NULL}, meaning everything for dep, nothing for indep.

Columns in \code{data}. Currently allows tidyselect-syntax, which will be removed.}

\item{colour_palette}{Character vector of colour codes.}

\item{mesos_group}{\emph{Specific group to compare with}

\verb{scalar<character>} // \emph{Default:} \code{NULL} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}

\item{call}{\emph{Internal call}

\verb{obj:<call>} // \emph{Default:} \code{rlang::caller_env()} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}
}
\value{
rdocx object, which can be saved with print() after loading the officer-package

rdocx object, which can be saved with print() after loading the officer-package
}
\description{
Create Word Report with Univariates for Categorical Columns Sharing Same Categories

Create Word Report with Univariates for Categorical Columns Sharing Same Categories
}
\examples{
library(officer) # To save the rdocx object to disk

test_docx_b13 <-
   ex_survey |>
   embed_cat_freq_plot_docx(dep = b_1:b_3,
              showNA = "never",
              descend = TRUE,
              return_raw = FALSE,
              hide_label_if_prop_below=0,
              data_label = "count",
              data_label_decimal_symbol = ",",
              digits = 1,
              label_font_size = 12,
              main_font_size = 12,
             plot_height_multiplier = .3,
             plot_height_fixed_constant = 1,
              vertical = FALSE,
              font_family = "sans")
print(test_docx_b13, target = tempfile(fileext = ".docx"))
library(officer) # To save the rdocx object to disk

test_docx_b13 <-
   ex_survey |>
   embed_cat_freq_plot_docx(dep = b_1:b_3,
              showNA = "never",
              descend = TRUE,
              return_raw = FALSE,
              hide_label_if_prop_below=0,
              data_label = "count",
              data_label_decimal_symbol = ",",
              digits = 1,
              label_font_size = 12,
              main_font_size = 12,
             plot_height_multiplier = .3,
             plot_height_fixed_constant = 1,
              vertical = FALSE,
              font_family = "sans")
print(test_docx_b13, target = tempfile(fileext = ".docx"))
}
