% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft_report.R
\name{draft_report}
\alias{draft_report}
\title{Automatically Draft a Quarto Report}
\usage{
draft_report(
  data,
  chapter_overview = NULL,
  ...,
  path,
  title = "Report",
  authors = NULL,
  mesos_report = FALSE,
  mesos_var = NULL,
  label_separator = " - ",
  name_separator = NULL,
  index_yaml_file = NULL,
  report_yaml_file = NULL,
  chapter_yaml_file = NULL,
  qmd_start_section_filepath = NULL,
  qmd_end_section_filepath = NULL,
  index_filename = "index.qmd",
  element_names = c("uni_cat_prop_plot", "uni_cat_freq_plot", "uni_cat_table",
    "uni_chr_table", "bi_catcat_prop_plot", "bi_catcat_freq_plot",
    "bi_catcat_prop_plot2", "bi_catcat_freq_plot2", "bi_catcat_table", "bi_sigtest"),
  sort_by = ".upper",
  data_label = saros::get_data_label_opts(),
  always_show_bi_for_indep = NULL,
  categories_treated_as_na = NULL,
  variables_always_at_top = NULL,
  variables_always_at_bottom = NULL,
  return_raw = TRUE,
  showNA = c("never", "always", "ifany"),
  totals = FALSE,
  hide_bi_entry_if_sig_above = 1,
  hide_test_if_n_below = 10,
  hide_result_if_n_below = 10,
  hide_chr_for_others = TRUE,
  hide_variable_if_all_na = TRUE,
  single_y_bivariates_if_indep_cats_above = 3,
  single_y_bivariates_if_deps_above = 20,
  digits = 1,
  data_label_decimal_symbol = ".",
  hide_label_if_prop_below = 0.01,
  hide_axis_text_if_single_variable = FALSE,
  label_font_size = 8,
  main_font_size = 8,
  x_axis_label_width = 20,
  plot_height_multiplier_per_horizontal_line = NA,
  plot_height_multiplier_per_vertical_letter = 0.2,
  plot_height_multiplier_per_facet = 0.95,
  plot_height_multiplier_per_legend_line = 1.1,
  plot_height_fixed_constant = 0,
  plot_height_max = 8,
  plot_height_min = 1.5,
  vertical_height = 12,
  vertical = FALSE,
  strip_angle = 0,
  png_scale = 1.2,
  png_width = 14,
  png_height = 16,
  font_family = "sans",
  colour_palette_nominal = NULL,
  colour_palette_ordinal = NULL,
  colour_na = "gray90",
  colour_2nd_binary_cat = NULL,
  table_main_question_as_header = FALSE,
  max_width_obj = 128,
  max_width_file = 64,
  max_clean_folder_name = 12,
  open_after_drafting = FALSE,
  organize_by = c("chapter", ".variable_label_prefix_dep", ".variable_name_indep",
    ".element_name"),
  arrange_output_by = c("chapter", ".variable_name_dep", ".variable_name_indep"),
  ignore_heading_for_group = c(".element_name", ".variable_type_dep", "chapter"),
  replace_heading_for_group = c(.variable_label_suffix_dep = ".variable_name_dep"),
  mesos_first = TRUE,
  descend = TRUE,
  require_common_categories = TRUE,
  panel_tabset_mesos = TRUE,
  pdf = TRUE,
  attach_chapter_dataset = TRUE,
  auxiliary_variables = NULL,
  flexi = FALSE,
  micro = FALSE,
  reps = 1000,
  information = c(".variable_label_dep", ".category", ".count", ".count_se",
    ".proportion", ".proportion_se", ".mean", ".mean_se", ".data_label",
    ".comb_categories", ".sum_value"),
  contents = c("intro", "not_used_category", "mode_max", "value_max", "value_min",
    "value_diff", "mean_max", "mean_min", "mean_diff", "median_max", "median_min",
    "median_diff", "variance_max", "variance_min"),
  include_numbers = TRUE,
  n_top_bottom = 1,
  log_file = NULL,
  serialized_format = c("rds", "qs"),
  tabular_format = c("delim", "xlsx", "csv", "csv2", "tsv", "sav", "dta"),
  translations = list(last_sep = " and ", download_report = "Download report (PDF)",
    intro_prefix = "We will now look at the questions asked regarding ", intro_suffix =
    "", mode_max_onfix = " on ", mode_max_prefix = "The most common responses were ",
    mode_max_suffix = "", not_used_prefix =
    "The following response categories were not used: ", not_used_suffix = "",
    value_max_prefix = "", value_max_infix =
    " {?is/are} the {dots$n_top_bottom} item{?s} where the most responded ",
    value_max_suffix = "", value_min_prefix = "", 
     value_min_infix =
    " {?is/are} the {dots$n_top_bottom} item{?s} where the fewest responded ",
    value_min_suffix = "", mean_onfix = "M = ", mean_max_prefix =
    "They have highest mean on ", mean_max_suffix = "", mean_min_prefix =
    "They have lowest mean on ", mean_min_suffix = "", median_onfix = "Median = ",
    median_max_prefix = "They have highest median on ", median_max_suffix = "",
    median_min_prefix = "They have lowest median on ", median_min_suffix = "",
    intro_by_prefix = "We will now look at the questions asked regarding ", 
    
    intro_by_infix = " broken down by ", intro_by_suffix = "", by_breakdown = " by ",
    n_equal_prefix = " (N &equals; ", n_equal_suffix = ")", table_heading_N =
    "Total (N)", by_total = "Everyone", sigtest_prefix = "Significance testing of ",
    sigtest_suffix = "", mesos_group_prefix = " Group: ", mesos_group_suffix = "",
    mesos_label_all_others = "Others", empty_chunk_text = "\\nText\\n",
    flexi_input_chapter = "Chapter(s):", flexi_input_dep = "Dependent variable(s):",
    flexi_input_indep = "Independent variable:", 
     flexi_input_mesos_group =
    "Filter:", flexi_figure_type = "Figure type:", flexi_data_label =
    "Summary to display", flexi_showNA = "Show NA (Missing)", flexi_sort_by = "Sort by",
    flexi_totals = "Totals", flexi_digits = "Digits after decimal", flexi_table =
    "Table", flexi_figure = "Figure", flexi_cols_variable_name = "Variable name",
    flexi_cols_variable_label = "Variable label", flexi_cols_category =
    "Response category", flexi_cols_count = "N", flexi_cols_count_se = "SE(N)",
    flexi_cols_proportion = "Proportion", 
     flexi_cols_proportion_se =
    "SE(Proportion)", flexi_cols_mean = "Mean", flexi_cols_mean_se = "SE(Mean)",
    flexi_cols_data_label = "Data label", flexi_cols_comb_categories =
    "Combined categories", flexi_cols_sum_value =
    "Sum of data label across combined categories", flexi_validate =
    "Error: Columns must have some categories in common.", flexi_settings = "Settings",
    flexi_basic_settings = "Basic", flexi_advanced_settings = "Advanced",
    flexi_input_indep_none = "<none>", flexi_figure_type_proportion = "Proportion", 
    
    flexi_figure_type_frequency = "Frequency", flexi_hide_label_if_prop_below =
    "Hide label if proportion below:")
)
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{chapter_overview}{\emph{What goes in each chapter}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

Data frame (or tibble, possibly grouped). One row per chapter. Should
contain the columns 'chapter' and 'dep', Optionally 'indep' (independent
variables) and other informative columns as needed.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{path}{\emph{Output path}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to save all output.}

\item{title}{\emph{Title of report}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Added automatically to YAML-header of index.qmd-file.}

\item{authors}{\emph{Authors of entire report}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

If NULL, infers from chapter_overview$authors, and collates for entire report.}

\item{mesos_report}{\emph{Whether to produce reports per mesos group}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}
If false, returns a regular single report.}

\item{mesos_var}{\emph{Variable in ´data´ indicating groups to tailor reports for}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Column name in data indicating the groups for which mesos reports will be produced.}

\item{label_separator}{\emph{Variable label separator}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

String to split labels on main question and sub-items.}

\item{name_separator}{\emph{Variable name separator}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

String to split column names in data between main question and sub-items}

\item{index_yaml_file, report_yaml_file}{\emph{Path to YAML-file to insert into index.qmd and report.qmd respectively}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to file used to insert header YAML, in index and report files.}

\item{chapter_yaml_file}{\emph{Path to YAML-file to insert into each chapter qmd-file}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to file used to insert header YAML, in each chapter.}

\item{qmd_start_section_filepath, qmd_end_section_filepath}{\emph{Path to qmd-bit for start/end of each qmd}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to qmd-snippet placed before/after body of all chapter qmds.}

\item{index_filename}{\emph{Index filename}

\verb{scalar<character>} // \emph{default:} \code{"index.qmd"} (\code{optional})

The name of the main index Quarto file (and its subfolder) used as landing
page for each report. Will link to a PDF (report.qmd) which collects all chapters.}

\item{element_names}{\emph{Elements to be reported}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Elements to be reported for all sets (batteries) of y-variables.}

\item{sort_by}{\emph{What to sort output by}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Sort output (and collapse if requested).

\describe{
\item{".top"}{The proportion for the highest category available in the variable.}
\item{".upper"}{The sum of the proportions for the categories above the middle category.}
\item{".mid_upper"}{The sum of the proportions for the categories including and above the middle category.}
\item{".mid_lower"}{The sum of the proportions for the categories including and below the middle category.}
\item{".lower"}{The sum of the proportions for the categories below the middle category.}
\item{".bottom"}{The proportions for the lowest category available in the variable.}
\item{".variable_label"}{Sort by the variable labels.}
\item{".id"}{Sort by the variable names.}
\item{".by_group"}{The groups of the by argument.}
\item{character()}{Character vector of category labels to sum together.}
}}

\item{data_label}{\emph{Data label}

\verb{scalar<character>} // \emph{default:} \code{"proportion"} (\code{optional})

One of "proportion", "percentage", "percentage_bare", "count", "mean", or "median".}

\item{always_show_bi_for_indep}{\emph{Always show bivariate for indep-variable}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Specific combinations with a by-variable where bivariates should always be shown.}

\item{categories_treated_as_na}{\emph{NA categories}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Categories that should be treated as NA.}

\item{variables_always_at_top, variables_always_at_bottom}{\emph{Top/bottom variables}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names in \code{data} that should always be placed at the top or bottom of figures/tables.}

\item{return_raw}{\emph{NOT IN USE}

\verb{scalar<integer>} // \emph{default:} \code{FALSE}

Whether to return the raw static element.}

\item{showNA}{\emph{Show/hide NA in categorical variables}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

Whether to show NA in categorical variables (one of c("ifany", "always", "never")).}

\item{totals}{\emph{Include totals}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to include totals in the output.}

\item{hide_bi_entry_if_sig_above}{\emph{p-value threshold for hiding bivariate entry}

\verb{scalar<double>} // \emph{default:} \code{1} (\code{optional})

Whether to hide bivariate entry if significance is above this value.
Defaults to showing all.}

\item{hide_test_if_n_below}{\emph{Threshold n for hiding significance test}

\verb{scalar<integer>} // \emph{default:} \code{0} (\code{optional})

If N is below this value, p-value will not be shown.}

\item{hide_result_if_n_below}{\emph{Hide result if N below}

\verb{scalar<integer>} // \emph{default:} \code{10} (\code{optional})

Whether to hide result if N for a given datasets (or mesos group) is below
this value. NOTE: Exceptions will be made to chr_table and chr_plot as these are
typically exempted in the first place. This might change in the future with
a separate argument.}

\item{hide_chr_for_others}{\emph{Hide open response displays for others}

\verb{scalar<logical>} // \emph{default:} \code{TRUE} (\code{optional})

For mesos reports using the element "chr_table", open responses are
displayed for also the entire sample (\code{FALSE}) or only for the mesos
group to ensure data privacy (\code{TRUE}).}

\item{hide_variable_if_all_na}{\emph{Hide variable from outputs if containing all NA}

\verb{scalar<boolean>} // \emph{default:} \code{TRUE} (\code{optional})

Whether to remove all variables (in particular useful for mesos) if all values are NA}

\item{single_y_bivariates_if_indep_cats_above}{\emph{Single y bivariates if indep-cats above ...}

\verb{scalar<integer>} // \emph{default:} \code{3} (\code{optional})

Figures and tables for bivariates can become very long if the independent
variable has many categories. This argument specifies the number of indep categories
above which only single y bivariates should be shown.}

\item{single_y_bivariates_if_deps_above}{\emph{Single y bivariates if dep-vars above ...}

\verb{scalar<integer>} // \emph{default:} \code{20} (\code{optional})

Figures and tables for bivariates can become very long if there are many dependent
variables in a battery/question matrix. This argument specifies the number of dep variables
above which only single y bivariates should be shown. Set to 0 to always show single y bivariates.}

\item{digits}{\emph{Decimal places}

\verb{scalar<integer>} // \emph{default:} \code{0L} (\code{optional})

Number of decimal places.}

\item{data_label_decimal_symbol}{\emph{Decimal symbol}

\verb{scalar<character>} // \emph{default:} \code{"."} (\code{optional})

Decimal marker, some might prefer a comma ',' or something else entirely.
NOTE: Future version will likely postpone formatting this until \code{gt()}, \code{kable()}, etc.}

\item{hide_label_if_prop_below}{\emph{Hide label threshold}

\verb{scalar<numeric>} // \emph{default:} \code{NULL} (\code{optional})

Whether to hide label if below this value.
NOTE: Future versions will likely distinguish between element_types.}

\item{hide_axis_text_if_single_variable}{\emph{Hide y-axis text if just a single variable}

\verb{scalar<boolean>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to hide text on the y-axis label if just a single variable}

\item{label_font_size}{\emph{Data labels font size}

\verb{scalar<integer>} // \emph{default:} \code{10} (\code{optional})

Font size for data labels.}

\item{main_font_size}{\emph{Main font size}

\verb{scalar<integer>} // \emph{default:} \code{12} (\code{optional})

Font size for all other text.}

\item{x_axis_label_width}{\emph{X-axis label width of plots}

\verb{scalar<integer>} // \emph{default:} \code{20} (\code{optional})

Width of the labels used for the categorical column names.}

\item{plot_height_multiplier_per_vertical_letter, plot_height_multiplier_per_horizontal_line}{\emph{Height multiplier}

\verb{scalar<double>} // \emph{default:} \code{.1}

Height in cm per chart entry, for all static plots.}

\item{plot_height_multiplier_per_facet}{\emph{Plot height multiplier per facet}

\verb{scalar<double>} // \emph{default:} \code{0.95} (\code{optional})

Multiplier for plot height per facet. Defaults to optimal at .95, i.e. slightly less than no change (1).}

\item{plot_height_multiplier_per_legend_line}{\emph{Plot height multiplier per legend line}

\verb{scalar<double>} // \emph{default:} \code{1.1} (\code{optional})

Multiplier for plot height per horizontal line of legend.
Defaults to optimal at 1.1, i.e. slightly more than no change (1).}

\item{plot_height_fixed_constant}{\emph{Height constant addition}

\verb{scalar<double>} // \emph{default:} \code{0}

Fixed height in cm to add to all static plots.}

\item{plot_height_max}{\emph{Maximum plot height}

\verb{scalar<double>} // \emph{default:} \code{10} (\code{optional})

Maximum height for the plot.}

\item{plot_height_min}{\emph{Minimum plot height}

\verb{scalar<double>} // \emph{default:} \code{2} (\code{optional})

Minimum height for the plot.}

\item{vertical_height}{\emph{Vertical height}

\verb{scalar<double>} // \emph{default:} \code{NULL} (\code{optional})

Height for vertical layout of plot? NEEDS CHECKING}

\item{vertical}{\emph{Orientation of plots}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

If FALSE (default), then horizontal plots.}

\item{strip_angle}{\emph{Angle on the facet strip in plots}

\verb{scalar<double>} // \emph{default:} \code{0}}

\item{png_scale}{\emph{PNG scale}

\verb{scalar<double>} // \emph{default:} \code{1} (\code{optional})

Scale factor for PNG output.}

\item{png_width, png_height}{\emph{PNG width and height}

\verb{scalar<double>} // \emph{default:} \code{12} (\code{optional})

Width for PNG output.}

\item{font_family}{\emph{Font family}

\verb{scalar<character>} // \emph{default:} \code{"sans"} (\code{optional})

Word font family. See officer::fp_text.}

\item{colour_palette_nominal, colour_palette_ordinal}{\emph{Colour palettes (nominal and ordinal)}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Must contain at least the number of unique values (including missing) in the data set.}

\item{colour_na}{\emph{Colour for NA category}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Colour as a single string for NA values.}

\item{colour_2nd_binary_cat}{\emph{Colour for second binary category}

\verb{scalar<character>} // \emph{default:} \code{"#ffffff"} (\code{optional})

Colour for second category in binary variables. Often useful to hide this.}

\item{table_main_question_as_header}{\emph{Table main question as header}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to include the main question as a header in the table.}

\item{max_width_obj}{\emph{Maximum object width}

\verb{scalar<integer>} // \emph{default:} \code{NULL} (\code{optional})

Maximum width for object names in the Quarto script. In particular useful
when having label as part of the structure.}

\item{max_width_file}{\emph{Maximum filename width}

\verb{scalar<integer>} // \emph{default:} \code{NULL} (\code{optional})

Maximum width for any filename. Due to OneDrive having a max path of about
400 characters, this can quickly be exceeded with a long path base path,
long file names if using labels as part of structure, and hashing with
Quarto's \code{cache: true} feature. This argument truncates the filenames.}

\item{max_clean_folder_name}{\emph{Maximum clean folder name length}

\verb{scalar<integer>} // \emph{default:} \code{NULL} (\code{optional})

Whereas \code{max_width_file} truncates the file name, this argument truncates
the folder name. It will not impact the report or chapter names in website,
only the folders.}

\item{open_after_drafting}{\emph{Whether to open index.qmd}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to open the main output file (index.qmd) after completion.}

\item{organize_by}{\emph{Grouping columns}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names used for identifying chapters and sections.}

\item{arrange_output_by}{\emph{Grouping columns}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names used for sorting output within each organize_by group}

\item{ignore_heading_for_group}{\emph{Ignore heading for group}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Type of refined chapter_overview data for which to suppress the heading
in the report output. Typically variable_name_dep, variable_name_indep, etc.}

\item{replace_heading_for_group}{\emph{Replacing heading for group}

\verb{named vector<character>} // \emph{default:} \code{c(".variable_label_suffix_dep" = ".variable_name_dep")}

Occasionally, one needs to replace the heading with another piece of information
in the refined chapter_overview. For instance, one may want to organize output
by variable_name_indep, but to display the variable_label_indep instead. Use
the name for the replacement and the value for the original.}

\item{mesos_first}{\emph{mesos first}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to place the mesos group element before or after the entire sample.}

\item{descend}{\emph{Sorting order}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Reverse sorting of \code{sort_by}.}

\item{require_common_categories}{\emph{Check common categories}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

Whether to check if all items share common categories.}

\item{panel_tabset_mesos}{\emph{mesos panel tabset}

\verb{scalar<logical>} // \emph{default:} \code{TRUE} (\code{optional})

Whether in mesos reports the comparison group should be displayed as
a Quarto panel tabset (\code{TRUE}), or above each other (\code{FALSE}).}

\item{pdf}{\emph{Create PDF of full report?}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to create a PDF of the entire report (all chapters included in a single file).}

\item{attach_chapter_dataset}{\emph{Toggle inclusion of chapter-specific datasets in qmd-files}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Whether to save in each chapter folder an 'Rds'-file with the
chapter-specific dataset, and load it at the top of each QMD-file.}

\item{auxiliary_variables}{\emph{Auxiliary variables to be included in datasets}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names in \code{data} that should always be included in datasets for
chapter qmd-files, if \code{attach_chapter_dataset=TRUE}. Not publicly available.}

\item{flexi}{\emph{Create page with user-editable categorical plots and tables}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to create a folder with a Shiny flexi app containing all the
variables in the chapter_overview and auxiliary_variables.}

\item{micro}{\emph{Create page with raw data (micro data) and codebook}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to a page with local links to a raw dataset (in various formats) and codebook (in various formats).}

\item{reps}{\emph{Number of permutations}

\verb{scalar<integer>} // \emph{default:} \code{100} (\code{optional})

Number of permutations to be performed in bootstrap significance tests.}

\item{information}{\emph{Pre-computed information}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Which pre-computed information for each variable-category to display.}

\item{contents}{\emph{Text interpretations}

\verb{vector<character>} // \emph{default:} all available (\code{optional})

The type of text interpretations to return.}

\item{include_numbers}{\emph{Include numbers}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

Whether or not to include the actual numbers in parentheses.}

\item{n_top_bottom}{\emph{Top and bottom entries to report}

\verb{scalar<integer>} // \emph{default:} \code{NULL} (\code{optional})

The number of top and bottom entries to report.}

\item{log_file}{\emph{Path to log file}

\verb{scalar<string>} // \emph{default:} \code{"_log.txt"} (\code{optional})

Path to log file. Set to NULL to disable logging.}

\item{serialized_format}{\emph{Serialized format}

\verb{scalar<string>} // \emph{default:} \code{"rds"}

Format for serialized data. One of \code{"rds"} (default), \code{"qs"} or \code{"fst"}.
The latter two requires the respective packages to be installed.
qs is usually the fastest and most space efficient, but sets package
dependencies on the report.}

\item{tabular_format}{\emph{Serialized format}

\verb{scalar<string>} // \emph{default:} \code{"delim"}

Format for pretty tabular data, meant for end-user to peruse and will be
linked to in reports (the graph data, etc). One of \code{"delim"} (tab-separated delim-files)
\code{"xlsx"} requires \code{writexl}-package), \code{"csv"} or \code{"csv2"} (requires \code{readr}-package.
\code{"dta"} or \code{"sav"} requires \code{haven}-package. Currently must be specified,
in the future this will become an optional argument.}

\item{translations}{\emph{Translations}

\code{list} // \emph{default:} \code{saros:::.saros.env$defaults$translations} (\code{optional})

Named list of strings for translations.}
}
\value{
Path to index qmd-file. If not specified in the yaml_path file, will default to index.qmd.
}
\description{
The \code{draft_report()} function is the main function, and the only necessary
user interface, to create semi-automated (draft) reports. It does not need to
be the first step, however, as one might want to store and read in arguments
for the function with the \code{read_yaml_params()}-function first. After the
report files has been drafted with \code{draft_report()}, you can edit, render, and
ultimately publish these as usual with Quarto features in RStudio.
The index.qmd will be the main output file containing "includes" to other
chapters.
}
\details{
This function requires at a minimum a dataset (data frame and tibbles are
supported so far). Note that saros treats data as they are stored: numeric,
integer, factor, ordinal, character, and datetime. Currently, only
factor/ordinal and character are implemented. Second, the chapter_overview
must be specified, also as a (small) data frame, with at least the character
columns 'chapter' and 'dep', where the first names the output chapters, and
the 'dep'-column contain comma-separated (alternatively using tidyselect-syntax)
columns in the \code{data} which are to be treated as dependent variables.
See \code{chapter_overview} for more options.
}
\examples{
\donttest{
index_filepath <-
 draft_report(
    chapter_overview = ex_survey_ch_overview,
    data = ex_survey,
    path = tempdir())
index_filepaths <-
  draft_report(
   chapter_overview = ex_survey_ch_overview,
   data = ex_survey,
   mesos_report = TRUE,
   mesos_var = "f_uni",
   path = tempdir())
}
}
