
## Do not edit this file manually.
## It has been automatically generated from *.org sources.

setGeneric("modelOrder",
           function(object, convention, ...){ standardGeneric("modelOrder") })
setGeneric("modelCoef" ,
           function(object, convention, ...){ standardGeneric("modelCoef") })
setGeneric("modelPoly",
           function(object, convention, ...){ standardGeneric("modelPoly") })
setGeneric("modelPolyCoef",
           function(object, convention, lag_0 = TRUE, ...){
               standardGeneric("modelPolyCoef")
           },
           signature = c("object", "convention")
           )

setClass("VirtualMeanModel",  contains = c("VIRTUAL"))

setClass("VirtualAutocovarianceModel",  contains = c("VIRTUAL"))
setClass("VirtualAutocorelationModel",
         contains = c("VirtualAutocovarianceModel", "VIRTUAL"))

setClass("VirtualPartialAutocovarianceModel", contains = "VIRTUAL")
setClass("VirtualPartialAutocorelationModel",
         contains = c("VirtualPartialAutocovarianceModel", "VIRTUAL"))

setClass("VirtualStationaryModel",
         contains = c("VirtualAutocovarianceModel", "VirtualMeanModel"))

setClass("VirtualWhiteNoiseModel", contains = c("VirtualStationaryModel", "VIRTUAL"))

setClass("VirtualFilterModel",  contains = c("VIRTUAL"))

setGeneric("sigmaSq", def = function(object){ standardGeneric("sigmaSq") })

setClass("VirtualArmaModel",
         contains = c("VirtualFilterModel", "VirtualStationaryModel", "VIRTUAL")
         ## , prototype = list(acv = new("Arma"), mean = numeric(0))
        )
setClass("VirtualArModel", contains = c("VirtualArmaModel", "VIRTUAL") )
setClass("VirtualMaModel", contains = c("VirtualArmaModel", "VIRTUAL") )

setClass("VirtualSarimaModel", contains = c("VirtualFilterModel", "VIRTUAL") )

setClass("VirtualArimaModel", contains = c("VirtualSarimaModel", "VIRTUAL") )
setClass("VirtualAriModel", contains   = c("VirtualArimaModel", "VIRTUAL") )
setClass("VirtualImaModel", contains   = c("VirtualArimaModel", "VIRTUAL") )

setClass("VirtualAutocovarianceSpec", contains = "VIRTUAL",
         slots = c(acvf = "ANY")
         )

setClass("AutocovarianceSpec",
         slots = c(acvf = "numeric")
         )

## setClass("AutocorrelationSpec", contains = "???")

setClass("ArmaSpec", contains = "ArmaFilter",
         slots = c(center =  "numeric", intercept = "numeric", sigma2 = "numeric"),
         prototype = list(center = 0, intercept = 0, sigma2 = NA_real_)
         )

## setMethod("innovationVariances", "ArmaSpec", function(object) object@sigma2 )
## TODO: Mean, Intercept - ne, tezi may sa za "ArmaModel"

setMethod("initialize", "ArmaSpec",
          function(.Object, ..., ar, ma, sar, sma, mean){ # .Object <- callNextMethod()
              .Object <- callNextMethod(.Object, ...)
              if(!missing(mean)){
                  if(.Object@center == 0 && .Object@intercept == 0)
                      .Object@center <- mean
                  else
                      ## Could do more here but hardly worth the effort
                      ## TODO: Document this behaviour.
                      stop(paste0("Use argument 'mean' only when 'center' and 'intercept' ",
                                  "are missing or zero"))
              }

              if(!missing(ar)) .Object@ar <- as(ar, "BJFilter")
              if(!missing(ma)) .Object@ma <- as(ma, "SPFilter")
              if(!missing(sar)) .Object@sar <- as(sar, "BJFilter")
              if(!missing(sma)) .Object@sma <- as(sma, "SPFilter")

              .Object
          }
          )

setClass("AutocovarianceModel",
         contains = c("VirtualAutocovarianceModel", "AutocovarianceSpec")
        )

## TODO: are these needed?
##
##      "PartialAutocovarianceModel"
##
## setClass("AutocorrelationModel",
##          contains = c("VirtualAutocorrelationModel", "AutocorrelationSpec")
##         )
##
## setClass("PartialAutocorrelationModel",
##          contains = c("VirtualPartialAutocorrelationModel", "PartialAutocorrelationSpec")
##         )

setClass("ArmaModel",
         contains = c("ArmaSpec", "VirtualArmaModel")
        )

## TODO: Check if this convoluted inheritance is fine.
setClass("ArModel", contains = c("VirtualArModel", "ArmaModel"))
setClass("MaModel", contains = c("VirtualMaModel", "ArmaModel"))

## TODO: define class "ArmaModelSpec" and define this for it.
setMethod("sigmaSq", "ArmaModel", function(object) object@sigma2)

setMethod("modelCoef", c("VirtualArmaModel", "missing"),
          function(object){
              filterCoef(object)
          }
          )
setMethod("modelCoef", c("VirtualArmaModel", "character"),
          function(object, convention){
              filterCoef(object, convention = convention)
          }
          )

setClass("SarimaSpec", contains = c("SarimaFilter"),
         slots = c(center = "numeric", intercept = "numeric", sigma2 = "numeric"),
         prototype = list(center = 0, intercept = 0, sigma2 = NA_real_)
         )

setClass("SarimaModel", contains = c("VirtualFilterModel", "SarimaSpec")
         )

## TODO: subset seasonal arima (only some roots of one, specify them by
##           sequence number, i.e. as k in  exp(2pi k/s) , k= 0, ..., s-1

setMethod("sigmaSq", "SarimaSpec", function(object) object@sigma2)

setMethod("modelPoly", c("SarimaModel", "missing"),
          function(object){
              filterPoly(object)
         }
         )

setMethod("modelPoly", c("SarimaModel", "ArmaFilter"),
          function(object, convention){
              wrk <- filterPoly(object)

              list(ar = wrk$fullarpoly,
                   ma = wrk$fullmapoly )
          }
          )

setMethod("modelPolyCoef", c("SarimaModel", "missing"),
          function(object, lag_0 = TRUE){
              filterPolyCoef(object, lag_0 = lag_0)
          }
          )

setMethod("modelPolyCoef", c("SarimaModel", "ArmaFilter"),
          function(object, convention, lag_0 = TRUE){
              wrk <- modelPoly(object, convention)

              if(lag_0)
                  list(ar = coef(wrk$ar), ma = coef(wrk$ma) )
              else
                  list(ar = coef(wrk$ar)[-1], ma = coef(wrk$ma)[-1] )
          }
          )

setMethod("modelCoef", c("SarimaModel", "missing"),
          function(object){
              as(object, "SarimaFilter")
          }
          )

## TODO: could define this for signature c("ANY", "character"), as a default
setMethod("modelCoef", c("SarimaModel", "character"),
          function(object, convention){
              convention <- new(convention)
              modelCoef(object, convention  = convention )
          }
          )

setMethod("modelCoef", c("SarimaModel", "SarimaFilter"),
          function(object, convention){
          as(object, "SarimaFilter")  # equivalently: modelCoef(object)
      }
      )

setMethod("modelCoef", c("SarimaModel", "ArmaFilter"),
          function(object, convention){
              wrk <- filterPoly(object)

              new("ArmaFilter", ar = - coef(wrk$fullarpoly)[-1],
                                ma = coef(wrk$fullmapoly)[-1]   )
          }
          )

setMethod("modelCoef", c("SarimaModel", "ArFilter"),
          function(object, convention){
              wrk <- filterPoly(object)
              if(length(coef(wrk$fullmapoly)) > 1)
                   stop("Model not Ar-like (has non-trivial moving average part)")

                   # note: currently the result is ArmaFilter, not ArFilter
              new("ArmaFilter", ar = - coef(wrk$fullarpoly)[-1] )
          }
          )

setMethod("modelCoef", c("SarimaModel", "MaFilter"),
          function(object, convention){
              wrk <- filterPoly(object)
              if(length(coef(wrk$fullarpoly)) > 1)
                  stop("Model not MA-like (has non-trivial autoregressive part)")

                 # note: currently the result is ArmaFilter, not MaFilter
              new("ArmaFilter", ma = coef(wrk$fullmapoly)[-1] )
          }
          )

## TODO: methods for these!
##
## if(model$mean != 0 && d==0 && ds==0)
##    res$fullintercept <- res$intercept + (1-sum(res$fullar))*model$mean
##
##  res$fullmean <- res$mean                                # more care needed!
##  if(model$intercept != 0 && d==0 && ds==0)
##    res$fullmean <- res$fullintercept/(1-sum(res$fullar))

setMethod("show",
    signature(object = "ArmaSpec"),
    function (object)
    {
        .reportClassName(object, "ArmaSpec")
    intercept <- object@intercept
    center <- object@center

    if(is.na(intercept) || is.na(center))
        cat("mean: ", NA, "\n")
    else{##both not NA below
        pofzero <- sum(c(1, filterPolyCoef(object)$ar))
        fullintercept <- intercept +  pofzero * center # TODO: guard against div by 0
        mean <- fullintercept / pofzero
        if(intercept == 0)
            cat("mean: ", center, "\n")
        else if(center == 0)
            cat("intercept: ", intercept, "\n")
            else{ #both non-zero
        cat("mean: ", mean, "\n")
        cat("intercept: ", intercept, "(full intercept: ", fullintercept, ")", "\n")
        }
    }
    cat("innovation variance: ", object@sigma2)
    callNextMethod()
    }
)

setMethod("show",
    signature(object = "ArmaModel"),
    function (object)
    {
        .reportClassName(object, "ArmaModel")
    callNextMethod()
    }
)
setMethod("show",
    signature(object = "ArModel"),
    function (object)
    {
        .reportClassName(object, "ArModel")
    callNextMethod()
    }
)
setMethod("show",
    signature(object = "MaModel"),
    function (object)
    {
        .reportClassName(object, "MaModel")
    callNextMethod()
    }
)

setMethod("show",
    signature(object = "SarimaModel"),
    function (object)
    {
        .reportClassName(object, "SarimaModel")
    callNextMethod()
    }
)

summary.SarimaSpec <- function(object, ...){
    cat("Intercept: ", object@intercept, "\n")
    cat("Center: ", object@center, "\n")
    cat("Innovation variance: ", object@sigma2, "\n")

    summary.SarimaFilter(object)
}

summary.SarimaModel <- function(object, ...){
    .reportClassName(object, "SarimaModel")
    summary.SarimaSpec(object)
}

setMethod("modelOrder", c("ArmaModel", "missing"),
          function(object){
              filterOrder(object)
          }
          )

setMethod("modelOrder", c("ArmaModel", "ArFilter"),
          function(object, convention){
          wrk <- filterOrder(object)
          if(wrk$ma != 0)
              stop("Non-zero moving average order")
              wrk
          }
          )

setMethod("modelOrder", c("ArmaModel", "MaFilter"),
          function(object, convention){
              wrk <- filterOrder(object)
              if(wrk$ar != 0)
                  stop("Non-zero moving average order")
              wrk
          }
          )

setMethod("modelOrder", c("SarimaModel", "missing"),
          function(object){
              filterOrder(object)
          }
          )

## check that these methods are inherited for convention = "ArmaModel", "ArModel" etc.
## But: even if they are, they may need to be redefined (different meaning!, see below)
setMethod("modelOrder", c("SarimaModel", "ArmaFilter"),
          function(object, convention){
               wrk <- modelOrder(object)
               if(is.na(wrk$nseasons))
                   wrk$nseasons <- 0

               with(wrk, list(ar = ar + iorder + (sar + siorder) * nseasons,
                              ma = ma + sma * nseasons ) )
          }
          )

setMethod("modelOrder", c("SarimaModel", "ArFilter"),
          function(object, convention){
               wrk <- modelOrder(object, "ArmaFilter")
               if(wrk$ma != 0)
                   stop("Non-zero moving average order")
               wrk
          }
          )

setMethod("modelOrder", c("SarimaModel", "MaFilter"),
          function(object, convention){
               wrk <- modelOrder(object, "ArmaFilter")
               if(wrk$ar != 0)
                   stop("Non-zero autoregressive order")
               wrk
          }
          )

## !!! notice the difference to c("SarimaModel", "ArmaFilter")
setMethod("modelOrder", c("SarimaModel", "ArmaModel"),
          function(object, convention){
               wrk <- modelOrder(object)
               if(is.na(wrk$nseasons))
                   wrk$nseasons <- 0

               with(wrk, {stopifnot(iorder == 0, siorder == 0)
                          list(ar = ar + sar * nseasons,
                               ma = ma + sma * nseasons )
                         })
           }
           )

setMethod("modelOrder", c("SarimaModel", "ArModel"),
          function(object, convention){
               wrk <- modelOrder(object, "ArmaModel")
               if(wrk$ma != 0)
                   stop("Non-zero moving average order")
               wrk
          }
          )

setMethod("modelOrder", c("SarimaModel", "MaModel"),
          function(object, convention){
               wrk <- modelOrder(object, "ArmaModel")
               if(wrk$ar != 0)
                   stop("Non-zero autoregressive order")
               wrk
          }
          )

.slots2list <- function(object){
    nams <- slotNames(object)
    res <- lapply(nams, function(x) slot(object, x))
    names(res) <- nams
    res
}

setAs("SarimaModel", "list",
      function(from){
          res <- .slots2list(from)

          res$ar <- filterCoef(res$ar)
          res$sar <- filterCoef(res$sar)
          res$ma <- filterCoef(res$ma)
          res$sma <- filterCoef(res$sma)

          res
      }
      )

as.list.SarimaModel <- function(x, ...){
    as(x, "list")
}

setAs("ArmaSpec", "list",
      function(from){
          res <- .slots2list(from)

          res$ar <- filterCoef(res$ar)
          res$ma <- filterCoef(res$ma)

          res
      }
      )

as.list.ArmaModel <- function(x, ...){ as(x, "list") }
as.list.ArmaSpec <- function(x, ...){ as(x, "list") }
