% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_pvalue_fit.R
\name{santaR_pvalue_fit_within}
\alias{santaR_pvalue_fit_within}
\title{Evaluate difference between a group mean curve and a constant model using the comparison of model fit (F-test)}
\usage{
santaR_pvalue_fit_within(SANTAGroup, nPerm = 1000)
}
\arguments{
\item{SANTAGroup}{A fitted group extracted from a \emph{SANTAObj} generated by \code{\link{santaR_fit}}.}

\item{nPerm}{(int) Number of permutations. Default 1000.}
}
\value{
A \emph{p-value}
}
\description{
Execute a t-test based on the comparison of improvement of model fit from a single group mean curve to the fit of both a group mean curve and a constant linear model. This statistic identifies within-class differential evolution, and test whether the population average time curve is flat or not. \emph{n} constant linear model are generated to match the \emph{n} individual trajetories. The \emph{Null} distribution is generated by permuting the \emph{n} group individuals and the \emph{n} constant trajectories. The real improvement in model fit for the real group membership versus flat trajectories is then compared to the \emph{Null} distribution of model fit improvement, similarly to \code{\link{santaR_pvalue_fit}}. Adapted from \cite{Storey and al. 'Significance analysis of time course microarray experiments', PNAS, 2005 [1]}.
}
\examples{
## 56 measurements, 8 subjects, 7 unique time-points
## Default parameter values decreased to ensure an execution < 2 seconds
Yi          <- acuteInflammation$data$var_3
ind         <- acuteInflammation$meta$ind
time        <- acuteInflammation$meta$time
group       <- acuteInflammation$meta$group
grouping    <- get_grouping(ind, group)
inputMatrix <- get_ind_time_matrix(Yi, ind, time)
SANTAObj    <- santaR_fit(inputMatrix, df=5, grouping=grouping, verbose=TRUE)
SANTAGroup  <- SANTAObj$groups[[1]]
#SANTAGroup <- SANTAObj$groups$Group1
santaR_pvalue_fit_within(SANTAGroup, nPerm=500)
# ~0.6726747

}
\references{
[1] Storey, J. D., Xiao, W., Leek, J. T., Tompkins, R. G. & Davis, R. W. Significance analysis of time course microarray experiments. \emph{Proceedings of the National Academy of Sciences of the United States of America} \strong{102}, 12837-42 (2005).
}
\seealso{
Inter-group comparison with \code{\link{santaR_pvalue_fit}}
}
