% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salt_replace.R
\name{salt_replace}
\alias{salt_replace}
\title{Replace certain patterns into some values in a vector}
\usage{
salt_replace(x, replacements, p = 0.1, rep_p = 0.5)
}
\arguments{
\item{x}{A vector. This will always be coerced to character during salting.}

\item{replacements}{A \link{replacement_shaker} function, or a named character
vector of patterns and replacements.}

\item{p}{A number between 0 and 1. Percent of values in \code{x} that should be
salted.}

\item{rep_p}{A number between 0 and 1. Probability that a given match should
be replaced in one of the selected values.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Inserts a selection of characters into some values of x. Pair \link{salt_replace}
with the named vectors in \link{replacement_shaker}, or supply your own named
vector of replacements. The convenience functions \link{salt_ocr} and
\link{salt_capitalization} are light wrappers around \link{salt_replace}.
}
\examples{

x <- c("Lorem ipsum dolor sit amet, consectetur adipiscing elit.",
       "Nunc finibus tortor a elit eleifend interdum.",
       "Maecenas aliquam augue sit amet ultricies placerat.")

salt_replace(x, replacement_shaker$capitalization, p = 0.5, rep_p = 0.2)

salt_ocr(x, p = 1, rep_p = 0.5)
}
