% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSetting.R
\name{addSetting}
\alias{addSetting}
\title{Adds a new setting for use in the safetyGraphics shiny app}
\usage{
addSetting(text_key, label, description, setting_type,
  setting_required = FALSE, column_mapping = FALSE, column_type = NA,
  field_mapping = FALSE, field_column_key = "", setting_cat,
  default = "", charts = c(), settingsLocation = getwd(),
  overwrite = TRUE)
}
\arguments{
\item{text_key}{Text key indicating the setting name. \code{'--'} delimiter indicates a nested setting}

\item{label}{Label}

\item{description}{Description}

\item{setting_type}{Expected type for setting value. Should be "character", "vector", "numeric" or "logical"}

\item{setting_required}{Flag indicating if the setting is required}

\item{column_mapping}{Flag indicating if the setting corresponds to a column in the associated data}

\item{column_type}{Expected type for the data column values. Should be "character","logical" or "numeric"}

\item{field_mapping}{Flag indicating whether the setting corresponds to a field-level mapping in the data}

\item{field_column_key}{Key for the column that provides options for the field-level mapping in the data}

\item{setting_cat}{Setting category (data, measure, appearance)}

\item{default}{Default value for non-data settings}

\item{charts}{character vector of charts using this setting}

\item{settingsLocation}{path where the custom settings will be loaded/saved. If metadata is not found in that location, it will be read from the package (e.g. safetyGraphics::settingsMetadata), and then written to the specified location once the new setting has been added.}

\item{overwrite}{overwrite any existing setting metadata? Note that having settings with the same name is not supported and will cause unexpected results. default = true}
}
\description{
This function updates settings objects to add a new setting parameter to the safetyGraphics shiny app
}
\details{
This function makes it easy for users to adds a new settings to the safetyGraphics shiny app by making updates to the underlying metadata used by the package. Specifically, the function adds a row to settingsMetadata.rda describing the setting.
}
