% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addChart.R
\name{addChart}
\alias{addChart}
\title{Adds a new chart for use in the safetyGraphics shiny app}
\usage{
addChart(chart, label = "", description = "", repo_url = "",
  settings_url = "", main = "character", type = "static",
  maxWidth = 1000, requiredSettings = c(""),
  settingsLocation = getwd(), overwrite = TRUE)
}
\arguments{
\item{chart}{Name of the chart - one word, all lower case}

\item{label}{Nicely formatted name of the chart}

\item{description}{Description of the chart}

\item{repo_url}{Homepage for chart's code repository (if any)}

\item{settings_url}{Homepage for chart's settings documentation}

\item{main}{Name of the main function used to initialize the app. If the type is htmlwidgets, the js function must accept "location" and "settings" parameters (in that order) and have an .init() method, expecting a json data array. Otherwise, the r function should accept named data and settings parameters, and should be loaded in the user's namespace.}

\item{type}{type of chart. Should be 'static', 'plotly' or 'module'}

\item{maxWidth}{max width for the widget in pixels}

\item{requiredSettings}{array of text_key values (matching those used in settingsMetadata) for the required settings for this chart}

\item{settingsLocation}{path where the custom settings will be loaded/saved. If metadata is not found in that location, it will be read from the package (e.g. safetyGraphics::settingsMetadata), and then written to the specified location once the new chart has been added.}

\item{overwrite}{overwrite any existing chart metadata? Note that having multiple charts with the same name is not supported and will cause unexpected results. default = true}
}
\description{
This function updates settings objects to add a new chart to the safetyGraphics shiny app
}
\details{
This function makes it easy for users to add a new chart to the safetyGraphics shiny app, by making updates to the underlying metadata used by the package. Specifically, the function adds a row to chartsMetadata.rda describing the chart and adds a column to settingsMetadata.rda specifying which settings are used with the chart. If new settings are needed for the chart, the user should call addSetting() for each new setting required.
}
