% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSettingsMetadata.R
\name{getSettingsMetadata}
\alias{getSettingsMetadata}
\title{Get metadata about chart settings}
\usage{
getSettingsMetadata(charts = NULL, text_keys = NULL, cols = NULL,
  filter_expr = NULL, add_standards = TRUE,
  metadata = safetyGraphics::settingsMetadata)
}
\arguments{
\item{charts}{optional vector of chart names used to filter the metadata. Exact matches only (case-insensitive). All rows returned by default.}

\item{text_keys}{optional vector of keys used to filter the metadata. Partial matches for any of the strings are returned (case-insensitive). All rows returned by default.}

\item{cols}{optional vector of columns to return from the metadata. All columns returned by default.}

\item{filter_expr}{optional filter expression used to subset the data.}

\item{add_standards}{should data standard info stored in standardsMetadata be included}

\item{metadata}{metadata data frame to be queried}
}
\value{
dataframe with the requested metadata or single metadata value
}
\description{
Retrieve specified metadata about chart settings from the data/settingsMetadata.Rda file.
}
\examples{
safetyGraphics:::getSettingsMetadata()
# Returns a full copy of settingsMetadata.Rda

safetyGraphics:::getSettingsMetadata(text_keys=c("id_col"))
# returns a dataframe with a single row with metadata for the id_col setting

safetyGraphics:::getSettingsMetadata(text_keys=c("id_col"), cols=c("label"))
# returns the character value for the specified row.

}
