% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/03-sim_gen_preconf.R
\name{sim_gen_x}
\alias{sim_gen_e}
\alias{sim_gen_ec}
\alias{sim_gen_v}
\alias{sim_gen_vc}
\alias{sim_gen_x}
\title{Preconfigured generation components}
\usage{
sim_gen_x(simSetup, mean = 0, sd = 4, name = "x")

sim_gen_e(simSetup, mean = 0, sd = 4, name = "e")

sim_gen_ec(simSetup, mean = 0, sd = 150, name = "e", nCont = 0.05,
  type = "unit", areaVar = "idD", fixed = TRUE)

sim_gen_v(simSetup, mean = 0, sd = 1, name = "v")

sim_gen_vc(simSetup, mean = 0, sd = 40, name = "v", nCont = 0.05,
  type = "area", areaVar = "idD", fixed = TRUE)
}
\arguments{
\item{simSetup}{a \code{sim_setup}.}

\item{mean}{the mean passed to the random number generator, for example \code{\link{rnorm}}.}

\item{sd}{the standard deviation passed to the random number generator, for example \link{rnorm}.}

\item{name}{name of variable as character in which random numbers are stored.}

\item{nCont}{gives the number of contaminated observations. Values between 0 and 1 will be trated as probability. If length is larger 1, the expected length is the number of areas.}

\item{type}{"unit" or "area" - unit- or area-level contamination.}

\item{areaVar}{character with variable name(s) identifying areas.}

\item{fixed}{TRUE fixes the observations which will be contaminated. FALSE will result in a random selection of observations or areas.}
}
\description{
These are some preconfigured generation components and all wrappers around \code{\link{sim_gen}} and \code{\link{sim_gen_cont}}.
}
\details{
\code{x}: fixed-effect component; \code{e}: model-error; \code{ec}: contaminated model error; \code{v}: random-effect (error constant for each domain); \code{vc} contaminated random-effect. Note that for contamination you are expected to add both, a non-contaminated component and a contaminated component.
}

