% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance.R
\name{variance}
\alias{variance}
\alias{variance.fitrfh}
\alias{variance.fitrsfh}
\alias{variance.fitrtfh}
\alias{variance.fitrstfh}
\alias{weights.fitrfh}
\title{Construct variance}
\usage{
variance(.object, ...)

\method{variance}{fitrfh}(.object, ...)

\method{variance}{fitrsfh}(.object, ...)

\method{variance}{fitrtfh}(.object, ...)

\method{variance}{fitrstfh}(.object, ...)

\method{weights}{fitrfh}(object, c = 1, ...)
}
\arguments{
\item{.object, object}{an object}

\item{...}{arguments passed to method}

\item{c}{(numeric) scalar}
}
\description{
A generic function to construct the different variance components of an
object. You may want to use this in conjunction with \link{bootstrap}.
}
\examples{
data("grapes", package = "sae")
data("grapesprox", package = "sae")

fitRFH <- rfh(
  grapehect ~ area + workdays - 1,
  data = grapes,
  samplingVar = "var"
)

# The variance component of a mixed linear model:
matV <- variance(fitRFH)
# The full variance matrix:
matV$V()

# The sampling error component
matV$Ve()

# the random effects component
matV$Vu()
}
