% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helpers.R
\name{num_to_admin}
\alias{num_to_admin}
\title{Convert Numeric Code to Administrative Level String}
\usage{
num_to_admin(num)
}
\arguments{
\item{num}{A single integer representing the administrative level.
The value 0 corresponds to "National", while positive integers correspond to "Admin-X".}
}
\value{
A character string representing the administrative level:
- 0 is converted to "National".
- Positive integers are converted to "Admin-X".
- Returns NULL if the input is invalid.
}
\description{
This function converts a numerical administrative level into its corresponding
string format.
}
\examples{
num_to_admin(0)    # Returns "National"
num_to_admin(1)    # Returns "Admin-1"
num_to_admin(2)    # Returns "Admin-2"

}
