% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sGBJ_scores.R
\name{sGBJ_scores}
\alias{sGBJ_scores}
\title{Compute the sGBJ statistic along with its p-value quantifying the association
between a gene set and survival outcome}
\usage{
sGBJ_scores(surv, factor_matrix, covariates = NULL, nperm = 300)
}
\arguments{
\item{surv}{a \code{\link[survival]{Surv}} object of length \code{n}}

\item{factor_matrix}{a \code{n x p} \code{data.frame} of the expression for the
particular gene set of interest being tested}

\item{covariates}{a \code{n x l} matrix of the covariates to adjust upon. Default is \code{NULL}}

\item{nperm}{number of permutations performed to estimate the \code{epsilon} matrix.
Default is \code{300}.}
}
\value{
a list containing the sGBJ statistic estimation and its associated p-value
}
\description{
Compute the sGBJ statistic along with its p-value quantifying the association
between a gene set and survival outcome
}
\examples{
 n <- 100
 surv_data <- data.frame(Time = runif(n = n, min = 0, max = 100),
                         event = rbinom(n = n, size = 1, prob = 0.5))
 surv <- survival::Surv(time = surv_data$Time, event = surv_data$event)

 factor_matrix <- data.frame(P1 = rnorm(n = n),
                              P2 = rnorm(n = n))

 sGBJ::sGBJ_scores(surv,factor_matrix, nperm = 2)

 # with covariates

 covariates <- data.frame(age = runif(n = n, 60, 90))

 sGBJ_scores(surv,factor_matrix, nperm = 2, covariates = covariates)
}
