% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EOF.R
\name{EOF}
\alias{EOF}
\title{Area-weighted empirical orthogonal function analysis using SVD}
\usage{
EOF(
  ano,
  lat,
  lon,
  time_dim = "sdate",
  space_dim = c("lat", "lon"),
  neofs = 15,
  corr = FALSE,
  ncores = NULL
)
}
\arguments{
\item{ano}{A numerical array of anomalies with named dimensions to calculate
EOF. The dimensions must have at least 'time_dim' and 'space_dim'. NAs 
could exist but it should be consistent along time_dim. That is, if one grid
point has NAs, all the time steps at this point should be NAs.}

\item{lat}{A vector of the latitudes of 'ano'.}

\item{lon}{A vector of the longitudes of 'ano'.}

\item{time_dim}{A character string indicating the name of the time dimension
of 'ano'. The default value is 'sdate'.}

\item{space_dim}{A vector of two character strings. The first is the dimension
name of latitude of 'ano' and the second is the dimension name of longitude
of 'ano'. The default value is c('lat', 'lon').}

\item{neofs}{A positive integer of the modes to be kept. The default value is
15. If time length or the product of the length of space_dim is smaller than
neofs, neofs will be changed to the minimum of the three values.}

\item{corr}{A logical value indicating whether to base on a correlation (TRUE)
or on a covariance matrix (FALSE). The default value is FALSE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing:
\item{EOFs}{
 An array of EOF patterns normalized to 1 (unitless) with dimensions 
 (number of modes, rest of the dimensions of 'ano' except 'time_dim'). 
 Multiplying \code{EOFs} by \code{PCs} gives the original reconstructed 
 field.
}
\item{PCs}{
 An array of principal components with the units of the original field to 
 the power of 2, with dimensions (time_dim, number of modes, rest of the
 dimensions of 'ano' except 'space_dim'). 
 'PCs' contains already the percentage of explained variance so, 
 to reconstruct the original field it's only needed to multiply 'EOFs'
 by 'PCs'.
} 
\item{var}{
 An array of the percentage (%) of variance fraction of total variance 
 explained by each mode (number of modes). The dimensions are (number of 
 modes, rest of the dimensions of 'ano' except 'time_dim' and 'space_dim').
}
\item{mask}{
 An array of the mask with dimensions (space_dim, rest of the dimensions of 
 'ano' except 'time_dim'). It is made from 'ano', 1 for the positions that 
 'ano' has value and NA for the positions that 'ano' has NA. It is used to 
 replace NAs with 0s for EOF calculation and mask the result with NAs again
 after the calculation.
}
\item{wght}{
 An array of the area weighting with dimensions 'space_dim'. It is calculated
 by cosine of 'lat' and used to compute the fraction of variance explained by
 each EOFs.
}
\item{tot_var}{
 A number or a numeric array of the total variance explained by all the modes.
 The dimensions are same as 'ano' except 'time_dim' and 'space_dim'.
}
}
\description{
Perform an area-weighted EOF analysis using single value decomposition (SVD) 
based on a covariance matrix or a correlation matrix if parameter 'corr' is 
set to TRUE.
}
\examples{
# This example computes the EOFs along forecast horizons and plots the one 
# that explains the greatest amount of variability. The example data has low  
# resolution so the result may not be explanatory, but it displays how to 
# use this function.
\dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                    c('observation'), startDates,
                                    leadtimemin = 1,
                                    leadtimemax = 4,
                                    output = 'lonlat',
                                    latmin = 27, latmax = 48,
                                    lonmin = -12, lonmax = 40)
}
ano <- Ano_CrossValid(sampleData$mod, sampleData$obs)
tmp <- MeanDims(ano$exp, c('dataset', 'member'))
ano <- tmp[1, , ,]
names(dim(ano)) <- names(dim(tmp))[-2]
eof <- EOF(ano, sampleData$lat, sampleData$lon)
\dontrun{
PlotEquiMap(eof$EOFs[1, , ], sampleData$lon, sampleData$lat)
}

}
\seealso{
ProjectField, NAO, PlotBoxWhisker
}
