% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ryt_get_report.R
\name{ryt_get_report_types}
\alias{ryt_get_report_types}
\alias{ryt_create_job}
\alias{ryt_get_job_list}
\alias{ryt_get_report_list}
\alias{ryt_get_report}
\alias{ryt_get_report_metadata}
\alias{ryt_delete_job}
\title{Returns a list of report types that the channel or content owner can retrieve. Each item in the list contains an id property, which identifies the report's ID, and you need this value to schedule a reporting job.}
\usage{
ryt_get_report_types()

ryt_create_job(
  report_type = c("channel_annotations_a1", "channel_basic_a2", "channel_cards_a1",
    "channel_combined_a2", "channel_demographics_a1", "channel_device_os_a2",
    "channel_end_screens_a1", "channel_playback_location_a2", "channel_province_a2",
    "channel_sharing_service_a1", "channel_playback_location_a2", "channel_province_a2",
    "channel_sharing_service_a1", "channel_subtitles_a2", "channel_traffic_source_a2",
    "playlist_basic_a1", "playlist_device_os_a1", "playlist_playback_location_a1",
    "playlist_province_a1", "playlist_traffic_source_a1")
)

ryt_get_job_list()

ryt_get_report_list(
  job_id,
  created_after = NULL,
  start_time_at_or_after = NULL,
  start_time_before = NULL
)

ryt_get_report(download_url)

ryt_get_report_metadata(job_id, report_id)

ryt_delete_job(job_id)
}
\arguments{
\item{report_type}{The type of report that the job creates. The property value corresponds to the id of a reportType as retrieved from the \code{\link{ryt_get_report_types}} function.}

\item{job_id}{The ID that YouTube uses to uniquely identify the job that is being deleted. Use \code{\link{ryt_get_job_list}}.}

\item{created_after}{If specified, this parameter indicates that the API response should only contain reports created after the specified date and time, including new reports with backfilled data. Note that the value pertains to the time that the report is created and not the dates associated with the returned data. The value is a timestamp in RFC3339 UTC "Zulu" format, accurate to microseconds. Example: \code{"2015-10-02T15:01:23.045678Z"}.}

\item{start_time_at_or_after}{This parameter indicates that the API response should only contain reports if the earliest data in the report is on or after the specified date. Whereas the createdAfter parameter value pertains to the time the report was created, this date pertains to the data in the report. The value is a timestamp in RFC3339 UTC "Zulu" format, accurate to microseconds. Example: \code{"2015-10-02T15:01:23.045678Z"}.}

\item{start_time_before}{This parameter indicates that the API response should only contain reports if the earliest data in the report is before the specified date. Whereas the createdAfter parameter value pertains to the time the report was created, this date pertains to the data in the report. The value is a timestamp in RFC3339 UTC "Zulu" format, accurate to microseconds. Example: \code{"2015-10-02T15:01:23.045678Z"}.}

\item{download_url}{download URL, you can get it by \code{\link{ryt_get_report_list}} or \code{\link{ryt_get_report_metadata}}}

\item{report_id}{The ID that YouTube uses to uniquely identify the report that is being retrieved. Use \code{\link{ryt_get_report_list}}}
}
\value{
ryt_get_report_types: tibble with report types

ryt_reports_create_job: No return value, called for side effects

ryt_get_job_list: tibble with jobs metadata

ryt_get_report_list: tibble with reports metadata

ryt_get_report: tibble with report data

ryt_get_report_metadata: list with report metadata

ryt_reports_delete_job: No return value, called for side effects
}
\description{
By creating a reporting job, you are instructing YouTube to generate that report on a daily basis. The report is available within 24 hours of the time that the job is created.

Each resource in the response contains an id property, which specifies the ID that YouTube uses to uniquely identify the job. You need that ID to retrieve the list of reports that have been generated for the job or to delete the job.
}
\examples{
\dontrun{
 # auth
 ryt_auth('me@gmail.com')

 # get reporting data
 ## create job
 ryt_reports_create_job('channel_basic_a2')

 ## get job list
 jobs <- ryt_get_job_list()

 ## get job report list
 reports <- ryt_get_report_list(
   job_id = jobs$id[1],
   created_after = '2021-10-20T15:01:23.045678Z'
 )

 ## get report data
 data <- ryt_get_report(
   download_url = reports$downloadUrl[1]
 )

 ## delete job
 ryt_reports_delete_job(jobs$id[1])
 }
}
\seealso{
\href{https://developers.google.com/youtube/reporting/v1/reference/rest/v1/reportTypes/list}{Reporting API Documentation: Method reportTypes.list}.

\href{https://developers.google.com/youtube/reporting/v1/reference/rest/v1/jobs/create}{Reporting API Documentation: Method jobs.create}

\href{https://developers.google.com/youtube/reporting/v1/reference/rest/v1/jobs/list}{Reporting API Documentation: Method jobs.list}

\href{https://developers.google.com/youtube/reporting/v1/reference/rest/v1/jobs.reports/list}{Reporting API Documentation: Method jobs.reports.list }

\href{https://developers.google.com/youtube/reporting/v1/reports}{Reporting API Documentation: Data Model}

\href{https://developers.google.com/youtube/reporting/v1/reference/rest/v1/jobs.reports/get}{Reporting API Documentation: Method jobs.reports.get}

\href{https://developers.google.com/youtube/reporting/v1/reference/rest/v1/jobs/delete}{Reporting API Documentation: Method jobs.delete}
}
\concept{reporting api functions}
