% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlogit.R
\name{mexpit}
\alias{mexpit}
\title{mexpit -- Convert log-scale numbers to probabilities}
\usage{
mexpit(...)
}
\arguments{
\item{...}{numeric log-scale numbers to convert to probabilities.}
}
\value{
Probabilities that add up to a number less than 1.
}
\description{
This function converts log-scale numbers to probabilities.
}
\details{
The probabilities are calculated using the following equation:

\deqn{p_i = \frac{e^{x_i}}{1+\sum_{j=1}^{N-1} e^{x_j}}}

This ensures one remaining probability will add to one, that is

\deqn{p_N = \frac{1}{1+\sum_{j=1}^{N-1} e^{x_j}}}
}
\examples{

m <- mlogit(0.1, 0.2, 0.3)
mexpit(m)

p <- mexpit(-3, 0.5, 3)
mlogit(p)

}
\author{
Matthew L. Fidler
}
