% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assertCompartmentName}
\alias{assertCompartmentName}
\alias{assertVariableName}
\alias{assertParameterValue}
\alias{assertExists}
\alias{testExists}
\title{Verify that a value is a valid nlmixr2 compartment name}
\usage{
assertCompartmentName(x)

assertVariableName(x)

assertParameterValue(x)

assertExists(ui, x)

testExists(ui, x)
}
\arguments{
\item{x}{The value to test}

\item{ui}{when needed, this is the rxode2/nlmixr2 model}
}
\value{
The value or an error
}
\description{
Verify that a value is a valid nlmixr2 compartment name
}
\section{Functions}{
\itemize{
\item \code{assertVariableName()}: Verify that a value is a valid
nlmixr2 variable name

\item \code{assertParameterValue()}: Verify that a value is a valid
nlmixr2 parameter value

\item \code{assertExists()}: Assert compartment/variable exists

\item \code{testExists()}: Test compartment/variable exists

}}
\seealso{
Other Assertions: 
\code{\link{assertCompartmentExists}()},
\code{\link{assertCompartmentNew}()},
\code{\link{assertRxUi}()},
\code{\link{assertVariableExists}()},
\code{\link{assertVariableNew}()},
\code{\link{testIniDf}()},
\code{\link{testRxUnbounded}()}
}
\author{
Bill Denney
}
\concept{Assertions}
