% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/history.R
\name{history_range}
\alias{history_range}
\title{Hourly weather data for specified date range.}
\usage{
history_range(location, date_start = "20150101", date_end = "20150105",
  limit = 10, no_api = FALSE, use_metric = FALSE, key = get_api_key(),
  raw = FALSE, message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{date_start}{start date}

\item{date_end}{end date}

\item{limit}{Maximum number of API requests per minute,
NULL to have no limits}

\item{no_api}{bypass API and use URL requests}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df with date, temperature, dew point,
        humidity, wind speed, gust and direction,
        visibility, pressure, wind chill, heat index,
        precipitation, condition, fog, rain, snow,
        hail, thunder, tornado
}
\description{
Hourly weather data for specified date range.
}
\examples{
\dontrun{
history_range(set_location(territory = "Hawaii", city = "Honolulu"), "20130101", "20130105")
history_range(set_location(airport_code = "SEA"), "20130101", "20130105")
history_range(set_location(zip_code = "90210"), "20130131", "20130205")
history_range(set_location(territory = "IR", city = "Tehran"), "20140131", "20140202")
}
}

