% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R, R/rworldmap-package.R
\docType{package}
\name{rworldmap-package}
\alias{rworldmap}
\alias{rworldmap-package}
\title{For mapping global data.}
\description{
Enables mapping of country level and gridded user datasets by facilitating
joining to modern world maps and offering visualisation options. Country
borders are derived from Natural Earth data v 1.4.0.

Enables mapping of country level and gridded user datasets by facilitating
joining to modern world maps and offering visualisation options. Country
borders are derived from Natural Earth data v 1.4.0.
}
\details{
\tabular{ll}{ Package: \tab rworldmap\cr Type: \tab Package\cr Version: \tab
1.3-4\cr Date: \tab 2014-11-11\cr License: \tab GPL (>= 2)\cr }

Country Level Data can be joined to a map using
\code{\link{joinCountryData2Map}}, then mapped using
\code{\link{mapCountryData}}. These functions can cope with a range of
country names and country codes.

Country boundaries are derived from version 1.4.0 of Natural Earth data as
described in \code{\link{countriesCoarse}}. Higher resolution boundaries are
provided in a companion package rworldxtra.

More generic functions allow the user to provide their own polygon map using
\code{\link{joinData2Map}} and \code{\link{mapPolys}}.

Bubble, bar and pie charts can be added to maps using
\code{\link{mapBubbles}}, \code{\link{mapBars}} and \code{\link{mapPies}}.

Try the new method \code{\link{barplotCountryData}} for producing a ranked
bar plot of country data with country names that can provide a useful
companion to maps.

Options are provided for categorising data, colouring maps and symbols, and
adding legends.

Gridded data can be mapped using \code{\link{mapGriddedData}}, but the
raster package is much more comprehensive.

Type vignette('rworldmap') to access a short document showing a few examples
of the main rworldmap functions to get you started.

Country Level Data can be joined to a map using
\code{\link{joinCountryData2Map}}, then mapped using
\code{\link{mapCountryData}}. These functions can cope with a range of
country names and country codes.

Country boundaries are derived from version 1.4.0 of Natural Earth data as
described in \code{\link{countriesCoarse}}. Higher resolution boundaries are
provided in a companion package rworldxtra.

More generic functions allow the user to provide their own polygon map using
\code{\link{joinData2Map}} and \code{\link{mapPolys}}.

Bubble, bar and pie charts can be added to maps using
\code{\link{mapBubbles}}, \code{\link{mapBars}} and \code{\link{mapPies}}.

Try the new method \code{\link{barplotCountryData}} for producing a ranked
bar plot of country data with country names that can provide a useful
companion to maps.

Options are provided for categorising data, colouring maps and symbols, and
adding legends.

Gridded data can be mapped using \code{\link{mapGriddedData}}, but the
raster package is much more comprehensive.

Type vignette('rworldmap') to access a short document showing a few examples
of the main rworldmap functions to get you started.
}
\examples{


#mapping country level data, with no file specified it uses internal example data
mapCountryData()
#specifying region
mapCountryData(mapRegion="asia")
#mapping gridded data, with no file specified it uses internal example data
mapGriddedData()
#specifying region 
mapGriddedData(mapRegion="africa")  
#aggregating gridded data to country level 
#with no file specified it uses internal example data
mapHalfDegreeGridToCountries()              



}
\author{
Andy South

with contributions from Joe Scutt-Phillips, Barry Rowlingson, Roger Bivand
and Pru Foster

Maintainer: <southandy@gmail.com>

Andy South

with contributions from Joe Scutt-Phillips, Barry Rowlingson, Roger Bivand
and Pru Foster

Maintainer: <southandy@gmail.com>
}
\references{
Stable version :
http://cran.r-project.org/web/packages/rworldmap \cr Development version :
https://r-forge.r-project.org/projects/rworldmap/

Discussion group : http://groups.google.com/group/rworldmap

Stable version :
http://cran.r-project.org/web/packages/rworldmap 
\cr Development version :https://github.com/AndySouth/rworldmap

Discussion group : http://groups.google.com/group/rworldmap
}
\keyword{package}

