% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWT3_PO.R
\name{FWT3_PO}
\alias{FWT3_PO}
\title{3-d MRA wavelet transform (periodized, orthogonal).}
\usage{
FWT3_PO(x, L, qmf)
}
\arguments{
\item{x}{3-d array (n by n by n array, n dyadic).}

\item{L}{coarse level.}

\item{qmf}{quadrature mirror filter.}
}
\value{
\code{wc} 3-d wavelet transform.
}
\description{
A three-dimensional Wavelet Transform is computed for the array x.
\code{qmf} filter may be obtained from \code{\link{MakeONFilter}}.
To reconstruct, use \code{\link{IWT3_PO}}.
}
\details{
3-D counterpart of Donoho's FWT2_PO, original matlab code
Vicki Yang and Brani Vidakovic.
}
\examples{
qmf <- MakeONFilter('Daubechies', 10)
L <- 3
x <- array(rnorm(32^3), c(32,32,32))
wc <- FWT3_PO(x, L, qmf)
}
\seealso{
\code{\link{IWT3_PO}}, \code{\link{MakeONFilter}}.
}
