% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{html_table}
\alias{html_table}
\title{Parse an html table into a data frame.}
\usage{
html_table(x, header = NA, trim = TRUE, fill = FALSE, dec = ".")
}
\arguments{
\item{x}{A node, node set or document.}

\item{header}{Use first row as header? If \code{NA}, will use first row
if it consists of \verb{<th>} tags.}

\item{trim}{Remove leading and trailing whitespace within each cell?}

\item{fill}{If \code{TRUE}, automatically fill rows with fewer than
the maximum number of columns with \code{NA}s.}

\item{dec}{The character used as decimal mark.}
}
\description{
Parse an html table into a data frame.
}
\section{Assumptions}{


\code{html_table} currently makes a few assumptions:

\itemize{
\item No cells span multiple rows
\item Headers are in the first row
}
}

\examples{
sample1 <- minimal_html("<table>
  <tr><th>Col A</th><th>Col B</th></tr>
  <tr><td>1</td><td>x</td></tr>
  <tr><td>4</td><td>y</td></tr>
  <tr><td>10</td><td>z</td></tr>
</table>")
sample1 \%>\%
  html_node("table") \%>\%
  html_table()

# Values in merged cells will be duplicated
sample2 <- minimal_html("<table>
  <tr><th>A</th><th>B</th><th>C</th></tr>
  <tr><td>1</td><td>2</td><td>3</td></tr>
  <tr><td colspan='2'>4</td><td>5</td></tr>
  <tr><td>6</td><td colspan='2'>7</td></tr>
</table>")

sample2 \%>\%
  html_node("table") \%>\%
  html_table()

# If the table is badly formed, and has different number of columns
# in each row, use `fill = TRUE` to fill in the missing values
sample3 <- minimal_html("<table>
  <tr><th>A</th><th>B</th><th>C</th></tr>
  <tr><td colspan='2'>1</td><td>2</td></tr>
  <tr><td colspan='2'>3</td></tr>
  <tr><td>4</td></tr>
</table>")

sample3 \%>\%
  html_node("table") \%>\%
  html_table(fill = TRUE)
}
