% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertmap.R
\name{vertmap}
\alias{vertmap}
\title{Make a simple map to visualize VertNet data.}
\usage{
vertmap(input = NULL, mapdatabase = "world", region = ".",
  geom = geom_point, jitter = NULL)
}
\arguments{
\item{input}{Output from \code{\link{vertsearch}}, 
\code{\link{searchbyterm}}, or \code{\link{spatialsearch}}. Must
     include columns "decimallatitude" and "decimallongitude"}

\item{mapdatabase}{The base map on which your data are displayed; what you
choose here determines what you can choose in the region parameter; one
of: county, state, usa, world, world2, france, italy, or nz}

\item{region}{The region in which your data are displayed; to see region names
for the "world" database layer, run
\code{sort(unique(map_data("world")$region))} after loading packages maps 
and ggplot2; to see region names for the US "state" layer, run 
\code{sort(unique(map_data("state")$region))}}

\item{geom}{Specifies the type of object being plotted; one of: \code{geom_point} or
\code{geom_jitter} (do not use quotes)}

\item{jitter}{If \code{geom = geom_jitter}, the amount by which to jitter points in
width, height, or both. Default}
}
\value{
Map of record locations displayed on the selected base map
}
\description{
Plots record locations on a world or regional map using latitude/longitude
data returned by a VertNet search.
}
\details{
\code{vertmap} uses decimal latitude and longitude data in records generated by
   an rvertnet search to display returned records on a specified base map. Taxa
   are color-coded by scientific name, if available. Adapt the vertmap code to
   construct maps according to your own specfications.
}
\examples{
\dontrun{
out <- vertsearch("Junco hyemalis") # get occurrence records
vertmap(out)                        # map occurrence records

# Records are color coded by dwc term "scientificname" - sometimes unavailble
out <- vertsearch("mustela nigripes")
vertmap(input = out, mapdatabase = "state")

# Use searchbyterm() to match records with mapped region
spec <- searchbyterm(genus = "ochotona", specificepithet = "princeps", state = "california",
limit = 200)
vertmap(input = spec, mapdatabase = "state", region = "california")

# Many species
splist <- c("Accipiter erythronemius", "Aix sponsa", "Haliaeetus leucocephalus",
		"Corvus corone", "Threskiornis molucca", "Merops malimbicus")
out <- lapply(splist, function(x) vertsearch(t=x, lim=100))
library("plyr")
out <- ldply(lapply(out, "[[", "data"))
vertmap(out)
## jitter points
library("ggplot2")
vertmap(out, geom = geom_jitter, jitter = position_jitter(1, 6))
}
}

