% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{posterior}
\alias{posterior}
\alias{posterior.lm}
\alias{posterior.glm}
\title{Generate Posterior Simulations}
\usage{
posterior(obj, ...)
}
\arguments{
\item{obj}{an object}

\item{\dots}{further arguments}
}
\value{
A (named) list of random vectors.  For example, the \code{lm} method
returns a list with components \code{sigma} (the residual s.d.)  and
\code{beta}, the regression coefficients.
}
\description{
Generate posterior simulations for a given fitted linear or general linear
model, assuming the standard "noninformative" priors on the unknowns.
}
\examples{

  \dontrun{
  x <- 1:20
  y <- rnorm(length(x), mean=x, sd=10)
  print(summary(fit <- lm(y ~ x)))
  bayes.estimates <- posterior(fit)
  }

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
