% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Rusquant.R
\name{getSymbols.Rusquant}
\alias{getSymbols.Rusquant}
\title{Download alpha strategy data from Rusquant}
\usage{
getSymbols.Rusquant(
  Symbols,
  env = globalenv(),
  field = NULL,
  from = "2007-01-01",
  to = Sys.Date(),
  period = "day",
  market = NULL,
  api.key = NULL,
  verbose = FALSE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{a character vector of symbols to be downloaded.}

\item{env}{the environment where the data should be stored. Default is the global environment.}

\item{field}{the name(s) of alpha strategy to retrieve from the API. Default is NULL.}

\item{from}{the start date of the data to be retrieved. Default is '2007-01-01'.}

\item{to}{the end date of the data to be retrieved. Default is Sys.Date().}

\item{period}{a character value indicating the periodicity of the data. Default is 'day'.}

\item{market}{a character value indicating the market where the symbols are traded. Default is NULL.}

\item{api.key}{a character value indicating the API key to be used for the request. Default is NULL.}

\item{verbose}{a logical value indicating whether to print informative messages. Default is FALSE.}

\item{auto.assign}{a logical value indicating whether to automatically assign the downloaded data to an object with the symbol name. Default is FALSE.}

\item{...}{Additional arguments to be passed to functions.}
}
\value{
returns an data.table object containing the requested data with alpha strategy data
}
\description{
This function retrieves alpha data for the specified alpha,symbols from Rusquant API.
The data can be returned in either xts or data.frame format.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
\donttest{
rusquant_key = 'get free key from rusquant.ru'
getSymbols.Rusquant('SBER',field = 'A1_L_P1',api.key = rusquant_key)
getSymbols('SBER',src='Rusquant',field = 'A1_L_P1',api.key = rusquant_key)
}
}
\author{
Vyacheslav Arbuzov
}
