% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_plot.R
\name{round_time}
\alias{round_time}
\title{A generic function for rounding date and time values}
\usage{
round_time(x, n, tz)
}
\arguments{
\item{x}{A vector of class POSIX or Date.}

\item{n}{Unit to round to. Defaults to mins. Numeric values treated
as seconds. Otherwise this should be one of "mins", "hours", "days",
"weeks", "months", "years" (plural optional).}

\item{tz}{Time zone to be used, defaults to "UTC" (Twitter default)}
}
\value{
If POSIXct then POSIX. If date then Date.
}
\description{
A generic function for rounding date and time values
}
\examples{

## class posixct
round_time(Sys.time(), "12 hours")

## class date
unique(round_time(seq(Sys.Date(), Sys.Date() + 100, "1 day"), "weeks"))
}
