% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggested.R
\name{suggested_slugs}
\alias{suggested_slugs}
\alias{suggested_users}
\title{Get user [account] suggestions for authenticating user}
\usage{
suggested_slugs(lang = NULL, token = NULL)

suggested_users(slug, lang = NULL, token = NULL)
}
\arguments{
\item{lang}{optional Restricts the suggested categories to the
requested language. The language must be specified by the
appropriate two letter ISO 639-1 representation.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}

\item{slug}{required The short name of list or a category}
}
\value{
List of recommended categories which can be passed along as
  the "slug" parameter in \code{\link{suggested_users}}

Recommended users
}
\description{
Returns Twitter's list of suggested user categories.

Returns users from a specific, suggested category
}
\examples{

\dontrun{

## get slugs
slugs <- suggested_slugs()

## use slugs to get suggested users
suggested_users(slugs$slug[1])

}

}
