% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{ds.getSymbol.yahoo}
\alias{ds.getSymbol.yahoo}
\alias{ds.getSymbol.FRED}
\alias{ds.getSymbol.Quandl}
\alias{ds.getSymbol.av}
\alias{ds.getSymbol.tiingo}
\alias{ds.getSymbol.fake.stock.data}
\title{Get quotes from Yahoo Finance}
\usage{
ds.getSymbol.yahoo(Symbol, from = "1900-01-01", to = Sys.Date())

ds.getSymbol.FRED(Symbol, from = "1900-01-01", to = Sys.Date())

ds.getSymbol.Quandl(Symbol, from = "1900-01-01", to = Sys.Date())

ds.getSymbol.av(Symbol, from = "1900-01-01", to = Sys.Date())

ds.getSymbol.tiingo(Symbol, from = "1900-01-01", to = Sys.Date())

ds.getSymbol.fake.stock.data(Symbol, from = "1900-01-01",
  to = Sys.Date())
}
\arguments{
\item{Symbol}{symbol}

\item{from}{start date, expected in yyyy-mm-dd format, \strong{defaults to 1900-01-01}}

\item{to}{end date, expected in yyyy-mm-dd format, \strong{defaults to today's date}}
}
\value{
xts object with data
}
\description{
Download historical data from Yahoo Finance using `getSymbols.yahoo` function from `quantmod` package.

Download historical data from FRED using `get_fred_series` function from `alfred` package.

Download historical data from Quandl using `Quandl` function from `Quandl` package.

Download historical data from AlphaVantage using `getSymbols.av` function from `quantmod` package.

Download historical data from Tiingo using `getSymbols.tiingo` function from `quantmod` package.

Generate fake stock data for use in rtsdata examples
}
\details{
Quandl recommends getting an API key
Add following code options(Quandl.api_key = api_key)  to your .Rprofile file

You need an API key from www.alphavantage.co
Add following code options(getSymbols.av.Default = api_key) to your .Rprofile file

You need an API key from api.tiingo.com
Add following code options(getSymbols.av.Default = api_key) to your .Rprofile file
}
\examples{
 # get sample of the fake stock data
 ds.getSymbol.fake.stock.data('dummy', from = '2018-02-01', to = '2018-02-13')

}
