% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoFACTORplot.r
\name{twoFACTORplot}
\alias{twoFACTORplot}
\title{Bar plot of the relative gene expression (RE) from the \code{qpcrANOVA} output of a two-factorial experiment data}
\usage{
twoFACTORplot(
  res,
  x.axis.factor,
  group.factor,
  width = 0.5,
  fill = "Blues",
  y.axis.adjust = 0.5,
  y.axis.by = 2,
  show.errorbars = TRUE,
  errorbar = "se",
  show.letters = TRUE,
  show.points = FALSE,
  letter.position.adjust = 0.1,
  ylab = "Relative Expression",
  xlab = "none",
  legend.position = c(0.09, 0.8),
  fontsize = 12,
  fontsizePvalue = 7,
  axis.text.x.angle = 0,
  axis.text.x.hjust = 0.5
)
}
\arguments{
\item{res}{an object created by \code{qpcrANOVA(x)} function on a two factor data such as \code{data_2factor}.}

\item{x.axis.factor}{x-axis factor.}

\item{group.factor}{grouping factor.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify the fill color vector for the columns of the bar plot. One of the palettes in \code{\link[RColorBrewer]{display.brewer.all}} (e.g. "Reds" or "Blues", ...) can be applied.}

\item{y.axis.adjust}{a negative or positive number for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length.}

\item{show.errorbars}{show errorbars}

\item{errorbar}{Type of error bar, can be \code{se} or \code{ci}.}

\item{show.letters}{a logical variable. If TRUE, mean grouping letters are added to the bars.}

\item{show.points}{show points}

\item{letter.position.adjust}{adjust the distance between the grouping letters to the error bars.}

\item{ylab}{the title of the y axis.}

\item{xlab}{the title of the x axis.}

\item{legend.position}{a two digit vector specifying the legend position.}

\item{fontsize}{size of all fonts  of the plot.}

\item{fontsizePvalue}{font size of the pvalue labels}

\item{axis.text.x.angle}{angle of x axis text}

\item{axis.text.x.hjust}{horizontal justification of x axis text}
}
\value{
Bar plot of the average fold change for target genes along with the significance and the 95\% confidence interval as error bars.
}
\description{
Bar plot of the relative expression (RE) of a gene along with the standard error (se), 95\% confidence interval (ci) and significance
}
\details{
The \code{twoFACTORplot} function generates the bar plot of the average fold change for target genes along with the significance, standard error (se) and the 95\% confidence interval (ci) as error bars.
}
\examples{

# See a sample data frame
data_2factor

# Before generating plot, the result table needs to be extracted as below:
res <- qpcrANOVA(data_2factor, numberOfrefGenes = 1)
res

# Plot of the 'res' data with 'Genotype' as grouping factor
twoFACTORplot(res,
   x.axis.factor = Drought,
   group.factor = Genotype,
   width = 0.5,
   fill = "Greens",
   y.axis.adjust = 1,
   y.axis.by = 2,
   ylab = "Relative Expression",
   xlab = "Drought Levels",
   show.letters = TRUE, 
   letter.position.adjust = 0.3,
   legend.position = c(0.09, 0.8),
   errorbar = "ci")

# Plotting the same data with 'Drought' as grouping factor
twoFACTORplot(res,
   x.axis.factor = Genotype,
   group.factor = Drought,
   xlab = "Genotype",
   fill = "Blues",
   fontsize = 12,
   show.letters = FALSE,
   show.points = TRUE,
   show.errorbars = FALSE)


}
\author{
Ghader Mirzaghaderi
}
