% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrTTESTplot.r
\name{qpcrTTESTplot}
\alias{qpcrTTESTplot}
\title{Bar plot of the average fold change of the target genes}
\usage{
qpcrTTESTplot(
  x,
  order = default.order,
  numberOfrefGenes,
  paired = FALSE,
  var.equal = TRUE,
  width = 0.5,
  fill = "skyblue",
  y.axis.adjust = 0,
  y.axis.by = 2,
  letter.position.adjust = 0.3,
  ylab = "Average Fold Change",
  xlab = "Gene",
  fontsize = 12
)
}
\arguments{
\item{x}{a data frame. The data frame consists of 4 columns belonging to condition levels, E (efficiency), genes and Ct values, respectively. Each Ct in the following data frame is the mean of technical replicates. Complete amplification efficiencies of 2 is assumed here for all wells but the calculated efficienies can be used we well. We use this data set for Fold Change expression analysis of the target genes in treatment condition compared to normal condition.}

\item{order}{a vector determinig genes order on the output graph.}

\item{numberOfrefGenes}{number of reference genes. Up to two reference genes can be handled.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify the fill color for the columns of the bar plot.}

\item{y.axis.adjust}{a negative or positive value for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{letter.position.adjust}{adjust the distance between the signs and the error bars.}

\item{ylab}{the title of the y axis}

\item{xlab}{the title of the x axis}

\item{fontsize}{all fonts size of the plot}
}
\value{
Bar  plot of the average fold change for target genes along with the significance and the 95 percent CI as error bars.
}
\description{
Bar plot of the average fold change for target genes along with the 95 percent CI and significance
}
\details{
The \code{qpcrTTESTplot} function applies a t.test based analysis to any number of genes along with one reference gene, that have been evaluated under control and treatment conditions, and returns the bar plot of the average fold change for target genes along with the 95\% CI and significance.
}
\examples{

# See a sample data frame
data_ttest


qpcrTTESTplot(data_ttest, 
              numberOfrefGenes = 1)


# Producing the plot
qpcrTTESTplot(data_ttest,
              numberOfrefGenes = 1,
              order = c("C2H2-01", "C2H2-12", "C2H2-26"),
              paired = FALSE,
              var.equal = TRUE,
              width = 0.5,
              fill = "skyblue",
              y.axis.adjust = 0,
              y.axis.by = 2,
              letter.position.adjust = 0.3,
              ylab = "Average Fold Change in Treatment vs Control",
              xlab = "Gene")


}
\author{
Ghader Mirzaghaderi
}
