% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article.R
\name{acm_article}
\alias{acm_article}
\alias{acs_article}
\alias{aea_article}
\alias{agu_article}
\alias{amq_article}
\alias{ams_article}
\alias{asa_article}
\alias{arxiv_article}
\alias{bioinformatics_article}
\alias{biometrics_article}
\alias{ctex_article}
\alias{ctex}
\alias{elsevier_article}
\alias{frontiers_article}
\alias{mdpi_article}
\alias{mnras_article}
\alias{oup_article}
\alias{peerj_article}
\alias{plos_article}
\alias{pnas_article}
\alias{sage_article}
\alias{sim_article}
\alias{springer_article}
\alias{tf_article}
\title{R Markdown output formats for (journal) articles}
\usage{
acm_article(...)

acs_article(
  ...,
  keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"),
  fig_caption = TRUE
)

aea_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

agu_article(
  ...,
  keep_tex = TRUE,
  citation_package = "natbib",
  highlight = NULL,
  md_extensions = c("-autolink_bare_uris", "-auto_identifiers")
)

amq_article(
  ...,
  latex_engine = "xelatex",
  keep_tex = TRUE,
  fig_caption = TRUE,
  md_extensions = c("-autolink_bare_uris")
)

ams_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

asa_article(..., keep_tex = TRUE, citation_package = "natbib")

arxiv_article(..., keep_tex = TRUE)

bioinformatics_article(..., keep_tex = TRUE, citation_package = "natbib")

biometrics_article(..., keep_tex = TRUE, citation_package = "natbib")

ctex_article(..., latex_engine = "xelatex")

ctex(..., latex_engine = "xelatex")

elsevier_article(
  ...,
  keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris")
)

frontiers_article(..., keep_tex = TRUE)

mdpi_article(..., keep_tex = TRUE)

mnras_article(..., keep_tex = TRUE, fig_caption = TRUE)

oup_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

peerj_article(..., keep_tex = TRUE)

plos_article(..., keep_tex = TRUE, md_extensions = c("-autolink_bare_uris"))

pnas_article(..., keep_tex = TRUE)

sage_article(..., highlight = NULL, citation_package = "natbib")

sim_article(..., highlight = NULL, citation_package = "natbib")

springer_article(..., keep_tex = TRUE, citation_package = "none")

tf_article(..., keep_tex = TRUE, citation_package = "natbib")
}
\arguments{
\item{..., keep_tex, latex_engine, citation_package, highlight, fig_caption, md_extensions}{Arguments passed to \code{rmarkdown::\link{pdf_document}()}.}
}
\value{
An R Markdown output format.
}
\description{
Most article formats are based on \code{rmarkdown::pdf_document()}, with a
custom Pandoc LaTeX template and different default values for other arguments
(e.g., \code{keep_tex = TRUE}).
}
\section{Details}{
 You can find more details about each output format below.
}

\section{\code{acm_article}}{
 Format for creating an Association for Computing
  Machinery (ACM) articles. Adapted from
  \url{https://www.acm.org/publications/proceedings-template}.
}

\section{\code{acs_article}}{
 Format for creating an American Chemical Society
  (ACS) Journal articles. Adapted from
  \url{https://pubs.acs.org/page/4authors/submission/tex.html}.
}

\section{\code{aea_article}}{
 Format for creating submissions to the American
  Economic Association (AER, AEJ, JEL, PP).
}

\section{\code{agu_article}}{
 Format for creating a American Geophysical Union
  (AGU) article. Adapted from
  \url{https://www.agu.org/Publish-with-AGU/Publish/#1}.
}

\section{\code{amq_article}}{
 Ce format a été adapté du format du bulletin de
  l'AMQ.
}

\section{\code{ams_article}}{
 Format for creating an American Meteorological
  Society (AMS) Journal articles. Adapted from
  \url{https://www.ametsoc.org/ams/index.cfm/publications/authors/journal-and-bams-authors/author-resources/latex-author-info/}.
}

\section{\code{asa_article}}{
 This format was adapted from The American
  Statistican (TAS) format, but it should be fairly consistent across
  American Statistical Association (ASA) journals.
}

\section{\code{arxiv_article}}{
 Adapted from the George Kour's format for
  arXiv and bio-arXiv preprints. So far as I'm aware, entirely
  unofficial but still a staple.
}

\section{\code{bioinformatics_article}}{
 Format for creating submissions to a Bioinformatics journal. Adapted from
\url{https://academic.oup.com/bioinformatics/pages/submission_online}.
}

\section{\code{biometrics_article}}{
 This format was adapted from the
  Biometrics journal.
}

\section{\code{ctex_article}}{
 A wrapper function for
  \code{rmarkdown::pdf_document()} and the default value of
  \code{latex_engine} is changed to \command{xelatex}, so it works better for
  typesetting Chinese documents with the LaTeX package \pkg{ctex}. The
  function \code{ctex} is an alias of \code{ctex_article}.
}

\section{\code{elsevier_article}}{
 Format for creating submissions to Elsevier
  journals. Adapted from
  \url{https://www.elsevier.com/authors/author-schemas/latex-instructions}.
}

\section{\code{frontiers_article}}{
 Format for creating Frontiers journal
  articles. Adapted from
  \url{https://www.frontiersin.org/about/author-guidelines}.
}

\section{\code{mdpi_article}}{
 Format for creating submissions to
  Multidisciplinary Digital Publishing Institute (MDPI) journals. Adapted
  from \url{https://www.mdpi.com/authors/latex}.
}

\section{\code{mnras_article}}{
 Format for creating an Monthly Notices of
  Royal Astronomical Society (MNRAS) Journal articles. Adapted from
  \url{https://ras.ac.uk}.
}

\section{\code{oup_article}}{
 Format for creating submissions to many Oxford University Press
  journals. Adapted from
  \url{https://academic.oup.com/journals/pages/authors/preparing_your_manuscript}
  and \url{https://academic.oup.com/icesjms/pages/General_Instructions}.
}

\section{\code{peerj_article}}{
 Format for creating submissions to The PeerJ
  Journal. This was adapted from the
  \href{https://www.overleaf.com/latex/templates/latex-template-for-peerj-journal-and-pre-print-submissions/ptdwfrqxqzbn}{PeerJ
   Overleaf Template}.
}

\section{\code{plos_article}}{
 Format for creating submissions to PLOS
  journals. Adapted from \url{https://journals.plos.org/ploscompbiol/s/latex}.
}

\section{\code{pnas_article}}{
 Format for creating submissions to PNAS
  journals.
}

\section{\code{sage_article}}{
 Format for creating submissions to Sage
  Journals. Based on the official Sage Journals
  \href{https://uk.sagepub.com/sites/default/files/sage_latex_template_4.zip}{class}.

Possible arguments for the YAML header are:
\itemize{
  \item \code{title} title of the manuscript
  \item \code{runninghead} short author list for header
  \item \code{author} list of authors, containing \code{name} and \code{num}
  \item \code{address} list containing \code{num} and \code{org} for defining \code{author} affiliations
  \item \code{corrauth} corresponding author name and address
  \item \code{email} correspondence email
  \item \code{abstract} abstract, limited to 200 words
  \item \code{keywords} keywords for the article
  \item \code{bibliography} BibTeX \code{.bib} file name
  \item \code{classoption} options of the \code{sagej} class
 \item \code{header-includes}: custom additions to the header, before the \code{\\begin\{document\}} statement
 \item \code{include-after}: for including additional LaTeX code before the \code{\\end\{document\}} statement}
}

\section{\code{sim_article}}{
 Format for creating submissions to Statistics in
  Medicine. Based on the official Statistics in Medicine
  \href{http://onlinelibrary.wiley.com/journal/10.1002/(ISSN)1097-0258/homepage/la_tex_class_file.htm}{class}.

Possible arguments for the YAML header are:
\itemize{
  \item \code{title} title of the manuscript
  \item \code{author} list of authors, containing \code{name} and \code{num}
  \item \code{address} list containing \code{num} and \code{org} for defining \code{author} affiliations
  \item \code{presentaddress} not sure what they mean with this
  \item \code{corres} author and address for correspondence
  \item \code{authormark} short author list for header
  \item \code{received}, \code{revised}, \code{accepted} dates of submission, revision, and acceptance of the manuscript
  \item \code{abstract} abstract, limited to 250 words
  \item \code{keywords} up to 6 keywords
  \item \code{bibliography} BibTeX \code{.bib} file
  \item \code{classoption} options of the \code{WileyNJD-v2} class
  \item \code{longtable} set to \code{true} to include the \code{longtable} package, used by default from \code{pandoc} to convert markdown to LaTeX code
 \item \code{header-includes}: custom additions to the header, before the \code{\\begin\{document\}} statement
 \item \code{include-after}: for including additional LaTeX code before the \code{\\end\{document\}} statement}
}

\section{\code{springer_article}}{
 This format was adapted from the Springer
  Macro package for Springer Journals.
}

\section{\code{tf_article}}{
 Format for creating submissions to a Taylor & Francis journal. Adapted from
\url{https://www.tandf.co.uk/journals/authors/InteractCADLaTeX.zip}.
}

\examples{
\dontrun{
rmarkdown::draft("MyArticle.Rmd", template = "acm", package = "rticles")
rmarkdown::draft("MyArticle.Rmd", template = "asa", package = "rticles")}
}
