% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{get_valid_query}
\alias{get_valid_query}
\title{Get Valid Query Example}
\usage{
get_valid_query(modality = "bulk")
}
\arguments{
\item{modality}{Character string specifying the modality. Either "bulk" or "single-cell".
Default is "bulk".}
}
\value{
A list representing a valid query structure.
}
\description{
Generates a sample query for prediction and validation for the model.
This function provides an example query structure that can be modified for specific needs.
The sample query contains two example inputs: one for a cell line with CRISPR perturbation
and another for a primary tissue sample with disease information.
}
\examples{
# Get a sample query for bulk RNA-seq
query <- get_valid_query()

# Get a sample query for single-cell RNA-seq
query_sc <- get_valid_query(modality = "single-cell")

# Modify the query
query$inputs[[1]]$num_samples <- 10
}
