% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{chart}
\alias{chart}
\alias{chart,character-method}
\alias{chart,SsimObject-method}
\title{Create or open a chart}
\usage{
chart(ssimObject = NULL, chart = NULL, create = FALSE, summary = FALSE)

\S4method{chart}{character}(ssimObject = NULL, chart = NULL, create = FALSE, summary = FALSE)

\S4method{chart}{SsimObject}(ssimObject = NULL, chart = NULL, create = FALSE, summary = FALSE)
}
\arguments{
\item{ssimObject}{\code{\link{Project}} or \code{\link{Scenario}} object}

\item{chart}{character or integer. If character, then will either open an
existing chart if \code{create=FALSE}, or will create a new chart with the
given name if the chart does not exist yet or \code{create=TRUE}.
If integer, will open the existing chart with the given chart ID (if the
ID exists). If no value is provided and \code{create=TRUE}, a new chart will
be created with the default naming convention (e.g. "_Chart1", "_Chart2")}

\item{create}{logical. Whether to create a new chart if the chart name given
already exists in the SyncroSim library. If \code{FALSE} (Default), then will
return the existing chart with the given name. If \code{TRUE}, then will
return a new chart with the same name as an existing chart (but different
chart ID)}

\item{summary}{logical. If \code{TRUE}, returns a summary of chart
information as an R data.frame. If \code{FALSE} (Default), then returns
a SyncroSim Chart object}
}
\value{
A \code{Chart} object representing a SyncroSim chart
}
\description{
Create or open a \code{\link{Chart}} from a SyncroSim
\code{\link{Project}}.
}
\examples{
\dontrun{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, 
                         session = mySession,
                         packages = "stsim") 
myProject <- project(myLibrary, project = "My Project")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Create a new chart
myChart <- chart(myProject, chart = "New Chart")
}
}
