% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sunlight_tocsv}
\alias{sunlight_tocsv}
\alias{sunlight_tocsv.cg_getcommitteelist}
\alias{sunlight_tocsv.cg_getcommittees}
\alias{sunlight_tocsv.cg_getcommitteesallleg}
\alias{sunlight_tocsv.cg_getdistrictlatlong}
\alias{sunlight_tocsv.cg_getdistrictzip}
\alias{sunlight_tocsv.cg_getlegislator}
\title{Write data from any rsunlight function output to a csv file on your machine.}
\usage{
sunlight_tocsv(x, file = "~/", ...)

\method{sunlight_tocsv}{cg_getcommittees}(x, file = "~/", ...)

\method{sunlight_tocsv}{cg_getcommitteesallleg}(x, file = "~/", ...)

\method{sunlight_tocsv}{cg_getcommitteelist}(x, file = "~/", ...)

\method{sunlight_tocsv}{cg_getdistrictlatlong}(x, file = "~/", ...)

\method{sunlight_tocsv}{cg_getdistrictzip}(x, file = "~/", ...)

\method{sunlight_tocsv}{cg_getlegislator}(x, file = "~/", ...)
}
\arguments{
\item{x}{Output from any of the rsunlight functions.}

\item{file}{File name, with path.}

\item{...}{Further args passed to read.csv}
}
\description{
Write data from any rsunlight function output to a csv file on your machine.
}
\details{
This function attemps to coerce the raw output from each rsunlight function to a
data.frame to write to csv, but it may fail in some cases. You can always make your own
data.frame.
}
\examples{
\dontrun{
out <- cg_getcommittees(id = 'JSPR')
sunlight_tocsv(out, "~/myfile.csv")

out <- cg_getcommitteesallleg(bioguide_id = 'S000148')
sunlight_tocsv(out, "~/myfile.csv")

out <- cg_getcommitteeslist(chamber = 'Joint')
sunlight_tocsv(out, "~/myfile.csv")

out <- cg_getdistrictlatlong(latitude = 35.778788, longitude = -78.787805)
sunlight_tocsv(out, "~/myfile.csv")

out <- cg_getdistrictzip(zip = 27511)
sunlight_tocsv(out, "~/myfile.csv")

out <- cg_getlegislator(last_name = 'Pelosi')
sunlight_tocsv(out, "~/myfile.csv")
out <- cg_getlegislator(party = 'D')
sunlight_tocsv(out, "~/myfile.csv")
}
}
\keyword{internal}

