% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_test.R
\name{prop_test}
\alias{prop_test}
\alias{pairwise_prop_test}
\alias{row_wise_prop_test}
\title{Proportion Test}
\usage{
prop_test(x, n, p = NULL, alternative = c("two.sided", "less",
  "greater"), correct = TRUE, conf.level = 0.95, detailed = FALSE)

pairwise_prop_test(xtab, p.adjust.method = "holm", ...)

row_wise_prop_test(xtab, p.adjust.method = "holm", detailed = FALSE,
  ...)
}
\arguments{
\item{x}{a vector of counts of successes, a one-dimensional table with
    two entries, or a two-dimensional table (or matrix) with 2 columns,
    giving the counts of successes and failures, respectively.}

\item{n}{a vector of counts of trials; ignored if \code{x} is a
    matrix or a table.}

\item{p}{a vector of probabilities of success.  The length of
    \code{p} must be the same as the number of groups specified by
    \code{x}, and its elements must be greater than 0 and less than 1.}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.  Only used for testing the null that a single proportion
    equals a given value, or that two proportions are equal; ignored
    otherwise.}

\item{correct}{a logical indicating whether Yates' continuity
    correction should be applied where possible.}

\item{conf.level}{confidence level of the returned confidence
    interval.  Must be a single number between 0 and 1.  Only used
    when testing the null that a single proportion equals a given
    value, or that two proportions are equal; ignored otherwise.}

\item{detailed}{logical value. Default is FALSE. If TRUE, a detailed result is
shown.}

\item{xtab}{a cross-tabulation (or contingency table) with two columns and
multiple rows (rx2 design). The columns give the counts of successes and
failures respectively.}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}

\item{...}{Other arguments passed to the function \code{prop_test()}.}
}
\value{
return a data frame with some the following columns: \itemize{
\item \code{n}: the number of participants.
\item \code{group}: the categories in the row-wise proportion tests. \item
 \code{statistic}: the value of Pearson's chi-squared test statistic. \item
 \code{df}: the degrees of freedom of the approximate chi-squared
 distribution of the test statistic. \item \code{p}: p-value. \item
 \code{p.adj}: the adjusted p-value. \item \code{method}: the used
 statistical test. \item \code{p.signif, p.adj.signif}: the significance
 level of p-values and adjusted p-values, respectively. \item
 \code{estimate}: a vector with the sample proportions x/n. \item
 \code{estimate1, estimate2}: the proportion in each of the two populations.
 \item \code{alternative}: a character string describing the alternative
 hypothesis. \item \code{conf.low,conf.high}: Lower and upper bound on a
 confidence interval. a confidence interval for the true proportion if there
 is one group, or for the difference in proportions if there are 2 groups and
 p is not given, or NULL otherwise. In the cases where it is not NULL, the
 returned confidence interval has an asymptotic confidence level as specified
 by conf.level, and is appropriate to the specified alternative hypothesis.}

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs proportion tests to either evaluate the homogeneity of
 proportions (probabilities of success) in several groups or to test that the
 proportions are equal to certain given values.

 Wrappers around the R base function \code{\link[stats]{prop.test}()} but have
 the advantage of performing pairwise and row-wise z-test of two proportions,
 the post-hoc tests following a significant chi-square test of homogeneity
 for 2xc and rx2 contingency tables.
}
\section{Functions}{
\itemize{
\item \code{prop_test}: performs one-sample and two-samples z-test of
proportions. Wrapper around the function \code{\link[stats]{prop.test}()}.

\item \code{pairwise_prop_test}: pairwise comparisons between proportions, a post-hoc
tests following a significant chi-square test of homogeneity for 2xc
design. Wrapper around \code{\link[stats]{pairwise.prop.test}()}

\item \code{row_wise_prop_test}: performs row-wise z-test of two proportions, a post-hoc tests following a significant chi-square test
of homogeneity for rx2 contingency table. The z-test of two proportions is calculated for each category (row).
}}

\examples{
# Comparing an observed proportion to an expected proportion
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
prop_test(x = 95, n = 160, p = 0.5, detailed = TRUE)

# Comparing two proportions
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Data: frequencies of smokers between two groups
xtab <- as.table(rbind(c(490, 10), c(400, 100)))
dimnames(xtab) <- list(
  group = c("grp1", "grp2"),
  smoker = c("yes", "no")
)
xtab
# compare the proportion of smokers
prop_test(xtab, detailed = TRUE)

# Homogeneity of proportions between groups
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# H0: the proportion of smokers is similar in the four groups
# Ha:  this proportion is different in at least one of the populations.
#
# Data preparation
grp.size <- c( 106, 113, 156, 102 )
smokers  <- c( 50, 100, 139, 80 )
no.smokers <- grp.size - smokers
xtab <- as.table(rbind(
  smokers,
  no.smokers
))
dimnames(xtab) <- list(
  Smokers = c("Yes", "No"),
  Groups = c("grp1", "grp2", "grp3", "grp4")
)
xtab

# Compare the proportions of smokers between groups
prop_test(xtab, detailed = TRUE)

# Pairwise comparison between groups
pairwise_prop_test(xtab)


# Pairwise proportion tests
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Data: Titanic
xtab <- as.table(rbind(
  c(122, 167, 528, 673),
  c(203, 118, 178, 212)
))
dimnames(xtab) <- list(
  Survived = c("No", "Yes"),
  Class = c("1st", "2nd", "3rd", "Crew")
)
xtab
# Compare the proportion of survived between groups
pairwise_prop_test(xtab)

# Row-wise proportion tests
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Data: Titanic
xtab <- as.table(rbind(
  c(180, 145), c(179, 106),
  c(510, 196), c(862, 23)
))
dimnames(xtab) <- list(
  Class = c("1st", "2nd", "3rd", "Crew"),
  Gender = c("Male", "Female")
)
xtab
# Compare the proportion of males and females in each category
row_wise_prop_test(xtab)
}
