% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_error.R
\name{predictive_error}
\alias{predictive_error}
\alias{predictive_error.stapreg}
\title{In-sample or out-of-sample predictive errors}
\usage{
\method{predictive_error}{stapreg}(object, newsubjdata = NULL,
  newdistdata = NULL, newtimedata = NULL, draws = NULL,
  re.form = NULL, seed = NULL, offset = NULL, ...)
}
\arguments{
\item{object}{Either a fitted model object returned by one of the 
\pkg{rstap} modeling functions (a \link[=stapreg-objects]{stapreg 
object}) or, for the \code{"ppd"} method, a matrix of draws from the 
posterior predictive distribution returned by 
\code{\link{posterior_predict}}.}

\item{newsubjdata, newdistdata, newtimedata, draws, seed, offset, re.form}{Optional arguments passed to 
\code{\link{posterior_predict}}. For binomial models, please see the
\strong{Note} section below if \code{newsubjdata} will be specified.}

\item{...}{Currently ignored.}
}
\value{
A \code{draws} by \code{nrow(newsubjdata)} matrix. If \code{newsubjdata} is 
  not specified then it will be \code{draws} by \code{nobs(object)}.
}
\description{
This is a convenience function for computing \eqn{y - y^{rep}}{y - yrep} 
(in-sample, for observed \eqn{y}) or \eqn{y - \tilde{y}}{y - ytilde} 
(out-of-sample, for new or held-out \eqn{y}). The method for stapreg objects 
calls \code{\link{posterior_predict}} internally, whereas the method for
objects with class \code{"ppd"} accepts the matrix returned by 
\code{posterior_predict} as input and can be used to avoid multiple calls to 
\code{posterior_predict}.

The \pkg{rstap} model-fitting functions return an object of class 
\code{'stapreg'}, which is a list containing at a minimum the components listed 
below. Each \code{stapreg} object will also have additional classes (e.g. 'glm')
and several additional components depending on the model and estimation 
algorithm. \cr
\cr
}
\note{
The \strong{Note} section in \code{\link{posterior_predict}} about 
  \code{nnewsubjdata} for binomial models also applies for
  \code{predictive_error}, with one important difference. For
  \code{posterior_predict} if the left-hand side of the model formula is 
  \code{cbind(successes, failures)} then the particular values of 
  \code{successes} and \code{failures} in \code{newsubjdata} don't matter, only 
  that they add to the desired number of trials. \strong{This is not the case
  for} \code{predictive_error}. For \code{predictive_error} the particular
  value of \code{successes} matters because it is used as \eqn{y} when
  computing the error.
}
\section{Elements for \code{stapreg} objects}{
   
\describe{
  \item{\code{coefficients}}{
  Point estimates, as described in \code{\link{print.stapreg}}.
  }
  \item{\code{ses}}{
  Standard errors based on \code{\link[stats]{mad}}, as described in
  \code{\link{print.stapreg}}.
  }
  \item{\code{residuals}}{
  Residuals of type \code{'response'}.
  }
  \item{\code{fitted.values}}{
  Fitted mean values. For GLMs the linear predictors are transformed by the
  inverse link function.
  }
  \item{\code{linear.predictors}}{
  Linear fit on the link scale. For linear models this is the same as
  \code{fitted.values}.
  }
  \item{\code{covmat}}{
  Variance-covariance matrix for the coefficients based on draws from the
  posterior distribution, the variational approximation, or the asymptotic 
  sampling distribution, depending on the estimation algorithm.
  }
  \item{\code{model,x,y,z}}{
  If requested, the the model frame, model matrix and response variable used, 
  respectively. Note that z corresponds to the fixed covariates, z to the spatial aggregated covariates, and y the response.
  }
  \item{\code{family}}{
  The \code{\link[stats]{family}} object used.
  }
  \item{\code{call}}{
  The matched call.
  }
  \item{\code{formula}}{
  The model \code{\link[stats]{formula}}.
  }
  \item{\code{data,offset,weights}}{
  The \code{data}, \code{offset}, and \code{weights} arguments.
  }
  \item{\code{prior.info}}{
  A list with information about the prior distributions used.
  }
  \item{\code{stapfit,stan_summary}}{
  The object of \code{\link[rstan]{stanfit-class}} returned by RStan and a
  matrix of various summary statistics from the stapfit object.
  }
  \item{\code{rstan_version}}{
  The version of the \pkg{rstan} package that was used to fit the model.
  }
}
}

\seealso{
\code{\link[=posterior_predict.stapreg]{posterior_predict}} to draw
  from the posterior predictive distribution without computing predictive
  errors.
}
