/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_bernoulli_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
make_theta_L(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
            (void) theta_L;  // dummy to suppress unused var warning
            stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(theta_L,DUMMY_VAR__);
            int zeta_mark(0);
            (void) zeta_mark;  // dummy to suppress unused var warning
            stan::math::fill(zeta_mark, std::numeric_limits<int>::min());
            stan::math::assign(zeta_mark,1);
            int rho_mark(0);
            (void) rho_mark;  // dummy to suppress unused var warning
            stan::math::fill(rho_mark, std::numeric_limits<int>::min());
            stan::math::assign(rho_mark,1);
            int z_T_mark(0);
            (void) z_T_mark;  // dummy to suppress unused var warning
            stan::math::fill(z_T_mark, std::numeric_limits<int>::min());
            stan::math::assign(z_T_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {

                        stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), ((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion));
                        stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            fun_scalar_t__ std_dev;
                            (void) std_dev;  // dummy to suppress unused var warning
                            stan::math::initialize(std_dev, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(std_dev,DUMMY_VAR__);
                            fun_scalar_t__ T21;
                            (void) T21;  // dummy to suppress unused var warning
                            stan::math::initialize(T21, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T21,DUMMY_VAR__);
                            fun_scalar_t__ trace_T_i;
                            (void) trace_T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(trace_T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(trace_T_i,DUMMY_VAR__);
                            stan::math::assign(trace_T_i,(square(((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion)) * nc));
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(nc));
                            (void) pi;  // dummy to suppress unused var warning
                            stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(pi,DUMMY_VAR__);
                            stan::math::assign(pi,segment(zeta,zeta_mark,nc));


                            stan::math::assign(pi, divide(pi,sum(pi)));
                            stan::math::assign(zeta_mark, (zeta_mark + nc));
                            stan::math::assign(std_dev, sqrt((get_base1(pi,1,"pi",1) * trace_T_i)));
                            stan::math::assign(get_base1_lhs(T_i,1,1,"T_i",1), std_dev);
                            stan::math::assign(std_dev, sqrt((get_base1(pi,2,"pi",1) * trace_T_i)));
                            stan::math::assign(T21, ((2.0 * get_base1(rho,rho_mark,"rho",1)) - 1.0));
                            stan::math::assign(rho_mark, (rho_mark + 1));
                            stan::math::assign(get_base1_lhs(T_i,2,2,"T_i",1), (std_dev * sqrt((1.0 - square(T21)))));
                            stan::math::assign(get_base1_lhs(T_i,2,1,"T_i",1), (std_dev * T21));
                            for (int r = 2; r <= (nc - 1); ++r) {
                                {
                                    int rp1(0);
                                    (void) rp1;  // dummy to suppress unused var warning
                                    stan::math::fill(rp1, std::numeric_limits<int>::min());
                                    stan::math::assign(rp1,(r + 1));
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  T_row(static_cast<Eigen::VectorXd::Index>(r));
                                    (void) T_row;  // dummy to suppress unused var warning
                                    stan::math::initialize(T_row, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(T_row,DUMMY_VAR__);
                                    stan::math::assign(T_row,segment(z_T,z_T_mark,r));
                                    fun_scalar_t__ scale_factor;
                                    (void) scale_factor;  // dummy to suppress unused var warning
                                    stan::math::initialize(scale_factor, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(scale_factor,DUMMY_VAR__);
                                    stan::math::assign(scale_factor,(sqrt((get_base1(rho,rho_mark,"rho",1) / dot_self(T_row))) * std_dev));


                                    stan::math::assign(z_T_mark, (z_T_mark + r));
                                    stan::math::assign(std_dev, sqrt((get_base1(pi,rp1,"pi",1) * trace_T_i)));
                                    for (int c = 1; c <= r; ++c) {
                                        stan::math::assign(get_base1_lhs(T_i,rp1,c,"T_i",1), (get_base1(T_row,c,"T_row",1) * scale_factor));
                                    }
                                    stan::math::assign(get_base1_lhs(T_i,rp1,rp1,"T_i",1), (sqrt((1.0 - get_base1(rho,rho_mark,"rho",1))) * std_dev));
                                    stan::math::assign(rho_mark, (rho_mark + 1));
                                }
                            }
                            for (int c = 1; c <= nc; ++c) {
                                for (int r = c; r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), get_base1(T_i,r,c,"T_i",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(theta_L);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_theta_L_functor__ {
    template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
    operator()(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) const {
        return make_theta_L(len_theta_L, p, dispersion, tau, scale, zeta, rho, z_T, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
make_b(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(rows(z_b)));
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(b,DUMMY_VAR__);
            int b_mark(0);
            (void) b_mark;  // dummy to suppress unused var warning
            stan::math::fill(b_mark, std::numeric_limits<int>::min());
            stan::math::assign(b_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {
                        {
                            fun_scalar_t__ theta_L_start;
                            (void) theta_L_start;  // dummy to suppress unused var warning
                            stan::math::initialize(theta_L_start, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(theta_L_start,DUMMY_VAR__);
                            stan::math::assign(theta_L_start,get_base1(theta_L,theta_L_mark,"theta_L",1));


                            for (int s = b_mark; s <= ((b_mark + get_base1(l,i,"l",1)) - 1); ++s) {
                                stan::math::assign(get_base1_lhs(b,s,"b",1), (theta_L_start * get_base1(z_b,s,"z_b",1)));
                            }
                            stan::math::assign(b_mark, (b_mark + get_base1(l,i,"l",1)));
                            stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                        }
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            stan::math::assign(T_i,rep_matrix(0,nc,nc));


                            for (int c = 1; c <= nc; ++c) {

                                stan::math::assign(get_base1_lhs(T_i,c,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                for (int r = (c + 1); r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(T_i,r,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                            for (int j = 1; j <= get_base1(l,i,"l",1); ++j) {
                                {
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  temp(static_cast<Eigen::VectorXd::Index>(nc));
                                    (void) temp;  // dummy to suppress unused var warning
                                    stan::math::initialize(temp, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(temp,DUMMY_VAR__);
                                    stan::math::assign(temp,multiply(T_i,segment(z_b,b_mark,nc)));


                                    stan::math::assign(b_mark, (b_mark - 1));
                                    for (int s = 1; s <= nc; ++s) {
                                        stan::math::assign(get_base1_lhs(b,(b_mark + s),"b",1), get_base1(temp,s,"temp",1));
                                    }
                                    stan::math::assign(b_mark, ((b_mark + nc) + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(b);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_b_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) const {
        return make_b(z_b, theta_L, p, l, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
void
decov_lp(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int pos_reg(0);
            (void) pos_reg;  // dummy to suppress unused var warning
            stan::math::fill(pos_reg, std::numeric_limits<int>::min());
            stan::math::assign(pos_reg,1);
            int pos_rho(0);
            (void) pos_rho;  // dummy to suppress unused var warning
            stan::math::fill(pos_rho, std::numeric_limits<int>::min());
            stan::math::assign(pos_rho,1);


            lp_accum__.add(normal_log(z_b,0,1));
            lp_accum__.add(normal_log(z_T,0,1));
            for (int i = 1; i <= t; ++i) {
                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {
                    {
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape1(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape1;  // dummy to suppress unused var warning
                        stan::math::initialize(shape1, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape1,DUMMY_VAR__);
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape2(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape2;  // dummy to suppress unused var warning
                        stan::math::initialize(shape2, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape2,DUMMY_VAR__);
                        fun_scalar_t__ nu;
                        (void) nu;  // dummy to suppress unused var warning
                        stan::math::initialize(nu, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(nu,DUMMY_VAR__);
                        stan::math::assign(nu,(get_base1(regularization,pos_reg,"regularization",1) + (0.5 * (get_base1(p,i,"p",1) - 2))));


                        stan::math::assign(pos_reg, (pos_reg + 1));
                        stan::math::assign(get_base1_lhs(shape1,1,"shape1",1), nu);
                        stan::math::assign(get_base1_lhs(shape2,1,"shape2",1), nu);
                        for (int j = 2; j <= (get_base1(p,i,"p",1) - 1); ++j) {

                            stan::math::assign(nu, (nu - 0.5));
                            stan::math::assign(get_base1_lhs(shape1,j,"shape1",1), (0.5 * j));
                            stan::math::assign(get_base1_lhs(shape2,j,"shape2",1), nu);
                        }
                        lp_accum__.add(beta_log(stan::model::rvalue(rho, stan::model::cons_list(stan::model::index_min_max(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 2)), stan::model::nil_index_list()), "rho"),shape1,shape2));
                        stan::math::assign(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 1));
                    }
                }
            }
            lp_accum__.add(gamma_log(zeta,delta,1));
            lp_accum__.add(gamma_log(tau,shape,1));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct decov_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return decov_lp(z_b, z_T, rho, zeta, tau, regularization, delta, shape, t, p, lp__, lp_accum__, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hs_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(rows(z_beta)));
            (void) lambda;  // dummy to suppress unused var warning
            stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lambda,DUMMY_VAR__);
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());


            stan::math::assign(K, rows(z_beta));
            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(lambda,k,"lambda",1), (get_base1(get_base1(local,1,"local",1),k,"local",2) * sqrt(get_base1(get_base1(local,2,"local",1),k,"local",2))));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(z_beta,lambda),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hs_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) const {
        return hs_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hsplus_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(elt_multiply(z_beta,elt_multiply(get_base1(local,1,"local",1),sqrt(get_base1(local,2,"local",1)))),elt_multiply(get_base1(local,3,"local",1),sqrt(get_base1(local,4,"local",1)))),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hsplus_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) const {
        return hsplus_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
divide_real_by_vector(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());
            stan::math::assign(K,rows(y));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ret(static_cast<Eigen::VectorXd::Index>(K));
            (void) ret;  // dummy to suppress unused var warning
            stan::math::initialize(ret, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ret,DUMMY_VAR__);


            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(ret,k,"ret",1), (x / get_base1(y,k,"y",1)));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct divide_real_by_vector_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) const {
        return divide_real_by_vector(x, y, pstream__);
    }
};

template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
CFt(const T0__& z,
        const T1__& df, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ z2;
            (void) z2;  // dummy to suppress unused var warning
            stan::math::initialize(z2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z2,DUMMY_VAR__);
            stan::math::assign(z2,square(z));
            fun_scalar_t__ z3;
            (void) z3;  // dummy to suppress unused var warning
            stan::math::initialize(z3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z3,DUMMY_VAR__);
            stan::math::assign(z3,(z2 * z));
            fun_scalar_t__ z5;
            (void) z5;  // dummy to suppress unused var warning
            stan::math::initialize(z5, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z5,DUMMY_VAR__);
            stan::math::assign(z5,(z2 * z3));
            fun_scalar_t__ z7;
            (void) z7;  // dummy to suppress unused var warning
            stan::math::initialize(z7, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z7,DUMMY_VAR__);
            stan::math::assign(z7,(z2 * z5));
            fun_scalar_t__ z9;
            (void) z9;  // dummy to suppress unused var warning
            stan::math::initialize(z9, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z9,DUMMY_VAR__);
            stan::math::assign(z9,(z2 * z7));
            fun_scalar_t__ df2;
            (void) df2;  // dummy to suppress unused var warning
            stan::math::initialize(df2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df2,DUMMY_VAR__);
            stan::math::assign(df2,square(df));
            fun_scalar_t__ df3;
            (void) df3;  // dummy to suppress unused var warning
            stan::math::initialize(df3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df3,DUMMY_VAR__);
            stan::math::assign(df3,(df2 * df));
            fun_scalar_t__ df4;
            (void) df4;  // dummy to suppress unused var warning
            stan::math::initialize(df4, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df4,DUMMY_VAR__);
            stan::math::assign(df4,(df2 * df2));


            return stan::math::promote_scalar<fun_return_scalar_t__>(((((z + ((z3 + z) / (4 * df))) + ((((5 * z5) + (16 * z3)) + (3 * z)) / (96 * df2))) + (((((3 * z7) + (19 * z5)) + (17 * z3)) - (15 * z)) / (384 * df3))) + ((((((79 * z9) + (776 * z7)) + (1482 * z5)) - (1920 * z3)) - (945 * z)) / (92160 * df4))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct CFt_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& z,
        const T1__& df, std::ostream* pstream__) const {
        return CFt(z, df, pstream__);
    }
};

std::vector<std::vector<int> >
make_V(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) {
    typedef double fun_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<vector<int> > V(t, (vector<int>(N, 0)));
            stan::math::fill(V, std::numeric_limits<int>::min());
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);


            if (as_bool(logical_gt(t,0))) {
                for (int j = 1; j <= N; ++j) {
                    for (int i = 1; i <= t; ++i) {

                        stan::math::assign(get_base1_lhs(get_base1_lhs(V,i,"V",1),j,"V",2), get_base1(v,pos,"v",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(V);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_V_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) const {
        return make_V(N, t, v, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_bern(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                 const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_logit(eta));
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(Phi(eta));
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(add(divide(atan(eta),stan::math::pi()),0.5));
        } else if (as_bool(logical_eq(link,4))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(exp(eta));
        } else if (as_bool(logical_eq(link,5))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_cloglog(eta));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_bern_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                 const int& link, std::ostream* pstream__) const {
        return linkinv_bern(eta, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T_lp__, typename T_lp_accum__>
typename boost::math::tools::promote_args<T0__, T1__, T_lp__>::type
ll_bern_lp(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta0,
               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta1,
               const int& link,
               const std::vector<int>& N, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T_lp__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,5))))) {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        if (as_bool(logical_eq(link,1))) {

            lp_accum__.add(logistic_ccdf_log(eta0,0,1));
            lp_accum__.add(logistic_cdf_log(eta1,0,1));
        } else if (as_bool(logical_eq(link,2))) {

            lp_accum__.add(normal_ccdf_log(eta0,0,1));
            lp_accum__.add(normal_cdf_log(eta1,0,1));
        } else if (as_bool(logical_eq(link,3))) {

            lp_accum__.add(cauchy_ccdf_log(eta0,0,1));
            lp_accum__.add(cauchy_cdf_log(eta1,0,1));
        } else if (as_bool(logical_eq(link,4))) {

            lp_accum__.add(log1m_exp(eta0));
            lp_accum__.add(eta1);
        } else if (as_bool(logical_eq(link,5))) {

            lp_accum__.add(log1m_exp(minus(exp(eta1))));
            lp_accum__.add(minus(exp(eta0)));
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(get_lp(lp__, lp_accum__));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct ll_bern_lp_functor__ {
    template <typename T0__, typename T1__, typename T_lp__, typename T_lp_accum__>
        typename boost::math::tools::promote_args<T0__, T1__, T_lp__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta0,
               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta1,
               const int& link,
               const std::vector<int>& N, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return ll_bern_lp(eta0, eta1, link, N, lp__, lp_accum__, pstream__);
    }
};

template <typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic,1>
pw_bern(const int& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int N(0);
            (void) N;  // dummy to suppress unused var warning
            stan::math::fill(N, std::numeric_limits<int>::min());
            stan::math::assign(N,rows(eta));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(N));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,5))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(link,1))) {

                for (int n = 1; n <= N; ++n) {
                    stan::math::assign(get_base1_lhs(ll,n,"ll",1), bernoulli_logit_log(y,get_base1(eta,n,"eta",1)));
                }
            } else {
                {
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
                    (void) pi;  // dummy to suppress unused var warning
                    stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pi,DUMMY_VAR__);


                    stan::math::assign(pi, linkinv_bern(eta,link, pstream__));
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), bernoulli_log(y,get_base1(pi,n,"pi",1)));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_bern_functor__ {
    template <typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic,1>
    operator()(const int& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const int& link, std::ostream* pstream__) const {
        return pw_bern(y, eta, link, pstream__);
    }
};

class model_bernoulli : public prob_grad {
private:
    int K;
    vector<int> N;
    vector_d xbar;
    int dense_X;
    vector<matrix_d> X0;
    vector<matrix_d> X1;
    int nnz_X0;
    vector_d w_X0;
    vector<int> v_X0;
    vector<int> u_X0;
    int nnz_X1;
    vector_d w_X1;
    vector<int> v_X1;
    vector<int> u_X1;
    int prior_PD;
    int has_intercept;
    int family;
    int link;
    int prior_dist;
    int prior_dist_for_intercept;
    int prior_dist_for_aux;
    int has_weights;
    vector_d weights0;
    vector_d weights1;
    int has_offset;
    vector_d offset0;
    vector_d offset1;
    vector_d prior_scale;
    double prior_scale_for_intercept;
    double prior_scale_for_aux;
    vector_d prior_mean;
    double prior_mean_for_intercept;
    double prior_mean_for_aux;
    vector_d prior_df;
    double prior_df_for_intercept;
    double prior_df_for_aux;
    double global_prior_df;
    double global_prior_scale;
    vector<int> num_normals;
    int t;
    vector<int> p;
    vector<int> l;
    int q;
    int len_theta_L;
    vector_d shape;
    vector_d scale;
    int len_concentration;
    vector<double> concentration;
    int len_regularization;
    vector<double> regularization;
    vector<int> num_non_zero;
    vector_d w0;
    vector_d w1;
    vector<int> v0;
    vector<int> v1;
    vector<int> u0;
    vector<int> u1;
    int special_case;
    int NN;
    double aux;
    vector<vector<int> > V0;
    vector<vector<int> > V1;
    int len_z_T;
    int len_var_group;
    int len_rho;
    int is_continuous;
    int pos;
    vector<double> delta;
    int hs;
public:
    model_bernoulli(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_bernoulli(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_bernoulli_namespace::model_bernoulli";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(2));
        validate_non_negative_index("N", "2", 2);
        N = std::vector<int>(2,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("xbar", "K", K);
        xbar = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "xbar", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("xbar");
        pos__ = 0;
        size_t xbar_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < xbar_i_vec_lim__; ++i_vec__) {
            xbar[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "dense_X", "int", context__.to_vec());
        dense_X = int(0);
        vals_i__ = context__.vals_i("dense_X");
        pos__ = 0;
        dense_X = vals_i__[pos__++];
        context__.validate_dims("data initialization", "X0", "matrix_d", context__.to_vec(dense_X,get_base1(N,1,"N",1),K));
        validate_non_negative_index("X0", "dense_X", dense_X);
        validate_non_negative_index("X0", "get_base1(N,1,\"N\",1)", get_base1(N,1,"N",1));
        validate_non_negative_index("X0", "K", K);
        X0 = std::vector<matrix_d>(dense_X,matrix_d(static_cast<Eigen::VectorXd::Index>(get_base1(N,1,"N",1)),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("X0");
        pos__ = 0;
        size_t X0_m_mat_lim__ = get_base1(N,1,"N",1);
        size_t X0_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < X0_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X0_m_mat_lim__; ++m_mat__) {
                size_t X0_limit_0__ = dense_X;
                for (size_t i_0__ = 0; i_0__ < X0_limit_0__; ++i_0__) {
                    X0[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }
        context__.validate_dims("data initialization", "X1", "matrix_d", context__.to_vec(dense_X,get_base1(N,2,"N",1),K));
        validate_non_negative_index("X1", "dense_X", dense_X);
        validate_non_negative_index("X1", "get_base1(N,2,\"N\",1)", get_base1(N,2,"N",1));
        validate_non_negative_index("X1", "K", K);
        X1 = std::vector<matrix_d>(dense_X,matrix_d(static_cast<Eigen::VectorXd::Index>(get_base1(N,2,"N",1)),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("X1");
        pos__ = 0;
        size_t X1_m_mat_lim__ = get_base1(N,2,"N",1);
        size_t X1_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < X1_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X1_m_mat_lim__; ++m_mat__) {
                size_t X1_limit_0__ = dense_X;
                for (size_t i_0__ = 0; i_0__ < X1_limit_0__; ++i_0__) {
                    X1[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }
        context__.validate_dims("data initialization", "nnz_X0", "int", context__.to_vec());
        nnz_X0 = int(0);
        vals_i__ = context__.vals_i("nnz_X0");
        pos__ = 0;
        nnz_X0 = vals_i__[pos__++];
        validate_non_negative_index("w_X0", "nnz_X0", nnz_X0);
        w_X0 = vector_d(static_cast<Eigen::VectorXd::Index>(nnz_X0));
        context__.validate_dims("data initialization", "w_X0", "vector_d", context__.to_vec(nnz_X0));
        vals_r__ = context__.vals_r("w_X0");
        pos__ = 0;
        size_t w_X0_i_vec_lim__ = nnz_X0;
        for (size_t i_vec__ = 0; i_vec__ < w_X0_i_vec_lim__; ++i_vec__) {
            w_X0[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v_X0", "int", context__.to_vec(nnz_X0));
        validate_non_negative_index("v_X0", "nnz_X0", nnz_X0);
        v_X0 = std::vector<int>(nnz_X0,int(0));
        vals_i__ = context__.vals_i("v_X0");
        pos__ = 0;
        size_t v_X0_limit_0__ = nnz_X0;
        for (size_t i_0__ = 0; i_0__ < v_X0_limit_0__; ++i_0__) {
            v_X0[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u_X0", "int", context__.to_vec((dense_X ? 0 : (get_base1(N,1,"N",1) + 1) )));
        validate_non_negative_index("u_X0", "(dense_X ? 0 : (get_base1(N,1,\"N\",1) + 1) )", (dense_X ? 0 : (get_base1(N,1,"N",1) + 1) ));
        u_X0 = std::vector<int>((dense_X ? 0 : (get_base1(N,1,"N",1) + 1) ),int(0));
        vals_i__ = context__.vals_i("u_X0");
        pos__ = 0;
        size_t u_X0_limit_0__ = (dense_X ? 0 : (get_base1(N,1,"N",1) + 1) );
        for (size_t i_0__ = 0; i_0__ < u_X0_limit_0__; ++i_0__) {
            u_X0[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "nnz_X1", "int", context__.to_vec());
        nnz_X1 = int(0);
        vals_i__ = context__.vals_i("nnz_X1");
        pos__ = 0;
        nnz_X1 = vals_i__[pos__++];
        validate_non_negative_index("w_X1", "nnz_X1", nnz_X1);
        w_X1 = vector_d(static_cast<Eigen::VectorXd::Index>(nnz_X1));
        context__.validate_dims("data initialization", "w_X1", "vector_d", context__.to_vec(nnz_X1));
        vals_r__ = context__.vals_r("w_X1");
        pos__ = 0;
        size_t w_X1_i_vec_lim__ = nnz_X1;
        for (size_t i_vec__ = 0; i_vec__ < w_X1_i_vec_lim__; ++i_vec__) {
            w_X1[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v_X1", "int", context__.to_vec(nnz_X1));
        validate_non_negative_index("v_X1", "nnz_X1", nnz_X1);
        v_X1 = std::vector<int>(nnz_X1,int(0));
        vals_i__ = context__.vals_i("v_X1");
        pos__ = 0;
        size_t v_X1_limit_0__ = nnz_X1;
        for (size_t i_0__ = 0; i_0__ < v_X1_limit_0__; ++i_0__) {
            v_X1[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u_X1", "int", context__.to_vec((dense_X ? 0 : (get_base1(N,2,"N",1) + 1) )));
        validate_non_negative_index("u_X1", "(dense_X ? 0 : (get_base1(N,2,\"N\",1) + 1) )", (dense_X ? 0 : (get_base1(N,2,"N",1) + 1) ));
        u_X1 = std::vector<int>((dense_X ? 0 : (get_base1(N,2,"N",1) + 1) ),int(0));
        vals_i__ = context__.vals_i("u_X1");
        pos__ = 0;
        size_t u_X1_limit_0__ = (dense_X ? 0 : (get_base1(N,2,"N",1) + 1) );
        for (size_t i_0__ = 0; i_0__ < u_X1_limit_0__; ++i_0__) {
            u_X1[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
        prior_PD = int(0);
        vals_i__ = context__.vals_i("prior_PD");
        pos__ = 0;
        prior_PD = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
        has_intercept = int(0);
        vals_i__ = context__.vals_i("has_intercept");
        pos__ = 0;
        has_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "family", "int", context__.to_vec());
        family = int(0);
        vals_i__ = context__.vals_i("family");
        pos__ = 0;
        family = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link", "int", context__.to_vec());
        link = int(0);
        vals_i__ = context__.vals_i("link");
        pos__ = 0;
        link = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
        prior_dist = int(0);
        vals_i__ = context__.vals_i("prior_dist");
        pos__ = 0;
        prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec());
        prior_dist_for_intercept = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept");
        pos__ = 0;
        prior_dist_for_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_aux", "int", context__.to_vec());
        prior_dist_for_aux = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_aux");
        pos__ = 0;
        prior_dist_for_aux = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_weights", "int", context__.to_vec());
        has_weights = int(0);
        vals_i__ = context__.vals_i("has_weights");
        pos__ = 0;
        has_weights = vals_i__[pos__++];
        validate_non_negative_index("weights0", "(has_weights ? get_base1(N,1,\"N\",1) : 0 )", (has_weights ? get_base1(N,1,"N",1) : 0 ));
        weights0 = vector_d(static_cast<Eigen::VectorXd::Index>((has_weights ? get_base1(N,1,"N",1) : 0 )));
        context__.validate_dims("data initialization", "weights0", "vector_d", context__.to_vec((has_weights ? get_base1(N,1,"N",1) : 0 )));
        vals_r__ = context__.vals_r("weights0");
        pos__ = 0;
        size_t weights0_i_vec_lim__ = (has_weights ? get_base1(N,1,"N",1) : 0 );
        for (size_t i_vec__ = 0; i_vec__ < weights0_i_vec_lim__; ++i_vec__) {
            weights0[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("weights1", "(has_weights ? get_base1(N,2,\"N\",1) : 0 )", (has_weights ? get_base1(N,2,"N",1) : 0 ));
        weights1 = vector_d(static_cast<Eigen::VectorXd::Index>((has_weights ? get_base1(N,2,"N",1) : 0 )));
        context__.validate_dims("data initialization", "weights1", "vector_d", context__.to_vec((has_weights ? get_base1(N,2,"N",1) : 0 )));
        vals_r__ = context__.vals_r("weights1");
        pos__ = 0;
        size_t weights1_i_vec_lim__ = (has_weights ? get_base1(N,2,"N",1) : 0 );
        for (size_t i_vec__ = 0; i_vec__ < weights1_i_vec_lim__; ++i_vec__) {
            weights1[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec());
        has_offset = int(0);
        vals_i__ = context__.vals_i("has_offset");
        pos__ = 0;
        has_offset = vals_i__[pos__++];
        validate_non_negative_index("offset0", "(has_offset ? get_base1(N,1,\"N\",1) : 0 )", (has_offset ? get_base1(N,1,"N",1) : 0 ));
        offset0 = vector_d(static_cast<Eigen::VectorXd::Index>((has_offset ? get_base1(N,1,"N",1) : 0 )));
        context__.validate_dims("data initialization", "offset0", "vector_d", context__.to_vec((has_offset ? get_base1(N,1,"N",1) : 0 )));
        vals_r__ = context__.vals_r("offset0");
        pos__ = 0;
        size_t offset0_i_vec_lim__ = (has_offset ? get_base1(N,1,"N",1) : 0 );
        for (size_t i_vec__ = 0; i_vec__ < offset0_i_vec_lim__; ++i_vec__) {
            offset0[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("offset1", "(has_offset ? get_base1(N,2,\"N\",1) : 0 )", (has_offset ? get_base1(N,2,"N",1) : 0 ));
        offset1 = vector_d(static_cast<Eigen::VectorXd::Index>((has_offset ? get_base1(N,2,"N",1) : 0 )));
        context__.validate_dims("data initialization", "offset1", "vector_d", context__.to_vec((has_offset ? get_base1(N,2,"N",1) : 0 )));
        vals_r__ = context__.vals_r("offset1");
        pos__ = 0;
        size_t offset1_i_vec_lim__ = (has_offset ? get_base1(N,2,"N",1) : 0 );
        for (size_t i_vec__ = 0; i_vec__ < offset1_i_vec_lim__; ++i_vec__) {
            offset1[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("prior_scale", "K", K);
        prior_scale = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_scale", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_scale");
        pos__ = 0;
        size_t prior_scale_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_scale_i_vec_lim__; ++i_vec__) {
            prior_scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_scale_for_intercept", "double", context__.to_vec());
        prior_scale_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_intercept");
        pos__ = 0;
        prior_scale_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_scale_for_aux", "double", context__.to_vec());
        prior_scale_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_aux");
        pos__ = 0;
        prior_scale_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_mean", "K", K);
        prior_mean = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_mean", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_mean");
        pos__ = 0;
        size_t prior_mean_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_mean_i_vec_lim__; ++i_vec__) {
            prior_mean[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_mean_for_intercept", "double", context__.to_vec());
        prior_mean_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_intercept");
        pos__ = 0;
        prior_mean_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_mean_for_aux", "double", context__.to_vec());
        prior_mean_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_aux");
        pos__ = 0;
        prior_mean_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_df", "K", K);
        prior_df = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_df", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_df");
        pos__ = 0;
        size_t prior_df_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_df_i_vec_lim__; ++i_vec__) {
            prior_df[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_df_for_intercept", "double", context__.to_vec());
        prior_df_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_df_for_intercept");
        pos__ = 0;
        prior_df_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_df_for_aux", "double", context__.to_vec());
        prior_df_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_df_for_aux");
        pos__ = 0;
        prior_df_for_aux = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_df", "double", context__.to_vec());
        global_prior_df = double(0);
        vals_r__ = context__.vals_r("global_prior_df");
        pos__ = 0;
        global_prior_df = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_scale", "double", context__.to_vec());
        global_prior_scale = double(0);
        vals_r__ = context__.vals_r("global_prior_scale");
        pos__ = 0;
        global_prior_scale = vals_r__[pos__++];
        context__.validate_dims("data initialization", "num_normals", "int", context__.to_vec((logical_eq(prior_dist,7) ? K : 0 )));
        validate_non_negative_index("num_normals", "(logical_eq(prior_dist,7) ? K : 0 )", (logical_eq(prior_dist,7) ? K : 0 ));
        num_normals = std::vector<int>((logical_eq(prior_dist,7) ? K : 0 ),int(0));
        vals_i__ = context__.vals_i("num_normals");
        pos__ = 0;
        size_t num_normals_limit_0__ = (logical_eq(prior_dist,7) ? K : 0 );
        for (size_t i_0__ = 0; i_0__ < num_normals_limit_0__; ++i_0__) {
            num_normals[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "t", "int", context__.to_vec());
        t = int(0);
        vals_i__ = context__.vals_i("t");
        pos__ = 0;
        t = vals_i__[pos__++];
        context__.validate_dims("data initialization", "p", "int", context__.to_vec(t));
        validate_non_negative_index("p", "t", t);
        p = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("p");
        pos__ = 0;
        size_t p_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < p_limit_0__; ++i_0__) {
            p[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "l", "int", context__.to_vec(t));
        validate_non_negative_index("l", "t", t);
        l = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("l");
        pos__ = 0;
        size_t l_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < l_limit_0__; ++i_0__) {
            l[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "int", context__.to_vec());
        q = int(0);
        vals_i__ = context__.vals_i("q");
        pos__ = 0;
        q = vals_i__[pos__++];
        context__.validate_dims("data initialization", "len_theta_L", "int", context__.to_vec());
        len_theta_L = int(0);
        vals_i__ = context__.vals_i("len_theta_L");
        pos__ = 0;
        len_theta_L = vals_i__[pos__++];
        validate_non_negative_index("shape", "t", t);
        shape = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "shape", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("shape");
        pos__ = 0;
        size_t shape_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < shape_i_vec_lim__; ++i_vec__) {
            shape[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("scale", "t", t);
        scale = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "scale", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("scale");
        pos__ = 0;
        size_t scale_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < scale_i_vec_lim__; ++i_vec__) {
            scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_concentration", "int", context__.to_vec());
        len_concentration = int(0);
        vals_i__ = context__.vals_i("len_concentration");
        pos__ = 0;
        len_concentration = vals_i__[pos__++];
        context__.validate_dims("data initialization", "concentration", "double", context__.to_vec(len_concentration));
        validate_non_negative_index("concentration", "len_concentration", len_concentration);
        concentration = std::vector<double>(len_concentration,double(0));
        vals_r__ = context__.vals_r("concentration");
        pos__ = 0;
        size_t concentration_limit_0__ = len_concentration;
        for (size_t i_0__ = 0; i_0__ < concentration_limit_0__; ++i_0__) {
            concentration[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_regularization", "int", context__.to_vec());
        len_regularization = int(0);
        vals_i__ = context__.vals_i("len_regularization");
        pos__ = 0;
        len_regularization = vals_i__[pos__++];
        context__.validate_dims("data initialization", "regularization", "double", context__.to_vec(len_regularization));
        validate_non_negative_index("regularization", "len_regularization", len_regularization);
        regularization = std::vector<double>(len_regularization,double(0));
        vals_r__ = context__.vals_r("regularization");
        pos__ = 0;
        size_t regularization_limit_0__ = len_regularization;
        for (size_t i_0__ = 0; i_0__ < regularization_limit_0__; ++i_0__) {
            regularization[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "num_non_zero", "int", context__.to_vec(2));
        validate_non_negative_index("num_non_zero", "2", 2);
        num_non_zero = std::vector<int>(2,int(0));
        vals_i__ = context__.vals_i("num_non_zero");
        pos__ = 0;
        size_t num_non_zero_limit_0__ = 2;
        for (size_t i_0__ = 0; i_0__ < num_non_zero_limit_0__; ++i_0__) {
            num_non_zero[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("w0", "get_base1(num_non_zero,1,\"num_non_zero\",1)", get_base1(num_non_zero,1,"num_non_zero",1));
        w0 = vector_d(static_cast<Eigen::VectorXd::Index>(get_base1(num_non_zero,1,"num_non_zero",1)));
        context__.validate_dims("data initialization", "w0", "vector_d", context__.to_vec(get_base1(num_non_zero,1,"num_non_zero",1)));
        vals_r__ = context__.vals_r("w0");
        pos__ = 0;
        size_t w0_i_vec_lim__ = get_base1(num_non_zero,1,"num_non_zero",1);
        for (size_t i_vec__ = 0; i_vec__ < w0_i_vec_lim__; ++i_vec__) {
            w0[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("w1", "get_base1(num_non_zero,2,\"num_non_zero\",1)", get_base1(num_non_zero,2,"num_non_zero",1));
        w1 = vector_d(static_cast<Eigen::VectorXd::Index>(get_base1(num_non_zero,2,"num_non_zero",1)));
        context__.validate_dims("data initialization", "w1", "vector_d", context__.to_vec(get_base1(num_non_zero,2,"num_non_zero",1)));
        vals_r__ = context__.vals_r("w1");
        pos__ = 0;
        size_t w1_i_vec_lim__ = get_base1(num_non_zero,2,"num_non_zero",1);
        for (size_t i_vec__ = 0; i_vec__ < w1_i_vec_lim__; ++i_vec__) {
            w1[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v0", "int", context__.to_vec(get_base1(num_non_zero,1,"num_non_zero",1)));
        validate_non_negative_index("v0", "get_base1(num_non_zero,1,\"num_non_zero\",1)", get_base1(num_non_zero,1,"num_non_zero",1));
        v0 = std::vector<int>(get_base1(num_non_zero,1,"num_non_zero",1),int(0));
        vals_i__ = context__.vals_i("v0");
        pos__ = 0;
        size_t v0_limit_0__ = get_base1(num_non_zero,1,"num_non_zero",1);
        for (size_t i_0__ = 0; i_0__ < v0_limit_0__; ++i_0__) {
            v0[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "v1", "int", context__.to_vec(get_base1(num_non_zero,2,"num_non_zero",1)));
        validate_non_negative_index("v1", "get_base1(num_non_zero,2,\"num_non_zero\",1)", get_base1(num_non_zero,2,"num_non_zero",1));
        v1 = std::vector<int>(get_base1(num_non_zero,2,"num_non_zero",1),int(0));
        vals_i__ = context__.vals_i("v1");
        pos__ = 0;
        size_t v1_limit_0__ = get_base1(num_non_zero,2,"num_non_zero",1);
        for (size_t i_0__ = 0; i_0__ < v1_limit_0__; ++i_0__) {
            v1[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u0", "int", context__.to_vec((logical_gt(t,0) ? (get_base1(N,1,"N",1) + 1) : 0 )));
        validate_non_negative_index("u0", "(logical_gt(t,0) ? (get_base1(N,1,\"N\",1) + 1) : 0 )", (logical_gt(t,0) ? (get_base1(N,1,"N",1) + 1) : 0 ));
        u0 = std::vector<int>((logical_gt(t,0) ? (get_base1(N,1,"N",1) + 1) : 0 ),int(0));
        vals_i__ = context__.vals_i("u0");
        pos__ = 0;
        size_t u0_limit_0__ = (logical_gt(t,0) ? (get_base1(N,1,"N",1) + 1) : 0 );
        for (size_t i_0__ = 0; i_0__ < u0_limit_0__; ++i_0__) {
            u0[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u1", "int", context__.to_vec((logical_gt(t,0) ? (get_base1(N,2,"N",1) + 1) : 0 )));
        validate_non_negative_index("u1", "(logical_gt(t,0) ? (get_base1(N,2,\"N\",1) + 1) : 0 )", (logical_gt(t,0) ? (get_base1(N,2,"N",1) + 1) : 0 ));
        u1 = std::vector<int>((logical_gt(t,0) ? (get_base1(N,2,"N",1) + 1) : 0 ),int(0));
        vals_i__ = context__.vals_i("u1");
        pos__ = 0;
        size_t u1_limit_0__ = (logical_gt(t,0) ? (get_base1(N,2,"N",1) + 1) : 0 );
        for (size_t i_0__ = 0; i_0__ < u1_limit_0__; ++i_0__) {
            u1[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "special_case", "int", context__.to_vec());
        special_case = int(0);
        vals_i__ = context__.vals_i("special_case");
        pos__ = 0;
        special_case = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"K",K,0);
        for (int k0__ = 0; k0__ < 2; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        check_greater_or_equal(function__,"dense_X",dense_X,0);
        check_less_or_equal(function__,"dense_X",dense_X,1);
        check_greater_or_equal(function__,"nnz_X0",nnz_X0,0);
        for (int k0__ = 0; k0__ < nnz_X0; ++k0__) {
            check_greater_or_equal(function__,"v_X0[k0__]",v_X0[k0__],0);
        }
        for (int k0__ = 0; k0__ < (dense_X ? 0 : (get_base1(N,1,"N",1) + 1) ); ++k0__) {
            check_greater_or_equal(function__,"u_X0[k0__]",u_X0[k0__],0);
        }
        check_greater_or_equal(function__,"nnz_X1",nnz_X1,0);
        for (int k0__ = 0; k0__ < nnz_X1; ++k0__) {
            check_greater_or_equal(function__,"v_X1[k0__]",v_X1[k0__],0);
        }
        for (int k0__ = 0; k0__ < (dense_X ? 0 : (get_base1(N,2,"N",1) + 1) ); ++k0__) {
            check_greater_or_equal(function__,"u_X1[k0__]",u_X1[k0__],0);
        }
        check_greater_or_equal(function__,"prior_PD",prior_PD,0);
        check_less_or_equal(function__,"prior_PD",prior_PD,1);
        check_greater_or_equal(function__,"has_intercept",has_intercept,0);
        check_less_or_equal(function__,"has_intercept",has_intercept,1);
        check_greater_or_equal(function__,"family",family,1);
        check_greater_or_equal(function__,"link",link,1);
        check_greater_or_equal(function__,"prior_dist",prior_dist,0);
        check_less_or_equal(function__,"prior_dist",prior_dist,7);
        check_greater_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,0);
        check_less_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,2);
        check_greater_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,0);
        check_less_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,3);
        check_greater_or_equal(function__,"has_weights",has_weights,0);
        check_less_or_equal(function__,"has_weights",has_weights,1);
        check_greater_or_equal(function__,"has_offset",has_offset,0);
        check_less_or_equal(function__,"has_offset",has_offset,1);
        check_greater_or_equal(function__,"prior_scale",prior_scale,0);
        check_greater_or_equal(function__,"prior_scale_for_intercept",prior_scale_for_intercept,0);
        check_greater_or_equal(function__,"prior_scale_for_aux",prior_scale_for_aux,0);
        check_greater_or_equal(function__,"prior_mean_for_aux",prior_mean_for_aux,0);
        check_greater_or_equal(function__,"prior_df",prior_df,0);
        check_greater_or_equal(function__,"prior_df_for_intercept",prior_df_for_intercept,0);
        check_greater_or_equal(function__,"prior_df_for_aux",prior_df_for_aux,0);
        check_greater_or_equal(function__,"global_prior_df",global_prior_df,0);
        check_greater_or_equal(function__,"global_prior_scale",global_prior_scale,0);
        for (int k0__ = 0; k0__ < (logical_eq(prior_dist,7) ? K : 0 ); ++k0__) {
            check_greater_or_equal(function__,"num_normals[k0__]",num_normals[k0__],2);
        }
        check_greater_or_equal(function__,"t",t,0);
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"p[k0__]",p[k0__],1);
        }
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"l[k0__]",l[k0__],1);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_greater_or_equal(function__,"len_theta_L",len_theta_L,0);
        check_greater_or_equal(function__,"shape",shape,0);
        check_greater_or_equal(function__,"scale",scale,0);
        check_greater_or_equal(function__,"len_concentration",len_concentration,0);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"concentration[k0__]",concentration[k0__],0);
        }
        check_greater_or_equal(function__,"len_regularization",len_regularization,0);
        for (int k0__ = 0; k0__ < len_regularization; ++k0__) {
            check_greater_or_equal(function__,"regularization[k0__]",regularization[k0__],0);
        }
        for (int k0__ = 0; k0__ < 2; ++k0__) {
            check_greater_or_equal(function__,"num_non_zero[k0__]",num_non_zero[k0__],0);
        }
        for (int k0__ = 0; k0__ < get_base1(num_non_zero,1,"num_non_zero",1); ++k0__) {
            check_greater_or_equal(function__,"v0[k0__]",v0[k0__],0);
        }
        for (int k0__ = 0; k0__ < get_base1(num_non_zero,2,"num_non_zero",1); ++k0__) {
            check_greater_or_equal(function__,"v1[k0__]",v1[k0__],0);
        }
        for (int k0__ = 0; k0__ < (logical_gt(t,0) ? (get_base1(N,1,"N",1) + 1) : 0 ); ++k0__) {
            check_greater_or_equal(function__,"u0[k0__]",u0[k0__],0);
        }
        for (int k0__ = 0; k0__ < (logical_gt(t,0) ? (get_base1(N,2,"N",1) + 1) : 0 ); ++k0__) {
            check_greater_or_equal(function__,"u1[k0__]",u1[k0__],0);
        }
        check_greater_or_equal(function__,"special_case",special_case,0);
        check_less_or_equal(function__,"special_case",special_case,1);
        // initialize data variables
        NN = int(0);
        stan::math::fill(NN, std::numeric_limits<int>::min());
        stan::math::assign(NN,(get_base1(N,1,"N",1) + get_base1(N,2,"N",1)));
        aux = double(0);
        stan::math::fill(aux,DUMMY_VAR__);
        stan::math::assign(aux,stan::math::not_a_number());
        validate_non_negative_index("V0", "t", t);
        validate_non_negative_index("V0", "get_base1(N,1,\"N\",1)", get_base1(N,1,"N",1));
        V0 = std::vector<std::vector<int> >(t,std::vector<int>(get_base1(N,1,"N",1),int(0)));
        stan::math::fill(V0, std::numeric_limits<int>::min());
        stan::math::assign(V0,make_V(get_base1(N,1,"N",1),t,v0, pstream__));
        validate_non_negative_index("V1", "t", t);
        validate_non_negative_index("V1", "get_base1(N,2,\"N\",1)", get_base1(N,2,"N",1));
        V1 = std::vector<std::vector<int> >(t,std::vector<int>(get_base1(N,2,"N",1),int(0)));
        stan::math::fill(V1, std::numeric_limits<int>::min());
        stan::math::assign(V1,make_V(get_base1(N,2,"N",1),t,v1, pstream__));
        len_z_T = int(0);
        stan::math::fill(len_z_T, std::numeric_limits<int>::min());
        stan::math::assign(len_z_T,0);
        len_var_group = int(0);
        stan::math::fill(len_var_group, std::numeric_limits<int>::min());
        stan::math::assign(len_var_group,(sum(p) * logical_gt(t,0)));
        len_rho = int(0);
        stan::math::fill(len_rho, std::numeric_limits<int>::min());
        stan::math::assign(len_rho,(sum(p) - t));
        is_continuous = int(0);
        stan::math::fill(is_continuous, std::numeric_limits<int>::min());
        stan::math::assign(is_continuous,0);
        pos = int(0);
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        validate_non_negative_index("delta", "len_concentration", len_concentration);
        delta = std::vector<double>(len_concentration,double(0));
        stan::math::fill(delta,DUMMY_VAR__);
        hs = int(0);
        stan::math::fill(hs, std::numeric_limits<int>::min());

        try {
            if (as_bool(logical_lte(prior_dist,2))) {
                stan::math::assign(hs, 0);
            } else if (as_bool(logical_eq(prior_dist,3))) {
                stan::math::assign(hs, 2);
            } else if (as_bool(logical_eq(prior_dist,4))) {
                stan::math::assign(hs, 4);
            } else {
                stan::math::assign(hs, 0);
            }
            stan::math::assign(len_z_T, 0);
            stan::math::assign(len_var_group, (sum(p) * logical_gt(t,0)));
            stan::math::assign(len_rho, (sum(p) - t));
            stan::math::assign(pos, 1);
            for (int i = 1; i <= t; ++i) {

                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {

                    for (int j = 1; j <= get_base1(p,i,"p",1); ++j) {

                        stan::math::assign(get_base1_lhs(delta,pos,"delta",1), get_base1(concentration,j,"concentration",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
                for (int j = 3; j <= get_base1(p,i,"p",1); ++j) {
                    stan::math::assign(len_z_T, ((len_z_T + get_base1(p,i,"p",1)) - 1));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        for (int k0__ = 0; k0__ < t; ++k0__) {
            for (int k1__ = 0; k1__ < get_base1(N,1,"N",1); ++k1__) {
                check_greater_or_equal(function__,"V0[k0__][k1__]",V0[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < t; ++k0__) {
            for (int k1__ = 0; k1__ < get_base1(N,2,"N",1); ++k1__) {
                check_greater_or_equal(function__,"V1[k0__][k1__]",V1[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"len_z_T",len_z_T,0);
        check_greater_or_equal(function__,"len_var_group",len_var_group,0);
        check_greater_or_equal(function__,"len_rho",len_rho,0);
        check_greater_or_equal(function__,"is_continuous",is_continuous,0);
        check_less_or_equal(function__,"is_continuous",is_continuous,1);
        check_greater_or_equal(function__,"pos",pos,1);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"delta[k0__]",delta[k0__],0);
        }
        check_greater_or_equal(function__,"hs",hs,0);

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += has_intercept;
        num_params_r__ += (logical_eq(prior_dist,7) ? sum(num_normals) : K );
        num_params_r__ += hs;
        num_params_r__ += K * hs;
        num_params_r__ += K * (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        num_params_r__ += logical_eq(prior_dist,6);
        num_params_r__ += q;
        num_params_r__ += len_z_T;
        num_params_r__ += len_rho;
        num_params_r__ += len_concentration;
        num_params_r__ += t;
    }

    ~model_bernoulli() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("gamma")))
            throw std::runtime_error("variable gamma missing");
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma", "double", context__.to_vec(has_intercept));
        // generate_declaration gamma
        std::vector<double> gamma(has_intercept,double(0));
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            gamma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            try {
            writer__.scalar_ub_unconstrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() ),gamma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma: ") + e.what());
        }

        if (!(context__.contains_r("z_beta")))
            throw std::runtime_error("variable z_beta missing");
        vals_r__ = context__.vals_r("z_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_beta", "vector_d", context__.to_vec((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        // generate_declaration z_beta
        vector_d z_beta(static_cast<Eigen::VectorXd::Index>((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        for (int j1__ = 0U; j1__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++j1__)
            z_beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_beta: ") + e.what());
        }

        if (!(context__.contains_r("global")))
            throw std::runtime_error("variable global missing");
        vals_r__ = context__.vals_r("global");
        pos__ = 0U;
        context__.validate_dims("initialization", "global", "double", context__.to_vec(hs));
        // generate_declaration global
        std::vector<double> global(hs,double(0));
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            global[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,global[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable global: ") + e.what());
        }

        if (!(context__.contains_r("local")))
            throw std::runtime_error("variable local missing");
        vals_r__ = context__.vals_r("local");
        pos__ = 0U;
        context__.validate_dims("initialization", "local", "vector_d", context__.to_vec(hs,K));
        // generate_declaration local
        std::vector<vector_d> local(hs,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < hs; ++i0__)
                local[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,local[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable local: ") + e.what());
        }

        if (!(context__.contains_r("S")))
            throw std::runtime_error("variable S missing");
        vals_r__ = context__.vals_r("S");
        pos__ = 0U;
        context__.validate_dims("initialization", "S", "vector_d", context__.to_vec((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),K));
        // generate_declaration S
        std::vector<vector_d> S((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
                S[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,S[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable S: ") + e.what());
        }

        if (!(context__.contains_r("one_over_lambda")))
            throw std::runtime_error("variable one_over_lambda missing");
        vals_r__ = context__.vals_r("one_over_lambda");
        pos__ = 0U;
        context__.validate_dims("initialization", "one_over_lambda", "double", context__.to_vec(logical_eq(prior_dist,6)));
        // generate_declaration one_over_lambda
        std::vector<double> one_over_lambda(logical_eq(prior_dist,6),double(0));
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            one_over_lambda[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,one_over_lambda[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable one_over_lambda: ") + e.what());
        }

        if (!(context__.contains_r("z_b")))
            throw std::runtime_error("variable z_b missing");
        vals_r__ = context__.vals_r("z_b");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_b", "vector_d", context__.to_vec(q));
        // generate_declaration z_b
        vector_d z_b(static_cast<Eigen::VectorXd::Index>(q));
        for (int j1__ = 0U; j1__ < q; ++j1__)
            z_b(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_b: ") + e.what());
        }

        if (!(context__.contains_r("z_T")))
            throw std::runtime_error("variable z_T missing");
        vals_r__ = context__.vals_r("z_T");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_T", "vector_d", context__.to_vec(len_z_T));
        // generate_declaration z_T
        vector_d z_T(static_cast<Eigen::VectorXd::Index>(len_z_T));
        for (int j1__ = 0U; j1__ < len_z_T; ++j1__)
            z_T(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_T);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_T: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho", "vector_d", context__.to_vec(len_rho));
        // generate_declaration rho
        vector_d rho(static_cast<Eigen::VectorXd::Index>(len_rho));
        for (int j1__ = 0U; j1__ < len_rho; ++j1__)
            rho(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        if (!(context__.contains_r("zeta")))
            throw std::runtime_error("variable zeta missing");
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "zeta", "vector_d", context__.to_vec(len_concentration));
        // generate_declaration zeta
        vector_d zeta(static_cast<Eigen::VectorXd::Index>(len_concentration));
        for (int j1__ = 0U; j1__ < len_concentration; ++j1__)
            zeta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,zeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zeta: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "vector_d", context__.to_vec(t));
        // generate_declaration tau
        vector_d tau(static_cast<Eigen::VectorXd::Index>(t));
        for (int j1__ = 0U; j1__ < t; ++j1__)
            tau(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<T__> gamma;
        size_t dim_gamma_0__ = has_intercept;
        gamma.reserve(dim_gamma_0__);
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            if (jacobian__)
                gamma.push_back(in__.scalar_ub_constrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() ),lp__));
            else
                gamma.push_back(in__.scalar_ub_constrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() )));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_beta;
        (void) z_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ),lp__);
        else
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));

        vector<T__> global;
        size_t dim_global_0__ = hs;
        global.reserve(dim_global_0__);
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            if (jacobian__)
                global.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                global.push_back(in__.scalar_lb_constrain(0));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > local;
        size_t dim_local_0__ = hs;
        local.reserve(dim_local_0__);
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            if (jacobian__)
                local.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                local.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        S.reserve(dim_S_0__);
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            if (jacobian__)
                S.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                S.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<T__> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        one_over_lambda.reserve(dim_one_over_lambda_0__);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            if (jacobian__)
                one_over_lambda.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_b;
        (void) z_b;  // dummy to suppress unused var warning
        if (jacobian__)
            z_b = in__.vector_constrain(q,lp__);
        else
            z_b = in__.vector_constrain(q);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_T;
        (void) z_T;  // dummy to suppress unused var warning
        if (jacobian__)
            z_T = in__.vector_constrain(len_z_T,lp__);
        else
            z_T = in__.vector_constrain(len_z_T);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho;
        (void) rho;  // dummy to suppress unused var warning
        if (jacobian__)
            rho = in__.vector_lub_constrain(0,1,len_rho,lp__);
        else
            rho = in__.vector_lub_constrain(0,1,len_rho);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  zeta;
        (void) zeta;  // dummy to suppress unused var warning
        if (jacobian__)
            zeta = in__.vector_lb_constrain(0,len_concentration,lp__);
        else
            zeta = in__.vector_lb_constrain(0,len_concentration);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.vector_lb_constrain(0,t,lp__);
        else
            tau = in__.vector_lb_constrain(0,t);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, DUMMY_VAR__);
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(special_case)) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, tau);
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(tau,1,"tau",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(tau,i,"tau",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    stan::math::assign(theta_L, make_theta_L(len_theta_L,p,1.0,tau,scale,zeta,rho,z_T, pstream__));
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < q; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < len_theta_L; ++i0__) {
            if (stan::math::is_uninitialized(theta_L(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: theta_L" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta0(static_cast<Eigen::VectorXd::Index>(get_base1(N,1,"N",1)));
                (void) eta0;  // dummy to suppress unused var warning
                stan::math::initialize(eta0, DUMMY_VAR__);
                stan::math::fill(eta0,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta1(static_cast<Eigen::VectorXd::Index>(get_base1(N,2,"N",1)));
                (void) eta1;  // dummy to suppress unused var warning
                stan::math::initialize(eta1, DUMMY_VAR__);
                stan::math::fill(eta1,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {

                        stan::math::assign(eta0, multiply(get_base1(X0,1,"X0",1),beta));
                        stan::math::assign(eta1, multiply(get_base1(X1,1,"X1",1),beta));
                    } else {

                        stan::math::assign(eta0, csr_matrix_times_vector(get_base1(N,1,"N",1),K,w_X0,v_X0,u_X0,beta));
                        stan::math::assign(eta1, csr_matrix_times_vector(get_base1(N,2,"N",1),K,w_X1,v_X1,u_X1,beta));
                    }
                } else {

                    stan::math::assign(eta0, rep_vector(0.0,get_base1(N,1,"N",1)));
                    stan::math::assign(eta1, rep_vector(0.0,get_base1(N,2,"N",1)));
                }
                if (as_bool((primitive_value(logical_eq(has_intercept,0)) && primitive_value(dense_X)))) {
                    {
                        T__ tmp;
                        (void) tmp;  // dummy to suppress unused var warning
                        stan::math::initialize(tmp, DUMMY_VAR__);
                        stan::math::fill(tmp,DUMMY_VAR__);


                        stan::math::assign(tmp, dot_product(xbar,beta));
                        stan::math::assign(eta0, add(eta0,tmp));
                        stan::math::assign(eta1, add(eta1,tmp));
                    }
                }
                if (as_bool(logical_eq(has_offset,1))) {

                    stan::math::assign(eta0, add(eta0,offset0));
                    stan::math::assign(eta1, add(eta1,offset1));
                }
                if (as_bool(special_case)) {
                    for (int i = 1; i <= t; ++i) {

                        stan::math::assign(eta0, add(eta0,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V0,t,"V0",1)), stan::model::nil_index_list()), "b")));
                        stan::math::assign(eta1, add(eta1,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V1,t,"V1",1)), stan::model::nil_index_list()), "b")));
                    }
                } else if (as_bool(logical_gt(t,0))) {

                    stan::math::assign(eta0, add(eta0,csr_matrix_times_vector(get_base1(N,1,"N",1),q,w0,v0,u0,b)));
                    stan::math::assign(eta1, add(eta1,csr_matrix_times_vector(get_base1(N,2,"N",1),q,w1,v1,u1,b)));
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_neq(link,4))) {

                        stan::math::assign(eta0, add(get_base1(gamma,1,"gamma",1),eta0));
                        stan::math::assign(eta1, add(get_base1(gamma,1,"gamma",1),eta1));
                    } else {
                        {
                            T__ shift;
                            (void) shift;  // dummy to suppress unused var warning
                            stan::math::initialize(shift, DUMMY_VAR__);
                            stan::math::fill(shift,DUMMY_VAR__);


                            stan::math::assign(shift, stan::math::fmax(max(eta0),max(eta1)));
                            stan::math::assign(eta0, subtract(add(get_base1(gamma,1,"gamma",1),eta0),shift));
                            stan::math::assign(eta1, subtract(add(get_base1(gamma,1,"gamma",1),eta1),shift));
                        }
                    }
                }
                if (as_bool((primitive_value(logical_eq(has_weights,0)) && primitive_value(logical_eq(prior_PD,0))))) {
                    {
                        T__ dummy;
                        (void) dummy;  // dummy to suppress unused var warning
                        stan::math::initialize(dummy, DUMMY_VAR__);
                        stan::math::fill(dummy,DUMMY_VAR__);


                        stan::math::assign(dummy, ll_bern_lp(eta0,eta1,link,N, lp__, lp_accum__, pstream__));
                    }
                } else if (as_bool(logical_eq(prior_PD,0))) {

                    lp_accum__.add(dot_product(weights0,pw_bern(0,eta0,link, pstream__)));
                    lp_accum__.add(dot_product(weights1,pw_bern(1,eta1,link, pstream__)));
                }
                if (as_bool(logical_eq(prior_dist,1))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,2))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,3))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,4))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(local,3,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,4,"local",1),multiply(0.5,prior_scale),multiply(0.5,prior_scale)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,5))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                } else if (as_bool(logical_eq(prior_dist,6))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                    lp_accum__.add(chi_square_log(get_base1(one_over_lambda,1,"one_over_lambda",1),get_base1(prior_df,1,"prior_df",1)));
                } else if (as_bool(logical_eq(prior_dist,7))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_eq(prior_dist_for_intercept,1))) {
                        lp_accum__.add(normal_log(gamma,prior_mean_for_intercept,prior_scale_for_intercept));
                    } else if (as_bool(logical_eq(prior_dist_for_intercept,2))) {
                        lp_accum__.add(student_t_log(gamma,prior_df_for_intercept,prior_mean_for_intercept,prior_scale_for_intercept));
                    }
                }
                if (as_bool(logical_gt(t,0))) {
                    decov_lp(z_b,z_T,rho,zeta,tau,regularization,delta,shape,t,p, lp__, lp_accum__, pstream__);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("z_beta");
        names__.push_back("global");
        names__.push_back("local");
        names__.push_back("S");
        names__.push_back("one_over_lambda");
        names__.push_back("z_b");
        names__.push_back("z_T");
        names__.push_back("rho");
        names__.push_back("zeta");
        names__.push_back("tau");
        names__.push_back("beta");
        names__.push_back("b");
        names__.push_back("theta_L");
        names__.push_back("alpha");
        names__.push_back("mean_PPD");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))));
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(prior_dist,6));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_z_T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_rho);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_concentration);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_theta_L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_bernoulli_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector<double> gamma;
        size_t dim_gamma_0__ = has_intercept;
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            gamma.push_back(in__.scalar_ub_constrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() )));
        }
        vector_d z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        vector<double> global;
        size_t dim_global_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            global.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> local;
        size_t dim_local_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            local.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<vector_d> S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            S.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<double> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }
        vector_d z_b = in__.vector_constrain(q);
        vector_d z_T = in__.vector_constrain(len_z_T);
        vector_d rho = in__.vector_lub_constrain(0,1,len_rho);
        vector_d zeta = in__.vector_lb_constrain(0,len_concentration);
        vector_d tau = in__.vector_lb_constrain(0,t);
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            vars__.push_back(z_beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
            vars__.push_back(global[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
                vars__.push_back(local[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                vars__.push_back(S[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < logical_eq(prior_dist,6); ++k_0__) {
            vars__.push_back(one_over_lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(z_b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_z_T; ++k_0__) {
            vars__.push_back(z_T[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_rho; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_concentration; ++k_0__) {
            vars__.push_back(zeta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < t; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(special_case)) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, tau);
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(tau,1,"tau",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(tau,i,"tau",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    stan::math::assign(theta_L, make_theta_L(len_theta_L,p,1.0,tau,scale,zeta,rho,z_T, pstream__));
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_theta_L; ++k_0__) {
            vars__.push_back(theta_L[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> alpha(has_intercept, 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        double mean_PPD(0.0);
        (void) mean_PPD;  // dummy to suppress unused var warning
        stan::math::initialize(mean_PPD, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mean_PPD,DUMMY_VAR__);
        stan::math::assign(mean_PPD,0);


        try {
            if (as_bool(logical_eq(has_intercept,1))) {

                if (as_bool(dense_X)) {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(gamma,1,"gamma",1) - dot_product(xbar,beta)));
                } else {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), get_base1(gamma,1,"gamma",1));
                }
            }
            {
                vector_d pi0(static_cast<Eigen::VectorXd::Index>(get_base1(N,1,"N",1)));
                (void) pi0;  // dummy to suppress unused var warning
                stan::math::initialize(pi0, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(pi0,DUMMY_VAR__);
                vector_d pi1(static_cast<Eigen::VectorXd::Index>(get_base1(N,2,"N",1)));
                (void) pi1;  // dummy to suppress unused var warning
                stan::math::initialize(pi1, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(pi1,DUMMY_VAR__);
                vector_d eta0(static_cast<Eigen::VectorXd::Index>(get_base1(N,1,"N",1)));
                (void) eta0;  // dummy to suppress unused var warning
                stan::math::initialize(eta0, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta0,DUMMY_VAR__);
                vector_d eta1(static_cast<Eigen::VectorXd::Index>(get_base1(N,2,"N",1)));
                (void) eta1;  // dummy to suppress unused var warning
                stan::math::initialize(eta1, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta1,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {

                        stan::math::assign(eta0, multiply(get_base1(X0,1,"X0",1),beta));
                        stan::math::assign(eta1, multiply(get_base1(X1,1,"X1",1),beta));
                    } else {

                        stan::math::assign(eta0, csr_matrix_times_vector(get_base1(N,1,"N",1),K,w_X0,v_X0,u_X0,beta));
                        stan::math::assign(eta1, csr_matrix_times_vector(get_base1(N,2,"N",1),K,w_X1,v_X1,u_X1,beta));
                    }
                } else {

                    stan::math::assign(eta0, rep_vector(0.0,get_base1(N,1,"N",1)));
                    stan::math::assign(eta1, rep_vector(0.0,get_base1(N,2,"N",1)));
                }
                if (as_bool((primitive_value(logical_eq(has_intercept,0)) && primitive_value(dense_X)))) {
                    {
                        double tmp(0.0);
                        (void) tmp;  // dummy to suppress unused var warning
                        stan::math::initialize(tmp, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(tmp,DUMMY_VAR__);


                        stan::math::assign(tmp, dot_product(xbar,beta));
                        stan::math::assign(eta0, add(eta0,tmp));
                        stan::math::assign(eta1, add(eta1,tmp));
                    }
                }
                if (as_bool(logical_eq(has_offset,1))) {

                    stan::math::assign(eta0, add(eta0,offset0));
                    stan::math::assign(eta1, add(eta1,offset1));
                }
                if (as_bool(special_case)) {
                    for (int i = 1; i <= t; ++i) {

                        stan::math::assign(eta0, add(eta0,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V0,t,"V0",1)), stan::model::nil_index_list()), "b")));
                        stan::math::assign(eta1, add(eta1,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V1,t,"V1",1)), stan::model::nil_index_list()), "b")));
                    }
                } else if (as_bool(logical_gt(t,0))) {

                    stan::math::assign(eta0, add(eta0,csr_matrix_times_vector(get_base1(N,1,"N",1),q,w0,v0,u0,b)));
                    stan::math::assign(eta1, add(eta1,csr_matrix_times_vector(get_base1(N,2,"N",1),q,w1,v1,u1,b)));
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_neq(link,4))) {

                        stan::math::assign(eta0, add(get_base1(gamma,1,"gamma",1),eta0));
                        stan::math::assign(eta1, add(get_base1(gamma,1,"gamma",1),eta1));
                    } else {
                        {
                            double shift(0.0);
                            (void) shift;  // dummy to suppress unused var warning
                            stan::math::initialize(shift, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(shift,DUMMY_VAR__);


                            stan::math::assign(shift, stan::math::fmax(max(eta0),max(eta1)));
                            stan::math::assign(eta0, subtract(add(get_base1(gamma,1,"gamma",1),eta0),shift));
                            stan::math::assign(eta1, subtract(add(get_base1(gamma,1,"gamma",1),eta1),shift));
                            stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(alpha,1,"alpha",1) - shift));
                        }
                    }
                }
                stan::math::assign(pi0, linkinv_bern(eta0,link, pstream__));
                stan::math::assign(pi1, linkinv_bern(eta1,link, pstream__));
                for (int n = 1; n <= get_base1(N,1,"N",1); ++n) {
                    stan::math::assign(mean_PPD, (mean_PPD + bernoulli_rng(get_base1(pi0,n,"pi0",1), base_rng__)));
                }
                for (int n = 1; n <= get_base1(N,2,"N",1); ++n) {
                    stan::math::assign(mean_PPD, (mean_PPD + bernoulli_rng(get_base1(pi1,n,"pi1",1), base_rng__)));
                }
                stan::math::assign(mean_PPD, (mean_PPD / NN));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        vars__.push_back(mean_PPD);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bernoulli";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_binomial_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
make_theta_L(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
            (void) theta_L;  // dummy to suppress unused var warning
            stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(theta_L,DUMMY_VAR__);
            int zeta_mark(0);
            (void) zeta_mark;  // dummy to suppress unused var warning
            stan::math::fill(zeta_mark, std::numeric_limits<int>::min());
            stan::math::assign(zeta_mark,1);
            int rho_mark(0);
            (void) rho_mark;  // dummy to suppress unused var warning
            stan::math::fill(rho_mark, std::numeric_limits<int>::min());
            stan::math::assign(rho_mark,1);
            int z_T_mark(0);
            (void) z_T_mark;  // dummy to suppress unused var warning
            stan::math::fill(z_T_mark, std::numeric_limits<int>::min());
            stan::math::assign(z_T_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {

                        stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), ((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion));
                        stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            fun_scalar_t__ std_dev;
                            (void) std_dev;  // dummy to suppress unused var warning
                            stan::math::initialize(std_dev, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(std_dev,DUMMY_VAR__);
                            fun_scalar_t__ T21;
                            (void) T21;  // dummy to suppress unused var warning
                            stan::math::initialize(T21, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T21,DUMMY_VAR__);
                            fun_scalar_t__ trace_T_i;
                            (void) trace_T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(trace_T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(trace_T_i,DUMMY_VAR__);
                            stan::math::assign(trace_T_i,(square(((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion)) * nc));
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(nc));
                            (void) pi;  // dummy to suppress unused var warning
                            stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(pi,DUMMY_VAR__);
                            stan::math::assign(pi,segment(zeta,zeta_mark,nc));


                            stan::math::assign(pi, divide(pi,sum(pi)));
                            stan::math::assign(zeta_mark, (zeta_mark + nc));
                            stan::math::assign(std_dev, sqrt((get_base1(pi,1,"pi",1) * trace_T_i)));
                            stan::math::assign(get_base1_lhs(T_i,1,1,"T_i",1), std_dev);
                            stan::math::assign(std_dev, sqrt((get_base1(pi,2,"pi",1) * trace_T_i)));
                            stan::math::assign(T21, ((2.0 * get_base1(rho,rho_mark,"rho",1)) - 1.0));
                            stan::math::assign(rho_mark, (rho_mark + 1));
                            stan::math::assign(get_base1_lhs(T_i,2,2,"T_i",1), (std_dev * sqrt((1.0 - square(T21)))));
                            stan::math::assign(get_base1_lhs(T_i,2,1,"T_i",1), (std_dev * T21));
                            for (int r = 2; r <= (nc - 1); ++r) {
                                {
                                    int rp1(0);
                                    (void) rp1;  // dummy to suppress unused var warning
                                    stan::math::fill(rp1, std::numeric_limits<int>::min());
                                    stan::math::assign(rp1,(r + 1));
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  T_row(static_cast<Eigen::VectorXd::Index>(r));
                                    (void) T_row;  // dummy to suppress unused var warning
                                    stan::math::initialize(T_row, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(T_row,DUMMY_VAR__);
                                    stan::math::assign(T_row,segment(z_T,z_T_mark,r));
                                    fun_scalar_t__ scale_factor;
                                    (void) scale_factor;  // dummy to suppress unused var warning
                                    stan::math::initialize(scale_factor, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(scale_factor,DUMMY_VAR__);
                                    stan::math::assign(scale_factor,(sqrt((get_base1(rho,rho_mark,"rho",1) / dot_self(T_row))) * std_dev));


                                    stan::math::assign(z_T_mark, (z_T_mark + r));
                                    stan::math::assign(std_dev, sqrt((get_base1(pi,rp1,"pi",1) * trace_T_i)));
                                    for (int c = 1; c <= r; ++c) {
                                        stan::math::assign(get_base1_lhs(T_i,rp1,c,"T_i",1), (get_base1(T_row,c,"T_row",1) * scale_factor));
                                    }
                                    stan::math::assign(get_base1_lhs(T_i,rp1,rp1,"T_i",1), (sqrt((1.0 - get_base1(rho,rho_mark,"rho",1))) * std_dev));
                                    stan::math::assign(rho_mark, (rho_mark + 1));
                                }
                            }
                            for (int c = 1; c <= nc; ++c) {
                                for (int r = c; r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), get_base1(T_i,r,c,"T_i",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(theta_L);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_theta_L_functor__ {
    template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
    operator()(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) const {
        return make_theta_L(len_theta_L, p, dispersion, tau, scale, zeta, rho, z_T, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
make_b(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(rows(z_b)));
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(b,DUMMY_VAR__);
            int b_mark(0);
            (void) b_mark;  // dummy to suppress unused var warning
            stan::math::fill(b_mark, std::numeric_limits<int>::min());
            stan::math::assign(b_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {
                        {
                            fun_scalar_t__ theta_L_start;
                            (void) theta_L_start;  // dummy to suppress unused var warning
                            stan::math::initialize(theta_L_start, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(theta_L_start,DUMMY_VAR__);
                            stan::math::assign(theta_L_start,get_base1(theta_L,theta_L_mark,"theta_L",1));


                            for (int s = b_mark; s <= ((b_mark + get_base1(l,i,"l",1)) - 1); ++s) {
                                stan::math::assign(get_base1_lhs(b,s,"b",1), (theta_L_start * get_base1(z_b,s,"z_b",1)));
                            }
                            stan::math::assign(b_mark, (b_mark + get_base1(l,i,"l",1)));
                            stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                        }
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            stan::math::assign(T_i,rep_matrix(0,nc,nc));


                            for (int c = 1; c <= nc; ++c) {

                                stan::math::assign(get_base1_lhs(T_i,c,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                for (int r = (c + 1); r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(T_i,r,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                            for (int j = 1; j <= get_base1(l,i,"l",1); ++j) {
                                {
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  temp(static_cast<Eigen::VectorXd::Index>(nc));
                                    (void) temp;  // dummy to suppress unused var warning
                                    stan::math::initialize(temp, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(temp,DUMMY_VAR__);
                                    stan::math::assign(temp,multiply(T_i,segment(z_b,b_mark,nc)));


                                    stan::math::assign(b_mark, (b_mark - 1));
                                    for (int s = 1; s <= nc; ++s) {
                                        stan::math::assign(get_base1_lhs(b,(b_mark + s),"b",1), get_base1(temp,s,"temp",1));
                                    }
                                    stan::math::assign(b_mark, ((b_mark + nc) + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(b);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_b_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) const {
        return make_b(z_b, theta_L, p, l, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
void
decov_lp(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int pos_reg(0);
            (void) pos_reg;  // dummy to suppress unused var warning
            stan::math::fill(pos_reg, std::numeric_limits<int>::min());
            stan::math::assign(pos_reg,1);
            int pos_rho(0);
            (void) pos_rho;  // dummy to suppress unused var warning
            stan::math::fill(pos_rho, std::numeric_limits<int>::min());
            stan::math::assign(pos_rho,1);


            lp_accum__.add(normal_log(z_b,0,1));
            lp_accum__.add(normal_log(z_T,0,1));
            for (int i = 1; i <= t; ++i) {
                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {
                    {
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape1(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape1;  // dummy to suppress unused var warning
                        stan::math::initialize(shape1, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape1,DUMMY_VAR__);
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape2(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape2;  // dummy to suppress unused var warning
                        stan::math::initialize(shape2, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape2,DUMMY_VAR__);
                        fun_scalar_t__ nu;
                        (void) nu;  // dummy to suppress unused var warning
                        stan::math::initialize(nu, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(nu,DUMMY_VAR__);
                        stan::math::assign(nu,(get_base1(regularization,pos_reg,"regularization",1) + (0.5 * (get_base1(p,i,"p",1) - 2))));


                        stan::math::assign(pos_reg, (pos_reg + 1));
                        stan::math::assign(get_base1_lhs(shape1,1,"shape1",1), nu);
                        stan::math::assign(get_base1_lhs(shape2,1,"shape2",1), nu);
                        for (int j = 2; j <= (get_base1(p,i,"p",1) - 1); ++j) {

                            stan::math::assign(nu, (nu - 0.5));
                            stan::math::assign(get_base1_lhs(shape1,j,"shape1",1), (0.5 * j));
                            stan::math::assign(get_base1_lhs(shape2,j,"shape2",1), nu);
                        }
                        lp_accum__.add(beta_log(stan::model::rvalue(rho, stan::model::cons_list(stan::model::index_min_max(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 2)), stan::model::nil_index_list()), "rho"),shape1,shape2));
                        stan::math::assign(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 1));
                    }
                }
            }
            lp_accum__.add(gamma_log(zeta,delta,1));
            lp_accum__.add(gamma_log(tau,shape,1));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct decov_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return decov_lp(z_b, z_T, rho, zeta, tau, regularization, delta, shape, t, p, lp__, lp_accum__, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hs_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(rows(z_beta)));
            (void) lambda;  // dummy to suppress unused var warning
            stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lambda,DUMMY_VAR__);
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());


            stan::math::assign(K, rows(z_beta));
            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(lambda,k,"lambda",1), (get_base1(get_base1(local,1,"local",1),k,"local",2) * sqrt(get_base1(get_base1(local,2,"local",1),k,"local",2))));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(z_beta,lambda),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hs_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) const {
        return hs_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hsplus_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(elt_multiply(z_beta,elt_multiply(get_base1(local,1,"local",1),sqrt(get_base1(local,2,"local",1)))),elt_multiply(get_base1(local,3,"local",1),sqrt(get_base1(local,4,"local",1)))),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hsplus_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) const {
        return hsplus_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
divide_real_by_vector(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());
            stan::math::assign(K,rows(y));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ret(static_cast<Eigen::VectorXd::Index>(K));
            (void) ret;  // dummy to suppress unused var warning
            stan::math::initialize(ret, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ret,DUMMY_VAR__);


            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(ret,k,"ret",1), (x / get_base1(y,k,"y",1)));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct divide_real_by_vector_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) const {
        return divide_real_by_vector(x, y, pstream__);
    }
};

template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
CFt(const T0__& z,
        const T1__& df, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ z2;
            (void) z2;  // dummy to suppress unused var warning
            stan::math::initialize(z2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z2,DUMMY_VAR__);
            stan::math::assign(z2,square(z));
            fun_scalar_t__ z3;
            (void) z3;  // dummy to suppress unused var warning
            stan::math::initialize(z3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z3,DUMMY_VAR__);
            stan::math::assign(z3,(z2 * z));
            fun_scalar_t__ z5;
            (void) z5;  // dummy to suppress unused var warning
            stan::math::initialize(z5, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z5,DUMMY_VAR__);
            stan::math::assign(z5,(z2 * z3));
            fun_scalar_t__ z7;
            (void) z7;  // dummy to suppress unused var warning
            stan::math::initialize(z7, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z7,DUMMY_VAR__);
            stan::math::assign(z7,(z2 * z5));
            fun_scalar_t__ z9;
            (void) z9;  // dummy to suppress unused var warning
            stan::math::initialize(z9, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z9,DUMMY_VAR__);
            stan::math::assign(z9,(z2 * z7));
            fun_scalar_t__ df2;
            (void) df2;  // dummy to suppress unused var warning
            stan::math::initialize(df2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df2,DUMMY_VAR__);
            stan::math::assign(df2,square(df));
            fun_scalar_t__ df3;
            (void) df3;  // dummy to suppress unused var warning
            stan::math::initialize(df3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df3,DUMMY_VAR__);
            stan::math::assign(df3,(df2 * df));
            fun_scalar_t__ df4;
            (void) df4;  // dummy to suppress unused var warning
            stan::math::initialize(df4, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df4,DUMMY_VAR__);
            stan::math::assign(df4,(df2 * df2));


            return stan::math::promote_scalar<fun_return_scalar_t__>(((((z + ((z3 + z) / (4 * df))) + ((((5 * z5) + (16 * z3)) + (3 * z)) / (96 * df2))) + (((((3 * z7) + (19 * z5)) + (17 * z3)) - (15 * z)) / (384 * df3))) + ((((((79 * z9) + (776 * z7)) + (1482 * z5)) - (1920 * z3)) - (945 * z)) / (92160 * df4))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct CFt_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& z,
        const T1__& df, std::ostream* pstream__) const {
        return CFt(z, df, pstream__);
    }
};

std::vector<std::vector<int> >
make_V(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) {
    typedef double fun_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<vector<int> > V(t, (vector<int>(N, 0)));
            stan::math::fill(V, std::numeric_limits<int>::min());
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);


            if (as_bool(logical_gt(t,0))) {
                for (int j = 1; j <= N; ++j) {
                    for (int i = 1; i <= t; ++i) {

                        stan::math::assign(get_base1_lhs(get_base1_lhs(V,i,"V",1),j,"V",2), get_base1(v,pos,"v",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(V);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_V_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) const {
        return make_V(N, t, v, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_binom(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_logit(eta));
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(Phi(eta));
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(add(divide(atan(eta),stan::math::pi()),0.5));
        } else if (as_bool(logical_eq(link,4))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(exp(eta));
        } else if (as_bool(logical_eq(link,5))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_cloglog(eta));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_binom_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) const {
        return linkinv_binom(eta, link, pstream__);
    }
};

template <typename T2__, typename T_lp__, typename T_lp_accum__>
typename boost::math::tools::promote_args<T2__, T_lp__>::type
ll_binom_lp(const std::vector<int>& y,
                const std::vector<int>& trials,
                const Eigen::Matrix<T2__, Eigen::Dynamic,1>& eta,
                const int& link, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T_lp__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,5))))) {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        if (as_bool(logical_eq(link,1))) {
            lp_accum__.add(binomial_logit_log(y,trials,eta));
        } else if (as_bool(logical_lt(link,4))) {
            lp_accum__.add(binomial_log(y,trials,linkinv_binom(eta,link, pstream__)));
        } else if (as_bool(logical_eq(link,4))) {

            for (int n = 1; n <= num_elements(y); ++n) {

                lp_accum__.add((get_base1(y,n,"y",1) * get_base1(eta,n,"eta",1)));
                lp_accum__.add(((get_base1(trials,n,"trials",1) - get_base1(y,n,"y",1)) * log1m_exp(get_base1(eta,n,"eta",1))));
            }
        } else if (as_bool(logical_eq(link,5))) {
            {
                fun_scalar_t__ neg_exp_eta;
                (void) neg_exp_eta;  // dummy to suppress unused var warning
                stan::math::initialize(neg_exp_eta, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(neg_exp_eta,DUMMY_VAR__);


                for (int n = 1; n <= num_elements(y); ++n) {

                    stan::math::assign(neg_exp_eta, -(exp(get_base1(eta,n,"eta",1))));
                    lp_accum__.add((get_base1(y,n,"y",1) * log1m_exp(neg_exp_eta)));
                    lp_accum__.add(((get_base1(trials,n,"trials",1) - get_base1(y,n,"y",1)) * neg_exp_eta));
                }
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(get_lp(lp__, lp_accum__));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct ll_binom_lp_functor__ {
    template <typename T2__, typename T_lp__, typename T_lp_accum__>
        typename boost::math::tools::promote_args<T2__, T_lp__>::type
    operator()(const std::vector<int>& y,
                const std::vector<int>& trials,
                const Eigen::Matrix<T2__, Eigen::Dynamic,1>& eta,
                const int& link, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return ll_binom_lp(y, trials, eta, link, lp__, lp_accum__, pstream__);
    }
};

template <typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic,1>
pw_binom(const std::vector<int>& y,
             const std::vector<int>& trials,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& eta,
             const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int N(0);
            (void) N;  // dummy to suppress unused var warning
            stan::math::fill(N, std::numeric_limits<int>::min());
            stan::math::assign(N,rows(eta));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(N));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,5))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(link,1))) {

                for (int n = 1; n <= N; ++n) {
                    stan::math::assign(get_base1_lhs(ll,n,"ll",1), binomial_logit_log(get_base1(y,n,"y",1),get_base1(trials,n,"trials",1),get_base1(eta,n,"eta",1)));
                }
            } else {
                {
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
                    (void) pi;  // dummy to suppress unused var warning
                    stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pi,DUMMY_VAR__);


                    stan::math::assign(pi, linkinv_binom(eta,link, pstream__));
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), binomial_log(get_base1(y,n,"y",1),get_base1(trials,n,"trials",1),get_base1(pi,n,"pi",1)));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_binom_functor__ {
    template <typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic,1>
    operator()(const std::vector<int>& y,
             const std::vector<int>& trials,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& eta,
             const int& link, std::ostream* pstream__) const {
        return pw_binom(y, trials, eta, link, pstream__);
    }
};

class model_binomial : public prob_grad {
private:
    int N;
    int K;
    vector_d xbar;
    int dense_X;
    vector<matrix_d> X;
    int nnz_X;
    vector_d w_X;
    vector<int> v_X;
    vector<int> u_X;
    vector<int> y;
    vector<int> trials;
    int prior_PD;
    int has_intercept;
    int family;
    int link;
    int prior_dist;
    int prior_dist_for_intercept;
    int prior_dist_for_aux;
    int has_weights;
    vector_d weights;
    int has_offset;
    vector_d offset;
    vector_d prior_scale;
    double prior_scale_for_intercept;
    double prior_scale_for_aux;
    vector_d prior_mean;
    double prior_mean_for_intercept;
    double prior_mean_for_aux;
    vector_d prior_df;
    double prior_df_for_intercept;
    double prior_df_for_aux;
    double global_prior_df;
    double global_prior_scale;
    vector<int> num_normals;
    int t;
    vector<int> p;
    vector<int> l;
    int q;
    int len_theta_L;
    vector_d shape;
    vector_d scale;
    int len_concentration;
    vector<double> concentration;
    int len_regularization;
    vector<double> regularization;
    int num_non_zero;
    vector_d w;
    vector<int> v;
    vector<int> u;
    int special_case;
    double aux;
    vector<vector<int> > V;
    int len_z_T;
    int len_var_group;
    int len_rho;
    int is_continuous;
    int pos;
    vector<double> delta;
    int hs;
public:
    model_binomial(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_binomial(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_binomial_namespace::model_binomial";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        validate_non_negative_index("xbar", "K", K);
        xbar = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "xbar", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("xbar");
        pos__ = 0;
        size_t xbar_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < xbar_i_vec_lim__; ++i_vec__) {
            xbar[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "dense_X", "int", context__.to_vec());
        dense_X = int(0);
        vals_i__ = context__.vals_i("dense_X");
        pos__ = 0;
        dense_X = vals_i__[pos__++];
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(dense_X,N,K));
        validate_non_negative_index("X", "dense_X", dense_X);
        validate_non_negative_index("X", "N", N);
        validate_non_negative_index("X", "K", K);
        X = std::vector<matrix_d>(dense_X,matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = N;
        size_t X_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                size_t X_limit_0__ = dense_X;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }
        context__.validate_dims("data initialization", "nnz_X", "int", context__.to_vec());
        nnz_X = int(0);
        vals_i__ = context__.vals_i("nnz_X");
        pos__ = 0;
        nnz_X = vals_i__[pos__++];
        validate_non_negative_index("w_X", "nnz_X", nnz_X);
        w_X = vector_d(static_cast<Eigen::VectorXd::Index>(nnz_X));
        context__.validate_dims("data initialization", "w_X", "vector_d", context__.to_vec(nnz_X));
        vals_r__ = context__.vals_r("w_X");
        pos__ = 0;
        size_t w_X_i_vec_lim__ = nnz_X;
        for (size_t i_vec__ = 0; i_vec__ < w_X_i_vec_lim__; ++i_vec__) {
            w_X[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v_X", "int", context__.to_vec(nnz_X));
        validate_non_negative_index("v_X", "nnz_X", nnz_X);
        v_X = std::vector<int>(nnz_X,int(0));
        vals_i__ = context__.vals_i("v_X");
        pos__ = 0;
        size_t v_X_limit_0__ = nnz_X;
        for (size_t i_0__ = 0; i_0__ < v_X_limit_0__; ++i_0__) {
            v_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u_X", "int", context__.to_vec((dense_X ? 0 : (N + 1) )));
        validate_non_negative_index("u_X", "(dense_X ? 0 : (N + 1) )", (dense_X ? 0 : (N + 1) ));
        u_X = std::vector<int>((dense_X ? 0 : (N + 1) ),int(0));
        vals_i__ = context__.vals_i("u_X");
        pos__ = 0;
        size_t u_X_limit_0__ = (dense_X ? 0 : (N + 1) );
        for (size_t i_0__ = 0; i_0__ < u_X_limit_0__; ++i_0__) {
            u_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
        validate_non_negative_index("y", "N", N);
        y = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "trials", "int", context__.to_vec(N));
        validate_non_negative_index("trials", "N", N);
        trials = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("trials");
        pos__ = 0;
        size_t trials_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < trials_limit_0__; ++i_0__) {
            trials[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
        prior_PD = int(0);
        vals_i__ = context__.vals_i("prior_PD");
        pos__ = 0;
        prior_PD = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
        has_intercept = int(0);
        vals_i__ = context__.vals_i("has_intercept");
        pos__ = 0;
        has_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "family", "int", context__.to_vec());
        family = int(0);
        vals_i__ = context__.vals_i("family");
        pos__ = 0;
        family = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link", "int", context__.to_vec());
        link = int(0);
        vals_i__ = context__.vals_i("link");
        pos__ = 0;
        link = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
        prior_dist = int(0);
        vals_i__ = context__.vals_i("prior_dist");
        pos__ = 0;
        prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec());
        prior_dist_for_intercept = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept");
        pos__ = 0;
        prior_dist_for_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_aux", "int", context__.to_vec());
        prior_dist_for_aux = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_aux");
        pos__ = 0;
        prior_dist_for_aux = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_weights", "int", context__.to_vec());
        has_weights = int(0);
        vals_i__ = context__.vals_i("has_weights");
        pos__ = 0;
        has_weights = vals_i__[pos__++];
        validate_non_negative_index("weights", "(has_weights ? N : 0 )", (has_weights ? N : 0 ));
        weights = vector_d(static_cast<Eigen::VectorXd::Index>((has_weights ? N : 0 )));
        context__.validate_dims("data initialization", "weights", "vector_d", context__.to_vec((has_weights ? N : 0 )));
        vals_r__ = context__.vals_r("weights");
        pos__ = 0;
        size_t weights_i_vec_lim__ = (has_weights ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < weights_i_vec_lim__; ++i_vec__) {
            weights[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec());
        has_offset = int(0);
        vals_i__ = context__.vals_i("has_offset");
        pos__ = 0;
        has_offset = vals_i__[pos__++];
        validate_non_negative_index("offset", "(has_offset ? N : 0 )", (has_offset ? N : 0 ));
        offset = vector_d(static_cast<Eigen::VectorXd::Index>((has_offset ? N : 0 )));
        context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec((has_offset ? N : 0 )));
        vals_r__ = context__.vals_r("offset");
        pos__ = 0;
        size_t offset_i_vec_lim__ = (has_offset ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < offset_i_vec_lim__; ++i_vec__) {
            offset[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("prior_scale", "K", K);
        prior_scale = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_scale", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_scale");
        pos__ = 0;
        size_t prior_scale_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_scale_i_vec_lim__; ++i_vec__) {
            prior_scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_scale_for_intercept", "double", context__.to_vec());
        prior_scale_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_intercept");
        pos__ = 0;
        prior_scale_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_scale_for_aux", "double", context__.to_vec());
        prior_scale_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_aux");
        pos__ = 0;
        prior_scale_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_mean", "K", K);
        prior_mean = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_mean", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_mean");
        pos__ = 0;
        size_t prior_mean_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_mean_i_vec_lim__; ++i_vec__) {
            prior_mean[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_mean_for_intercept", "double", context__.to_vec());
        prior_mean_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_intercept");
        pos__ = 0;
        prior_mean_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_mean_for_aux", "double", context__.to_vec());
        prior_mean_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_aux");
        pos__ = 0;
        prior_mean_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_df", "K", K);
        prior_df = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_df", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_df");
        pos__ = 0;
        size_t prior_df_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_df_i_vec_lim__; ++i_vec__) {
            prior_df[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_df_for_intercept", "double", context__.to_vec());
        prior_df_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_df_for_intercept");
        pos__ = 0;
        prior_df_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_df_for_aux", "double", context__.to_vec());
        prior_df_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_df_for_aux");
        pos__ = 0;
        prior_df_for_aux = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_df", "double", context__.to_vec());
        global_prior_df = double(0);
        vals_r__ = context__.vals_r("global_prior_df");
        pos__ = 0;
        global_prior_df = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_scale", "double", context__.to_vec());
        global_prior_scale = double(0);
        vals_r__ = context__.vals_r("global_prior_scale");
        pos__ = 0;
        global_prior_scale = vals_r__[pos__++];
        context__.validate_dims("data initialization", "num_normals", "int", context__.to_vec((logical_eq(prior_dist,7) ? K : 0 )));
        validate_non_negative_index("num_normals", "(logical_eq(prior_dist,7) ? K : 0 )", (logical_eq(prior_dist,7) ? K : 0 ));
        num_normals = std::vector<int>((logical_eq(prior_dist,7) ? K : 0 ),int(0));
        vals_i__ = context__.vals_i("num_normals");
        pos__ = 0;
        size_t num_normals_limit_0__ = (logical_eq(prior_dist,7) ? K : 0 );
        for (size_t i_0__ = 0; i_0__ < num_normals_limit_0__; ++i_0__) {
            num_normals[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "t", "int", context__.to_vec());
        t = int(0);
        vals_i__ = context__.vals_i("t");
        pos__ = 0;
        t = vals_i__[pos__++];
        context__.validate_dims("data initialization", "p", "int", context__.to_vec(t));
        validate_non_negative_index("p", "t", t);
        p = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("p");
        pos__ = 0;
        size_t p_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < p_limit_0__; ++i_0__) {
            p[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "l", "int", context__.to_vec(t));
        validate_non_negative_index("l", "t", t);
        l = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("l");
        pos__ = 0;
        size_t l_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < l_limit_0__; ++i_0__) {
            l[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "int", context__.to_vec());
        q = int(0);
        vals_i__ = context__.vals_i("q");
        pos__ = 0;
        q = vals_i__[pos__++];
        context__.validate_dims("data initialization", "len_theta_L", "int", context__.to_vec());
        len_theta_L = int(0);
        vals_i__ = context__.vals_i("len_theta_L");
        pos__ = 0;
        len_theta_L = vals_i__[pos__++];
        validate_non_negative_index("shape", "t", t);
        shape = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "shape", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("shape");
        pos__ = 0;
        size_t shape_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < shape_i_vec_lim__; ++i_vec__) {
            shape[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("scale", "t", t);
        scale = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "scale", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("scale");
        pos__ = 0;
        size_t scale_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < scale_i_vec_lim__; ++i_vec__) {
            scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_concentration", "int", context__.to_vec());
        len_concentration = int(0);
        vals_i__ = context__.vals_i("len_concentration");
        pos__ = 0;
        len_concentration = vals_i__[pos__++];
        context__.validate_dims("data initialization", "concentration", "double", context__.to_vec(len_concentration));
        validate_non_negative_index("concentration", "len_concentration", len_concentration);
        concentration = std::vector<double>(len_concentration,double(0));
        vals_r__ = context__.vals_r("concentration");
        pos__ = 0;
        size_t concentration_limit_0__ = len_concentration;
        for (size_t i_0__ = 0; i_0__ < concentration_limit_0__; ++i_0__) {
            concentration[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_regularization", "int", context__.to_vec());
        len_regularization = int(0);
        vals_i__ = context__.vals_i("len_regularization");
        pos__ = 0;
        len_regularization = vals_i__[pos__++];
        context__.validate_dims("data initialization", "regularization", "double", context__.to_vec(len_regularization));
        validate_non_negative_index("regularization", "len_regularization", len_regularization);
        regularization = std::vector<double>(len_regularization,double(0));
        vals_r__ = context__.vals_r("regularization");
        pos__ = 0;
        size_t regularization_limit_0__ = len_regularization;
        for (size_t i_0__ = 0; i_0__ < regularization_limit_0__; ++i_0__) {
            regularization[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "num_non_zero", "int", context__.to_vec());
        num_non_zero = int(0);
        vals_i__ = context__.vals_i("num_non_zero");
        pos__ = 0;
        num_non_zero = vals_i__[pos__++];
        validate_non_negative_index("w", "num_non_zero", num_non_zero);
        w = vector_d(static_cast<Eigen::VectorXd::Index>(num_non_zero));
        context__.validate_dims("data initialization", "w", "vector_d", context__.to_vec(num_non_zero));
        vals_r__ = context__.vals_r("w");
        pos__ = 0;
        size_t w_i_vec_lim__ = num_non_zero;
        for (size_t i_vec__ = 0; i_vec__ < w_i_vec_lim__; ++i_vec__) {
            w[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v", "int", context__.to_vec(num_non_zero));
        validate_non_negative_index("v", "num_non_zero", num_non_zero);
        v = std::vector<int>(num_non_zero,int(0));
        vals_i__ = context__.vals_i("v");
        pos__ = 0;
        size_t v_limit_0__ = num_non_zero;
        for (size_t i_0__ = 0; i_0__ < v_limit_0__; ++i_0__) {
            v[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u", "int", context__.to_vec((logical_gt(t,0) ? (N + 1) : 0 )));
        validate_non_negative_index("u", "(logical_gt(t,0) ? (N + 1) : 0 )", (logical_gt(t,0) ? (N + 1) : 0 ));
        u = std::vector<int>((logical_gt(t,0) ? (N + 1) : 0 ),int(0));
        vals_i__ = context__.vals_i("u");
        pos__ = 0;
        size_t u_limit_0__ = (logical_gt(t,0) ? (N + 1) : 0 );
        for (size_t i_0__ = 0; i_0__ < u_limit_0__; ++i_0__) {
            u[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "special_case", "int", context__.to_vec());
        special_case = int(0);
        vals_i__ = context__.vals_i("special_case");
        pos__ = 0;
        special_case = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"N",N,0);
        check_greater_or_equal(function__,"K",K,0);
        check_greater_or_equal(function__,"dense_X",dense_X,0);
        check_less_or_equal(function__,"dense_X",dense_X,1);
        check_greater_or_equal(function__,"nnz_X",nnz_X,0);
        for (int k0__ = 0; k0__ < nnz_X; ++k0__) {
            check_greater_or_equal(function__,"v_X[k0__]",v_X[k0__],0);
        }
        for (int k0__ = 0; k0__ < (dense_X ? 0 : (N + 1) ); ++k0__) {
            check_greater_or_equal(function__,"u_X[k0__]",u_X[k0__],0);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"trials[k0__]",trials[k0__],0);
        }
        check_greater_or_equal(function__,"prior_PD",prior_PD,0);
        check_less_or_equal(function__,"prior_PD",prior_PD,1);
        check_greater_or_equal(function__,"has_intercept",has_intercept,0);
        check_less_or_equal(function__,"has_intercept",has_intercept,1);
        check_greater_or_equal(function__,"family",family,1);
        check_greater_or_equal(function__,"link",link,1);
        check_greater_or_equal(function__,"prior_dist",prior_dist,0);
        check_less_or_equal(function__,"prior_dist",prior_dist,7);
        check_greater_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,0);
        check_less_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,2);
        check_greater_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,0);
        check_less_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,3);
        check_greater_or_equal(function__,"has_weights",has_weights,0);
        check_less_or_equal(function__,"has_weights",has_weights,1);
        check_greater_or_equal(function__,"has_offset",has_offset,0);
        check_less_or_equal(function__,"has_offset",has_offset,1);
        check_greater_or_equal(function__,"prior_scale",prior_scale,0);
        check_greater_or_equal(function__,"prior_scale_for_intercept",prior_scale_for_intercept,0);
        check_greater_or_equal(function__,"prior_scale_for_aux",prior_scale_for_aux,0);
        check_greater_or_equal(function__,"prior_mean_for_aux",prior_mean_for_aux,0);
        check_greater_or_equal(function__,"prior_df",prior_df,0);
        check_greater_or_equal(function__,"prior_df_for_intercept",prior_df_for_intercept,0);
        check_greater_or_equal(function__,"prior_df_for_aux",prior_df_for_aux,0);
        check_greater_or_equal(function__,"global_prior_df",global_prior_df,0);
        check_greater_or_equal(function__,"global_prior_scale",global_prior_scale,0);
        for (int k0__ = 0; k0__ < (logical_eq(prior_dist,7) ? K : 0 ); ++k0__) {
            check_greater_or_equal(function__,"num_normals[k0__]",num_normals[k0__],2);
        }
        check_greater_or_equal(function__,"t",t,0);
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"p[k0__]",p[k0__],1);
        }
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"l[k0__]",l[k0__],1);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_greater_or_equal(function__,"len_theta_L",len_theta_L,0);
        check_greater_or_equal(function__,"shape",shape,0);
        check_greater_or_equal(function__,"scale",scale,0);
        check_greater_or_equal(function__,"len_concentration",len_concentration,0);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"concentration[k0__]",concentration[k0__],0);
        }
        check_greater_or_equal(function__,"len_regularization",len_regularization,0);
        for (int k0__ = 0; k0__ < len_regularization; ++k0__) {
            check_greater_or_equal(function__,"regularization[k0__]",regularization[k0__],0);
        }
        check_greater_or_equal(function__,"num_non_zero",num_non_zero,0);
        for (int k0__ = 0; k0__ < num_non_zero; ++k0__) {
            check_greater_or_equal(function__,"v[k0__]",v[k0__],0);
        }
        for (int k0__ = 0; k0__ < (logical_gt(t,0) ? (N + 1) : 0 ); ++k0__) {
            check_greater_or_equal(function__,"u[k0__]",u[k0__],0);
        }
        check_greater_or_equal(function__,"special_case",special_case,0);
        check_less_or_equal(function__,"special_case",special_case,1);
        // initialize data variables
        aux = double(0);
        stan::math::fill(aux,DUMMY_VAR__);
        stan::math::assign(aux,stan::math::not_a_number());
        validate_non_negative_index("V", "t", t);
        validate_non_negative_index("V", "N", N);
        V = std::vector<std::vector<int> >(t,std::vector<int>(N,int(0)));
        stan::math::fill(V, std::numeric_limits<int>::min());
        stan::math::assign(V,make_V(N,t,v, pstream__));
        len_z_T = int(0);
        stan::math::fill(len_z_T, std::numeric_limits<int>::min());
        stan::math::assign(len_z_T,0);
        len_var_group = int(0);
        stan::math::fill(len_var_group, std::numeric_limits<int>::min());
        stan::math::assign(len_var_group,(sum(p) * logical_gt(t,0)));
        len_rho = int(0);
        stan::math::fill(len_rho, std::numeric_limits<int>::min());
        stan::math::assign(len_rho,(sum(p) - t));
        is_continuous = int(0);
        stan::math::fill(is_continuous, std::numeric_limits<int>::min());
        stan::math::assign(is_continuous,0);
        pos = int(0);
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        validate_non_negative_index("delta", "len_concentration", len_concentration);
        delta = std::vector<double>(len_concentration,double(0));
        stan::math::fill(delta,DUMMY_VAR__);
        hs = int(0);
        stan::math::fill(hs, std::numeric_limits<int>::min());

        try {
            if (as_bool(logical_lte(prior_dist,2))) {
                stan::math::assign(hs, 0);
            } else if (as_bool(logical_eq(prior_dist,3))) {
                stan::math::assign(hs, 2);
            } else if (as_bool(logical_eq(prior_dist,4))) {
                stan::math::assign(hs, 4);
            } else {
                stan::math::assign(hs, 0);
            }
            stan::math::assign(len_z_T, 0);
            stan::math::assign(len_var_group, (sum(p) * logical_gt(t,0)));
            stan::math::assign(len_rho, (sum(p) - t));
            stan::math::assign(pos, 1);
            for (int i = 1; i <= t; ++i) {

                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {

                    for (int j = 1; j <= get_base1(p,i,"p",1); ++j) {

                        stan::math::assign(get_base1_lhs(delta,pos,"delta",1), get_base1(concentration,j,"concentration",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
                for (int j = 3; j <= get_base1(p,i,"p",1); ++j) {
                    stan::math::assign(len_z_T, ((len_z_T + get_base1(p,i,"p",1)) - 1));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        for (int k0__ = 0; k0__ < t; ++k0__) {
            for (int k1__ = 0; k1__ < N; ++k1__) {
                check_greater_or_equal(function__,"V[k0__][k1__]",V[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"len_z_T",len_z_T,0);
        check_greater_or_equal(function__,"len_var_group",len_var_group,0);
        check_greater_or_equal(function__,"len_rho",len_rho,0);
        check_greater_or_equal(function__,"is_continuous",is_continuous,0);
        check_less_or_equal(function__,"is_continuous",is_continuous,1);
        check_greater_or_equal(function__,"pos",pos,1);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"delta[k0__]",delta[k0__],0);
        }
        check_greater_or_equal(function__,"hs",hs,0);

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += has_intercept;
        num_params_r__ += (logical_eq(prior_dist,7) ? sum(num_normals) : K );
        num_params_r__ += hs;
        num_params_r__ += K * hs;
        num_params_r__ += K * (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        num_params_r__ += logical_eq(prior_dist,6);
        num_params_r__ += q;
        num_params_r__ += len_z_T;
        num_params_r__ += len_rho;
        num_params_r__ += len_concentration;
        num_params_r__ += t;
    }

    ~model_binomial() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("gamma")))
            throw std::runtime_error("variable gamma missing");
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma", "double", context__.to_vec(has_intercept));
        // generate_declaration gamma
        std::vector<double> gamma(has_intercept,double(0));
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            gamma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            try {
            writer__.scalar_ub_unconstrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() ),gamma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma: ") + e.what());
        }

        if (!(context__.contains_r("z_beta")))
            throw std::runtime_error("variable z_beta missing");
        vals_r__ = context__.vals_r("z_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_beta", "vector_d", context__.to_vec((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        // generate_declaration z_beta
        vector_d z_beta(static_cast<Eigen::VectorXd::Index>((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        for (int j1__ = 0U; j1__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++j1__)
            z_beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_beta: ") + e.what());
        }

        if (!(context__.contains_r("global")))
            throw std::runtime_error("variable global missing");
        vals_r__ = context__.vals_r("global");
        pos__ = 0U;
        context__.validate_dims("initialization", "global", "double", context__.to_vec(hs));
        // generate_declaration global
        std::vector<double> global(hs,double(0));
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            global[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,global[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable global: ") + e.what());
        }

        if (!(context__.contains_r("local")))
            throw std::runtime_error("variable local missing");
        vals_r__ = context__.vals_r("local");
        pos__ = 0U;
        context__.validate_dims("initialization", "local", "vector_d", context__.to_vec(hs,K));
        // generate_declaration local
        std::vector<vector_d> local(hs,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < hs; ++i0__)
                local[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,local[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable local: ") + e.what());
        }

        if (!(context__.contains_r("S")))
            throw std::runtime_error("variable S missing");
        vals_r__ = context__.vals_r("S");
        pos__ = 0U;
        context__.validate_dims("initialization", "S", "vector_d", context__.to_vec((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),K));
        // generate_declaration S
        std::vector<vector_d> S((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
                S[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,S[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable S: ") + e.what());
        }

        if (!(context__.contains_r("one_over_lambda")))
            throw std::runtime_error("variable one_over_lambda missing");
        vals_r__ = context__.vals_r("one_over_lambda");
        pos__ = 0U;
        context__.validate_dims("initialization", "one_over_lambda", "double", context__.to_vec(logical_eq(prior_dist,6)));
        // generate_declaration one_over_lambda
        std::vector<double> one_over_lambda(logical_eq(prior_dist,6),double(0));
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            one_over_lambda[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,one_over_lambda[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable one_over_lambda: ") + e.what());
        }

        if (!(context__.contains_r("z_b")))
            throw std::runtime_error("variable z_b missing");
        vals_r__ = context__.vals_r("z_b");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_b", "vector_d", context__.to_vec(q));
        // generate_declaration z_b
        vector_d z_b(static_cast<Eigen::VectorXd::Index>(q));
        for (int j1__ = 0U; j1__ < q; ++j1__)
            z_b(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_b: ") + e.what());
        }

        if (!(context__.contains_r("z_T")))
            throw std::runtime_error("variable z_T missing");
        vals_r__ = context__.vals_r("z_T");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_T", "vector_d", context__.to_vec(len_z_T));
        // generate_declaration z_T
        vector_d z_T(static_cast<Eigen::VectorXd::Index>(len_z_T));
        for (int j1__ = 0U; j1__ < len_z_T; ++j1__)
            z_T(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_T);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_T: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho", "vector_d", context__.to_vec(len_rho));
        // generate_declaration rho
        vector_d rho(static_cast<Eigen::VectorXd::Index>(len_rho));
        for (int j1__ = 0U; j1__ < len_rho; ++j1__)
            rho(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        if (!(context__.contains_r("zeta")))
            throw std::runtime_error("variable zeta missing");
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "zeta", "vector_d", context__.to_vec(len_concentration));
        // generate_declaration zeta
        vector_d zeta(static_cast<Eigen::VectorXd::Index>(len_concentration));
        for (int j1__ = 0U; j1__ < len_concentration; ++j1__)
            zeta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,zeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zeta: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "vector_d", context__.to_vec(t));
        // generate_declaration tau
        vector_d tau(static_cast<Eigen::VectorXd::Index>(t));
        for (int j1__ = 0U; j1__ < t; ++j1__)
            tau(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<T__> gamma;
        size_t dim_gamma_0__ = has_intercept;
        gamma.reserve(dim_gamma_0__);
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            if (jacobian__)
                gamma.push_back(in__.scalar_ub_constrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() ),lp__));
            else
                gamma.push_back(in__.scalar_ub_constrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() )));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_beta;
        (void) z_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ),lp__);
        else
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));

        vector<T__> global;
        size_t dim_global_0__ = hs;
        global.reserve(dim_global_0__);
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            if (jacobian__)
                global.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                global.push_back(in__.scalar_lb_constrain(0));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > local;
        size_t dim_local_0__ = hs;
        local.reserve(dim_local_0__);
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            if (jacobian__)
                local.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                local.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        S.reserve(dim_S_0__);
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            if (jacobian__)
                S.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                S.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<T__> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        one_over_lambda.reserve(dim_one_over_lambda_0__);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            if (jacobian__)
                one_over_lambda.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_b;
        (void) z_b;  // dummy to suppress unused var warning
        if (jacobian__)
            z_b = in__.vector_constrain(q,lp__);
        else
            z_b = in__.vector_constrain(q);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_T;
        (void) z_T;  // dummy to suppress unused var warning
        if (jacobian__)
            z_T = in__.vector_constrain(len_z_T,lp__);
        else
            z_T = in__.vector_constrain(len_z_T);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho;
        (void) rho;  // dummy to suppress unused var warning
        if (jacobian__)
            rho = in__.vector_lub_constrain(0,1,len_rho,lp__);
        else
            rho = in__.vector_lub_constrain(0,1,len_rho);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  zeta;
        (void) zeta;  // dummy to suppress unused var warning
        if (jacobian__)
            zeta = in__.vector_lb_constrain(0,len_concentration,lp__);
        else
            zeta = in__.vector_lb_constrain(0,len_concentration);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.vector_lb_constrain(0,t,lp__);
        else
            tau = in__.vector_lb_constrain(0,t);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, DUMMY_VAR__);
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(logical_eq(special_case,1))) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, tau);
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(tau,1,"tau",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(tau,i,"tau",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    stan::math::assign(theta_L, make_theta_L(len_theta_L,p,1.0,tau,scale,zeta,rho,z_T, pstream__));
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < q; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < len_theta_L; ++i0__) {
            if (stan::math::is_uninitialized(theta_L(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: theta_L" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, DUMMY_VAR__);
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                if (as_bool(logical_gt(t,0))) {

                    if (as_bool(special_case)) {
                        for (int i = 1; i <= t; ++i) {
                            stan::math::assign(eta, add(eta,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V,i,"V",1)), stan::model::nil_index_list()), "b")));
                        }
                    } else {
                        stan::math::assign(eta, add(eta,csr_matrix_times_vector(N,q,w,v,u,b)));
                    }
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_neq(link,4))) {
                        stan::math::assign(eta, add(eta,get_base1(gamma,1,"gamma",1)));
                    } else {
                        stan::math::assign(eta, subtract(add(get_base1(gamma,1,"gamma",1),eta),max(eta)));
                    }
                } else {

                    stan::math::assign(eta, add(eta,dot_product(xbar,beta)));
                }
                if (as_bool((primitive_value(logical_eq(has_weights,0)) && primitive_value(logical_eq(prior_PD,0))))) {
                    {
                        T__ dummy;
                        (void) dummy;  // dummy to suppress unused var warning
                        stan::math::initialize(dummy, DUMMY_VAR__);
                        stan::math::fill(dummy,DUMMY_VAR__);


                        stan::math::assign(dummy, ll_binom_lp(y,trials,eta,link, lp__, lp_accum__, pstream__));
                    }
                } else if (as_bool(logical_eq(prior_PD,0))) {
                    lp_accum__.add(dot_product(weights,pw_binom(y,trials,eta,link, pstream__)));
                }
                if (as_bool(logical_eq(prior_dist,1))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,2))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,3))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,4))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(local,3,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,4,"local",1),multiply(0.5,prior_scale),multiply(0.5,prior_scale)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,5))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                } else if (as_bool(logical_eq(prior_dist,6))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                    lp_accum__.add(chi_square_log(get_base1(one_over_lambda,1,"one_over_lambda",1),get_base1(prior_df,1,"prior_df",1)));
                } else if (as_bool(logical_eq(prior_dist,7))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_eq(prior_dist_for_intercept,1))) {
                        lp_accum__.add(normal_log(gamma,prior_mean_for_intercept,prior_scale_for_intercept));
                    } else if (as_bool(logical_eq(prior_dist_for_intercept,2))) {
                        lp_accum__.add(student_t_log(gamma,prior_df_for_intercept,prior_mean_for_intercept,prior_scale_for_intercept));
                    }
                }
                if (as_bool(logical_gt(t,0))) {
                    decov_lp(z_b,z_T,rho,zeta,tau,regularization,delta,shape,t,p, lp__, lp_accum__, pstream__);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("z_beta");
        names__.push_back("global");
        names__.push_back("local");
        names__.push_back("S");
        names__.push_back("one_over_lambda");
        names__.push_back("z_b");
        names__.push_back("z_T");
        names__.push_back("rho");
        names__.push_back("zeta");
        names__.push_back("tau");
        names__.push_back("beta");
        names__.push_back("b");
        names__.push_back("theta_L");
        names__.push_back("alpha");
        names__.push_back("mean_PPD");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))));
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(prior_dist,6));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_z_T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_rho);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_concentration);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_theta_L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_binomial_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector<double> gamma;
        size_t dim_gamma_0__ = has_intercept;
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            gamma.push_back(in__.scalar_ub_constrain((logical_eq(link,4) ? 0.0 : stan::math::positive_infinity() )));
        }
        vector_d z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        vector<double> global;
        size_t dim_global_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            global.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> local;
        size_t dim_local_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            local.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<vector_d> S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            S.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<double> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }
        vector_d z_b = in__.vector_constrain(q);
        vector_d z_T = in__.vector_constrain(len_z_T);
        vector_d rho = in__.vector_lub_constrain(0,1,len_rho);
        vector_d zeta = in__.vector_lb_constrain(0,len_concentration);
        vector_d tau = in__.vector_lb_constrain(0,t);
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            vars__.push_back(z_beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
            vars__.push_back(global[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
                vars__.push_back(local[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                vars__.push_back(S[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < logical_eq(prior_dist,6); ++k_0__) {
            vars__.push_back(one_over_lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(z_b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_z_T; ++k_0__) {
            vars__.push_back(z_T[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_rho; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_concentration; ++k_0__) {
            vars__.push_back(zeta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < t; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(logical_eq(special_case,1))) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, tau);
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(tau,1,"tau",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(tau,i,"tau",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    stan::math::assign(theta_L, make_theta_L(len_theta_L,p,1.0,tau,scale,zeta,rho,z_T, pstream__));
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_theta_L; ++k_0__) {
            vars__.push_back(theta_L[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> alpha(has_intercept, 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        double mean_PPD(0.0);
        (void) mean_PPD;  // dummy to suppress unused var warning
        stan::math::initialize(mean_PPD, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mean_PPD,DUMMY_VAR__);
        stan::math::assign(mean_PPD,0);


        try {
            if (as_bool(logical_eq(has_intercept,1))) {

                if (as_bool(dense_X)) {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(gamma,1,"gamma",1) - dot_product(xbar,beta)));
                } else {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), get_base1(gamma,1,"gamma",1));
                }
            }
            {
                vector_d pi(static_cast<Eigen::VectorXd::Index>(N));
                (void) pi;  // dummy to suppress unused var warning
                stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(pi,DUMMY_VAR__);
                vector_d eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                if (as_bool(logical_gt(t,0))) {

                    if (as_bool(special_case)) {
                        for (int i = 1; i <= t; ++i) {
                            stan::math::assign(eta, add(eta,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V,i,"V",1)), stan::model::nil_index_list()), "b")));
                        }
                    } else {
                        stan::math::assign(eta, add(eta,csr_matrix_times_vector(N,q,w,v,u,b)));
                    }
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_neq(link,4))) {
                        stan::math::assign(eta, add(eta,get_base1(gamma,1,"gamma",1)));
                    } else {
                        {
                            double shift(0.0);
                            (void) shift;  // dummy to suppress unused var warning
                            stan::math::initialize(shift, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(shift,DUMMY_VAR__);


                            stan::math::assign(shift, max(eta));
                            stan::math::assign(eta, subtract(add(get_base1(gamma,1,"gamma",1),eta),shift));
                            stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(alpha,1,"alpha",1) - shift));
                        }
                    }
                } else {

                    stan::math::assign(eta, add(eta,dot_product(xbar,beta)));
                }
                stan::math::assign(pi, linkinv_binom(eta,link, pstream__));
                for (int n = 1; n <= N; ++n) {
                    stan::math::assign(mean_PPD, (mean_PPD + binomial_rng(get_base1(trials,n,"trials",1),get_base1(pi,n,"pi",1), base_rng__)));
                }
                stan::math::assign(mean_PPD, (mean_PPD / N));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        vars__.push_back(mean_PPD);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_binomial";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_continuous_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
make_theta_L(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
            (void) theta_L;  // dummy to suppress unused var warning
            stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(theta_L,DUMMY_VAR__);
            int zeta_mark(0);
            (void) zeta_mark;  // dummy to suppress unused var warning
            stan::math::fill(zeta_mark, std::numeric_limits<int>::min());
            stan::math::assign(zeta_mark,1);
            int rho_mark(0);
            (void) rho_mark;  // dummy to suppress unused var warning
            stan::math::fill(rho_mark, std::numeric_limits<int>::min());
            stan::math::assign(rho_mark,1);
            int z_T_mark(0);
            (void) z_T_mark;  // dummy to suppress unused var warning
            stan::math::fill(z_T_mark, std::numeric_limits<int>::min());
            stan::math::assign(z_T_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {

                        stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), ((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion));
                        stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            fun_scalar_t__ std_dev;
                            (void) std_dev;  // dummy to suppress unused var warning
                            stan::math::initialize(std_dev, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(std_dev,DUMMY_VAR__);
                            fun_scalar_t__ T21;
                            (void) T21;  // dummy to suppress unused var warning
                            stan::math::initialize(T21, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T21,DUMMY_VAR__);
                            fun_scalar_t__ trace_T_i;
                            (void) trace_T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(trace_T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(trace_T_i,DUMMY_VAR__);
                            stan::math::assign(trace_T_i,(square(((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion)) * nc));
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(nc));
                            (void) pi;  // dummy to suppress unused var warning
                            stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(pi,DUMMY_VAR__);
                            stan::math::assign(pi,segment(zeta,zeta_mark,nc));


                            stan::math::assign(pi, divide(pi,sum(pi)));
                            stan::math::assign(zeta_mark, (zeta_mark + nc));
                            stan::math::assign(std_dev, sqrt((get_base1(pi,1,"pi",1) * trace_T_i)));
                            stan::math::assign(get_base1_lhs(T_i,1,1,"T_i",1), std_dev);
                            stan::math::assign(std_dev, sqrt((get_base1(pi,2,"pi",1) * trace_T_i)));
                            stan::math::assign(T21, ((2.0 * get_base1(rho,rho_mark,"rho",1)) - 1.0));
                            stan::math::assign(rho_mark, (rho_mark + 1));
                            stan::math::assign(get_base1_lhs(T_i,2,2,"T_i",1), (std_dev * sqrt((1.0 - square(T21)))));
                            stan::math::assign(get_base1_lhs(T_i,2,1,"T_i",1), (std_dev * T21));
                            for (int r = 2; r <= (nc - 1); ++r) {
                                {
                                    int rp1(0);
                                    (void) rp1;  // dummy to suppress unused var warning
                                    stan::math::fill(rp1, std::numeric_limits<int>::min());
                                    stan::math::assign(rp1,(r + 1));
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  T_row(static_cast<Eigen::VectorXd::Index>(r));
                                    (void) T_row;  // dummy to suppress unused var warning
                                    stan::math::initialize(T_row, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(T_row,DUMMY_VAR__);
                                    stan::math::assign(T_row,segment(z_T,z_T_mark,r));
                                    fun_scalar_t__ scale_factor;
                                    (void) scale_factor;  // dummy to suppress unused var warning
                                    stan::math::initialize(scale_factor, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(scale_factor,DUMMY_VAR__);
                                    stan::math::assign(scale_factor,(sqrt((get_base1(rho,rho_mark,"rho",1) / dot_self(T_row))) * std_dev));


                                    stan::math::assign(z_T_mark, (z_T_mark + r));
                                    stan::math::assign(std_dev, sqrt((get_base1(pi,rp1,"pi",1) * trace_T_i)));
                                    for (int c = 1; c <= r; ++c) {
                                        stan::math::assign(get_base1_lhs(T_i,rp1,c,"T_i",1), (get_base1(T_row,c,"T_row",1) * scale_factor));
                                    }
                                    stan::math::assign(get_base1_lhs(T_i,rp1,rp1,"T_i",1), (sqrt((1.0 - get_base1(rho,rho_mark,"rho",1))) * std_dev));
                                    stan::math::assign(rho_mark, (rho_mark + 1));
                                }
                            }
                            for (int c = 1; c <= nc; ++c) {
                                for (int r = c; r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), get_base1(T_i,r,c,"T_i",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(theta_L);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_theta_L_functor__ {
    template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
    operator()(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) const {
        return make_theta_L(len_theta_L, p, dispersion, tau, scale, zeta, rho, z_T, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
make_b(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(rows(z_b)));
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(b,DUMMY_VAR__);
            int b_mark(0);
            (void) b_mark;  // dummy to suppress unused var warning
            stan::math::fill(b_mark, std::numeric_limits<int>::min());
            stan::math::assign(b_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {
                        {
                            fun_scalar_t__ theta_L_start;
                            (void) theta_L_start;  // dummy to suppress unused var warning
                            stan::math::initialize(theta_L_start, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(theta_L_start,DUMMY_VAR__);
                            stan::math::assign(theta_L_start,get_base1(theta_L,theta_L_mark,"theta_L",1));


                            for (int s = b_mark; s <= ((b_mark + get_base1(l,i,"l",1)) - 1); ++s) {
                                stan::math::assign(get_base1_lhs(b,s,"b",1), (theta_L_start * get_base1(z_b,s,"z_b",1)));
                            }
                            stan::math::assign(b_mark, (b_mark + get_base1(l,i,"l",1)));
                            stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                        }
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            stan::math::assign(T_i,rep_matrix(0,nc,nc));


                            for (int c = 1; c <= nc; ++c) {

                                stan::math::assign(get_base1_lhs(T_i,c,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                for (int r = (c + 1); r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(T_i,r,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                            for (int j = 1; j <= get_base1(l,i,"l",1); ++j) {
                                {
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  temp(static_cast<Eigen::VectorXd::Index>(nc));
                                    (void) temp;  // dummy to suppress unused var warning
                                    stan::math::initialize(temp, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(temp,DUMMY_VAR__);
                                    stan::math::assign(temp,multiply(T_i,segment(z_b,b_mark,nc)));


                                    stan::math::assign(b_mark, (b_mark - 1));
                                    for (int s = 1; s <= nc; ++s) {
                                        stan::math::assign(get_base1_lhs(b,(b_mark + s),"b",1), get_base1(temp,s,"temp",1));
                                    }
                                    stan::math::assign(b_mark, ((b_mark + nc) + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(b);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_b_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) const {
        return make_b(z_b, theta_L, p, l, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
void
decov_lp(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int pos_reg(0);
            (void) pos_reg;  // dummy to suppress unused var warning
            stan::math::fill(pos_reg, std::numeric_limits<int>::min());
            stan::math::assign(pos_reg,1);
            int pos_rho(0);
            (void) pos_rho;  // dummy to suppress unused var warning
            stan::math::fill(pos_rho, std::numeric_limits<int>::min());
            stan::math::assign(pos_rho,1);


            lp_accum__.add(normal_log(z_b,0,1));
            lp_accum__.add(normal_log(z_T,0,1));
            for (int i = 1; i <= t; ++i) {
                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {
                    {
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape1(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape1;  // dummy to suppress unused var warning
                        stan::math::initialize(shape1, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape1,DUMMY_VAR__);
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape2(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape2;  // dummy to suppress unused var warning
                        stan::math::initialize(shape2, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape2,DUMMY_VAR__);
                        fun_scalar_t__ nu;
                        (void) nu;  // dummy to suppress unused var warning
                        stan::math::initialize(nu, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(nu,DUMMY_VAR__);
                        stan::math::assign(nu,(get_base1(regularization,pos_reg,"regularization",1) + (0.5 * (get_base1(p,i,"p",1) - 2))));


                        stan::math::assign(pos_reg, (pos_reg + 1));
                        stan::math::assign(get_base1_lhs(shape1,1,"shape1",1), nu);
                        stan::math::assign(get_base1_lhs(shape2,1,"shape2",1), nu);
                        for (int j = 2; j <= (get_base1(p,i,"p",1) - 1); ++j) {

                            stan::math::assign(nu, (nu - 0.5));
                            stan::math::assign(get_base1_lhs(shape1,j,"shape1",1), (0.5 * j));
                            stan::math::assign(get_base1_lhs(shape2,j,"shape2",1), nu);
                        }
                        lp_accum__.add(beta_log(stan::model::rvalue(rho, stan::model::cons_list(stan::model::index_min_max(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 2)), stan::model::nil_index_list()), "rho"),shape1,shape2));
                        stan::math::assign(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 1));
                    }
                }
            }
            lp_accum__.add(gamma_log(zeta,delta,1));
            lp_accum__.add(gamma_log(tau,shape,1));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct decov_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return decov_lp(z_b, z_T, rho, zeta, tau, regularization, delta, shape, t, p, lp__, lp_accum__, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hs_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(rows(z_beta)));
            (void) lambda;  // dummy to suppress unused var warning
            stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lambda,DUMMY_VAR__);
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());


            stan::math::assign(K, rows(z_beta));
            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(lambda,k,"lambda",1), (get_base1(get_base1(local,1,"local",1),k,"local",2) * sqrt(get_base1(get_base1(local,2,"local",1),k,"local",2))));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(z_beta,lambda),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hs_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) const {
        return hs_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hsplus_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(elt_multiply(z_beta,elt_multiply(get_base1(local,1,"local",1),sqrt(get_base1(local,2,"local",1)))),elt_multiply(get_base1(local,3,"local",1),sqrt(get_base1(local,4,"local",1)))),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hsplus_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) const {
        return hsplus_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
divide_real_by_vector(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());
            stan::math::assign(K,rows(y));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ret(static_cast<Eigen::VectorXd::Index>(K));
            (void) ret;  // dummy to suppress unused var warning
            stan::math::initialize(ret, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ret,DUMMY_VAR__);


            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(ret,k,"ret",1), (x / get_base1(y,k,"y",1)));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct divide_real_by_vector_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) const {
        return divide_real_by_vector(x, y, pstream__);
    }
};

template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
CFt(const T0__& z,
        const T1__& df, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ z2;
            (void) z2;  // dummy to suppress unused var warning
            stan::math::initialize(z2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z2,DUMMY_VAR__);
            stan::math::assign(z2,square(z));
            fun_scalar_t__ z3;
            (void) z3;  // dummy to suppress unused var warning
            stan::math::initialize(z3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z3,DUMMY_VAR__);
            stan::math::assign(z3,(z2 * z));
            fun_scalar_t__ z5;
            (void) z5;  // dummy to suppress unused var warning
            stan::math::initialize(z5, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z5,DUMMY_VAR__);
            stan::math::assign(z5,(z2 * z3));
            fun_scalar_t__ z7;
            (void) z7;  // dummy to suppress unused var warning
            stan::math::initialize(z7, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z7,DUMMY_VAR__);
            stan::math::assign(z7,(z2 * z5));
            fun_scalar_t__ z9;
            (void) z9;  // dummy to suppress unused var warning
            stan::math::initialize(z9, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z9,DUMMY_VAR__);
            stan::math::assign(z9,(z2 * z7));
            fun_scalar_t__ df2;
            (void) df2;  // dummy to suppress unused var warning
            stan::math::initialize(df2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df2,DUMMY_VAR__);
            stan::math::assign(df2,square(df));
            fun_scalar_t__ df3;
            (void) df3;  // dummy to suppress unused var warning
            stan::math::initialize(df3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df3,DUMMY_VAR__);
            stan::math::assign(df3,(df2 * df));
            fun_scalar_t__ df4;
            (void) df4;  // dummy to suppress unused var warning
            stan::math::initialize(df4, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df4,DUMMY_VAR__);
            stan::math::assign(df4,(df2 * df2));


            return stan::math::promote_scalar<fun_return_scalar_t__>(((((z + ((z3 + z) / (4 * df))) + ((((5 * z5) + (16 * z3)) + (3 * z)) / (96 * df2))) + (((((3 * z7) + (19 * z5)) + (17 * z3)) - (15 * z)) / (384 * df3))) + ((((((79 * z9) + (776 * z7)) + (1482 * z5)) - (1920 * z3)) - (945 * z)) / (92160 * df4))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct CFt_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& z,
        const T1__& df, std::ostream* pstream__) const {
        return CFt(z, df, pstream__);
    }
};

std::vector<std::vector<int> >
make_V(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) {
    typedef double fun_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<vector<int> > V(t, (vector<int>(N, 0)));
            stan::math::fill(V, std::numeric_limits<int>::min());
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);


            if (as_bool(logical_gt(t,0))) {
                for (int j = 1; j <= N; ++j) {
                    for (int i = 1; i <= t; ++i) {

                        stan::math::assign(get_base1_lhs(get_base1_lhs(V,i,"V",1),j,"V",2), get_base1(v,pos,"v",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(V);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_V_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) const {
        return make_V(N, t, v, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_gauss(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(exp(eta));
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv(eta));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_gauss_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) const {
        return linkinv_gauss(eta, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
pw_gauss(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
             const T2__& sigma,
             const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(subtract((-(0.5) * log((6.2831853071795862 * sigma))),multiply(0.5,square(divide(subtract(y,linkinv_gauss(eta,link, pstream__)),sigma)))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_gauss_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
             const T2__& sigma,
             const int& link, std::ostream* pstream__) const {
        return pw_gauss(y, eta, sigma, link, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_gamma(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(exp(eta));
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv(eta));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_gamma_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) const {
        return linkinv_gamma(eta, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__>::type
GammaReg(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
             const T2__& shape,
             const int& link,
             const T4__& sum_log_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ ret;
            (void) ret;  // dummy to suppress unused var warning
            stan::math::initialize(ret, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ret,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,3))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            stan::math::assign(ret, ((rows(y) * ((shape * log(shape)) - stan::math::lgamma(shape))) + ((shape - 1) * sum_log_y)));
            if (as_bool(logical_eq(link,2))) {
                stan::math::assign(ret, ((ret - (shape * sum(eta))) - (shape * sum(elt_divide(y,exp(eta))))));
            } else if (as_bool(logical_eq(link,1))) {
                stan::math::assign(ret, ((ret - (shape * sum(log(eta)))) - (shape * sum(elt_divide(y,eta)))));
            } else {
                stan::math::assign(ret, ((ret + (shape * sum(log(eta)))) - (shape * dot_product(eta,y))));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct GammaReg_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
             const T2__& shape,
             const int& link,
             const T4__& sum_log_y, std::ostream* pstream__) const {
        return GammaReg(y, eta, shape, link, sum_log_y, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
pw_gamma(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
             const T2__& shape,
             const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int N(0);
            (void) N;  // dummy to suppress unused var warning
            stan::math::fill(N, std::numeric_limits<int>::min());
            stan::math::assign(N,rows(eta));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(N));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);


            if (as_bool(logical_eq(link,3))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(ll,n,"ll",1), gamma_log(get_base1(y,n,"y",1),shape,(shape * get_base1(eta,n,"eta",1))));
                }
            } else if (as_bool(logical_eq(link,2))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(ll,n,"ll",1), gamma_log(get_base1(y,n,"y",1),shape,(shape / exp(get_base1(eta,n,"eta",1)))));
                }
            } else if (as_bool(logical_eq(link,1))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(ll,n,"ll",1), gamma_log(get_base1(y,n,"y",1),shape,(shape / get_base1(eta,n,"eta",1))));
                }
            } else {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
             const T2__& shape,
             const int& link, std::ostream* pstream__) const {
        return pw_gamma(y, eta, shape, link, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_inv_gaussian(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                         const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(exp(eta));
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv(eta));
        } else if (as_bool(logical_eq(link,4))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_sqrt(eta));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_inv_gaussian_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                         const int& link, std::ostream* pstream__) const {
        return linkinv_inv_gaussian(eta, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
inv_gaussian(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                 const Eigen::Matrix<T1__, Eigen::Dynamic,1>& mu,
                 const T2__& lambda,
                 const T3__& sum_log_y,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& sqrt_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(((((0.5 * rows(y)) * log((lambda / 6.2831853071795862))) - (1.5 * sum_log_y)) - ((0.5 * lambda) * dot_self(elt_divide(subtract(y,mu),elt_multiply(mu,sqrt_y))))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct inv_gaussian_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                 const Eigen::Matrix<T1__, Eigen::Dynamic,1>& mu,
                 const T2__& lambda,
                 const T3__& sum_log_y,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& sqrt_y, std::ostream* pstream__) const {
        return inv_gaussian(y, mu, lambda, sum_log_y, sqrt_y, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type, Eigen::Dynamic,1>
pw_inv_gaussian(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
                    const T2__& lambda,
                    const int& link,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& log_y,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& sqrt_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) mu;  // dummy to suppress unused var warning
            stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu,DUMMY_VAR__);


            stan::math::assign(mu, linkinv_inv_gaussian(eta,link, pstream__));
            return stan::math::promote_scalar<fun_return_scalar_t__>(subtract(add(multiply((-(0.5) * lambda),square(elt_divide(subtract(y,mu),elt_multiply(mu,sqrt_y)))),(0.5 * log((lambda / 6.2831853071795862)))),multiply(1.5,log_y)));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_inv_gaussian_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
                    const T2__& lambda,
                    const int& link,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& log_y,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& sqrt_y, std::ostream* pstream__) const {
        return pw_inv_gaussian(y, eta, lambda, link, log_y, sqrt_y, pstream__);
    }
};

template <typename T0__, typename T1__, class RNG>
typename boost::math::tools::promote_args<T0__, T1__>::type
inv_gaussian_rng(const T0__& mu,
                     const T1__& lambda, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ mu2;
            (void) mu2;  // dummy to suppress unused var warning
            stan::math::initialize(mu2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu2,DUMMY_VAR__);
            stan::math::assign(mu2,square(mu));
            fun_scalar_t__ z;
            (void) z;  // dummy to suppress unused var warning
            stan::math::initialize(z, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z,DUMMY_VAR__);
            fun_scalar_t__ y;
            (void) y;  // dummy to suppress unused var warning
            stan::math::initialize(y, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(y,DUMMY_VAR__);
            fun_scalar_t__ x;
            (void) x;  // dummy to suppress unused var warning
            stan::math::initialize(x, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(x,DUMMY_VAR__);


            stan::math::assign(z, uniform_rng(0,1, base_rng__));
            stan::math::assign(y, square(normal_rng(0,1, base_rng__)));
            stan::math::assign(x, (mu + (((mu2 * y) - (mu * sqrt(((((4 * mu) * lambda) * y) + (mu2 * square(y)))))) / (2 * lambda))));
            if (as_bool(logical_lte(z,(mu / (mu + x))))) {
                return stan::math::promote_scalar<fun_return_scalar_t__>(x);
            } else {
                return stan::math::promote_scalar<fun_return_scalar_t__>((mu2 / x));
            }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct inv_gaussian_rng_functor__ {
    template <typename T0__, typename T1__, class RNG>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& mu,
                     const T1__& lambda, RNG& base_rng__, std::ostream* pstream__) const {
        return inv_gaussian_rng(mu, lambda, base_rng__, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_beta(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                 const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(rows(eta)));
            (void) mu;  // dummy to suppress unused var warning
            stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,6))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(link,1))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), inv_logit(get_base1(eta,n,"eta",1)));
                }
            } else if (as_bool(logical_eq(link,2))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), Phi(get_base1(eta,n,"eta",1)));
                }
            } else if (as_bool(logical_eq(link,3))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), inv_cloglog(get_base1(eta,n,"eta",1)));
                }
            } else if (as_bool(logical_eq(link,4))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), cauchy_cdf(get_base1(eta,n,"eta",1),0.0,1.0));
                }
            } else if (as_bool(logical_eq(link,5))) {
                for (int n = 1; n <= rows(eta); ++n) {

                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), exp(get_base1(eta,n,"eta",1)));
                    if (as_bool((primitive_value(logical_lt(get_base1(mu,n,"mu",1),0)) || primitive_value(logical_gt(get_base1(mu,n,"mu",1),1))))) {
                        std::stringstream errmsg_stream__;
                        errmsg_stream__ << "mu needs to be between 0 and 1";
                        throw std::domain_error(errmsg_stream__.str());
                    }
                }
            } else if (as_bool(logical_eq(link,6))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), (1 - inv_cloglog(-(get_base1(eta,n,"eta",1)))));
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(mu);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_beta_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                 const int& link, std::ostream* pstream__) const {
        return linkinv_beta(eta, link, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_beta_z(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                   const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(rows(eta)));
            (void) mu;  // dummy to suppress unused var warning
            stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,3))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(link,1))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), exp(get_base1(eta,n,"eta",1)));
                }
            } else if (as_bool(logical_eq(link,2))) {
                return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
            } else if (as_bool(logical_eq(link,3))) {
                for (int n = 1; n <= rows(eta); ++n) {
                    stan::math::assign(get_base1_lhs(mu,n,"mu",1), square(get_base1(eta,n,"eta",1)));
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(mu);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_beta_z_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                   const int& link, std::ostream* pstream__) const {
        return linkinv_beta_z(eta, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
pw_beta(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const T2__& dispersion,
            const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) mu;  // dummy to suppress unused var warning
            stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu,DUMMY_VAR__);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape1(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) shape1;  // dummy to suppress unused var warning
            stan::math::initialize(shape1, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(shape1,DUMMY_VAR__);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape2(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) shape2;  // dummy to suppress unused var warning
            stan::math::initialize(shape2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(shape2,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,6))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            stan::math::assign(mu, linkinv_beta(eta,link, pstream__));
            stan::math::assign(shape1, multiply(mu,dispersion));
            stan::math::assign(shape2, multiply(subtract(1,mu),dispersion));
            for (int n = 1; n <= rows(y); ++n) {

                stan::math::assign(get_base1_lhs(ll,n,"ll",1), beta_log(get_base1(y,n,"y",1),get_base1(shape1,n,"shape1",1),get_base1(shape2,n,"shape2",1)));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_beta_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const T2__& dispersion,
            const int& link, std::ostream* pstream__) const {
        return pw_beta(y, eta, dispersion, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
pw_beta_z(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
              const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
              const Eigen::Matrix<T2__, Eigen::Dynamic,1>& eta_z,
              const int& link,
              const int& link_phi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) mu;  // dummy to suppress unused var warning
            stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu,DUMMY_VAR__);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  mu_z(static_cast<Eigen::VectorXd::Index>(rows(y)));
            (void) mu_z;  // dummy to suppress unused var warning
            stan::math::initialize(mu_z, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(mu_z,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,6))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool((primitive_value(logical_lt(link_phi,1)) || primitive_value(logical_gt(link_phi,3))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            stan::math::assign(mu, linkinv_beta(eta,link, pstream__));
            stan::math::assign(mu_z, linkinv_beta_z(eta_z,link_phi, pstream__));
            for (int n = 1; n <= rows(y); ++n) {

                stan::math::assign(get_base1_lhs(ll,n,"ll",1), beta_log(get_base1(y,n,"y",1),(get_base1(mu,n,"mu",1) * get_base1(mu_z,n,"mu_z",1)),((1 - get_base1(mu,n,"mu",1)) * get_base1(mu_z,n,"mu_z",1))));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_beta_z_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
              const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
              const Eigen::Matrix<T2__, Eigen::Dynamic,1>& eta_z,
              const int& link,
              const int& link_phi, std::ostream* pstream__) const {
        return pw_beta_z(y, eta, eta_z, link, link_phi, pstream__);
    }
};

template <typename T2__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T5__>::type, Eigen::Dynamic,1>
test_csr_matrix_times_vector(const int& m,
                                 const int& n,
                                 const Eigen::Matrix<T2__, Eigen::Dynamic,1>& w,
                                 const std::vector<int>& v,
                                 const std::vector<int>& u,
                                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& b, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T5__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(csr_matrix_times_vector(m,n,w,v,u,b));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct test_csr_matrix_times_vector_functor__ {
    template <typename T2__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T5__>::type, Eigen::Dynamic,1>
    operator()(const int& m,
                                 const int& n,
                                 const Eigen::Matrix<T2__, Eigen::Dynamic,1>& w,
                                 const std::vector<int>& v,
                                 const std::vector<int>& u,
                                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& b, std::ostream* pstream__) const {
        return test_csr_matrix_times_vector(m, n, w, v, u, b, pstream__);
    }
};

class model_continuous : public prob_grad {
private:
    int N;
    int K;
    vector_d xbar;
    int dense_X;
    vector<matrix_d> X;
    int nnz_X;
    vector_d w_X;
    vector<int> v_X;
    vector<int> u_X;
    double lb_y;
    double ub_y;
    vector_d y;
    int prior_PD;
    int has_intercept;
    int family;
    int link;
    int prior_dist;
    int prior_dist_for_intercept;
    int prior_dist_for_aux;
    int has_weights;
    vector_d weights;
    int has_offset;
    vector_d offset;
    vector_d prior_scale;
    double prior_scale_for_intercept;
    double prior_scale_for_aux;
    vector_d prior_mean;
    double prior_mean_for_intercept;
    double prior_mean_for_aux;
    vector_d prior_df;
    double prior_df_for_intercept;
    double prior_df_for_aux;
    double global_prior_df;
    double global_prior_scale;
    vector<int> num_normals;
    int t;
    vector<int> p;
    vector<int> l;
    int q;
    int len_theta_L;
    vector_d shape;
    vector_d scale;
    int len_concentration;
    vector<double> concentration;
    int len_regularization;
    vector<double> regularization;
    int num_non_zero;
    vector_d w;
    vector<int> v;
    vector<int> u;
    int special_case;
    int has_intercept_z;
    int link_phi;
    int z_dim;
    matrix_d betareg_z;
    row_vector_d zbar;
    int prior_dist_z;
    int prior_dist_for_intercept_z;
    vector_d prior_scale_z;
    double prior_scale_for_intercept_z;
    vector_d prior_mean_z;
    double prior_mean_for_intercept_z;
    vector_d prior_df_z;
    double prior_df_for_intercept_z;
    double global_prior_scale_z;
    vector<int> num_normals_z;
    vector_d sqrt_y;
    vector_d log_y;
    double sum_log_y;
    vector<vector<int> > V;
    int hs_z;
    int len_z_T;
    int len_var_group;
    int len_rho;
    int is_continuous;
    int pos;
    vector<double> delta;
    int hs;
public:
    model_continuous(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_continuous(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_continuous_namespace::model_continuous";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        validate_non_negative_index("xbar", "K", K);
        xbar = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "xbar", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("xbar");
        pos__ = 0;
        size_t xbar_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < xbar_i_vec_lim__; ++i_vec__) {
            xbar[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "dense_X", "int", context__.to_vec());
        dense_X = int(0);
        vals_i__ = context__.vals_i("dense_X");
        pos__ = 0;
        dense_X = vals_i__[pos__++];
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(dense_X,N,K));
        validate_non_negative_index("X", "dense_X", dense_X);
        validate_non_negative_index("X", "N", N);
        validate_non_negative_index("X", "K", K);
        X = std::vector<matrix_d>(dense_X,matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = N;
        size_t X_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                size_t X_limit_0__ = dense_X;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }
        context__.validate_dims("data initialization", "nnz_X", "int", context__.to_vec());
        nnz_X = int(0);
        vals_i__ = context__.vals_i("nnz_X");
        pos__ = 0;
        nnz_X = vals_i__[pos__++];
        validate_non_negative_index("w_X", "nnz_X", nnz_X);
        w_X = vector_d(static_cast<Eigen::VectorXd::Index>(nnz_X));
        context__.validate_dims("data initialization", "w_X", "vector_d", context__.to_vec(nnz_X));
        vals_r__ = context__.vals_r("w_X");
        pos__ = 0;
        size_t w_X_i_vec_lim__ = nnz_X;
        for (size_t i_vec__ = 0; i_vec__ < w_X_i_vec_lim__; ++i_vec__) {
            w_X[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v_X", "int", context__.to_vec(nnz_X));
        validate_non_negative_index("v_X", "nnz_X", nnz_X);
        v_X = std::vector<int>(nnz_X,int(0));
        vals_i__ = context__.vals_i("v_X");
        pos__ = 0;
        size_t v_X_limit_0__ = nnz_X;
        for (size_t i_0__ = 0; i_0__ < v_X_limit_0__; ++i_0__) {
            v_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u_X", "int", context__.to_vec((dense_X ? 0 : (N + 1) )));
        validate_non_negative_index("u_X", "(dense_X ? 0 : (N + 1) )", (dense_X ? 0 : (N + 1) ));
        u_X = std::vector<int>((dense_X ? 0 : (N + 1) ),int(0));
        vals_i__ = context__.vals_i("u_X");
        pos__ = 0;
        size_t u_X_limit_0__ = (dense_X ? 0 : (N + 1) );
        for (size_t i_0__ = 0; i_0__ < u_X_limit_0__; ++i_0__) {
            u_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "lb_y", "double", context__.to_vec());
        lb_y = double(0);
        vals_r__ = context__.vals_r("lb_y");
        pos__ = 0;
        lb_y = vals_r__[pos__++];
        context__.validate_dims("data initialization", "ub_y", "double", context__.to_vec());
        ub_y = double(0);
        vals_r__ = context__.vals_r("ub_y");
        pos__ = 0;
        ub_y = vals_r__[pos__++];
        validate_non_negative_index("y", "N", N);
        y = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
            y[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
        prior_PD = int(0);
        vals_i__ = context__.vals_i("prior_PD");
        pos__ = 0;
        prior_PD = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
        has_intercept = int(0);
        vals_i__ = context__.vals_i("has_intercept");
        pos__ = 0;
        has_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "family", "int", context__.to_vec());
        family = int(0);
        vals_i__ = context__.vals_i("family");
        pos__ = 0;
        family = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link", "int", context__.to_vec());
        link = int(0);
        vals_i__ = context__.vals_i("link");
        pos__ = 0;
        link = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
        prior_dist = int(0);
        vals_i__ = context__.vals_i("prior_dist");
        pos__ = 0;
        prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec());
        prior_dist_for_intercept = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept");
        pos__ = 0;
        prior_dist_for_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_aux", "int", context__.to_vec());
        prior_dist_for_aux = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_aux");
        pos__ = 0;
        prior_dist_for_aux = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_weights", "int", context__.to_vec());
        has_weights = int(0);
        vals_i__ = context__.vals_i("has_weights");
        pos__ = 0;
        has_weights = vals_i__[pos__++];
        validate_non_negative_index("weights", "(has_weights ? N : 0 )", (has_weights ? N : 0 ));
        weights = vector_d(static_cast<Eigen::VectorXd::Index>((has_weights ? N : 0 )));
        context__.validate_dims("data initialization", "weights", "vector_d", context__.to_vec((has_weights ? N : 0 )));
        vals_r__ = context__.vals_r("weights");
        pos__ = 0;
        size_t weights_i_vec_lim__ = (has_weights ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < weights_i_vec_lim__; ++i_vec__) {
            weights[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec());
        has_offset = int(0);
        vals_i__ = context__.vals_i("has_offset");
        pos__ = 0;
        has_offset = vals_i__[pos__++];
        validate_non_negative_index("offset", "(has_offset ? N : 0 )", (has_offset ? N : 0 ));
        offset = vector_d(static_cast<Eigen::VectorXd::Index>((has_offset ? N : 0 )));
        context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec((has_offset ? N : 0 )));
        vals_r__ = context__.vals_r("offset");
        pos__ = 0;
        size_t offset_i_vec_lim__ = (has_offset ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < offset_i_vec_lim__; ++i_vec__) {
            offset[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("prior_scale", "K", K);
        prior_scale = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_scale", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_scale");
        pos__ = 0;
        size_t prior_scale_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_scale_i_vec_lim__; ++i_vec__) {
            prior_scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_scale_for_intercept", "double", context__.to_vec());
        prior_scale_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_intercept");
        pos__ = 0;
        prior_scale_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_scale_for_aux", "double", context__.to_vec());
        prior_scale_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_aux");
        pos__ = 0;
        prior_scale_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_mean", "K", K);
        prior_mean = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_mean", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_mean");
        pos__ = 0;
        size_t prior_mean_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_mean_i_vec_lim__; ++i_vec__) {
            prior_mean[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_mean_for_intercept", "double", context__.to_vec());
        prior_mean_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_intercept");
        pos__ = 0;
        prior_mean_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_mean_for_aux", "double", context__.to_vec());
        prior_mean_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_aux");
        pos__ = 0;
        prior_mean_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_df", "K", K);
        prior_df = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_df", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_df");
        pos__ = 0;
        size_t prior_df_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_df_i_vec_lim__; ++i_vec__) {
            prior_df[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_df_for_intercept", "double", context__.to_vec());
        prior_df_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_df_for_intercept");
        pos__ = 0;
        prior_df_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_df_for_aux", "double", context__.to_vec());
        prior_df_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_df_for_aux");
        pos__ = 0;
        prior_df_for_aux = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_df", "double", context__.to_vec());
        global_prior_df = double(0);
        vals_r__ = context__.vals_r("global_prior_df");
        pos__ = 0;
        global_prior_df = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_scale", "double", context__.to_vec());
        global_prior_scale = double(0);
        vals_r__ = context__.vals_r("global_prior_scale");
        pos__ = 0;
        global_prior_scale = vals_r__[pos__++];
        context__.validate_dims("data initialization", "num_normals", "int", context__.to_vec((logical_eq(prior_dist,7) ? K : 0 )));
        validate_non_negative_index("num_normals", "(logical_eq(prior_dist,7) ? K : 0 )", (logical_eq(prior_dist,7) ? K : 0 ));
        num_normals = std::vector<int>((logical_eq(prior_dist,7) ? K : 0 ),int(0));
        vals_i__ = context__.vals_i("num_normals");
        pos__ = 0;
        size_t num_normals_limit_0__ = (logical_eq(prior_dist,7) ? K : 0 );
        for (size_t i_0__ = 0; i_0__ < num_normals_limit_0__; ++i_0__) {
            num_normals[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "t", "int", context__.to_vec());
        t = int(0);
        vals_i__ = context__.vals_i("t");
        pos__ = 0;
        t = vals_i__[pos__++];
        context__.validate_dims("data initialization", "p", "int", context__.to_vec(t));
        validate_non_negative_index("p", "t", t);
        p = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("p");
        pos__ = 0;
        size_t p_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < p_limit_0__; ++i_0__) {
            p[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "l", "int", context__.to_vec(t));
        validate_non_negative_index("l", "t", t);
        l = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("l");
        pos__ = 0;
        size_t l_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < l_limit_0__; ++i_0__) {
            l[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "int", context__.to_vec());
        q = int(0);
        vals_i__ = context__.vals_i("q");
        pos__ = 0;
        q = vals_i__[pos__++];
        context__.validate_dims("data initialization", "len_theta_L", "int", context__.to_vec());
        len_theta_L = int(0);
        vals_i__ = context__.vals_i("len_theta_L");
        pos__ = 0;
        len_theta_L = vals_i__[pos__++];
        validate_non_negative_index("shape", "t", t);
        shape = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "shape", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("shape");
        pos__ = 0;
        size_t shape_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < shape_i_vec_lim__; ++i_vec__) {
            shape[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("scale", "t", t);
        scale = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "scale", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("scale");
        pos__ = 0;
        size_t scale_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < scale_i_vec_lim__; ++i_vec__) {
            scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_concentration", "int", context__.to_vec());
        len_concentration = int(0);
        vals_i__ = context__.vals_i("len_concentration");
        pos__ = 0;
        len_concentration = vals_i__[pos__++];
        context__.validate_dims("data initialization", "concentration", "double", context__.to_vec(len_concentration));
        validate_non_negative_index("concentration", "len_concentration", len_concentration);
        concentration = std::vector<double>(len_concentration,double(0));
        vals_r__ = context__.vals_r("concentration");
        pos__ = 0;
        size_t concentration_limit_0__ = len_concentration;
        for (size_t i_0__ = 0; i_0__ < concentration_limit_0__; ++i_0__) {
            concentration[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_regularization", "int", context__.to_vec());
        len_regularization = int(0);
        vals_i__ = context__.vals_i("len_regularization");
        pos__ = 0;
        len_regularization = vals_i__[pos__++];
        context__.validate_dims("data initialization", "regularization", "double", context__.to_vec(len_regularization));
        validate_non_negative_index("regularization", "len_regularization", len_regularization);
        regularization = std::vector<double>(len_regularization,double(0));
        vals_r__ = context__.vals_r("regularization");
        pos__ = 0;
        size_t regularization_limit_0__ = len_regularization;
        for (size_t i_0__ = 0; i_0__ < regularization_limit_0__; ++i_0__) {
            regularization[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "num_non_zero", "int", context__.to_vec());
        num_non_zero = int(0);
        vals_i__ = context__.vals_i("num_non_zero");
        pos__ = 0;
        num_non_zero = vals_i__[pos__++];
        validate_non_negative_index("w", "num_non_zero", num_non_zero);
        w = vector_d(static_cast<Eigen::VectorXd::Index>(num_non_zero));
        context__.validate_dims("data initialization", "w", "vector_d", context__.to_vec(num_non_zero));
        vals_r__ = context__.vals_r("w");
        pos__ = 0;
        size_t w_i_vec_lim__ = num_non_zero;
        for (size_t i_vec__ = 0; i_vec__ < w_i_vec_lim__; ++i_vec__) {
            w[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v", "int", context__.to_vec(num_non_zero));
        validate_non_negative_index("v", "num_non_zero", num_non_zero);
        v = std::vector<int>(num_non_zero,int(0));
        vals_i__ = context__.vals_i("v");
        pos__ = 0;
        size_t v_limit_0__ = num_non_zero;
        for (size_t i_0__ = 0; i_0__ < v_limit_0__; ++i_0__) {
            v[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u", "int", context__.to_vec((logical_gt(t,0) ? (N + 1) : 0 )));
        validate_non_negative_index("u", "(logical_gt(t,0) ? (N + 1) : 0 )", (logical_gt(t,0) ? (N + 1) : 0 ));
        u = std::vector<int>((logical_gt(t,0) ? (N + 1) : 0 ),int(0));
        vals_i__ = context__.vals_i("u");
        pos__ = 0;
        size_t u_limit_0__ = (logical_gt(t,0) ? (N + 1) : 0 );
        for (size_t i_0__ = 0; i_0__ < u_limit_0__; ++i_0__) {
            u[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "special_case", "int", context__.to_vec());
        special_case = int(0);
        vals_i__ = context__.vals_i("special_case");
        pos__ = 0;
        special_case = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_intercept_z", "int", context__.to_vec());
        has_intercept_z = int(0);
        vals_i__ = context__.vals_i("has_intercept_z");
        pos__ = 0;
        has_intercept_z = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link_phi", "int", context__.to_vec());
        link_phi = int(0);
        vals_i__ = context__.vals_i("link_phi");
        pos__ = 0;
        link_phi = vals_i__[pos__++];
        context__.validate_dims("data initialization", "z_dim", "int", context__.to_vec());
        z_dim = int(0);
        vals_i__ = context__.vals_i("z_dim");
        pos__ = 0;
        z_dim = vals_i__[pos__++];
        context__.validate_dims("data initialization", "betareg_z", "matrix_d", context__.to_vec(N,z_dim));
        validate_non_negative_index("betareg_z", "N", N);
        validate_non_negative_index("betareg_z", "z_dim", z_dim);
        betareg_z = matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(z_dim));
        vals_r__ = context__.vals_r("betareg_z");
        pos__ = 0;
        size_t betareg_z_m_mat_lim__ = N;
        size_t betareg_z_n_mat_lim__ = z_dim;
        for (size_t n_mat__ = 0; n_mat__ < betareg_z_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < betareg_z_m_mat_lim__; ++m_mat__) {
                betareg_z(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "zbar", "row_vector_d", context__.to_vec(z_dim));
        validate_non_negative_index("zbar", "z_dim", z_dim);
        zbar = row_vector_d(static_cast<Eigen::VectorXd::Index>(z_dim));
        vals_r__ = context__.vals_r("zbar");
        pos__ = 0;
        size_t zbar_i_vec_lim__ = z_dim;
        for (size_t i_vec__ = 0; i_vec__ < zbar_i_vec_lim__; ++i_vec__) {
            zbar[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_dist_z", "int", context__.to_vec());
        prior_dist_z = int(0);
        vals_i__ = context__.vals_i("prior_dist_z");
        pos__ = 0;
        prior_dist_z = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept_z", "int", context__.to_vec());
        prior_dist_for_intercept_z = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept_z");
        pos__ = 0;
        prior_dist_for_intercept_z = vals_i__[pos__++];
        validate_non_negative_index("prior_scale_z", "z_dim", z_dim);
        prior_scale_z = vector_d(static_cast<Eigen::VectorXd::Index>(z_dim));
        context__.validate_dims("data initialization", "prior_scale_z", "vector_d", context__.to_vec(z_dim));
        vals_r__ = context__.vals_r("prior_scale_z");
        pos__ = 0;
        size_t prior_scale_z_i_vec_lim__ = z_dim;
        for (size_t i_vec__ = 0; i_vec__ < prior_scale_z_i_vec_lim__; ++i_vec__) {
            prior_scale_z[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_scale_for_intercept_z", "double", context__.to_vec());
        prior_scale_for_intercept_z = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_intercept_z");
        pos__ = 0;
        prior_scale_for_intercept_z = vals_r__[pos__++];
        validate_non_negative_index("prior_mean_z", "z_dim", z_dim);
        prior_mean_z = vector_d(static_cast<Eigen::VectorXd::Index>(z_dim));
        context__.validate_dims("data initialization", "prior_mean_z", "vector_d", context__.to_vec(z_dim));
        vals_r__ = context__.vals_r("prior_mean_z");
        pos__ = 0;
        size_t prior_mean_z_i_vec_lim__ = z_dim;
        for (size_t i_vec__ = 0; i_vec__ < prior_mean_z_i_vec_lim__; ++i_vec__) {
            prior_mean_z[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_mean_for_intercept_z", "double", context__.to_vec());
        prior_mean_for_intercept_z = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_intercept_z");
        pos__ = 0;
        prior_mean_for_intercept_z = vals_r__[pos__++];
        validate_non_negative_index("prior_df_z", "z_dim", z_dim);
        prior_df_z = vector_d(static_cast<Eigen::VectorXd::Index>(z_dim));
        context__.validate_dims("data initialization", "prior_df_z", "vector_d", context__.to_vec(z_dim));
        vals_r__ = context__.vals_r("prior_df_z");
        pos__ = 0;
        size_t prior_df_z_i_vec_lim__ = z_dim;
        for (size_t i_vec__ = 0; i_vec__ < prior_df_z_i_vec_lim__; ++i_vec__) {
            prior_df_z[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_df_for_intercept_z", "double", context__.to_vec());
        prior_df_for_intercept_z = double(0);
        vals_r__ = context__.vals_r("prior_df_for_intercept_z");
        pos__ = 0;
        prior_df_for_intercept_z = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_scale_z", "double", context__.to_vec());
        global_prior_scale_z = double(0);
        vals_r__ = context__.vals_r("global_prior_scale_z");
        pos__ = 0;
        global_prior_scale_z = vals_r__[pos__++];
        context__.validate_dims("data initialization", "num_normals_z", "int", context__.to_vec((logical_eq(prior_dist_z,7) ? z_dim : 0 )));
        validate_non_negative_index("num_normals_z", "(logical_eq(prior_dist_z,7) ? z_dim : 0 )", (logical_eq(prior_dist_z,7) ? z_dim : 0 ));
        num_normals_z = std::vector<int>((logical_eq(prior_dist_z,7) ? z_dim : 0 ),int(0));
        vals_i__ = context__.vals_i("num_normals_z");
        pos__ = 0;
        size_t num_normals_z_limit_0__ = (logical_eq(prior_dist_z,7) ? z_dim : 0 );
        for (size_t i_0__ = 0; i_0__ < num_normals_z_limit_0__; ++i_0__) {
            num_normals_z[i_0__] = vals_i__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,0);
        check_greater_or_equal(function__,"K",K,0);
        check_greater_or_equal(function__,"dense_X",dense_X,0);
        check_less_or_equal(function__,"dense_X",dense_X,1);
        check_greater_or_equal(function__,"nnz_X",nnz_X,0);
        for (int k0__ = 0; k0__ < nnz_X; ++k0__) {
            check_greater_or_equal(function__,"v_X[k0__]",v_X[k0__],0);
        }
        for (int k0__ = 0; k0__ < (dense_X ? 0 : (N + 1) ); ++k0__) {
            check_greater_or_equal(function__,"u_X[k0__]",u_X[k0__],0);
        }
        check_greater_or_equal(function__,"ub_y",ub_y,lb_y);
        check_greater_or_equal(function__,"y",y,lb_y);
        check_less_or_equal(function__,"y",y,ub_y);
        check_greater_or_equal(function__,"prior_PD",prior_PD,0);
        check_less_or_equal(function__,"prior_PD",prior_PD,1);
        check_greater_or_equal(function__,"has_intercept",has_intercept,0);
        check_less_or_equal(function__,"has_intercept",has_intercept,1);
        check_greater_or_equal(function__,"family",family,1);
        check_greater_or_equal(function__,"link",link,1);
        check_greater_or_equal(function__,"prior_dist",prior_dist,0);
        check_less_or_equal(function__,"prior_dist",prior_dist,7);
        check_greater_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,0);
        check_less_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,2);
        check_greater_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,0);
        check_less_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,3);
        check_greater_or_equal(function__,"has_weights",has_weights,0);
        check_less_or_equal(function__,"has_weights",has_weights,1);
        check_greater_or_equal(function__,"has_offset",has_offset,0);
        check_less_or_equal(function__,"has_offset",has_offset,1);
        check_greater_or_equal(function__,"prior_scale",prior_scale,0);
        check_greater_or_equal(function__,"prior_scale_for_intercept",prior_scale_for_intercept,0);
        check_greater_or_equal(function__,"prior_scale_for_aux",prior_scale_for_aux,0);
        check_greater_or_equal(function__,"prior_mean_for_aux",prior_mean_for_aux,0);
        check_greater_or_equal(function__,"prior_df",prior_df,0);
        check_greater_or_equal(function__,"prior_df_for_intercept",prior_df_for_intercept,0);
        check_greater_or_equal(function__,"prior_df_for_aux",prior_df_for_aux,0);
        check_greater_or_equal(function__,"global_prior_df",global_prior_df,0);
        check_greater_or_equal(function__,"global_prior_scale",global_prior_scale,0);
        for (int k0__ = 0; k0__ < (logical_eq(prior_dist,7) ? K : 0 ); ++k0__) {
            check_greater_or_equal(function__,"num_normals[k0__]",num_normals[k0__],2);
        }
        check_greater_or_equal(function__,"t",t,0);
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"p[k0__]",p[k0__],1);
        }
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"l[k0__]",l[k0__],1);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_greater_or_equal(function__,"len_theta_L",len_theta_L,0);
        check_greater_or_equal(function__,"shape",shape,0);
        check_greater_or_equal(function__,"scale",scale,0);
        check_greater_or_equal(function__,"len_concentration",len_concentration,0);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"concentration[k0__]",concentration[k0__],0);
        }
        check_greater_or_equal(function__,"len_regularization",len_regularization,0);
        for (int k0__ = 0; k0__ < len_regularization; ++k0__) {
            check_greater_or_equal(function__,"regularization[k0__]",regularization[k0__],0);
        }
        check_greater_or_equal(function__,"num_non_zero",num_non_zero,0);
        for (int k0__ = 0; k0__ < num_non_zero; ++k0__) {
            check_greater_or_equal(function__,"v[k0__]",v[k0__],0);
        }
        for (int k0__ = 0; k0__ < (logical_gt(t,0) ? (N + 1) : 0 ); ++k0__) {
            check_greater_or_equal(function__,"u[k0__]",u[k0__],0);
        }
        check_greater_or_equal(function__,"special_case",special_case,0);
        check_less_or_equal(function__,"special_case",special_case,1);
        check_greater_or_equal(function__,"has_intercept_z",has_intercept_z,0);
        check_less_or_equal(function__,"has_intercept_z",has_intercept_z,1);
        check_greater_or_equal(function__,"link_phi",link_phi,0);
        check_greater_or_equal(function__,"z_dim",z_dim,0);
        check_greater_or_equal(function__,"prior_dist_z",prior_dist_z,0);
        check_less_or_equal(function__,"prior_dist_z",prior_dist_z,7);
        check_greater_or_equal(function__,"prior_dist_for_intercept_z",prior_dist_for_intercept_z,0);
        check_less_or_equal(function__,"prior_dist_for_intercept_z",prior_dist_for_intercept_z,2);
        check_greater_or_equal(function__,"prior_scale_z",prior_scale_z,0);
        check_greater_or_equal(function__,"prior_scale_for_intercept_z",prior_scale_for_intercept_z,0);
        check_greater_or_equal(function__,"prior_df_z",prior_df_z,0);
        check_greater_or_equal(function__,"prior_df_for_intercept_z",prior_df_for_intercept_z,0);
        check_greater_or_equal(function__,"global_prior_scale_z",global_prior_scale_z,0);
        for (int k0__ = 0; k0__ < (logical_eq(prior_dist_z,7) ? z_dim : 0 ); ++k0__) {
            check_greater_or_equal(function__,"num_normals_z[k0__]",num_normals_z[k0__],2);
        }
        // initialize data variables
        validate_non_negative_index("sqrt_y", "(logical_eq(family,3) ? N : 0 )", (logical_eq(family,3) ? N : 0 ));
        sqrt_y = vector_d(static_cast<Eigen::VectorXd::Index>((logical_eq(family,3) ? N : 0 )));
        stan::math::fill(sqrt_y,DUMMY_VAR__);
        validate_non_negative_index("log_y", "(logical_eq(family,3) ? N : 0 )", (logical_eq(family,3) ? N : 0 ));
        log_y = vector_d(static_cast<Eigen::VectorXd::Index>((logical_eq(family,3) ? N : 0 )));
        stan::math::fill(log_y,DUMMY_VAR__);
        sum_log_y = double(0);
        stan::math::fill(sum_log_y,DUMMY_VAR__);
        stan::math::assign(sum_log_y,(logical_eq(family,1) ? stan::math::not_a_number() : sum(log(y)) ));
        validate_non_negative_index("V", "t", t);
        validate_non_negative_index("V", "N", N);
        V = std::vector<std::vector<int> >(t,std::vector<int>(N,int(0)));
        stan::math::fill(V, std::numeric_limits<int>::min());
        stan::math::assign(V,make_V(N,t,v, pstream__));
        hs_z = int(0);
        stan::math::fill(hs_z, std::numeric_limits<int>::min());
        len_z_T = int(0);
        stan::math::fill(len_z_T, std::numeric_limits<int>::min());
        stan::math::assign(len_z_T,0);
        len_var_group = int(0);
        stan::math::fill(len_var_group, std::numeric_limits<int>::min());
        stan::math::assign(len_var_group,(sum(p) * logical_gt(t,0)));
        len_rho = int(0);
        stan::math::fill(len_rho, std::numeric_limits<int>::min());
        stan::math::assign(len_rho,(sum(p) - t));
        is_continuous = int(0);
        stan::math::fill(is_continuous, std::numeric_limits<int>::min());
        stan::math::assign(is_continuous,0);
        pos = int(0);
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        validate_non_negative_index("delta", "len_concentration", len_concentration);
        delta = std::vector<double>(len_concentration,double(0));
        stan::math::fill(delta,DUMMY_VAR__);
        hs = int(0);
        stan::math::fill(hs, std::numeric_limits<int>::min());

        try {
            if (as_bool(logical_lte(prior_dist,2))) {
                stan::math::assign(hs, 0);
            } else if (as_bool(logical_eq(prior_dist,3))) {
                stan::math::assign(hs, 2);
            } else if (as_bool(logical_eq(prior_dist,4))) {
                stan::math::assign(hs, 4);
            } else {
                stan::math::assign(hs, 0);
            }
            stan::math::assign(len_z_T, 0);
            stan::math::assign(len_var_group, (sum(p) * logical_gt(t,0)));
            stan::math::assign(len_rho, (sum(p) - t));
            stan::math::assign(pos, 1);
            for (int i = 1; i <= t; ++i) {

                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {

                    for (int j = 1; j <= get_base1(p,i,"p",1); ++j) {

                        stan::math::assign(get_base1_lhs(delta,pos,"delta",1), get_base1(concentration,j,"concentration",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
                for (int j = 3; j <= get_base1(p,i,"p",1); ++j) {
                    stan::math::assign(len_z_T, ((len_z_T + get_base1(p,i,"p",1)) - 1));
                }
            }
            if (as_bool(logical_lte(prior_dist_z,2))) {
                stan::math::assign(hs_z, 0);
            } else if (as_bool(logical_eq(prior_dist_z,3))) {
                stan::math::assign(hs_z, 2);
            } else if (as_bool(logical_eq(prior_dist_z,4))) {
                stan::math::assign(hs_z, 4);
            } else {
                stan::math::assign(hs_z, 0);
            }
            stan::math::assign(is_continuous, 1);
            if (as_bool(logical_eq(family,3))) {

                stan::math::assign(sqrt_y, sqrt(y));
                stan::math::assign(log_y, log(y));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        for (int k0__ = 0; k0__ < t; ++k0__) {
            for (int k1__ = 0; k1__ < N; ++k1__) {
                check_greater_or_equal(function__,"V[k0__][k1__]",V[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"hs_z",hs_z,0);
        check_greater_or_equal(function__,"len_z_T",len_z_T,0);
        check_greater_or_equal(function__,"len_var_group",len_var_group,0);
        check_greater_or_equal(function__,"len_rho",len_rho,0);
        check_greater_or_equal(function__,"is_continuous",is_continuous,0);
        check_less_or_equal(function__,"is_continuous",is_continuous,1);
        check_greater_or_equal(function__,"pos",pos,1);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"delta[k0__]",delta[k0__],0);
        }
        check_greater_or_equal(function__,"hs",hs,0);

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += has_intercept;
        num_params_r__ += (logical_eq(prior_dist,7) ? sum(num_normals) : K );
        num_params_r__ += hs;
        num_params_r__ += K * hs;
        num_params_r__ += K * (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        num_params_r__ += logical_eq(prior_dist,6);
        num_params_r__ += q;
        num_params_r__ += len_z_T;
        num_params_r__ += len_rho;
        num_params_r__ += len_concentration;
        num_params_r__ += t;
        ++num_params_r__;
        num_params_r__ += (logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim );
        num_params_r__ += has_intercept_z;
        num_params_r__ += hs_z;
        num_params_r__ += z_dim * hs_z;
        num_params_r__ += z_dim * (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6)));
        num_params_r__ += logical_eq(prior_dist_z,6);
    }

    ~model_continuous() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("gamma")))
            throw std::runtime_error("variable gamma missing");
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma", "double", context__.to_vec(has_intercept));
        // generate_declaration gamma
        std::vector<double> gamma(has_intercept,double(0));
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            gamma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(((primitive_value((primitive_value(logical_eq(family,1)) || primitive_value(logical_eq(link,2)))) || primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))))) ? stan::math::negative_infinity() : 0.0 ),((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))) ? 0.0 : stan::math::positive_infinity() ),gamma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma: ") + e.what());
        }

        if (!(context__.contains_r("z_beta")))
            throw std::runtime_error("variable z_beta missing");
        vals_r__ = context__.vals_r("z_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_beta", "vector_d", context__.to_vec((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        // generate_declaration z_beta
        vector_d z_beta(static_cast<Eigen::VectorXd::Index>((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        for (int j1__ = 0U; j1__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++j1__)
            z_beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_beta: ") + e.what());
        }

        if (!(context__.contains_r("global")))
            throw std::runtime_error("variable global missing");
        vals_r__ = context__.vals_r("global");
        pos__ = 0U;
        context__.validate_dims("initialization", "global", "double", context__.to_vec(hs));
        // generate_declaration global
        std::vector<double> global(hs,double(0));
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            global[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,global[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable global: ") + e.what());
        }

        if (!(context__.contains_r("local")))
            throw std::runtime_error("variable local missing");
        vals_r__ = context__.vals_r("local");
        pos__ = 0U;
        context__.validate_dims("initialization", "local", "vector_d", context__.to_vec(hs,K));
        // generate_declaration local
        std::vector<vector_d> local(hs,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < hs; ++i0__)
                local[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,local[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable local: ") + e.what());
        }

        if (!(context__.contains_r("S")))
            throw std::runtime_error("variable S missing");
        vals_r__ = context__.vals_r("S");
        pos__ = 0U;
        context__.validate_dims("initialization", "S", "vector_d", context__.to_vec((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),K));
        // generate_declaration S
        std::vector<vector_d> S((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
                S[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,S[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable S: ") + e.what());
        }

        if (!(context__.contains_r("one_over_lambda")))
            throw std::runtime_error("variable one_over_lambda missing");
        vals_r__ = context__.vals_r("one_over_lambda");
        pos__ = 0U;
        context__.validate_dims("initialization", "one_over_lambda", "double", context__.to_vec(logical_eq(prior_dist,6)));
        // generate_declaration one_over_lambda
        std::vector<double> one_over_lambda(logical_eq(prior_dist,6),double(0));
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            one_over_lambda[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,one_over_lambda[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable one_over_lambda: ") + e.what());
        }

        if (!(context__.contains_r("z_b")))
            throw std::runtime_error("variable z_b missing");
        vals_r__ = context__.vals_r("z_b");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_b", "vector_d", context__.to_vec(q));
        // generate_declaration z_b
        vector_d z_b(static_cast<Eigen::VectorXd::Index>(q));
        for (int j1__ = 0U; j1__ < q; ++j1__)
            z_b(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_b: ") + e.what());
        }

        if (!(context__.contains_r("z_T")))
            throw std::runtime_error("variable z_T missing");
        vals_r__ = context__.vals_r("z_T");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_T", "vector_d", context__.to_vec(len_z_T));
        // generate_declaration z_T
        vector_d z_T(static_cast<Eigen::VectorXd::Index>(len_z_T));
        for (int j1__ = 0U; j1__ < len_z_T; ++j1__)
            z_T(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_T);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_T: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho", "vector_d", context__.to_vec(len_rho));
        // generate_declaration rho
        vector_d rho(static_cast<Eigen::VectorXd::Index>(len_rho));
        for (int j1__ = 0U; j1__ < len_rho; ++j1__)
            rho(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        if (!(context__.contains_r("zeta")))
            throw std::runtime_error("variable zeta missing");
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "zeta", "vector_d", context__.to_vec(len_concentration));
        // generate_declaration zeta
        vector_d zeta(static_cast<Eigen::VectorXd::Index>(len_concentration));
        for (int j1__ = 0U; j1__ < len_concentration; ++j1__)
            zeta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,zeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zeta: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "vector_d", context__.to_vec(t));
        // generate_declaration tau
        vector_d tau(static_cast<Eigen::VectorXd::Index>(t));
        for (int j1__ = 0U; j1__ < t; ++j1__)
            tau(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("aux_unscaled")))
            throw std::runtime_error("variable aux_unscaled missing");
        vals_r__ = context__.vals_r("aux_unscaled");
        pos__ = 0U;
        context__.validate_dims("initialization", "aux_unscaled", "double", context__.to_vec());
        // generate_declaration aux_unscaled
        double aux_unscaled(0);
        aux_unscaled = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,aux_unscaled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable aux_unscaled: ") + e.what());
        }

        if (!(context__.contains_r("z_omega")))
            throw std::runtime_error("variable z_omega missing");
        vals_r__ = context__.vals_r("z_omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_omega", "vector_d", context__.to_vec((logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim )));
        // generate_declaration z_omega
        vector_d z_omega(static_cast<Eigen::VectorXd::Index>((logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim )));
        for (int j1__ = 0U; j1__ < (logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ); ++j1__)
            z_omega(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_omega: ") + e.what());
        }

        if (!(context__.contains_r("gamma_z")))
            throw std::runtime_error("variable gamma_z missing");
        vals_r__ = context__.vals_r("gamma_z");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma_z", "double", context__.to_vec(has_intercept_z));
        // generate_declaration gamma_z
        std::vector<double> gamma_z(has_intercept_z,double(0));
        for (int i0__ = 0U; i0__ < has_intercept_z; ++i0__)
            gamma_z[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < has_intercept_z; ++i0__)
            try {
            writer__.scalar_unconstrain(gamma_z[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma_z: ") + e.what());
        }

        if (!(context__.contains_r("global_z")))
            throw std::runtime_error("variable global_z missing");
        vals_r__ = context__.vals_r("global_z");
        pos__ = 0U;
        context__.validate_dims("initialization", "global_z", "double", context__.to_vec(hs_z));
        // generate_declaration global_z
        std::vector<double> global_z(hs_z,double(0));
        for (int i0__ = 0U; i0__ < hs_z; ++i0__)
            global_z[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs_z; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,global_z[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable global_z: ") + e.what());
        }

        if (!(context__.contains_r("local_z")))
            throw std::runtime_error("variable local_z missing");
        vals_r__ = context__.vals_r("local_z");
        pos__ = 0U;
        context__.validate_dims("initialization", "local_z", "vector_d", context__.to_vec(hs_z,z_dim));
        // generate_declaration local_z
        std::vector<vector_d> local_z(hs_z,vector_d(static_cast<Eigen::VectorXd::Index>(z_dim)));
        for (int j1__ = 0U; j1__ < z_dim; ++j1__)
            for (int i0__ = 0U; i0__ < hs_z; ++i0__)
                local_z[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs_z; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,local_z[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable local_z: ") + e.what());
        }

        if (!(context__.contains_r("S_z")))
            throw std::runtime_error("variable S_z missing");
        vals_r__ = context__.vals_r("S_z");
        pos__ = 0U;
        context__.validate_dims("initialization", "S_z", "vector_d", context__.to_vec((primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))),z_dim));
        // generate_declaration S_z
        std::vector<vector_d> S_z((primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))),vector_d(static_cast<Eigen::VectorXd::Index>(z_dim)));
        for (int j1__ = 0U; j1__ < z_dim; ++j1__)
            for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))); ++i0__)
                S_z[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))); ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,S_z[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable S_z: ") + e.what());
        }

        if (!(context__.contains_r("one_over_lambda_z")))
            throw std::runtime_error("variable one_over_lambda_z missing");
        vals_r__ = context__.vals_r("one_over_lambda_z");
        pos__ = 0U;
        context__.validate_dims("initialization", "one_over_lambda_z", "double", context__.to_vec(logical_eq(prior_dist_z,6)));
        // generate_declaration one_over_lambda_z
        std::vector<double> one_over_lambda_z(logical_eq(prior_dist_z,6),double(0));
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist_z,6); ++i0__)
            one_over_lambda_z[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist_z,6); ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,one_over_lambda_z[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable one_over_lambda_z: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<T__> gamma;
        size_t dim_gamma_0__ = has_intercept;
        gamma.reserve(dim_gamma_0__);
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            if (jacobian__)
                gamma.push_back(in__.scalar_lub_constrain(((primitive_value((primitive_value(logical_eq(family,1)) || primitive_value(logical_eq(link,2)))) || primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))))) ? stan::math::negative_infinity() : 0.0 ),((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))) ? 0.0 : stan::math::positive_infinity() ),lp__));
            else
                gamma.push_back(in__.scalar_lub_constrain(((primitive_value((primitive_value(logical_eq(family,1)) || primitive_value(logical_eq(link,2)))) || primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))))) ? stan::math::negative_infinity() : 0.0 ),((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))) ? 0.0 : stan::math::positive_infinity() )));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_beta;
        (void) z_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ),lp__);
        else
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));

        vector<T__> global;
        size_t dim_global_0__ = hs;
        global.reserve(dim_global_0__);
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            if (jacobian__)
                global.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                global.push_back(in__.scalar_lb_constrain(0));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > local;
        size_t dim_local_0__ = hs;
        local.reserve(dim_local_0__);
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            if (jacobian__)
                local.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                local.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        S.reserve(dim_S_0__);
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            if (jacobian__)
                S.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                S.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<T__> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        one_over_lambda.reserve(dim_one_over_lambda_0__);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            if (jacobian__)
                one_over_lambda.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_b;
        (void) z_b;  // dummy to suppress unused var warning
        if (jacobian__)
            z_b = in__.vector_constrain(q,lp__);
        else
            z_b = in__.vector_constrain(q);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_T;
        (void) z_T;  // dummy to suppress unused var warning
        if (jacobian__)
            z_T = in__.vector_constrain(len_z_T,lp__);
        else
            z_T = in__.vector_constrain(len_z_T);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho;
        (void) rho;  // dummy to suppress unused var warning
        if (jacobian__)
            rho = in__.vector_lub_constrain(0,1,len_rho,lp__);
        else
            rho = in__.vector_lub_constrain(0,1,len_rho);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  zeta;
        (void) zeta;  // dummy to suppress unused var warning
        if (jacobian__)
            zeta = in__.vector_lb_constrain(0,len_concentration,lp__);
        else
            zeta = in__.vector_lb_constrain(0,len_concentration);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.vector_lb_constrain(0,t,lp__);
        else
            tau = in__.vector_lb_constrain(0,t);

        T__ aux_unscaled;
        (void) aux_unscaled;  // dummy to suppress unused var warning
        if (jacobian__)
            aux_unscaled = in__.scalar_lb_constrain(0,lp__);
        else
            aux_unscaled = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_omega;
        (void) z_omega;  // dummy to suppress unused var warning
        if (jacobian__)
            z_omega = in__.vector_constrain((logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ),lp__);
        else
            z_omega = in__.vector_constrain((logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ));

        vector<T__> gamma_z;
        size_t dim_gamma_z_0__ = has_intercept_z;
        gamma_z.reserve(dim_gamma_z_0__);
        for (size_t k_0__ = 0; k_0__ < dim_gamma_z_0__; ++k_0__) {
            if (jacobian__)
                gamma_z.push_back(in__.scalar_constrain(lp__));
            else
                gamma_z.push_back(in__.scalar_constrain());
        }

        vector<T__> global_z;
        size_t dim_global_z_0__ = hs_z;
        global_z.reserve(dim_global_z_0__);
        for (size_t k_0__ = 0; k_0__ < dim_global_z_0__; ++k_0__) {
            if (jacobian__)
                global_z.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                global_z.push_back(in__.scalar_lb_constrain(0));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > local_z;
        size_t dim_local_z_0__ = hs_z;
        local_z.reserve(dim_local_z_0__);
        for (size_t k_0__ = 0; k_0__ < dim_local_z_0__; ++k_0__) {
            if (jacobian__)
                local_z.push_back(in__.vector_lb_constrain(0,z_dim,lp__));
            else
                local_z.push_back(in__.vector_lb_constrain(0,z_dim));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > S_z;
        size_t dim_S_z_0__ = (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6)));
        S_z.reserve(dim_S_z_0__);
        for (size_t k_0__ = 0; k_0__ < dim_S_z_0__; ++k_0__) {
            if (jacobian__)
                S_z.push_back(in__.vector_lb_constrain(0,z_dim,lp__));
            else
                S_z.push_back(in__.vector_lb_constrain(0,z_dim));
        }

        vector<T__> one_over_lambda_z;
        size_t dim_one_over_lambda_z_0__ = logical_eq(prior_dist_z,6);
        one_over_lambda_z.reserve(dim_one_over_lambda_z_0__);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_z_0__; ++k_0__) {
            if (jacobian__)
                one_over_lambda_z.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                one_over_lambda_z.push_back(in__.scalar_lb_constrain(0));
        }


        // transformed parameters
        T__ aux;
        (void) aux;  // dummy to suppress unused var warning
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux,DUMMY_VAR__);
        stan::math::assign(aux,(logical_eq(prior_dist_for_aux,0) ? stan::math::promote_scalar<T__>(aux_unscaled) : stan::math::promote_scalar<T__>((logical_lte(prior_dist_for_aux,2) ? stan::math::promote_scalar<T__>(((prior_scale_for_aux * aux_unscaled) + prior_mean_for_aux)) : stan::math::promote_scalar<T__>((prior_scale_for_aux * aux_unscaled)) )) ));
        Eigen::Matrix<T__,Eigen::Dynamic,1>  omega(static_cast<Eigen::VectorXd::Index>(z_dim));
        (void) omega;  // dummy to suppress unused var warning
        stan::math::initialize(omega, DUMMY_VAR__);
        stan::math::fill(omega,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, DUMMY_VAR__);
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool(logical_eq(prior_dist_z,0))) {
                stan::math::assign(omega, z_omega);
            } else if (as_bool(logical_eq(prior_dist_z,1))) {
                stan::math::assign(omega, add(elt_multiply(z_omega,prior_scale_z),prior_mean_z));
            } else if (as_bool(logical_eq(prior_dist_z,2))) {
                for (int k = 1; k <= z_dim; ++k) {

                    stan::math::assign(get_base1_lhs(omega,k,"omega",1), ((CFt(get_base1(omega,k,"omega",1),get_base1(prior_df_z,k,"prior_df_z",1), pstream__) * get_base1(prior_scale_z,k,"prior_scale_z",1)) + get_base1(prior_mean_z,k,"prior_mean_z",1)));
                }
            } else if (as_bool(logical_eq(prior_dist_z,3))) {
                stan::math::assign(omega, hs_prior(z_omega,global_z,local_z,global_prior_scale,1, pstream__));
            } else if (as_bool(logical_eq(prior_dist_z,4))) {
                stan::math::assign(omega, hsplus_prior(z_omega,global_z,local_z,global_prior_scale,1, pstream__));
            } else if (as_bool(logical_eq(prior_dist_z,5))) {
                stan::math::assign(omega, add(prior_mean_z,elt_multiply(elt_multiply(prior_scale_z,sqrt(multiply(2,get_base1(S_z,1,"S_z",1)))),z_omega)));
            } else if (as_bool(logical_eq(prior_dist_z,6))) {
                stan::math::assign(omega, add(prior_mean_z,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda_z,1,"one_over_lambda_z",1),prior_scale_z),sqrt(multiply(2,get_base1(S_z,1,"S_z",1)))),z_omega)));
            } else if (as_bool(logical_eq(prior_dist_z,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= z_dim; ++k) {

                        stan::math::assign(get_base1_lhs(omega,k,"omega",1), get_base1(z_omega,z_pos,"z_omega",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals_z,k,"num_normals_z",1); ++n) {

                            stan::math::assign(get_base1_lhs(omega,k,"omega",1), (get_base1(omega,k,"omega",1) * get_base1(z_omega,z_pos,"z_omega",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(omega,k,"omega",1), ((get_base1(omega,k,"omega",1) * pow(get_base1(prior_scale_z,k,"prior_scale_z",1),get_base1(num_normals_z,k,"num_normals_z",1))) + get_base1(prior_mean_z,k,"prior_mean_z",1)));
                    }
                }
            }
            if (as_bool(logical_eq(prior_dist_for_aux,0))) {
                stan::math::assign(aux, aux_unscaled);
            } else {

                stan::math::assign(aux, (prior_scale_for_aux * aux_unscaled));
                if (as_bool(logical_lte(prior_dist_for_aux,2))) {
                    stan::math::assign(aux, (aux + prior_mean_for_aux));
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(logical_eq(special_case,1))) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, multiply(tau,aux));
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(theta_L,1,"theta_L",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(theta_L,i,"theta_L",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    stan::math::assign(theta_L, make_theta_L(len_theta_L,p,aux,tau,scale,zeta,rho,z_T, pstream__));
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(aux)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: aux";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < z_dim; ++i0__) {
            if (stan::math::is_uninitialized(omega(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: omega" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < q; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < len_theta_L; ++i0__) {
            if (stan::math::is_uninitialized(theta_L(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: theta_L" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta_z(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta_z;  // dummy to suppress unused var warning
                stan::math::initialize(eta_z, DUMMY_VAR__);
                stan::math::fill(eta_z,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, DUMMY_VAR__);
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                if (as_bool(logical_gt(t,0))) {

                    if (as_bool(special_case)) {
                        for (int i = 1; i <= t; ++i) {
                            stan::math::assign(eta, add(eta,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V,i,"V",1)), stan::model::nil_index_list()), "b")));
                        }
                    } else {
                        stan::math::assign(eta, add(eta,csr_matrix_times_vector(N,q,w,v,u,b)));
                    }
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool((primitive_value((primitive_value(logical_eq(family,1)) || primitive_value(logical_eq(link,2)))) || primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_neq(link,5))))))) {
                        stan::math::assign(eta, add(eta,get_base1(gamma,1,"gamma",1)));
                    } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))))) {
                        stan::math::assign(eta, add(subtract(eta,max(eta)),get_base1(gamma,1,"gamma",1)));
                    } else {
                        stan::math::assign(eta, add(subtract(eta,min(eta)),get_base1(gamma,1,"gamma",1)));
                    }
                } else {

                    stan::math::assign(eta, add(eta,dot_product(xbar,beta)));
                }
                if (as_bool((primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_gt(z_dim,0)))) && primitive_value(logical_gt(link_phi,0))))) {

                    stan::math::assign(eta_z, multiply(betareg_z,omega));
                } else if (as_bool((primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(z_dim,0)))) && primitive_value(logical_eq(has_intercept_z,1))))) {

                    stan::math::assign(eta_z, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_intercept_z,1))) {

                    if (as_bool(logical_gt(link_phi,1))) {

                        stan::math::assign(eta_z, add(subtract(eta_z,min(eta_z)),get_base1(gamma_z,1,"gamma_z",1)));
                    } else {

                        stan::math::assign(eta_z, add(eta_z,get_base1(gamma_z,1,"gamma_z",1)));
                    }
                } else {

                    if (as_bool(logical_gt(link_phi,1))) {

                        stan::math::assign(eta_z, add(subtract(eta_z,min(eta_z)),dot_product(zbar,omega)));
                    } else {

                        stan::math::assign(eta_z, add(eta_z,dot_product(zbar,omega)));
                    }
                }
                if (as_bool((primitive_value(logical_eq(has_weights,0)) && primitive_value(logical_eq(prior_PD,0))))) {

                    if (as_bool(logical_eq(family,1))) {

                        if (as_bool(logical_eq(link,1))) {
                            lp_accum__.add(normal_log(y,eta,aux));
                        } else if (as_bool(logical_eq(link,2))) {
                            lp_accum__.add(normal_log(y,exp(eta),aux));
                        } else {
                            lp_accum__.add(normal_log(y,divide_real_by_vector(1,eta, pstream__),aux));
                        }
                    } else if (as_bool(logical_eq(family,2))) {

                        lp_accum__.add(GammaReg(y,eta,aux,link,sum_log_y, pstream__));
                    } else if (as_bool(logical_eq(family,3))) {

                        lp_accum__.add(inv_gaussian(y,linkinv_inv_gaussian(eta,link, pstream__),aux,sum_log_y,sqrt_y, pstream__));
                    } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link_phi,0))))) {
                        {
                            Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(N));
                            (void) mu;  // dummy to suppress unused var warning
                            stan::math::initialize(mu, DUMMY_VAR__);
                            stan::math::fill(mu,DUMMY_VAR__);


                            stan::math::assign(mu, linkinv_beta(eta,link, pstream__));
                            lp_accum__.add(beta_log(y,multiply(mu,aux),multiply(subtract(1,mu),aux)));
                        }
                    } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_gt(link_phi,0))))) {
                        {
                            Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(N));
                            (void) mu;  // dummy to suppress unused var warning
                            stan::math::initialize(mu, DUMMY_VAR__);
                            stan::math::fill(mu,DUMMY_VAR__);
                            Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_z(static_cast<Eigen::VectorXd::Index>(N));
                            (void) mu_z;  // dummy to suppress unused var warning
                            stan::math::initialize(mu_z, DUMMY_VAR__);
                            stan::math::fill(mu_z,DUMMY_VAR__);


                            stan::math::assign(mu, linkinv_beta(eta,link, pstream__));
                            stan::math::assign(mu_z, linkinv_beta_z(eta_z,link_phi, pstream__));
                            lp_accum__.add(beta_log(y,rows_dot_product(mu,mu_z),rows_dot_product(subtract(1,mu),mu_z)));
                        }
                    }
                } else if (as_bool(logical_eq(prior_PD,0))) {
                    {
                        Eigen::Matrix<T__,Eigen::Dynamic,1>  summands(static_cast<Eigen::VectorXd::Index>(N));
                        (void) summands;  // dummy to suppress unused var warning
                        stan::math::initialize(summands, DUMMY_VAR__);
                        stan::math::fill(summands,DUMMY_VAR__);


                        if (as_bool(logical_eq(family,1))) {
                            stan::math::assign(summands, pw_gauss(y,eta,aux,link, pstream__));
                        } else if (as_bool(logical_eq(family,2))) {
                            stan::math::assign(summands, pw_gamma(y,eta,aux,link, pstream__));
                        } else if (as_bool(logical_eq(family,3))) {
                            stan::math::assign(summands, pw_inv_gaussian(y,eta,aux,link,log_y,sqrt_y, pstream__));
                        } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link_phi,0))))) {
                            stan::math::assign(summands, pw_beta(y,eta,aux,link, pstream__));
                        } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_gt(link_phi,0))))) {
                            stan::math::assign(summands, pw_beta_z(y,eta,eta_z,link,link_phi, pstream__));
                        }
                        lp_accum__.add(dot_product(weights,summands));
                    }
                }
                if (as_bool((primitive_value(logical_gt(prior_dist_for_aux,0)) && primitive_value(logical_gt(prior_scale_for_aux,0))))) {

                    if (as_bool(logical_eq(prior_dist_for_aux,1))) {
                        lp_accum__.add(normal_log(aux_unscaled,0,1));
                    } else if (as_bool(logical_eq(prior_dist_for_aux,2))) {
                        lp_accum__.add(student_t_log(aux_unscaled,prior_df_for_aux,0,1));
                    } else {
                        lp_accum__.add(exponential_log(aux_unscaled,1));
                    }
                }
                if (as_bool(logical_eq(prior_dist,1))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,2))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,3))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,4))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(local,3,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,4,"local",1),multiply(0.5,prior_scale),multiply(0.5,prior_scale)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,5))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                } else if (as_bool(logical_eq(prior_dist,6))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                    lp_accum__.add(chi_square_log(get_base1(one_over_lambda,1,"one_over_lambda",1),get_base1(prior_df,1,"prior_df",1)));
                } else if (as_bool(logical_eq(prior_dist,7))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_eq(prior_dist_for_intercept,1))) {
                        lp_accum__.add(normal_log(gamma,prior_mean_for_intercept,prior_scale_for_intercept));
                    } else if (as_bool(logical_eq(prior_dist_for_intercept,2))) {
                        lp_accum__.add(student_t_log(gamma,prior_df_for_intercept,prior_mean_for_intercept,prior_scale_for_intercept));
                    }
                }
                if (as_bool(logical_eq(prior_dist_z,1))) {
                    lp_accum__.add(normal_log(z_omega,0,1));
                } else if (as_bool(logical_eq(prior_dist_z,2))) {
                    lp_accum__.add(normal_log(z_omega,0,1));
                } else if (as_bool(logical_eq(prior_dist_z,3))) {

                    lp_accum__.add(normal_log(z_omega,0,1));
                    lp_accum__.add(normal_log(get_base1(local_z,1,"local_z",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local_z,2,"local_z",1),multiply(0.5,prior_df_z),multiply(0.5,prior_df_z)));
                    lp_accum__.add(normal_log(get_base1(global_z,1,"global_z",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global_z,2,"global_z",1),0.5,0.5));
                } else if (as_bool(logical_eq(prior_dist_z,4))) {

                    lp_accum__.add(normal_log(z_omega,0,1));
                    lp_accum__.add(normal_log(get_base1(local_z,1,"local_z",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local_z,2,"local_z",1),multiply(0.5,prior_df_z),multiply(0.5,prior_df_z)));
                    lp_accum__.add(normal_log(get_base1(local_z,3,"local_z",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local_z,4,"local_z",1),multiply(0.5,prior_scale_z),multiply(0.5,prior_scale_z)));
                    lp_accum__.add(normal_log(get_base1(global_z,1,"global_z",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global_z,2,"global_z",1),0.5,0.5));
                } else if (as_bool(logical_eq(prior_dist_z,5))) {

                    lp_accum__.add(normal_log(z_omega,0,1));
                    lp_accum__.add(exponential_log(get_base1(S_z,1,"S_z",1),1));
                } else if (as_bool(logical_eq(prior_dist_z,6))) {

                    lp_accum__.add(normal_log(z_omega,0,1));
                    lp_accum__.add(exponential_log(get_base1(S_z,1,"S_z",1),1));
                    lp_accum__.add(chi_square_log(get_base1(one_over_lambda_z,1,"one_over_lambda_z",1),get_base1(prior_df_z,1,"prior_df_z",1)));
                } else if (as_bool(logical_eq(prior_dist_z,7))) {

                    lp_accum__.add(normal_log(z_omega,0,1));
                }
                if (as_bool(logical_eq(has_intercept_z,1))) {

                    if (as_bool(logical_eq(prior_dist_for_intercept_z,1))) {
                        lp_accum__.add(normal_log(gamma_z,prior_mean_for_intercept_z,prior_scale_for_intercept_z));
                    } else if (as_bool(logical_eq(prior_dist_for_intercept_z,2))) {
                        lp_accum__.add(student_t_log(gamma_z,prior_df_for_intercept_z,prior_mean_for_intercept_z,prior_scale_for_intercept_z));
                    }
                }
                if (as_bool(logical_gt(t,0))) {
                    decov_lp(z_b,z_T,rho,zeta,tau,regularization,delta,shape,t,p, lp__, lp_accum__, pstream__);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("z_beta");
        names__.push_back("global");
        names__.push_back("local");
        names__.push_back("S");
        names__.push_back("one_over_lambda");
        names__.push_back("z_b");
        names__.push_back("z_T");
        names__.push_back("rho");
        names__.push_back("zeta");
        names__.push_back("tau");
        names__.push_back("aux_unscaled");
        names__.push_back("z_omega");
        names__.push_back("gamma_z");
        names__.push_back("global_z");
        names__.push_back("local_z");
        names__.push_back("S_z");
        names__.push_back("one_over_lambda_z");
        names__.push_back("aux");
        names__.push_back("omega");
        names__.push_back("beta");
        names__.push_back("b");
        names__.push_back("theta_L");
        names__.push_back("alpha");
        names__.push_back("omega_int");
        names__.push_back("mean_PPD");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))));
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(prior_dist,6));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_z_T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_rho);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_concentration);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept_z);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs_z);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs_z);
        dims__.push_back(z_dim);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))));
        dims__.push_back(z_dim);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(prior_dist_z,6));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(z_dim);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_theta_L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept_z);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_continuous_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector<double> gamma;
        size_t dim_gamma_0__ = has_intercept;
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            gamma.push_back(in__.scalar_lub_constrain(((primitive_value((primitive_value(logical_eq(family,1)) || primitive_value(logical_eq(link,2)))) || primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))))) ? stan::math::negative_infinity() : 0.0 ),((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))) ? 0.0 : stan::math::positive_infinity() )));
        }
        vector_d z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        vector<double> global;
        size_t dim_global_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            global.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> local;
        size_t dim_local_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            local.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<vector_d> S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            S.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<double> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }
        vector_d z_b = in__.vector_constrain(q);
        vector_d z_T = in__.vector_constrain(len_z_T);
        vector_d rho = in__.vector_lub_constrain(0,1,len_rho);
        vector_d zeta = in__.vector_lb_constrain(0,len_concentration);
        vector_d tau = in__.vector_lb_constrain(0,t);
        double aux_unscaled = in__.scalar_lb_constrain(0);
        vector_d z_omega = in__.vector_constrain((logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ));
        vector<double> gamma_z;
        size_t dim_gamma_z_0__ = has_intercept_z;
        for (size_t k_0__ = 0; k_0__ < dim_gamma_z_0__; ++k_0__) {
            gamma_z.push_back(in__.scalar_constrain());
        }
        vector<double> global_z;
        size_t dim_global_z_0__ = hs_z;
        for (size_t k_0__ = 0; k_0__ < dim_global_z_0__; ++k_0__) {
            global_z.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> local_z;
        size_t dim_local_z_0__ = hs_z;
        for (size_t k_0__ = 0; k_0__ < dim_local_z_0__; ++k_0__) {
            local_z.push_back(in__.vector_lb_constrain(0,z_dim));
        }
        vector<vector_d> S_z;
        size_t dim_S_z_0__ = (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6)));
        for (size_t k_0__ = 0; k_0__ < dim_S_z_0__; ++k_0__) {
            S_z.push_back(in__.vector_lb_constrain(0,z_dim));
        }
        vector<double> one_over_lambda_z;
        size_t dim_one_over_lambda_z_0__ = logical_eq(prior_dist_z,6);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_z_0__; ++k_0__) {
            one_over_lambda_z.push_back(in__.scalar_lb_constrain(0));
        }
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            vars__.push_back(z_beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
            vars__.push_back(global[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
                vars__.push_back(local[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                vars__.push_back(S[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < logical_eq(prior_dist,6); ++k_0__) {
            vars__.push_back(one_over_lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(z_b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_z_T; ++k_0__) {
            vars__.push_back(z_T[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_rho; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_concentration; ++k_0__) {
            vars__.push_back(zeta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < t; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }
        vars__.push_back(aux_unscaled);
        for (int k_0__ = 0; k_0__ < (logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ); ++k_0__) {
            vars__.push_back(z_omega[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < has_intercept_z; ++k_0__) {
            vars__.push_back(gamma_z[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < hs_z; ++k_0__) {
            vars__.push_back(global_z[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < z_dim; ++k_1__) {
            for (int k_0__ = 0; k_0__ < hs_z; ++k_0__) {
                vars__.push_back(local_z[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < z_dim; ++k_1__) {
            for (int k_0__ = 0; k_0__ < (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))); ++k_0__) {
                vars__.push_back(S_z[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < logical_eq(prior_dist_z,6); ++k_0__) {
            vars__.push_back(one_over_lambda_z[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double aux(0.0);
        (void) aux;  // dummy to suppress unused var warning
        stan::math::initialize(aux, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(aux,DUMMY_VAR__);
        stan::math::assign(aux,(logical_eq(prior_dist_for_aux,0) ? stan::math::promote_scalar<double>(aux_unscaled) : stan::math::promote_scalar<double>((logical_lte(prior_dist_for_aux,2) ? stan::math::promote_scalar<double>(((prior_scale_for_aux * aux_unscaled) + prior_mean_for_aux)) : stan::math::promote_scalar<double>((prior_scale_for_aux * aux_unscaled)) )) ));
        vector_d omega(static_cast<Eigen::VectorXd::Index>(z_dim));
        (void) omega;  // dummy to suppress unused var warning
        stan::math::initialize(omega, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(omega,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool(logical_eq(prior_dist_z,0))) {
                stan::math::assign(omega, z_omega);
            } else if (as_bool(logical_eq(prior_dist_z,1))) {
                stan::math::assign(omega, add(elt_multiply(z_omega,prior_scale_z),prior_mean_z));
            } else if (as_bool(logical_eq(prior_dist_z,2))) {
                for (int k = 1; k <= z_dim; ++k) {

                    stan::math::assign(get_base1_lhs(omega,k,"omega",1), ((CFt(get_base1(omega,k,"omega",1),get_base1(prior_df_z,k,"prior_df_z",1), pstream__) * get_base1(prior_scale_z,k,"prior_scale_z",1)) + get_base1(prior_mean_z,k,"prior_mean_z",1)));
                }
            } else if (as_bool(logical_eq(prior_dist_z,3))) {
                stan::math::assign(omega, hs_prior(z_omega,global_z,local_z,global_prior_scale,1, pstream__));
            } else if (as_bool(logical_eq(prior_dist_z,4))) {
                stan::math::assign(omega, hsplus_prior(z_omega,global_z,local_z,global_prior_scale,1, pstream__));
            } else if (as_bool(logical_eq(prior_dist_z,5))) {
                stan::math::assign(omega, add(prior_mean_z,elt_multiply(elt_multiply(prior_scale_z,sqrt(multiply(2,get_base1(S_z,1,"S_z",1)))),z_omega)));
            } else if (as_bool(logical_eq(prior_dist_z,6))) {
                stan::math::assign(omega, add(prior_mean_z,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda_z,1,"one_over_lambda_z",1),prior_scale_z),sqrt(multiply(2,get_base1(S_z,1,"S_z",1)))),z_omega)));
            } else if (as_bool(logical_eq(prior_dist_z,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= z_dim; ++k) {

                        stan::math::assign(get_base1_lhs(omega,k,"omega",1), get_base1(z_omega,z_pos,"z_omega",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals_z,k,"num_normals_z",1); ++n) {

                            stan::math::assign(get_base1_lhs(omega,k,"omega",1), (get_base1(omega,k,"omega",1) * get_base1(z_omega,z_pos,"z_omega",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(omega,k,"omega",1), ((get_base1(omega,k,"omega",1) * pow(get_base1(prior_scale_z,k,"prior_scale_z",1),get_base1(num_normals_z,k,"num_normals_z",1))) + get_base1(prior_mean_z,k,"prior_mean_z",1)));
                    }
                }
            }
            if (as_bool(logical_eq(prior_dist_for_aux,0))) {
                stan::math::assign(aux, aux_unscaled);
            } else {

                stan::math::assign(aux, (prior_scale_for_aux * aux_unscaled));
                if (as_bool(logical_lte(prior_dist_for_aux,2))) {
                    stan::math::assign(aux, (aux + prior_mean_for_aux));
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(logical_eq(special_case,1))) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, multiply(tau,aux));
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(theta_L,1,"theta_L",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(theta_L,i,"theta_L",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    stan::math::assign(theta_L, make_theta_L(len_theta_L,p,aux,tau,scale,zeta,rho,z_T, pstream__));
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        vars__.push_back(aux);
        for (int k_0__ = 0; k_0__ < z_dim; ++k_0__) {
            vars__.push_back(omega[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_theta_L; ++k_0__) {
            vars__.push_back(theta_L[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> alpha(has_intercept, 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<double> omega_int(has_intercept_z, 0.0);
        stan::math::initialize(omega_int, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(omega_int,DUMMY_VAR__);
        double mean_PPD(0.0);
        (void) mean_PPD;  // dummy to suppress unused var warning
        stan::math::initialize(mean_PPD, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mean_PPD,DUMMY_VAR__);
        stan::math::assign(mean_PPD,0);


        try {
            if (as_bool(logical_eq(has_intercept,1))) {

                if (as_bool(dense_X)) {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(gamma,1,"gamma",1) - dot_product(xbar,beta)));
                } else {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), get_base1(gamma,1,"gamma",1));
                }
            }
            if (as_bool(logical_eq(has_intercept_z,1))) {

                stan::math::assign(get_base1_lhs(omega_int,1,"omega_int",1), (get_base1(gamma_z,1,"gamma_z",1) - dot_product(zbar,omega)));
            }
            {
                double nan_count(0.0);
                (void) nan_count;  // dummy to suppress unused var warning
                stan::math::initialize(nan_count, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(nan_count,DUMMY_VAR__);
                double yrep(0.0);
                (void) yrep;  // dummy to suppress unused var warning
                stan::math::initialize(yrep, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(yrep,DUMMY_VAR__);
                vector_d eta_z(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta_z;  // dummy to suppress unused var warning
                stan::math::initialize(eta_z, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta_z,DUMMY_VAR__);
                vector_d eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                stan::math::assign(nan_count, 0);
                if (as_bool(logical_gt(t,0))) {

                    if (as_bool(special_case)) {
                        for (int i = 1; i <= t; ++i) {
                            stan::math::assign(eta, add(eta,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V,i,"V",1)), stan::model::nil_index_list()), "b")));
                        }
                    } else {
                        stan::math::assign(eta, add(eta,csr_matrix_times_vector(N,q,w,v,u,b)));
                    }
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool((primitive_value((primitive_value(logical_eq(family,1)) || primitive_value(logical_eq(link,2)))) || primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_neq(link,5))))))) {
                        stan::math::assign(eta, add(eta,get_base1(gamma,1,"gamma",1)));
                    } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link,5))))) {
                        {
                            double max_eta(0.0);
                            (void) max_eta;  // dummy to suppress unused var warning
                            stan::math::initialize(max_eta, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(max_eta,DUMMY_VAR__);


                            stan::math::assign(max_eta, max(eta));
                            stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(alpha,1,"alpha",1) - max_eta));
                            stan::math::assign(eta, add(subtract(eta,max_eta),get_base1(gamma,1,"gamma",1)));
                        }
                    } else {
                        {
                            double min_eta(0.0);
                            (void) min_eta;  // dummy to suppress unused var warning
                            stan::math::initialize(min_eta, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(min_eta,DUMMY_VAR__);
                            stan::math::assign(min_eta,min(eta));


                            stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(alpha,1,"alpha",1) - min_eta));
                            stan::math::assign(eta, add(subtract(eta,min_eta),get_base1(gamma,1,"gamma",1)));
                        }
                    }
                } else {

                    stan::math::assign(eta, add(eta,dot_product(xbar,beta)));
                }
                if (as_bool((primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_gt(z_dim,0)))) && primitive_value(logical_gt(link_phi,0))))) {

                    stan::math::assign(eta_z, multiply(betareg_z,omega));
                } else if (as_bool((primitive_value((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(z_dim,0)))) && primitive_value(logical_eq(has_intercept_z,1))))) {

                    stan::math::assign(eta_z, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_intercept_z,1))) {

                    if (as_bool(logical_gt(link_phi,1))) {

                        stan::math::assign(get_base1_lhs(omega_int,1,"omega_int",1), (get_base1(omega_int,1,"omega_int",1) - min(eta_z)));
                        stan::math::assign(eta_z, add(subtract(eta_z,min(eta_z)),get_base1(gamma_z,1,"gamma_z",1)));
                    } else {

                        stan::math::assign(eta_z, add(eta_z,get_base1(gamma_z,1,"gamma_z",1)));
                    }
                } else {

                    if (as_bool(logical_gt(link_phi,1))) {

                        stan::math::assign(eta_z, add(subtract(eta_z,min(eta_z)),dot_product(zbar,omega)));
                    } else {

                        stan::math::assign(eta_z, add(eta_z,dot_product(zbar,omega)));
                    }
                }
                if (as_bool(logical_eq(family,1))) {

                    if (as_bool(logical_gt(link,1))) {
                        stan::math::assign(eta, linkinv_gauss(eta,link, pstream__));
                    }
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(mean_PPD, (mean_PPD + normal_rng(get_base1(eta,n,"eta",1),aux, base_rng__)));
                    }
                } else if (as_bool(logical_eq(family,2))) {

                    if (as_bool(logical_gt(link,1))) {
                        stan::math::assign(eta, linkinv_gamma(eta,link, pstream__));
                    }
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(mean_PPD, (mean_PPD + gamma_rng(aux,(aux / get_base1(eta,n,"eta",1)), base_rng__)));
                    }
                } else if (as_bool(logical_eq(family,3))) {

                    if (as_bool(logical_gt(link,1))) {
                        stan::math::assign(eta, linkinv_inv_gaussian(eta,link, pstream__));
                    }
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(mean_PPD, (mean_PPD + inv_gaussian_rng(get_base1(eta,n,"eta",1),aux, base_rng__, pstream__)));
                    }
                } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_eq(link_phi,0))))) {

                    stan::math::assign(eta, linkinv_beta(eta,link, pstream__));
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(mean_PPD, (mean_PPD + beta_rng((get_base1(eta,n,"eta",1) * aux),((1 - get_base1(eta,n,"eta",1)) * aux), base_rng__)));
                    }
                } else if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_gt(link_phi,0))))) {

                    stan::math::assign(eta, linkinv_beta(eta,link, pstream__));
                    stan::math::assign(eta_z, linkinv_beta_z(eta_z,link_phi, pstream__));
                    for (int n = 1; n <= N; ++n) {

                        stan::math::assign(yrep, beta_rng((get_base1(eta,n,"eta",1) * get_base1(eta_z,n,"eta_z",1)),((1 - get_base1(eta,n,"eta",1)) * get_base1(eta_z,n,"eta_z",1)), base_rng__));
                        if (as_bool(logical_eq(is_nan(yrep),1))) {

                            stan::math::assign(mean_PPD, mean_PPD);
                            stan::math::assign(nan_count, (nan_count + 1));
                        } else if (as_bool(logical_eq(is_nan(yrep),0))) {

                            stan::math::assign(mean_PPD, (mean_PPD + yrep));
                        }
                    }
                }
                if (as_bool((primitive_value(logical_eq(family,4)) && primitive_value(logical_gt(link_phi,0))))) {

                    stan::math::assign(mean_PPD, (mean_PPD / (N - nan_count)));
                } else {

                    stan::math::assign(mean_PPD, (mean_PPD / N));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < has_intercept_z; ++k_0__) {
            vars__.push_back(omega_int[k_0__]);
        }
        vars__.push_back(mean_PPD);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_continuous";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "aux_unscaled";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= has_intercept_z; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs_z; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global_z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= z_dim; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs_z; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local_z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= z_dim; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S_z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist_z,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda_z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "aux";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= z_dim; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= has_intercept_z; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega_int" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "aux_unscaled";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist_z,7) ? sum(num_normals_z) : z_dim ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= has_intercept_z; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs_z; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global_z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= z_dim; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs_z; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local_z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= z_dim; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist_z,5)) || primitive_value(logical_eq(prior_dist_z,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S_z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist_z,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda_z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "aux";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= z_dim; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= has_intercept_z; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega_int" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_count_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
make_theta_L(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
            (void) theta_L;  // dummy to suppress unused var warning
            stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(theta_L,DUMMY_VAR__);
            int zeta_mark(0);
            (void) zeta_mark;  // dummy to suppress unused var warning
            stan::math::fill(zeta_mark, std::numeric_limits<int>::min());
            stan::math::assign(zeta_mark,1);
            int rho_mark(0);
            (void) rho_mark;  // dummy to suppress unused var warning
            stan::math::fill(rho_mark, std::numeric_limits<int>::min());
            stan::math::assign(rho_mark,1);
            int z_T_mark(0);
            (void) z_T_mark;  // dummy to suppress unused var warning
            stan::math::fill(z_T_mark, std::numeric_limits<int>::min());
            stan::math::assign(z_T_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {

                        stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), ((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion));
                        stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            fun_scalar_t__ std_dev;
                            (void) std_dev;  // dummy to suppress unused var warning
                            stan::math::initialize(std_dev, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(std_dev,DUMMY_VAR__);
                            fun_scalar_t__ T21;
                            (void) T21;  // dummy to suppress unused var warning
                            stan::math::initialize(T21, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T21,DUMMY_VAR__);
                            fun_scalar_t__ trace_T_i;
                            (void) trace_T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(trace_T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(trace_T_i,DUMMY_VAR__);
                            stan::math::assign(trace_T_i,(square(((get_base1(tau,i,"tau",1) * get_base1(scale,i,"scale",1)) * dispersion)) * nc));
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(nc));
                            (void) pi;  // dummy to suppress unused var warning
                            stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(pi,DUMMY_VAR__);
                            stan::math::assign(pi,segment(zeta,zeta_mark,nc));


                            stan::math::assign(pi, divide(pi,sum(pi)));
                            stan::math::assign(zeta_mark, (zeta_mark + nc));
                            stan::math::assign(std_dev, sqrt((get_base1(pi,1,"pi",1) * trace_T_i)));
                            stan::math::assign(get_base1_lhs(T_i,1,1,"T_i",1), std_dev);
                            stan::math::assign(std_dev, sqrt((get_base1(pi,2,"pi",1) * trace_T_i)));
                            stan::math::assign(T21, ((2.0 * get_base1(rho,rho_mark,"rho",1)) - 1.0));
                            stan::math::assign(rho_mark, (rho_mark + 1));
                            stan::math::assign(get_base1_lhs(T_i,2,2,"T_i",1), (std_dev * sqrt((1.0 - square(T21)))));
                            stan::math::assign(get_base1_lhs(T_i,2,1,"T_i",1), (std_dev * T21));
                            for (int r = 2; r <= (nc - 1); ++r) {
                                {
                                    int rp1(0);
                                    (void) rp1;  // dummy to suppress unused var warning
                                    stan::math::fill(rp1, std::numeric_limits<int>::min());
                                    stan::math::assign(rp1,(r + 1));
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  T_row(static_cast<Eigen::VectorXd::Index>(r));
                                    (void) T_row;  // dummy to suppress unused var warning
                                    stan::math::initialize(T_row, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(T_row,DUMMY_VAR__);
                                    stan::math::assign(T_row,segment(z_T,z_T_mark,r));
                                    fun_scalar_t__ scale_factor;
                                    (void) scale_factor;  // dummy to suppress unused var warning
                                    stan::math::initialize(scale_factor, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(scale_factor,DUMMY_VAR__);
                                    stan::math::assign(scale_factor,(sqrt((get_base1(rho,rho_mark,"rho",1) / dot_self(T_row))) * std_dev));


                                    stan::math::assign(z_T_mark, (z_T_mark + r));
                                    stan::math::assign(std_dev, sqrt((get_base1(pi,rp1,"pi",1) * trace_T_i)));
                                    for (int c = 1; c <= r; ++c) {
                                        stan::math::assign(get_base1_lhs(T_i,rp1,c,"T_i",1), (get_base1(T_row,c,"T_row",1) * scale_factor));
                                    }
                                    stan::math::assign(get_base1_lhs(T_i,rp1,rp1,"T_i",1), (sqrt((1.0 - get_base1(rho,rho_mark,"rho",1))) * std_dev));
                                    stan::math::assign(rho_mark, (rho_mark + 1));
                                }
                            }
                            for (int c = 1; c <= nc; ++c) {
                                for (int r = c; r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(theta_L,theta_L_mark,"theta_L",1), get_base1(T_i,r,c,"T_i",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(theta_L);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_theta_L_functor__ {
    template <typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__, T3__, T4__, T5__, typename boost::math::tools::promote_args<T6__, T7__>::type>::type, Eigen::Dynamic,1>
    operator()(const int& len_theta_L,
                 const std::vector<int>& p,
                 const T2__& dispersion,
                 const Eigen::Matrix<T3__, Eigen::Dynamic,1>& tau,
                 const Eigen::Matrix<T4__, Eigen::Dynamic,1>& scale,
                 const Eigen::Matrix<T5__, Eigen::Dynamic,1>& zeta,
                 const Eigen::Matrix<T6__, Eigen::Dynamic,1>& rho,
                 const Eigen::Matrix<T7__, Eigen::Dynamic,1>& z_T, std::ostream* pstream__) const {
        return make_theta_L(len_theta_L, p, dispersion, tau, scale, zeta, rho, z_T, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
make_b(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(rows(z_b)));
            (void) b;  // dummy to suppress unused var warning
            stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(b,DUMMY_VAR__);
            int b_mark(0);
            (void) b_mark;  // dummy to suppress unused var warning
            stan::math::fill(b_mark, std::numeric_limits<int>::min());
            stan::math::assign(b_mark,1);
            int theta_L_mark(0);
            (void) theta_L_mark;  // dummy to suppress unused var warning
            stan::math::fill(theta_L_mark, std::numeric_limits<int>::min());
            stan::math::assign(theta_L_mark,1);


            for (int i = 1; i <= size(p); ++i) {
                {
                    int nc(0);
                    (void) nc;  // dummy to suppress unused var warning
                    stan::math::fill(nc, std::numeric_limits<int>::min());
                    stan::math::assign(nc,get_base1(p,i,"p",1));


                    if (as_bool(logical_eq(nc,1))) {
                        {
                            fun_scalar_t__ theta_L_start;
                            (void) theta_L_start;  // dummy to suppress unused var warning
                            stan::math::initialize(theta_L_start, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(theta_L_start,DUMMY_VAR__);
                            stan::math::assign(theta_L_start,get_base1(theta_L,theta_L_mark,"theta_L",1));


                            for (int s = b_mark; s <= ((b_mark + get_base1(l,i,"l",1)) - 1); ++s) {
                                stan::math::assign(get_base1_lhs(b,s,"b",1), (theta_L_start * get_base1(z_b,s,"z_b",1)));
                            }
                            stan::math::assign(b_mark, (b_mark + get_base1(l,i,"l",1)));
                            stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                        }
                    } else {
                        {
                            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  T_i(static_cast<Eigen::VectorXd::Index>(nc),static_cast<Eigen::VectorXd::Index>(nc));
                            (void) T_i;  // dummy to suppress unused var warning
                            stan::math::initialize(T_i, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(T_i,DUMMY_VAR__);
                            stan::math::assign(T_i,rep_matrix(0,nc,nc));


                            for (int c = 1; c <= nc; ++c) {

                                stan::math::assign(get_base1_lhs(T_i,c,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                for (int r = (c + 1); r <= nc; ++r) {

                                    stan::math::assign(get_base1_lhs(T_i,r,c,"T_i",1), get_base1(theta_L,theta_L_mark,"theta_L",1));
                                    stan::math::assign(theta_L_mark, (theta_L_mark + 1));
                                }
                            }
                            for (int j = 1; j <= get_base1(l,i,"l",1); ++j) {
                                {
                                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  temp(static_cast<Eigen::VectorXd::Index>(nc));
                                    (void) temp;  // dummy to suppress unused var warning
                                    stan::math::initialize(temp, std::numeric_limits<double>::quiet_NaN());
                                    stan::math::fill(temp,DUMMY_VAR__);
                                    stan::math::assign(temp,multiply(T_i,segment(z_b,b_mark,nc)));


                                    stan::math::assign(b_mark, (b_mark - 1));
                                    for (int s = 1; s <= nc; ++s) {
                                        stan::math::assign(get_base1_lhs(b,(b_mark + s),"b",1), get_base1(temp,s,"temp",1));
                                    }
                                    stan::math::assign(b_mark, ((b_mark + nc) + 1));
                                }
                            }
                        }
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(b);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_b_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
           const Eigen::Matrix<T1__, Eigen::Dynamic,1>& theta_L,
           const std::vector<int>& p,
           const std::vector<int>& l, std::ostream* pstream__) const {
        return make_b(z_b, theta_L, p, l, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
void
decov_lp(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int pos_reg(0);
            (void) pos_reg;  // dummy to suppress unused var warning
            stan::math::fill(pos_reg, std::numeric_limits<int>::min());
            stan::math::assign(pos_reg,1);
            int pos_rho(0);
            (void) pos_rho;  // dummy to suppress unused var warning
            stan::math::fill(pos_rho, std::numeric_limits<int>::min());
            stan::math::assign(pos_rho,1);


            lp_accum__.add(normal_log(z_b,0,1));
            lp_accum__.add(normal_log(z_T,0,1));
            for (int i = 1; i <= t; ++i) {
                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {
                    {
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape1(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape1;  // dummy to suppress unused var warning
                        stan::math::initialize(shape1, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape1,DUMMY_VAR__);
                        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  shape2(static_cast<Eigen::VectorXd::Index>((get_base1(p,i,"p",1) - 1)));
                        (void) shape2;  // dummy to suppress unused var warning
                        stan::math::initialize(shape2, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(shape2,DUMMY_VAR__);
                        fun_scalar_t__ nu;
                        (void) nu;  // dummy to suppress unused var warning
                        stan::math::initialize(nu, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(nu,DUMMY_VAR__);
                        stan::math::assign(nu,(get_base1(regularization,pos_reg,"regularization",1) + (0.5 * (get_base1(p,i,"p",1) - 2))));


                        stan::math::assign(pos_reg, (pos_reg + 1));
                        stan::math::assign(get_base1_lhs(shape1,1,"shape1",1), nu);
                        stan::math::assign(get_base1_lhs(shape2,1,"shape2",1), nu);
                        for (int j = 2; j <= (get_base1(p,i,"p",1) - 1); ++j) {

                            stan::math::assign(nu, (nu - 0.5));
                            stan::math::assign(get_base1_lhs(shape1,j,"shape1",1), (0.5 * j));
                            stan::math::assign(get_base1_lhs(shape2,j,"shape2",1), nu);
                        }
                        lp_accum__.add(beta_log(stan::model::rvalue(rho, stan::model::cons_list(stan::model::index_min_max(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 2)), stan::model::nil_index_list()), "rho"),shape1,shape2));
                        stan::math::assign(pos_rho, ((pos_rho + get_base1(p,i,"p",1)) - 1));
                    }
                }
            }
            lp_accum__.add(gamma_log(zeta,delta,1));
            lp_accum__.add(gamma_log(tau,shape,1));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct decov_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_b,
             const Eigen::Matrix<T1__, Eigen::Dynamic,1>& z_T,
             const Eigen::Matrix<T2__, Eigen::Dynamic,1>& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& zeta,
             const Eigen::Matrix<T4__, Eigen::Dynamic,1>& tau,
             const std::vector<T5__>& regularization,
             const std::vector<T6__>& delta,
             const Eigen::Matrix<T7__, Eigen::Dynamic,1>& shape,
             const int& t,
             const std::vector<int>& p, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return decov_lp(z_b, z_T, rho, zeta, tau, regularization, delta, shape, t, p, lp__, lp_accum__, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hs_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(rows(z_beta)));
            (void) lambda;  // dummy to suppress unused var warning
            stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(lambda,DUMMY_VAR__);
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());


            stan::math::assign(K, rows(z_beta));
            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(lambda,k,"lambda",1), (get_base1(get_base1(local,1,"local",1),k,"local",2) * sqrt(get_base1(get_base1(local,2,"local",1),k,"local",2))));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(z_beta,lambda),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hs_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
             const std::vector<T1__>& global,
             const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
             const T3__& global_prior_scale,
             const T4__& error_scale, std::ostream* pstream__) const {
        return hs_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
hsplus_prior(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(multiply(multiply(multiply(elt_multiply(elt_multiply(z_beta,elt_multiply(get_base1(local,1,"local",1),sqrt(get_base1(local,2,"local",1)))),elt_multiply(get_base1(local,3,"local",1),sqrt(get_base1(local,4,"local",1)))),get_base1(global,1,"global",1)),sqrt(get_base1(global,2,"global",1))),global_prior_scale),error_scale));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct hsplus_prior_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& z_beta,
                 const std::vector<T1__>& global,
                 const std::vector<Eigen::Matrix<T2__, Eigen::Dynamic,1> >& local,
                 const T3__& global_prior_scale,
                 const T4__& error_scale, std::ostream* pstream__) const {
        return hsplus_prior(z_beta, global, local, global_prior_scale, error_scale, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
divide_real_by_vector(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int K(0);
            (void) K;  // dummy to suppress unused var warning
            stan::math::fill(K, std::numeric_limits<int>::min());
            stan::math::assign(K,rows(y));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ret(static_cast<Eigen::VectorXd::Index>(K));
            (void) ret;  // dummy to suppress unused var warning
            stan::math::initialize(ret, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ret,DUMMY_VAR__);


            for (int k = 1; k <= K; ++k) {
                stan::math::assign(get_base1_lhs(ret,k,"ret",1), (x / get_base1(y,k,"y",1)));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct divide_real_by_vector_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const T0__& x,
                          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& y, std::ostream* pstream__) const {
        return divide_real_by_vector(x, y, pstream__);
    }
};

template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
CFt(const T0__& z,
        const T1__& df, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ z2;
            (void) z2;  // dummy to suppress unused var warning
            stan::math::initialize(z2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z2,DUMMY_VAR__);
            stan::math::assign(z2,square(z));
            fun_scalar_t__ z3;
            (void) z3;  // dummy to suppress unused var warning
            stan::math::initialize(z3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z3,DUMMY_VAR__);
            stan::math::assign(z3,(z2 * z));
            fun_scalar_t__ z5;
            (void) z5;  // dummy to suppress unused var warning
            stan::math::initialize(z5, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z5,DUMMY_VAR__);
            stan::math::assign(z5,(z2 * z3));
            fun_scalar_t__ z7;
            (void) z7;  // dummy to suppress unused var warning
            stan::math::initialize(z7, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z7,DUMMY_VAR__);
            stan::math::assign(z7,(z2 * z5));
            fun_scalar_t__ z9;
            (void) z9;  // dummy to suppress unused var warning
            stan::math::initialize(z9, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(z9,DUMMY_VAR__);
            stan::math::assign(z9,(z2 * z7));
            fun_scalar_t__ df2;
            (void) df2;  // dummy to suppress unused var warning
            stan::math::initialize(df2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df2,DUMMY_VAR__);
            stan::math::assign(df2,square(df));
            fun_scalar_t__ df3;
            (void) df3;  // dummy to suppress unused var warning
            stan::math::initialize(df3, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df3,DUMMY_VAR__);
            stan::math::assign(df3,(df2 * df));
            fun_scalar_t__ df4;
            (void) df4;  // dummy to suppress unused var warning
            stan::math::initialize(df4, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(df4,DUMMY_VAR__);
            stan::math::assign(df4,(df2 * df2));


            return stan::math::promote_scalar<fun_return_scalar_t__>(((((z + ((z3 + z) / (4 * df))) + ((((5 * z5) + (16 * z3)) + (3 * z)) / (96 * df2))) + (((((3 * z7) + (19 * z5)) + (17 * z3)) - (15 * z)) / (384 * df3))) + ((((((79 * z9) + (776 * z7)) + (1482 * z5)) - (1920 * z3)) - (945 * z)) / (92160 * df4))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct CFt_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const T0__& z,
        const T1__& df, std::ostream* pstream__) const {
        return CFt(z, df, pstream__);
    }
};

std::vector<std::vector<int> >
make_V(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) {
    typedef double fun_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<vector<int> > V(t, (vector<int>(N, 0)));
            stan::math::fill(V, std::numeric_limits<int>::min());
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);


            if (as_bool(logical_gt(t,0))) {
                for (int j = 1; j <= N; ++j) {
                    for (int i = 1; i <= t; ++i) {

                        stan::math::assign(get_base1_lhs(get_base1_lhs(V,i,"V",1),j,"V",2), get_base1(v,pos,"v",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(V);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_V_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& N,
           const int& t,
           const std::vector<int>& v, std::ostream* pstream__) const {
        return make_V(N, t, v, pstream__);
    }
};

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
linkinv_count(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(exp(eta));
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(square(eta));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linkinv_count_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& eta,
                  const int& link, std::ostream* pstream__) const {
        return linkinv_count(eta, link, pstream__);
    }
};

template <typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic,1>
pw_pois(const std::vector<int>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int N(0);
            (void) N;  // dummy to suppress unused var warning
            stan::math::fill(N, std::numeric_limits<int>::min());
            stan::math::assign(N,rows(eta));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(N));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,3))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(link,1))) {
                for (int n = 1; n <= N; ++n) {
                    stan::math::assign(get_base1_lhs(ll,n,"ll",1), poisson_log_log(get_base1(y,n,"y",1),get_base1(eta,n,"eta",1)));
                }
            } else {
                {
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  phi(static_cast<Eigen::VectorXd::Index>(N));
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(phi,DUMMY_VAR__);


                    stan::math::assign(phi, linkinv_count(eta,link, pstream__));
                    for (int n = 1; n <= N; ++n) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), poisson_log(get_base1(y,n,"y",1),get_base1(phi,n,"phi",1)));
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_pois_functor__ {
    template <typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic,1>
    operator()(const std::vector<int>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const int& link, std::ostream* pstream__) const {
        return pw_pois(y, eta, link, pstream__);
    }
};

template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic,1>
pw_nb(const std::vector<int>& y,
          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
          const T2__& theta,
          const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int N(0);
            (void) N;  // dummy to suppress unused var warning
            stan::math::fill(N, std::numeric_limits<int>::min());
            stan::math::assign(N,rows(eta));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
            (void) rho;  // dummy to suppress unused var warning
            stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(rho,DUMMY_VAR__);
            stan::math::assign(rho,linkinv_count(eta,link, pstream__));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(N));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);


            for (int n = 1; n <= N; ++n) {
                stan::math::assign(get_base1_lhs(ll,n,"ll",1), neg_binomial_2_log(get_base1(y,n,"y",1),get_base1(rho,n,"rho",1),theta));
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_nb_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic,1>
    operator()(const std::vector<int>& y,
          const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
          const T2__& theta,
          const int& link, std::ostream* pstream__) const {
        return pw_nb(y, eta, theta, link, pstream__);
    }
};

class model_count : public prob_grad {
private:
    int N;
    int K;
    vector_d xbar;
    int dense_X;
    vector<matrix_d> X;
    int nnz_X;
    vector_d w_X;
    vector<int> v_X;
    vector<int> u_X;
    vector<int> y;
    int prior_PD;
    int has_intercept;
    int family;
    int link;
    int prior_dist;
    int prior_dist_for_intercept;
    int prior_dist_for_aux;
    int has_weights;
    vector_d weights;
    int has_offset;
    vector_d offset;
    vector_d prior_scale;
    double prior_scale_for_intercept;
    double prior_scale_for_aux;
    vector_d prior_mean;
    double prior_mean_for_intercept;
    double prior_mean_for_aux;
    vector_d prior_df;
    double prior_df_for_intercept;
    double prior_df_for_aux;
    double global_prior_df;
    double global_prior_scale;
    vector<int> num_normals;
    int t;
    vector<int> p;
    vector<int> l;
    int q;
    int len_theta_L;
    vector_d shape;
    vector_d scale;
    int len_concentration;
    vector<double> concentration;
    int len_regularization;
    vector<double> regularization;
    int num_non_zero;
    vector_d w;
    vector<int> v;
    vector<int> u;
    int special_case;
    double poisson_max;
    vector<vector<int> > V;
    int len_z_T;
    int len_var_group;
    int len_rho;
    int is_continuous;
    int pos;
    vector<double> delta;
    int hs;
public:
    model_count(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_count(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_count_namespace::model_count";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        validate_non_negative_index("xbar", "K", K);
        xbar = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "xbar", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("xbar");
        pos__ = 0;
        size_t xbar_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < xbar_i_vec_lim__; ++i_vec__) {
            xbar[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "dense_X", "int", context__.to_vec());
        dense_X = int(0);
        vals_i__ = context__.vals_i("dense_X");
        pos__ = 0;
        dense_X = vals_i__[pos__++];
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(dense_X,N,K));
        validate_non_negative_index("X", "dense_X", dense_X);
        validate_non_negative_index("X", "N", N);
        validate_non_negative_index("X", "K", K);
        X = std::vector<matrix_d>(dense_X,matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = N;
        size_t X_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                size_t X_limit_0__ = dense_X;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }
        context__.validate_dims("data initialization", "nnz_X", "int", context__.to_vec());
        nnz_X = int(0);
        vals_i__ = context__.vals_i("nnz_X");
        pos__ = 0;
        nnz_X = vals_i__[pos__++];
        validate_non_negative_index("w_X", "nnz_X", nnz_X);
        w_X = vector_d(static_cast<Eigen::VectorXd::Index>(nnz_X));
        context__.validate_dims("data initialization", "w_X", "vector_d", context__.to_vec(nnz_X));
        vals_r__ = context__.vals_r("w_X");
        pos__ = 0;
        size_t w_X_i_vec_lim__ = nnz_X;
        for (size_t i_vec__ = 0; i_vec__ < w_X_i_vec_lim__; ++i_vec__) {
            w_X[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v_X", "int", context__.to_vec(nnz_X));
        validate_non_negative_index("v_X", "nnz_X", nnz_X);
        v_X = std::vector<int>(nnz_X,int(0));
        vals_i__ = context__.vals_i("v_X");
        pos__ = 0;
        size_t v_X_limit_0__ = nnz_X;
        for (size_t i_0__ = 0; i_0__ < v_X_limit_0__; ++i_0__) {
            v_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u_X", "int", context__.to_vec((dense_X ? 0 : (N + 1) )));
        validate_non_negative_index("u_X", "(dense_X ? 0 : (N + 1) )", (dense_X ? 0 : (N + 1) ));
        u_X = std::vector<int>((dense_X ? 0 : (N + 1) ),int(0));
        vals_i__ = context__.vals_i("u_X");
        pos__ = 0;
        size_t u_X_limit_0__ = (dense_X ? 0 : (N + 1) );
        for (size_t i_0__ = 0; i_0__ < u_X_limit_0__; ++i_0__) {
            u_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
        validate_non_negative_index("y", "N", N);
        y = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
        prior_PD = int(0);
        vals_i__ = context__.vals_i("prior_PD");
        pos__ = 0;
        prior_PD = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
        has_intercept = int(0);
        vals_i__ = context__.vals_i("has_intercept");
        pos__ = 0;
        has_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "family", "int", context__.to_vec());
        family = int(0);
        vals_i__ = context__.vals_i("family");
        pos__ = 0;
        family = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link", "int", context__.to_vec());
        link = int(0);
        vals_i__ = context__.vals_i("link");
        pos__ = 0;
        link = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
        prior_dist = int(0);
        vals_i__ = context__.vals_i("prior_dist");
        pos__ = 0;
        prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec());
        prior_dist_for_intercept = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept");
        pos__ = 0;
        prior_dist_for_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_aux", "int", context__.to_vec());
        prior_dist_for_aux = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_aux");
        pos__ = 0;
        prior_dist_for_aux = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_weights", "int", context__.to_vec());
        has_weights = int(0);
        vals_i__ = context__.vals_i("has_weights");
        pos__ = 0;
        has_weights = vals_i__[pos__++];
        validate_non_negative_index("weights", "(has_weights ? N : 0 )", (has_weights ? N : 0 ));
        weights = vector_d(static_cast<Eigen::VectorXd::Index>((has_weights ? N : 0 )));
        context__.validate_dims("data initialization", "weights", "vector_d", context__.to_vec((has_weights ? N : 0 )));
        vals_r__ = context__.vals_r("weights");
        pos__ = 0;
        size_t weights_i_vec_lim__ = (has_weights ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < weights_i_vec_lim__; ++i_vec__) {
            weights[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec());
        has_offset = int(0);
        vals_i__ = context__.vals_i("has_offset");
        pos__ = 0;
        has_offset = vals_i__[pos__++];
        validate_non_negative_index("offset", "(has_offset ? N : 0 )", (has_offset ? N : 0 ));
        offset = vector_d(static_cast<Eigen::VectorXd::Index>((has_offset ? N : 0 )));
        context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec((has_offset ? N : 0 )));
        vals_r__ = context__.vals_r("offset");
        pos__ = 0;
        size_t offset_i_vec_lim__ = (has_offset ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < offset_i_vec_lim__; ++i_vec__) {
            offset[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("prior_scale", "K", K);
        prior_scale = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_scale", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_scale");
        pos__ = 0;
        size_t prior_scale_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_scale_i_vec_lim__; ++i_vec__) {
            prior_scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_scale_for_intercept", "double", context__.to_vec());
        prior_scale_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_intercept");
        pos__ = 0;
        prior_scale_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_scale_for_aux", "double", context__.to_vec());
        prior_scale_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_aux");
        pos__ = 0;
        prior_scale_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_mean", "K", K);
        prior_mean = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_mean", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_mean");
        pos__ = 0;
        size_t prior_mean_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_mean_i_vec_lim__; ++i_vec__) {
            prior_mean[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_mean_for_intercept", "double", context__.to_vec());
        prior_mean_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_intercept");
        pos__ = 0;
        prior_mean_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_mean_for_aux", "double", context__.to_vec());
        prior_mean_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_aux");
        pos__ = 0;
        prior_mean_for_aux = vals_r__[pos__++];
        validate_non_negative_index("prior_df", "K", K);
        prior_df = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "prior_df", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("prior_df");
        pos__ = 0;
        size_t prior_df_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < prior_df_i_vec_lim__; ++i_vec__) {
            prior_df[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_df_for_intercept", "double", context__.to_vec());
        prior_df_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_df_for_intercept");
        pos__ = 0;
        prior_df_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_df_for_aux", "double", context__.to_vec());
        prior_df_for_aux = double(0);
        vals_r__ = context__.vals_r("prior_df_for_aux");
        pos__ = 0;
        prior_df_for_aux = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_df", "double", context__.to_vec());
        global_prior_df = double(0);
        vals_r__ = context__.vals_r("global_prior_df");
        pos__ = 0;
        global_prior_df = vals_r__[pos__++];
        context__.validate_dims("data initialization", "global_prior_scale", "double", context__.to_vec());
        global_prior_scale = double(0);
        vals_r__ = context__.vals_r("global_prior_scale");
        pos__ = 0;
        global_prior_scale = vals_r__[pos__++];
        context__.validate_dims("data initialization", "num_normals", "int", context__.to_vec((logical_eq(prior_dist,7) ? K : 0 )));
        validate_non_negative_index("num_normals", "(logical_eq(prior_dist,7) ? K : 0 )", (logical_eq(prior_dist,7) ? K : 0 ));
        num_normals = std::vector<int>((logical_eq(prior_dist,7) ? K : 0 ),int(0));
        vals_i__ = context__.vals_i("num_normals");
        pos__ = 0;
        size_t num_normals_limit_0__ = (logical_eq(prior_dist,7) ? K : 0 );
        for (size_t i_0__ = 0; i_0__ < num_normals_limit_0__; ++i_0__) {
            num_normals[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "t", "int", context__.to_vec());
        t = int(0);
        vals_i__ = context__.vals_i("t");
        pos__ = 0;
        t = vals_i__[pos__++];
        context__.validate_dims("data initialization", "p", "int", context__.to_vec(t));
        validate_non_negative_index("p", "t", t);
        p = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("p");
        pos__ = 0;
        size_t p_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < p_limit_0__; ++i_0__) {
            p[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "l", "int", context__.to_vec(t));
        validate_non_negative_index("l", "t", t);
        l = std::vector<int>(t,int(0));
        vals_i__ = context__.vals_i("l");
        pos__ = 0;
        size_t l_limit_0__ = t;
        for (size_t i_0__ = 0; i_0__ < l_limit_0__; ++i_0__) {
            l[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "int", context__.to_vec());
        q = int(0);
        vals_i__ = context__.vals_i("q");
        pos__ = 0;
        q = vals_i__[pos__++];
        context__.validate_dims("data initialization", "len_theta_L", "int", context__.to_vec());
        len_theta_L = int(0);
        vals_i__ = context__.vals_i("len_theta_L");
        pos__ = 0;
        len_theta_L = vals_i__[pos__++];
        validate_non_negative_index("shape", "t", t);
        shape = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "shape", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("shape");
        pos__ = 0;
        size_t shape_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < shape_i_vec_lim__; ++i_vec__) {
            shape[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("scale", "t", t);
        scale = vector_d(static_cast<Eigen::VectorXd::Index>(t));
        context__.validate_dims("data initialization", "scale", "vector_d", context__.to_vec(t));
        vals_r__ = context__.vals_r("scale");
        pos__ = 0;
        size_t scale_i_vec_lim__ = t;
        for (size_t i_vec__ = 0; i_vec__ < scale_i_vec_lim__; ++i_vec__) {
            scale[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_concentration", "int", context__.to_vec());
        len_concentration = int(0);
        vals_i__ = context__.vals_i("len_concentration");
        pos__ = 0;
        len_concentration = vals_i__[pos__++];
        context__.validate_dims("data initialization", "concentration", "double", context__.to_vec(len_concentration));
        validate_non_negative_index("concentration", "len_concentration", len_concentration);
        concentration = std::vector<double>(len_concentration,double(0));
        vals_r__ = context__.vals_r("concentration");
        pos__ = 0;
        size_t concentration_limit_0__ = len_concentration;
        for (size_t i_0__ = 0; i_0__ < concentration_limit_0__; ++i_0__) {
            concentration[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "len_regularization", "int", context__.to_vec());
        len_regularization = int(0);
        vals_i__ = context__.vals_i("len_regularization");
        pos__ = 0;
        len_regularization = vals_i__[pos__++];
        context__.validate_dims("data initialization", "regularization", "double", context__.to_vec(len_regularization));
        validate_non_negative_index("regularization", "len_regularization", len_regularization);
        regularization = std::vector<double>(len_regularization,double(0));
        vals_r__ = context__.vals_r("regularization");
        pos__ = 0;
        size_t regularization_limit_0__ = len_regularization;
        for (size_t i_0__ = 0; i_0__ < regularization_limit_0__; ++i_0__) {
            regularization[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "num_non_zero", "int", context__.to_vec());
        num_non_zero = int(0);
        vals_i__ = context__.vals_i("num_non_zero");
        pos__ = 0;
        num_non_zero = vals_i__[pos__++];
        validate_non_negative_index("w", "num_non_zero", num_non_zero);
        w = vector_d(static_cast<Eigen::VectorXd::Index>(num_non_zero));
        context__.validate_dims("data initialization", "w", "vector_d", context__.to_vec(num_non_zero));
        vals_r__ = context__.vals_r("w");
        pos__ = 0;
        size_t w_i_vec_lim__ = num_non_zero;
        for (size_t i_vec__ = 0; i_vec__ < w_i_vec_lim__; ++i_vec__) {
            w[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v", "int", context__.to_vec(num_non_zero));
        validate_non_negative_index("v", "num_non_zero", num_non_zero);
        v = std::vector<int>(num_non_zero,int(0));
        vals_i__ = context__.vals_i("v");
        pos__ = 0;
        size_t v_limit_0__ = num_non_zero;
        for (size_t i_0__ = 0; i_0__ < v_limit_0__; ++i_0__) {
            v[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u", "int", context__.to_vec((logical_gt(t,0) ? (N + 1) : 0 )));
        validate_non_negative_index("u", "(logical_gt(t,0) ? (N + 1) : 0 )", (logical_gt(t,0) ? (N + 1) : 0 ));
        u = std::vector<int>((logical_gt(t,0) ? (N + 1) : 0 ),int(0));
        vals_i__ = context__.vals_i("u");
        pos__ = 0;
        size_t u_limit_0__ = (logical_gt(t,0) ? (N + 1) : 0 );
        for (size_t i_0__ = 0; i_0__ < u_limit_0__; ++i_0__) {
            u[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "special_case", "int", context__.to_vec());
        special_case = int(0);
        vals_i__ = context__.vals_i("special_case");
        pos__ = 0;
        special_case = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"N",N,0);
        check_greater_or_equal(function__,"K",K,0);
        check_greater_or_equal(function__,"dense_X",dense_X,0);
        check_less_or_equal(function__,"dense_X",dense_X,1);
        check_greater_or_equal(function__,"nnz_X",nnz_X,0);
        for (int k0__ = 0; k0__ < nnz_X; ++k0__) {
            check_greater_or_equal(function__,"v_X[k0__]",v_X[k0__],0);
        }
        for (int k0__ = 0; k0__ < (dense_X ? 0 : (N + 1) ); ++k0__) {
            check_greater_or_equal(function__,"u_X[k0__]",u_X[k0__],0);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"prior_PD",prior_PD,0);
        check_less_or_equal(function__,"prior_PD",prior_PD,1);
        check_greater_or_equal(function__,"has_intercept",has_intercept,0);
        check_less_or_equal(function__,"has_intercept",has_intercept,1);
        check_greater_or_equal(function__,"family",family,1);
        check_greater_or_equal(function__,"link",link,1);
        check_greater_or_equal(function__,"prior_dist",prior_dist,0);
        check_less_or_equal(function__,"prior_dist",prior_dist,7);
        check_greater_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,0);
        check_less_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,2);
        check_greater_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,0);
        check_less_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,3);
        check_greater_or_equal(function__,"has_weights",has_weights,0);
        check_less_or_equal(function__,"has_weights",has_weights,1);
        check_greater_or_equal(function__,"has_offset",has_offset,0);
        check_less_or_equal(function__,"has_offset",has_offset,1);
        check_greater_or_equal(function__,"prior_scale",prior_scale,0);
        check_greater_or_equal(function__,"prior_scale_for_intercept",prior_scale_for_intercept,0);
        check_greater_or_equal(function__,"prior_scale_for_aux",prior_scale_for_aux,0);
        check_greater_or_equal(function__,"prior_mean_for_aux",prior_mean_for_aux,0);
        check_greater_or_equal(function__,"prior_df",prior_df,0);
        check_greater_or_equal(function__,"prior_df_for_intercept",prior_df_for_intercept,0);
        check_greater_or_equal(function__,"prior_df_for_aux",prior_df_for_aux,0);
        check_greater_or_equal(function__,"global_prior_df",global_prior_df,0);
        check_greater_or_equal(function__,"global_prior_scale",global_prior_scale,0);
        for (int k0__ = 0; k0__ < (logical_eq(prior_dist,7) ? K : 0 ); ++k0__) {
            check_greater_or_equal(function__,"num_normals[k0__]",num_normals[k0__],2);
        }
        check_greater_or_equal(function__,"t",t,0);
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"p[k0__]",p[k0__],1);
        }
        for (int k0__ = 0; k0__ < t; ++k0__) {
            check_greater_or_equal(function__,"l[k0__]",l[k0__],1);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_greater_or_equal(function__,"len_theta_L",len_theta_L,0);
        check_greater_or_equal(function__,"shape",shape,0);
        check_greater_or_equal(function__,"scale",scale,0);
        check_greater_or_equal(function__,"len_concentration",len_concentration,0);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"concentration[k0__]",concentration[k0__],0);
        }
        check_greater_or_equal(function__,"len_regularization",len_regularization,0);
        for (int k0__ = 0; k0__ < len_regularization; ++k0__) {
            check_greater_or_equal(function__,"regularization[k0__]",regularization[k0__],0);
        }
        check_greater_or_equal(function__,"num_non_zero",num_non_zero,0);
        for (int k0__ = 0; k0__ < num_non_zero; ++k0__) {
            check_greater_or_equal(function__,"v[k0__]",v[k0__],0);
        }
        for (int k0__ = 0; k0__ < (logical_gt(t,0) ? (N + 1) : 0 ); ++k0__) {
            check_greater_or_equal(function__,"u[k0__]",u[k0__],0);
        }
        check_greater_or_equal(function__,"special_case",special_case,0);
        check_less_or_equal(function__,"special_case",special_case,1);
        // initialize data variables
        poisson_max = double(0);
        stan::math::fill(poisson_max,DUMMY_VAR__);
        stan::math::assign(poisson_max,pow(2.0,30.0));
        validate_non_negative_index("V", "t", t);
        validate_non_negative_index("V", "N", N);
        V = std::vector<std::vector<int> >(t,std::vector<int>(N,int(0)));
        stan::math::fill(V, std::numeric_limits<int>::min());
        stan::math::assign(V,make_V(N,t,v, pstream__));
        len_z_T = int(0);
        stan::math::fill(len_z_T, std::numeric_limits<int>::min());
        stan::math::assign(len_z_T,0);
        len_var_group = int(0);
        stan::math::fill(len_var_group, std::numeric_limits<int>::min());
        stan::math::assign(len_var_group,(sum(p) * logical_gt(t,0)));
        len_rho = int(0);
        stan::math::fill(len_rho, std::numeric_limits<int>::min());
        stan::math::assign(len_rho,(sum(p) - t));
        is_continuous = int(0);
        stan::math::fill(is_continuous, std::numeric_limits<int>::min());
        stan::math::assign(is_continuous,0);
        pos = int(0);
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        validate_non_negative_index("delta", "len_concentration", len_concentration);
        delta = std::vector<double>(len_concentration,double(0));
        stan::math::fill(delta,DUMMY_VAR__);
        hs = int(0);
        stan::math::fill(hs, std::numeric_limits<int>::min());

        try {
            if (as_bool(logical_lte(prior_dist,2))) {
                stan::math::assign(hs, 0);
            } else if (as_bool(logical_eq(prior_dist,3))) {
                stan::math::assign(hs, 2);
            } else if (as_bool(logical_eq(prior_dist,4))) {
                stan::math::assign(hs, 4);
            } else {
                stan::math::assign(hs, 0);
            }
            stan::math::assign(len_z_T, 0);
            stan::math::assign(len_var_group, (sum(p) * logical_gt(t,0)));
            stan::math::assign(len_rho, (sum(p) - t));
            stan::math::assign(pos, 1);
            for (int i = 1; i <= t; ++i) {

                if (as_bool(logical_gt(get_base1(p,i,"p",1),1))) {

                    for (int j = 1; j <= get_base1(p,i,"p",1); ++j) {

                        stan::math::assign(get_base1_lhs(delta,pos,"delta",1), get_base1(concentration,j,"concentration",1));
                        stan::math::assign(pos, (pos + 1));
                    }
                }
                for (int j = 3; j <= get_base1(p,i,"p",1); ++j) {
                    stan::math::assign(len_z_T, ((len_z_T + get_base1(p,i,"p",1)) - 1));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        for (int k0__ = 0; k0__ < t; ++k0__) {
            for (int k1__ = 0; k1__ < N; ++k1__) {
                check_greater_or_equal(function__,"V[k0__][k1__]",V[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"len_z_T",len_z_T,0);
        check_greater_or_equal(function__,"len_var_group",len_var_group,0);
        check_greater_or_equal(function__,"len_rho",len_rho,0);
        check_greater_or_equal(function__,"is_continuous",is_continuous,0);
        check_less_or_equal(function__,"is_continuous",is_continuous,1);
        check_greater_or_equal(function__,"pos",pos,1);
        for (int k0__ = 0; k0__ < len_concentration; ++k0__) {
            check_greater_or_equal(function__,"delta[k0__]",delta[k0__],0);
        }
        check_greater_or_equal(function__,"hs",hs,0);

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += has_intercept;
        num_params_r__ += (logical_eq(prior_dist,7) ? sum(num_normals) : K );
        num_params_r__ += hs;
        num_params_r__ += K * hs;
        num_params_r__ += K * (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        num_params_r__ += logical_eq(prior_dist,6);
        num_params_r__ += q;
        num_params_r__ += len_z_T;
        num_params_r__ += len_rho;
        num_params_r__ += len_concentration;
        num_params_r__ += t;
        num_params_r__ += logical_gt(family,1);
        num_params_r__ += N * logical_eq(family,3);
    }

    ~model_count() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("gamma")))
            throw std::runtime_error("variable gamma missing");
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma", "double", context__.to_vec(has_intercept));
        // generate_declaration gamma
        std::vector<double> gamma(has_intercept,double(0));
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            gamma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < has_intercept; ++i0__)
            try {
            writer__.scalar_lb_unconstrain((logical_eq(link,1) ? stan::math::negative_infinity() : 0.0 ),gamma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma: ") + e.what());
        }

        if (!(context__.contains_r("z_beta")))
            throw std::runtime_error("variable z_beta missing");
        vals_r__ = context__.vals_r("z_beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_beta", "vector_d", context__.to_vec((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        // generate_declaration z_beta
        vector_d z_beta(static_cast<Eigen::VectorXd::Index>((logical_eq(prior_dist,7) ? sum(num_normals) : K )));
        for (int j1__ = 0U; j1__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++j1__)
            z_beta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_beta: ") + e.what());
        }

        if (!(context__.contains_r("global")))
            throw std::runtime_error("variable global missing");
        vals_r__ = context__.vals_r("global");
        pos__ = 0U;
        context__.validate_dims("initialization", "global", "double", context__.to_vec(hs));
        // generate_declaration global
        std::vector<double> global(hs,double(0));
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            global[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,global[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable global: ") + e.what());
        }

        if (!(context__.contains_r("local")))
            throw std::runtime_error("variable local missing");
        vals_r__ = context__.vals_r("local");
        pos__ = 0U;
        context__.validate_dims("initialization", "local", "vector_d", context__.to_vec(hs,K));
        // generate_declaration local
        std::vector<vector_d> local(hs,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < hs; ++i0__)
                local[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < hs; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,local[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable local: ") + e.what());
        }

        if (!(context__.contains_r("S")))
            throw std::runtime_error("variable S missing");
        vals_r__ = context__.vals_r("S");
        pos__ = 0U;
        context__.validate_dims("initialization", "S", "vector_d", context__.to_vec((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),K));
        // generate_declaration S
        std::vector<vector_d> S((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))),vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
                S[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,S[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable S: ") + e.what());
        }

        if (!(context__.contains_r("one_over_lambda")))
            throw std::runtime_error("variable one_over_lambda missing");
        vals_r__ = context__.vals_r("one_over_lambda");
        pos__ = 0U;
        context__.validate_dims("initialization", "one_over_lambda", "double", context__.to_vec(logical_eq(prior_dist,6)));
        // generate_declaration one_over_lambda
        std::vector<double> one_over_lambda(logical_eq(prior_dist,6),double(0));
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            one_over_lambda[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_eq(prior_dist,6); ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,one_over_lambda[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable one_over_lambda: ") + e.what());
        }

        if (!(context__.contains_r("z_b")))
            throw std::runtime_error("variable z_b missing");
        vals_r__ = context__.vals_r("z_b");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_b", "vector_d", context__.to_vec(q));
        // generate_declaration z_b
        vector_d z_b(static_cast<Eigen::VectorXd::Index>(q));
        for (int j1__ = 0U; j1__ < q; ++j1__)
            z_b(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_b: ") + e.what());
        }

        if (!(context__.contains_r("z_T")))
            throw std::runtime_error("variable z_T missing");
        vals_r__ = context__.vals_r("z_T");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_T", "vector_d", context__.to_vec(len_z_T));
        // generate_declaration z_T
        vector_d z_T(static_cast<Eigen::VectorXd::Index>(len_z_T));
        for (int j1__ = 0U; j1__ < len_z_T; ++j1__)
            z_T(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z_T);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_T: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho", "vector_d", context__.to_vec(len_rho));
        // generate_declaration rho
        vector_d rho(static_cast<Eigen::VectorXd::Index>(len_rho));
        for (int j1__ = 0U; j1__ < len_rho; ++j1__)
            rho(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,rho);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        if (!(context__.contains_r("zeta")))
            throw std::runtime_error("variable zeta missing");
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "zeta", "vector_d", context__.to_vec(len_concentration));
        // generate_declaration zeta
        vector_d zeta(static_cast<Eigen::VectorXd::Index>(len_concentration));
        for (int j1__ = 0U; j1__ < len_concentration; ++j1__)
            zeta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,zeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zeta: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "vector_d", context__.to_vec(t));
        // generate_declaration tau
        vector_d tau(static_cast<Eigen::VectorXd::Index>(t));
        for (int j1__ = 0U; j1__ < t; ++j1__)
            tau(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("aux_unscaled")))
            throw std::runtime_error("variable aux_unscaled missing");
        vals_r__ = context__.vals_r("aux_unscaled");
        pos__ = 0U;
        context__.validate_dims("initialization", "aux_unscaled", "double", context__.to_vec(logical_gt(family,1)));
        // generate_declaration aux_unscaled
        std::vector<double> aux_unscaled(logical_gt(family,1),double(0));
        for (int i0__ = 0U; i0__ < logical_gt(family,1); ++i0__)
            aux_unscaled[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_gt(family,1); ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,aux_unscaled[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable aux_unscaled: ") + e.what());
        }

        if (!(context__.contains_r("noise")))
            throw std::runtime_error("variable noise missing");
        vals_r__ = context__.vals_r("noise");
        pos__ = 0U;
        context__.validate_dims("initialization", "noise", "vector_d", context__.to_vec(logical_eq(family,3),N));
        // generate_declaration noise
        std::vector<vector_d> noise(logical_eq(family,3),vector_d(static_cast<Eigen::VectorXd::Index>(N)));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            for (int i0__ = 0U; i0__ < logical_eq(family,3); ++i0__)
                noise[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < logical_eq(family,3); ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,noise[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable noise: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<T__> gamma;
        size_t dim_gamma_0__ = has_intercept;
        gamma.reserve(dim_gamma_0__);
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            if (jacobian__)
                gamma.push_back(in__.scalar_lb_constrain((logical_eq(link,1) ? stan::math::negative_infinity() : 0.0 ),lp__));
            else
                gamma.push_back(in__.scalar_lb_constrain((logical_eq(link,1) ? stan::math::negative_infinity() : 0.0 )));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_beta;
        (void) z_beta;  // dummy to suppress unused var warning
        if (jacobian__)
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ),lp__);
        else
            z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));

        vector<T__> global;
        size_t dim_global_0__ = hs;
        global.reserve(dim_global_0__);
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            if (jacobian__)
                global.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                global.push_back(in__.scalar_lb_constrain(0));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > local;
        size_t dim_local_0__ = hs;
        local.reserve(dim_local_0__);
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            if (jacobian__)
                local.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                local.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        S.reserve(dim_S_0__);
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            if (jacobian__)
                S.push_back(in__.vector_lb_constrain(0,K,lp__));
            else
                S.push_back(in__.vector_lb_constrain(0,K));
        }

        vector<T__> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        one_over_lambda.reserve(dim_one_over_lambda_0__);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            if (jacobian__)
                one_over_lambda.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_b;
        (void) z_b;  // dummy to suppress unused var warning
        if (jacobian__)
            z_b = in__.vector_constrain(q,lp__);
        else
            z_b = in__.vector_constrain(q);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  z_T;
        (void) z_T;  // dummy to suppress unused var warning
        if (jacobian__)
            z_T = in__.vector_constrain(len_z_T,lp__);
        else
            z_T = in__.vector_constrain(len_z_T);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho;
        (void) rho;  // dummy to suppress unused var warning
        if (jacobian__)
            rho = in__.vector_lub_constrain(0,1,len_rho,lp__);
        else
            rho = in__.vector_lub_constrain(0,1,len_rho);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  zeta;
        (void) zeta;  // dummy to suppress unused var warning
        if (jacobian__)
            zeta = in__.vector_lb_constrain(0,len_concentration,lp__);
        else
            zeta = in__.vector_lb_constrain(0,len_concentration);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.vector_lb_constrain(0,t,lp__);
        else
            tau = in__.vector_lb_constrain(0,t);

        vector<T__> aux_unscaled;
        size_t dim_aux_unscaled_0__ = logical_gt(family,1);
        aux_unscaled.reserve(dim_aux_unscaled_0__);
        for (size_t k_0__ = 0; k_0__ < dim_aux_unscaled_0__; ++k_0__) {
            if (jacobian__)
                aux_unscaled.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                aux_unscaled.push_back(in__.scalar_lb_constrain(0));
        }

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > noise;
        size_t dim_noise_0__ = logical_eq(family,3);
        noise.reserve(dim_noise_0__);
        for (size_t k_0__ = 0; k_0__ < dim_noise_0__; ++k_0__) {
            if (jacobian__)
                noise.push_back(in__.vector_lb_constrain(0,N,lp__));
            else
                noise.push_back(in__.vector_lb_constrain(0,N));
        }


        // transformed parameters
        T__ aux;
        (void) aux;  // dummy to suppress unused var warning
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux,DUMMY_VAR__);
        stan::math::assign(aux,stan::math::negative_infinity());
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, DUMMY_VAR__);
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool((primitive_value(logical_gt(family,1)) && primitive_value((primitive_value(logical_eq(prior_dist_for_aux,0)) || primitive_value(logical_lte(prior_scale_for_aux,0))))))) {
                stan::math::assign(aux, get_base1(aux_unscaled,1,"aux_unscaled",1));
            } else if (as_bool(logical_gt(family,1))) {

                stan::math::assign(aux, (prior_scale_for_aux * get_base1(aux_unscaled,1,"aux_unscaled",1)));
                if (as_bool(logical_lte(prior_dist_for_aux,2))) {
                    stan::math::assign(aux, (aux + prior_mean_for_aux));
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(logical_eq(special_case,1))) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, (logical_eq(family,1) ? stan::math::promote_scalar<T__>(tau) : stan::math::promote_scalar<T__>(multiply(tau,aux)) ));
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(theta_L,1,"theta_L",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(theta_L,i,"theta_L",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    if (as_bool(logical_eq(family,1))) {
                        stan::math::assign(theta_L, make_theta_L(len_theta_L,p,1.0,tau,scale,zeta,rho,z_T, pstream__));
                    } else {
                        stan::math::assign(theta_L, make_theta_L(len_theta_L,p,aux,tau,scale,zeta,rho,z_T, pstream__));
                    }
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(aux)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: aux";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < q; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < len_theta_L; ++i0__) {
            if (stan::math::is_uninitialized(theta_L(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: theta_L" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, DUMMY_VAR__);
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                if (as_bool(logical_gt(t,0))) {

                    if (as_bool(special_case)) {
                        for (int i = 1; i <= t; ++i) {
                            stan::math::assign(eta, add(eta,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V,i,"V",1)), stan::model::nil_index_list()), "b")));
                        }
                    } else {
                        stan::math::assign(eta, add(eta,csr_matrix_times_vector(N,q,w,v,u,b)));
                    }
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_eq(link,1))) {
                        stan::math::assign(eta, add(eta,get_base1(gamma,1,"gamma",1)));
                    } else {
                        stan::math::assign(eta, add(subtract(eta,min(eta)),get_base1(gamma,1,"gamma",1)));
                    }
                } else {

                    stan::math::assign(eta, add(eta,dot_product(xbar,beta)));
                }
                if (as_bool(logical_eq(family,3))) {

                    if (as_bool(logical_eq(link,1))) {
                        stan::math::assign(eta, add(add(eta,log(aux)),log(get_base1(noise,1,"noise",1))));
                    } else if (as_bool(logical_eq(link,2))) {
                        stan::math::assign(eta, elt_multiply(multiply(eta,aux),get_base1(noise,1,"noise",1)));
                    } else {
                        stan::math::assign(eta, add(add(eta,sqrt(aux)),sqrt(get_base1(noise,1,"noise",1))));
                    }
                }
                if (as_bool((primitive_value(logical_eq(has_weights,0)) && primitive_value(logical_eq(prior_PD,0))))) {

                    if (as_bool(logical_neq(family,2))) {

                        if (as_bool(logical_eq(link,1))) {
                            lp_accum__.add(poisson_log_log(y,eta));
                        } else {
                            lp_accum__.add(poisson_log(y,linkinv_count(eta,link, pstream__)));
                        }
                    } else {

                        if (as_bool(logical_eq(link,1))) {
                            lp_accum__.add(neg_binomial_2_log_log(y,eta,aux));
                        } else {
                            lp_accum__.add(neg_binomial_2_log(y,linkinv_count(eta,link, pstream__),aux));
                        }
                    }
                } else if (as_bool((primitive_value(logical_neq(family,2)) && primitive_value(logical_eq(prior_PD,0))))) {
                    lp_accum__.add(dot_product(weights,pw_pois(y,eta,link, pstream__)));
                } else if (as_bool(logical_eq(prior_PD,0))) {
                    lp_accum__.add(dot_product(weights,pw_nb(y,eta,aux,link, pstream__)));
                }
                if (as_bool((primitive_value((primitive_value(logical_gt(family,1)) && primitive_value(logical_gt(prior_dist_for_aux,0)))) && primitive_value(logical_gt(prior_scale_for_aux,0))))) {

                    if (as_bool(logical_eq(prior_dist_for_aux,1))) {
                        lp_accum__.add(normal_log(aux_unscaled,0,1));
                    } else if (as_bool(logical_eq(prior_dist_for_aux,2))) {
                        lp_accum__.add(student_t_log(aux_unscaled,prior_df_for_aux,0,1));
                    } else {
                        lp_accum__.add(exponential_log(aux_unscaled,1));
                    }
                }
                if (as_bool(logical_eq(prior_dist,1))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,2))) {
                    lp_accum__.add(normal_log(z_beta,0,1));
                } else if (as_bool(logical_eq(prior_dist,3))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,4))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(normal_log(get_base1(local,1,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,2,"local",1),multiply(0.5,prior_df),multiply(0.5,prior_df)));
                    lp_accum__.add(normal_log(get_base1(local,3,"local",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(local,4,"local",1),multiply(0.5,prior_scale),multiply(0.5,prior_scale)));
                    lp_accum__.add(normal_log(get_base1(global,1,"global",1),0,1));
                    lp_accum__.add(inv_gamma_log(get_base1(global,2,"global",1),(0.5 * global_prior_df),(0.5 * global_prior_df)));
                } else if (as_bool(logical_eq(prior_dist,5))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                } else if (as_bool(logical_eq(prior_dist,6))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                    lp_accum__.add(exponential_log(get_base1(S,1,"S",1),1));
                    lp_accum__.add(chi_square_log(get_base1(one_over_lambda,1,"one_over_lambda",1),get_base1(prior_df,1,"prior_df",1)));
                } else if (as_bool(logical_eq(prior_dist,7))) {

                    lp_accum__.add(normal_log(z_beta,0,1));
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_eq(prior_dist_for_intercept,1))) {
                        lp_accum__.add(normal_log(gamma,prior_mean_for_intercept,prior_scale_for_intercept));
                    } else if (as_bool(logical_eq(prior_dist_for_intercept,2))) {
                        lp_accum__.add(student_t_log(gamma,prior_df_for_intercept,prior_mean_for_intercept,prior_scale_for_intercept));
                    }
                }
                if (as_bool(logical_eq(family,3))) {
                    lp_accum__.add(gamma_log(get_base1(noise,1,"noise",1),aux,1));
                }
                if (as_bool(logical_gt(t,0))) {
                    decov_lp(z_b,z_T,rho,zeta,tau,regularization,delta,shape,t,p, lp__, lp_accum__, pstream__);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("z_beta");
        names__.push_back("global");
        names__.push_back("local");
        names__.push_back("S");
        names__.push_back("one_over_lambda");
        names__.push_back("z_b");
        names__.push_back("z_T");
        names__.push_back("rho");
        names__.push_back("zeta");
        names__.push_back("tau");
        names__.push_back("aux_unscaled");
        names__.push_back("noise");
        names__.push_back("aux");
        names__.push_back("beta");
        names__.push_back("b");
        names__.push_back("theta_L");
        names__.push_back("alpha");
        names__.push_back("mean_PPD");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hs);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))));
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(prior_dist,6));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_z_T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_rho);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_concentration);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_gt(family,1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(family,3));
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(len_theta_L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_intercept);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_count_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector<double> gamma;
        size_t dim_gamma_0__ = has_intercept;
        for (size_t k_0__ = 0; k_0__ < dim_gamma_0__; ++k_0__) {
            gamma.push_back(in__.scalar_lb_constrain((logical_eq(link,1) ? stan::math::negative_infinity() : 0.0 )));
        }
        vector_d z_beta = in__.vector_constrain((logical_eq(prior_dist,7) ? sum(num_normals) : K ));
        vector<double> global;
        size_t dim_global_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_global_0__; ++k_0__) {
            global.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> local;
        size_t dim_local_0__ = hs;
        for (size_t k_0__ = 0; k_0__ < dim_local_0__; ++k_0__) {
            local.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<vector_d> S;
        size_t dim_S_0__ = (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6)));
        for (size_t k_0__ = 0; k_0__ < dim_S_0__; ++k_0__) {
            S.push_back(in__.vector_lb_constrain(0,K));
        }
        vector<double> one_over_lambda;
        size_t dim_one_over_lambda_0__ = logical_eq(prior_dist,6);
        for (size_t k_0__ = 0; k_0__ < dim_one_over_lambda_0__; ++k_0__) {
            one_over_lambda.push_back(in__.scalar_lb_constrain(0));
        }
        vector_d z_b = in__.vector_constrain(q);
        vector_d z_T = in__.vector_constrain(len_z_T);
        vector_d rho = in__.vector_lub_constrain(0,1,len_rho);
        vector_d zeta = in__.vector_lb_constrain(0,len_concentration);
        vector_d tau = in__.vector_lb_constrain(0,t);
        vector<double> aux_unscaled;
        size_t dim_aux_unscaled_0__ = logical_gt(family,1);
        for (size_t k_0__ = 0; k_0__ < dim_aux_unscaled_0__; ++k_0__) {
            aux_unscaled.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> noise;
        size_t dim_noise_0__ = logical_eq(family,3);
        for (size_t k_0__ = 0; k_0__ < dim_noise_0__; ++k_0__) {
            noise.push_back(in__.vector_lb_constrain(0,N));
        }
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            vars__.push_back(z_beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
            vars__.push_back(global[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < hs; ++k_0__) {
                vars__.push_back(local[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                vars__.push_back(S[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < logical_eq(prior_dist,6); ++k_0__) {
            vars__.push_back(one_over_lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(z_b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_z_T; ++k_0__) {
            vars__.push_back(z_T[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_rho; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_concentration; ++k_0__) {
            vars__.push_back(zeta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < t; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < logical_gt(family,1); ++k_0__) {
            vars__.push_back(aux_unscaled[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < N; ++k_1__) {
            for (int k_0__ = 0; k_0__ < logical_eq(family,3); ++k_0__) {
                vars__.push_back(noise[k_0__][k_1__]);
            }
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double aux(0.0);
        (void) aux;  // dummy to suppress unused var warning
        stan::math::initialize(aux, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(aux,DUMMY_VAR__);
        stan::math::assign(aux,stan::math::negative_infinity());
        vector_d beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(q));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d theta_L(static_cast<Eigen::VectorXd::Index>(len_theta_L));
        (void) theta_L;  // dummy to suppress unused var warning
        stan::math::initialize(theta_L, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta_L,DUMMY_VAR__);


        try {
            if (as_bool(logical_eq(prior_dist,0))) {
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_dist,1))) {
                stan::math::assign(beta, add(elt_multiply(z_beta,prior_scale),prior_mean));
            } else if (as_bool(logical_eq(prior_dist,2))) {
                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((CFt(get_base1(z_beta,k,"z_beta",1),get_base1(prior_df,k,"prior_df",1), pstream__) * get_base1(prior_scale,k,"prior_scale",1)) + get_base1(prior_mean,k,"prior_mean",1)));
                }
            } else if (as_bool(logical_eq(prior_dist,3))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hs_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,4))) {

                if (as_bool((primitive_value(logical_eq(is_continuous,1)) && primitive_value(logical_eq(family,1))))) {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,aux, pstream__));
                } else {
                    stan::math::assign(beta, hsplus_prior(z_beta,global,local,global_prior_scale,1, pstream__));
                }
            } else if (as_bool(logical_eq(prior_dist,5))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(prior_scale,sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,6))) {
                stan::math::assign(beta, add(prior_mean,elt_multiply(elt_multiply(multiply(get_base1(one_over_lambda,1,"one_over_lambda",1),prior_scale),sqrt(multiply(2,get_base1(S,1,"S",1)))),z_beta)));
            } else if (as_bool(logical_eq(prior_dist,7))) {
                {
                    int z_pos(0);
                    (void) z_pos;  // dummy to suppress unused var warning
                    stan::math::fill(z_pos, std::numeric_limits<int>::min());
                    stan::math::assign(z_pos,1);


                    for (int k = 1; k <= K; ++k) {

                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), get_base1(z_beta,z_pos,"z_beta",1));
                        stan::math::assign(z_pos, (z_pos + 1));
                        for (int n = 2; n <= get_base1(num_normals,k,"num_normals",1); ++n) {

                            stan::math::assign(get_base1_lhs(beta,k,"beta",1), (get_base1(beta,k,"beta",1) * get_base1(z_beta,z_pos,"z_beta",1)));
                            stan::math::assign(z_pos, (z_pos + 1));
                        }
                        stan::math::assign(get_base1_lhs(beta,k,"beta",1), ((get_base1(beta,k,"beta",1) * pow(get_base1(prior_scale,k,"prior_scale",1),get_base1(num_normals,k,"num_normals",1))) + get_base1(prior_mean,k,"prior_mean",1)));
                    }
                }
            }
            if (as_bool((primitive_value(logical_gt(family,1)) && primitive_value((primitive_value(logical_eq(prior_dist_for_aux,0)) || primitive_value(logical_lte(prior_scale_for_aux,0))))))) {
                stan::math::assign(aux, get_base1(aux_unscaled,1,"aux_unscaled",1));
            } else if (as_bool(logical_gt(family,1))) {

                stan::math::assign(aux, (prior_scale_for_aux * get_base1(aux_unscaled,1,"aux_unscaled",1)));
                if (as_bool(logical_lte(prior_dist_for_aux,2))) {
                    stan::math::assign(aux, (aux + prior_mean_for_aux));
                }
            }
            if (as_bool(logical_gt(t,0))) {

                if (as_bool(logical_eq(special_case,1))) {
                    {
                        int start(0);
                        (void) start;  // dummy to suppress unused var warning
                        stan::math::fill(start, std::numeric_limits<int>::min());
                        stan::math::assign(start,1);


                        stan::math::assign(theta_L, (logical_eq(family,1) ? stan::math::promote_scalar<double>(tau) : stan::math::promote_scalar<double>(multiply(tau,aux)) ));
                        if (as_bool(logical_eq(t,1))) {
                            stan::math::assign(b, multiply(get_base1(theta_L,1,"theta_L",1),z_b));
                        } else {
                            for (int i = 1; i <= t; ++i) {
                                {
                                    int end(0);
                                    (void) end;  // dummy to suppress unused var warning
                                    stan::math::fill(end, std::numeric_limits<int>::min());
                                    stan::math::assign(end,((start + get_base1(l,i,"l",1)) - 1));


                                    stan::model::assign(b, 
                                                stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), 
                                                multiply(get_base1(theta_L,i,"theta_L",1),stan::model::rvalue(z_b, stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list()), "z_b")), 
                                                "assigning variable b");
                                    stan::math::assign(start, (end + 1));
                                }
                            }
                        }
                    }
                } else {

                    if (as_bool(logical_eq(family,1))) {
                        stan::math::assign(theta_L, make_theta_L(len_theta_L,p,1.0,tau,scale,zeta,rho,z_T, pstream__));
                    } else {
                        stan::math::assign(theta_L, make_theta_L(len_theta_L,p,aux,tau,scale,zeta,rho,z_T, pstream__));
                    }
                    stan::math::assign(b, make_b(z_b,theta_L,p,l, pstream__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        vars__.push_back(aux);
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < q; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < len_theta_L; ++k_0__) {
            vars__.push_back(theta_L[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> alpha(has_intercept, 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        double mean_PPD(0.0);
        (void) mean_PPD;  // dummy to suppress unused var warning
        stan::math::initialize(mean_PPD, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mean_PPD,DUMMY_VAR__);
        stan::math::assign(mean_PPD,0);


        try {
            if (as_bool(logical_eq(has_intercept,1))) {

                if (as_bool(dense_X)) {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(gamma,1,"gamma",1) - dot_product(xbar,beta)));
                } else {
                    stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), get_base1(gamma,1,"gamma",1));
                }
            }
            {
                vector_d nu(static_cast<Eigen::VectorXd::Index>(N));
                (void) nu;  // dummy to suppress unused var warning
                stan::math::initialize(nu, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(nu,DUMMY_VAR__);
                vector_d eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                if (as_bool(logical_gt(t,0))) {

                    if (as_bool(special_case)) {
                        for (int i = 1; i <= t; ++i) {
                            stan::math::assign(eta, add(eta,stan::model::rvalue(b, stan::model::cons_list(stan::model::index_multi(get_base1(V,i,"V",1)), stan::model::nil_index_list()), "b")));
                        }
                    } else {
                        stan::math::assign(eta, add(eta,csr_matrix_times_vector(N,q,w,v,u,b)));
                    }
                }
                if (as_bool(logical_eq(has_intercept,1))) {

                    if (as_bool(logical_eq(link,1))) {
                        stan::math::assign(eta, add(eta,get_base1(gamma,1,"gamma",1)));
                    } else {
                        {
                            double shift(0.0);
                            (void) shift;  // dummy to suppress unused var warning
                            stan::math::initialize(shift, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(shift,DUMMY_VAR__);


                            stan::math::assign(shift, min(eta));
                            stan::math::assign(eta, add(subtract(eta,shift),get_base1(gamma,1,"gamma",1)));
                            stan::math::assign(get_base1_lhs(alpha,1,"alpha",1), (get_base1(alpha,1,"alpha",1) - shift));
                        }
                    }
                } else {

                    stan::math::assign(eta, add(eta,dot_product(xbar,beta)));
                }
                if (as_bool(logical_eq(family,3))) {

                    if (as_bool(logical_eq(link,1))) {
                        stan::math::assign(eta, add(add(eta,log(aux)),log(get_base1(noise,1,"noise",1))));
                    } else if (as_bool(logical_eq(link,2))) {
                        stan::math::assign(eta, elt_multiply(multiply(eta,aux),get_base1(noise,1,"noise",1)));
                    } else {
                        stan::math::assign(eta, add(add(eta,sqrt(aux)),sqrt(get_base1(noise,1,"noise",1))));
                    }
                }
                stan::math::assign(nu, linkinv_count(eta,link, pstream__));
                if (as_bool(logical_neq(family,2))) {
                    for (int n = 1; n <= N; ++n) {

                        if (as_bool(logical_lt(get_base1(nu,n,"nu",1),poisson_max))) {
                            stan::math::assign(mean_PPD, (mean_PPD + poisson_rng(get_base1(nu,n,"nu",1), base_rng__)));
                        } else {
                            stan::math::assign(mean_PPD, (mean_PPD + normal_rng(get_base1(nu,n,"nu",1),sqrt(get_base1(nu,n,"nu",1)), base_rng__)));
                        }
                    }
                } else {
                    for (int n = 1; n <= N; ++n) {
                        {
                            double gamma_temp(0.0);
                            (void) gamma_temp;  // dummy to suppress unused var warning
                            stan::math::initialize(gamma_temp, std::numeric_limits<double>::quiet_NaN());
                            stan::math::fill(gamma_temp,DUMMY_VAR__);


                            if (as_bool(is_inf(aux))) {
                                stan::math::assign(gamma_temp, get_base1(nu,n,"nu",1));
                            } else {
                                stan::math::assign(gamma_temp, gamma_rng(aux,(aux / get_base1(nu,n,"nu",1)), base_rng__));
                            }
                            if (as_bool(logical_lt(gamma_temp,poisson_max))) {
                                stan::math::assign(mean_PPD, (mean_PPD + poisson_rng(gamma_temp, base_rng__)));
                            } else {
                                stan::math::assign(mean_PPD, (mean_PPD + normal_rng(gamma_temp,sqrt(gamma_temp), base_rng__)));
                            }
                        }
                    }
                }
                stan::math::assign(mean_PPD, (mean_PPD / N));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < has_intercept; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        vars__.push_back(mean_PPD);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_count";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= logical_gt(family,1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux_unscaled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= logical_eq(family,3); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "noise" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "aux";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (logical_eq(prior_dist,7) ? sum(num_normals) : K ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "global" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= hs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "local" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= (primitive_value(logical_eq(prior_dist,5)) || primitive_value(logical_eq(prior_dist,6))); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "S" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= logical_eq(prior_dist,6); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "one_over_lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_z_T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_T" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_rho; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_concentration; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= t; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= logical_gt(family,1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux_unscaled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= logical_eq(family,3); ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "noise" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "aux";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= q; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= len_theta_L; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_L" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= has_intercept; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_PPD";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_lm_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type
ll_mvn_ols_qr_lp(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& theta,
                     const Eigen::Matrix<T1__, Eigen::Dynamic,1>& b,
                     const T2__& intercept,
                     const T3__& ybar,
                     const T4__& SSR,
                     const T5__& sigma,
                     const int& N, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        lp_accum__.add((((-(0.5) * ((dot_self(subtract(theta,b)) + (N * square((intercept - ybar)))) + SSR)) / square(sigma)) - (N * (log(sigma) + 0.91893853320467267))));
        return stan::math::promote_scalar<fun_return_scalar_t__>(get_lp(lp__, lp_accum__));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct ll_mvn_ols_qr_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& theta,
                     const Eigen::Matrix<T1__, Eigen::Dynamic,1>& b,
                     const T2__& intercept,
                     const T3__& ybar,
                     const T4__& SSR,
                     const T5__& sigma,
                     const int& N, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return ll_mvn_ols_qr_lp(theta, b, intercept, ybar, SSR, sigma, N, lp__, lp_accum__, pstream__);
    }
};

class model_lm : public prob_grad {
private:
    int has_intercept;
    int prior_dist_for_intercept;
    double prior_scale_for_intercept;
    double prior_mean_for_intercept;
    int prior_dist;
    int prior_PD;
    double eta;
    int J;
    vector<int> N;
    int K;
    vector<vector_d> xbarR_inv;
    vector<double> ybar;
    double center_y;
    vector<double> s_Y;
    vector<vector_d> Rb;
    vector<double> SSR;
    vector<matrix_d> R_inv;
    double half_K;
    vector<double> sqrt_inv_N;
    vector<double> sqrt_Nm1;
public:
    model_lm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_lm(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_lm_namespace::model_lm";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
        has_intercept = int(0);
        vals_i__ = context__.vals_i("has_intercept");
        pos__ = 0;
        has_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec());
        prior_dist_for_intercept = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept");
        pos__ = 0;
        prior_dist_for_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_scale_for_intercept", "double", context__.to_vec());
        prior_scale_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_scale_for_intercept");
        pos__ = 0;
        prior_scale_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_mean_for_intercept", "double", context__.to_vec());
        prior_mean_for_intercept = double(0);
        vals_r__ = context__.vals_r("prior_mean_for_intercept");
        pos__ = 0;
        prior_mean_for_intercept = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
        prior_dist = int(0);
        vals_i__ = context__.vals_i("prior_dist");
        pos__ = 0;
        prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
        prior_PD = int(0);
        vals_i__ = context__.vals_i("prior_PD");
        pos__ = 0;
        prior_PD = vals_i__[pos__++];
        context__.validate_dims("data initialization", "eta", "double", context__.to_vec());
        eta = double(0);
        vals_r__ = context__.vals_r("eta");
        pos__ = 0;
        eta = vals_r__[pos__++];
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(J));
        validate_non_negative_index("N", "J", J);
        N = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        validate_non_negative_index("xbarR_inv", "J", J);
        validate_non_negative_index("xbarR_inv", "K", K);
        xbarR_inv = std::vector<vector_d>(J,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        context__.validate_dims("data initialization", "xbarR_inv", "vector_d", context__.to_vec(J,K));
        vals_r__ = context__.vals_r("xbarR_inv");
        pos__ = 0;
        size_t xbarR_inv_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < xbarR_inv_i_vec_lim__; ++i_vec__) {
            size_t xbarR_inv_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < xbarR_inv_limit_0__; ++i_0__) {
                xbarR_inv[i_0__][i_vec__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "ybar", "double", context__.to_vec(J));
        validate_non_negative_index("ybar", "J", J);
        ybar = std::vector<double>(J,double(0));
        vals_r__ = context__.vals_r("ybar");
        pos__ = 0;
        size_t ybar_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ybar_limit_0__; ++i_0__) {
            ybar[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "center_y", "double", context__.to_vec());
        center_y = double(0);
        vals_r__ = context__.vals_r("center_y");
        pos__ = 0;
        center_y = vals_r__[pos__++];
        context__.validate_dims("data initialization", "s_Y", "double", context__.to_vec(J));
        validate_non_negative_index("s_Y", "J", J);
        s_Y = std::vector<double>(J,double(0));
        vals_r__ = context__.vals_r("s_Y");
        pos__ = 0;
        size_t s_Y_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < s_Y_limit_0__; ++i_0__) {
            s_Y[i_0__] = vals_r__[pos__++];
        }
        validate_non_negative_index("Rb", "J", J);
        validate_non_negative_index("Rb", "K", K);
        Rb = std::vector<vector_d>(J,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        context__.validate_dims("data initialization", "Rb", "vector_d", context__.to_vec(J,K));
        vals_r__ = context__.vals_r("Rb");
        pos__ = 0;
        size_t Rb_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < Rb_i_vec_lim__; ++i_vec__) {
            size_t Rb_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < Rb_limit_0__; ++i_0__) {
                Rb[i_0__][i_vec__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "SSR", "double", context__.to_vec(J));
        validate_non_negative_index("SSR", "J", J);
        SSR = std::vector<double>(J,double(0));
        vals_r__ = context__.vals_r("SSR");
        pos__ = 0;
        size_t SSR_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < SSR_limit_0__; ++i_0__) {
            SSR[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "R_inv", "matrix_d", context__.to_vec(J,K,K));
        validate_non_negative_index("R_inv", "J", J);
        validate_non_negative_index("R_inv", "K", K);
        validate_non_negative_index("R_inv", "K", K);
        R_inv = std::vector<matrix_d>(J,matrix_d(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("R_inv");
        pos__ = 0;
        size_t R_inv_m_mat_lim__ = K;
        size_t R_inv_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < R_inv_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < R_inv_m_mat_lim__; ++m_mat__) {
                size_t R_inv_limit_0__ = J;
                for (size_t i_0__ = 0; i_0__ < R_inv_limit_0__; ++i_0__) {
                    R_inv[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"has_intercept",has_intercept,0);
        check_less_or_equal(function__,"has_intercept",has_intercept,1);
        check_greater_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,0);
        check_less_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,1);
        check_greater_or_equal(function__,"prior_scale_for_intercept",prior_scale_for_intercept,0);
        check_greater_or_equal(function__,"prior_dist",prior_dist,0);
        check_less_or_equal(function__,"prior_dist",prior_dist,1);
        check_greater_or_equal(function__,"prior_PD",prior_PD,0);
        check_less_or_equal(function__,"prior_PD",prior_PD,1);
        check_greater_or_equal(function__,"eta",eta,0);
        check_greater_or_equal(function__,"J",J,1);
        for (int k0__ = 0; k0__ < J; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        check_greater_or_equal(function__,"K",K,1);
        check_less_or_equal(function__,"K",K,min(N));
        for (int k0__ = 0; k0__ < J; ++k0__) {
            check_greater_or_equal(function__,"s_Y[k0__]",s_Y[k0__],0);
        }
        for (int k0__ = 0; k0__ < J; ++k0__) {
            check_greater_or_equal(function__,"SSR[k0__]",SSR[k0__],0);
        }
        // initialize data variables
        half_K = double(0);
        stan::math::fill(half_K,DUMMY_VAR__);
        stan::math::assign(half_K,(0.5 * K));
        validate_non_negative_index("sqrt_inv_N", "J", J);
        sqrt_inv_N = std::vector<double>(J,double(0));
        stan::math::fill(sqrt_inv_N,DUMMY_VAR__);
        validate_non_negative_index("sqrt_Nm1", "J", J);
        sqrt_Nm1 = std::vector<double>(J,double(0));
        stan::math::fill(sqrt_Nm1,DUMMY_VAR__);

        try {
            for (int j = 1; j <= J; ++j) {

                stan::math::assign(get_base1_lhs(sqrt_inv_N,j,"sqrt_inv_N",1), sqrt((1.0 / get_base1(N,j,"N",1))));
                stan::math::assign(get_base1_lhs(sqrt_Nm1,j,"sqrt_Nm1",1), sqrt((get_base1(N,j,"N",1) - 1.0)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += (K) * J;
        num_params_r__ += (J * has_intercept);
        num_params_r__ += J;
        num_params_r__ += (J * (1 - prior_PD));
    }

    ~model_lm() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("u")))
            throw std::runtime_error("variable u missing");
        vals_r__ = context__.vals_r("u");
        pos__ = 0U;
        context__.validate_dims("initialization", "u", "vector_d", context__.to_vec(J,K));
        // generate_declaration u
        std::vector<vector_d> u(J,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < J; ++i0__)
                u[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.unit_vector_unconstrain(u[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable u: ") + e.what());
        }

        if (!(context__.contains_r("z_alpha")))
            throw std::runtime_error("variable z_alpha missing");
        vals_r__ = context__.vals_r("z_alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_alpha", "double", context__.to_vec((J * has_intercept)));
        // generate_declaration z_alpha
        std::vector<double> z_alpha((J * has_intercept),double(0));
        for (int i0__ = 0U; i0__ < (J * has_intercept); ++i0__)
            z_alpha[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (J * has_intercept); ++i0__)
            try {
            writer__.scalar_unconstrain(z_alpha[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_alpha: ") + e.what());
        }

        if (!(context__.contains_r("R2")))
            throw std::runtime_error("variable R2 missing");
        vals_r__ = context__.vals_r("R2");
        pos__ = 0U;
        context__.validate_dims("initialization", "R2", "double", context__.to_vec(J));
        // generate_declaration R2
        std::vector<double> R2(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            R2[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(0,1,R2[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable R2: ") + e.what());
        }

        if (!(context__.contains_r("log_omega")))
            throw std::runtime_error("variable log_omega missing");
        vals_r__ = context__.vals_r("log_omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "log_omega", "vector_d", context__.to_vec((J * (1 - prior_PD))));
        // generate_declaration log_omega
        vector_d log_omega(static_cast<Eigen::VectorXd::Index>((J * (1 - prior_PD))));
        for (int j1__ = 0U; j1__ < (J * (1 - prior_PD)); ++j1__)
            log_omega(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(log_omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable log_omega: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > u;
        size_t dim_u_0__ = J;
        u.reserve(dim_u_0__);
        for (size_t k_0__ = 0; k_0__ < dim_u_0__; ++k_0__) {
            if (jacobian__)
                u.push_back(in__.unit_vector_constrain(K,lp__));
            else
                u.push_back(in__.unit_vector_constrain(K));
        }

        vector<T__> z_alpha;
        size_t dim_z_alpha_0__ = (J * has_intercept);
        z_alpha.reserve(dim_z_alpha_0__);
        for (size_t k_0__ = 0; k_0__ < dim_z_alpha_0__; ++k_0__) {
            if (jacobian__)
                z_alpha.push_back(in__.scalar_constrain(lp__));
            else
                z_alpha.push_back(in__.scalar_constrain());
        }

        vector<T__> R2;
        size_t dim_R2_0__ = J;
        R2.reserve(dim_R2_0__);
        for (size_t k_0__ = 0; k_0__ < dim_R2_0__; ++k_0__) {
            if (jacobian__)
                R2.push_back(in__.scalar_lub_constrain(0,1,lp__));
            else
                R2.push_back(in__.scalar_lub_constrain(0,1));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  log_omega;
        (void) log_omega;  // dummy to suppress unused var warning
        if (jacobian__)
            log_omega = in__.vector_constrain((J * (1 - prior_PD)),lp__);
        else
            log_omega = in__.vector_constrain((J * (1 - prior_PD)));


        // transformed parameters
        vector<T__> alpha((J * has_intercept));
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > theta(J, (Eigen::Matrix<T__,Eigen::Dynamic,1> (static_cast<Eigen::VectorXd::Index>(K))));
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta,DUMMY_VAR__);
        vector<T__> sigma(J);
        stan::math::initialize(sigma, DUMMY_VAR__);
        stan::math::fill(sigma,DUMMY_VAR__);


        try {
            for (int j = 1; j <= J; ++j) {
                {
                    T__ Delta_y;
                    (void) Delta_y;  // dummy to suppress unused var warning
                    stan::math::initialize(Delta_y, DUMMY_VAR__);
                    stan::math::fill(Delta_y,DUMMY_VAR__);
                    stan::math::assign(Delta_y,(logical_eq(prior_PD,0) ? stan::math::promote_scalar<T__>((get_base1(s_Y,j,"s_Y",1) * exp(get_base1(log_omega,j,"log_omega",1)))) : stan::math::promote_scalar<T__>(1) ));


                    if (as_bool(logical_gt(K,1))) {
                        stan::math::assign(get_base1_lhs(theta,j,"theta",1), multiply(multiply(multiply(get_base1(u,j,"u",1),sqrt(get_base1(R2,j,"R2",1))),get_base1(sqrt_Nm1,j,"sqrt_Nm1",1)),Delta_y));
                    } else {
                        stan::math::assign(get_base1_lhs(get_base1_lhs(theta,j,"theta",1),1,"theta",2), (((get_base1(get_base1(u,j,"u",1),1,"u",2) * sqrt(get_base1(R2,j,"R2",1))) * get_base1(sqrt_Nm1,j,"sqrt_Nm1",1)) * Delta_y));
                    }
                    stan::math::assign(get_base1_lhs(sigma,j,"sigma",1), (Delta_y * sqrt((1 - get_base1(R2,j,"R2",1)))));
                    if (as_bool(logical_eq(has_intercept,1))) {

                        if (as_bool(logical_eq(prior_dist_for_intercept,0))) {
                            stan::math::assign(get_base1_lhs(alpha,j,"alpha",1), get_base1(z_alpha,j,"z_alpha",1));
                        } else if (as_bool(logical_eq(prior_scale_for_intercept,0))) {
                            stan::math::assign(get_base1_lhs(alpha,j,"alpha",1), (((get_base1(z_alpha,j,"z_alpha",1) * Delta_y) * get_base1(sqrt_inv_N,j,"sqrt_inv_N",1)) + prior_mean_for_intercept));
                        } else {
                            stan::math::assign(get_base1_lhs(alpha,j,"alpha",1), ((get_base1(z_alpha,j,"z_alpha",1) * prior_scale_for_intercept) + prior_mean_for_intercept));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < (J * has_intercept); ++i0__) {
            if (stan::math::is_uninitialized(alpha[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < J; ++i0__) {
            for (int i1__ = 0; i1__ < K; ++i1__) {
                if (stan::math::is_uninitialized(theta[i0__](i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(sigma[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sigma" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < J; ++k0__) {
            check_greater_or_equal(function__,"sigma[k0__]",sigma[k0__],0);
        }

        // model body
        try {

            for (int j = 1; j <= J; ++j) {

                if (as_bool(logical_eq(prior_PD,0))) {
                    {
                        T__ dummy;
                        (void) dummy;  // dummy to suppress unused var warning
                        stan::math::initialize(dummy, DUMMY_VAR__);
                        stan::math::fill(dummy,DUMMY_VAR__);
                        T__ shift;
                        (void) shift;  // dummy to suppress unused var warning
                        stan::math::initialize(shift, DUMMY_VAR__);
                        stan::math::fill(shift,DUMMY_VAR__);


                        stan::math::assign(shift, dot_product(get_base1(xbarR_inv,j,"xbarR_inv",1),get_base1(theta,j,"theta",1)));
                        stan::math::assign(dummy, ll_mvn_ols_qr_lp(get_base1(theta,j,"theta",1),get_base1(Rb,j,"Rb",1),(logical_eq(has_intercept,1) ? stan::math::promote_scalar<T__>((get_base1(alpha,j,"alpha",1) + shift)) : stan::math::promote_scalar<T__>(shift) ),get_base1(ybar,j,"ybar",1),get_base1(SSR,j,"SSR",1),get_base1(sigma,j,"sigma",1),get_base1(N,j,"N",1), lp__, lp_accum__, pstream__));
                    }
                }
            }
            if (as_bool((primitive_value(logical_eq(has_intercept,1)) && primitive_value(logical_gt(prior_dist_for_intercept,0))))) {
                lp_accum__.add(normal_log(z_alpha,0,1));
            }
            if (as_bool(logical_eq(prior_dist,1))) {
                lp_accum__.add(beta_log(R2,half_K,eta));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("u");
        names__.push_back("z_alpha");
        names__.push_back("R2");
        names__.push_back("log_omega");
        names__.push_back("alpha");
        names__.push_back("theta");
        names__.push_back("sigma");
        names__.push_back("mean_PPD");
        names__.push_back("beta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J * has_intercept));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J * (1 - prior_PD)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J * has_intercept));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_lm_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector<vector_d> u;
        size_t dim_u_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_u_0__; ++k_0__) {
            u.push_back(in__.unit_vector_constrain(K));
        }
        vector<double> z_alpha;
        size_t dim_z_alpha_0__ = (J * has_intercept);
        for (size_t k_0__ = 0; k_0__ < dim_z_alpha_0__; ++k_0__) {
            z_alpha.push_back(in__.scalar_constrain());
        }
        vector<double> R2;
        size_t dim_R2_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_R2_0__; ++k_0__) {
            R2.push_back(in__.scalar_lub_constrain(0,1));
        }
        vector_d log_omega = in__.vector_constrain((J * (1 - prior_PD)));
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
                vars__.push_back(u[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < (J * has_intercept); ++k_0__) {
            vars__.push_back(z_alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(R2[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (J * (1 - prior_PD)); ++k_0__) {
            vars__.push_back(log_omega[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> alpha((J * has_intercept), 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<vector_d> theta(J, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
        stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta,DUMMY_VAR__);
        vector<double> sigma(J, 0.0);
        stan::math::initialize(sigma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(sigma,DUMMY_VAR__);


        try {
            for (int j = 1; j <= J; ++j) {
                {
                    double Delta_y(0.0);
                    (void) Delta_y;  // dummy to suppress unused var warning
                    stan::math::initialize(Delta_y, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(Delta_y,DUMMY_VAR__);
                    stan::math::assign(Delta_y,(logical_eq(prior_PD,0) ? stan::math::promote_scalar<double>((get_base1(s_Y,j,"s_Y",1) * exp(get_base1(log_omega,j,"log_omega",1)))) : stan::math::promote_scalar<double>(1) ));


                    if (as_bool(logical_gt(K,1))) {
                        stan::math::assign(get_base1_lhs(theta,j,"theta",1), multiply(multiply(multiply(get_base1(u,j,"u",1),sqrt(get_base1(R2,j,"R2",1))),get_base1(sqrt_Nm1,j,"sqrt_Nm1",1)),Delta_y));
                    } else {
                        stan::math::assign(get_base1_lhs(get_base1_lhs(theta,j,"theta",1),1,"theta",2), (((get_base1(get_base1(u,j,"u",1),1,"u",2) * sqrt(get_base1(R2,j,"R2",1))) * get_base1(sqrt_Nm1,j,"sqrt_Nm1",1)) * Delta_y));
                    }
                    stan::math::assign(get_base1_lhs(sigma,j,"sigma",1), (Delta_y * sqrt((1 - get_base1(R2,j,"R2",1)))));
                    if (as_bool(logical_eq(has_intercept,1))) {

                        if (as_bool(logical_eq(prior_dist_for_intercept,0))) {
                            stan::math::assign(get_base1_lhs(alpha,j,"alpha",1), get_base1(z_alpha,j,"z_alpha",1));
                        } else if (as_bool(logical_eq(prior_scale_for_intercept,0))) {
                            stan::math::assign(get_base1_lhs(alpha,j,"alpha",1), (((get_base1(z_alpha,j,"z_alpha",1) * Delta_y) * get_base1(sqrt_inv_N,j,"sqrt_inv_N",1)) + prior_mean_for_intercept));
                        } else {
                            stan::math::assign(get_base1_lhs(alpha,j,"alpha",1), ((get_base1(z_alpha,j,"z_alpha",1) * prior_scale_for_intercept) + prior_mean_for_intercept));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < J; ++k0__) {
            check_greater_or_equal(function__,"sigma[k0__]",sigma[k0__],0);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < (J * has_intercept); ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
                vars__.push_back(theta[k_0__][k_1__]);
            }
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<double> mean_PPD(J, 0.0);
        stan::math::initialize(mean_PPD, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mean_PPD,DUMMY_VAR__);
        vector<vector_d> beta(J, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int j = 1; j <= J; ++j) {
                {
                    double shift(0.0);
                    (void) shift;  // dummy to suppress unused var warning
                    stan::math::initialize(shift, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(shift,DUMMY_VAR__);


                    stan::math::assign(shift, dot_product(get_base1(xbarR_inv,j,"xbarR_inv",1),get_base1(theta,j,"theta",1)));
                    stan::math::assign(get_base1_lhs(mean_PPD,j,"mean_PPD",1), normal_rng((logical_eq(has_intercept,1) ? stan::math::promote_scalar<double>((get_base1(alpha,j,"alpha",1) + shift)) : stan::math::promote_scalar<double>(shift) ),(get_base1(sigma,j,"sigma",1) * get_base1(sqrt_inv_N,j,"sqrt_inv_N",1)), base_rng__));
                    stan::math::assign(get_base1_lhs(beta,j,"beta",1), multiply(get_base1(R_inv,j,"R_inv",1),get_base1(theta,j,"theta",1)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mean_PPD[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
                vars__.push_back(beta[k_0__][k_1__]);
            }
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_lm";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "u" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= (J * has_intercept); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R2" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (J * (1 - prior_PD)); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= (J * has_intercept); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mean_PPD" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "u" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= (J * has_intercept); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R2" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (J * (1 - prior_PD)); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= (J * has_intercept); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mean_PPD" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_polr_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
CDF_polr(const T0__& x,
             const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        if (as_bool(logical_eq(link,1))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_logit(x));
        } else if (as_bool(logical_eq(link,2))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(Phi(x));
        } else if (as_bool(logical_eq(link,3))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(gumbel_cdf(x,0,1));
        } else if (as_bool(logical_eq(link,4))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_cloglog(x));
        } else if (as_bool(logical_eq(link,5))) {
            return stan::math::promote_scalar<fun_return_scalar_t__>(cauchy_cdf(x,0,1));
        } else {
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(x);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct CDF_polr_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& x,
             const int& link, std::ostream* pstream__) const {
        return CDF_polr(x, link, pstream__);
    }
};

template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic,1>
pw_polr(const std::vector<int>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const Eigen::Matrix<T2__, Eigen::Dynamic,1>& cutpoints,
            const int& link,
            const T4__& alpha, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int N(0);
            (void) N;  // dummy to suppress unused var warning
            stan::math::fill(N, std::numeric_limits<int>::min());
            stan::math::assign(N,rows(eta));
            int J(0);
            (void) J;  // dummy to suppress unused var warning
            stan::math::fill(J, std::numeric_limits<int>::min());
            stan::math::assign(J,(rows(cutpoints) + 1));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ll(static_cast<Eigen::VectorXd::Index>(N));
            (void) ll;  // dummy to suppress unused var warning
            stan::math::initialize(ll, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ll,DUMMY_VAR__);


            if (as_bool((primitive_value(logical_lt(link,1)) || primitive_value(logical_gt(link,5))))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(alpha,1))) {
                for (int n = 1; n <= N; ++n) {

                    if (as_bool(logical_eq(get_base1(y,n,"y",1),1))) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), CDF_polr((get_base1(cutpoints,1,"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__));
                    } else if (as_bool(logical_eq(get_base1(y,n,"y",1),J))) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), (1 - CDF_polr((get_base1(cutpoints,(J - 1),"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__)));
                    } else {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), (CDF_polr((get_base1(cutpoints,get_base1(y,n,"y",1),"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__) - CDF_polr((get_base1(cutpoints,(get_base1(y,n,"y",1) - 1),"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__)));
                    }
                }
            } else {
                for (int n = 1; n <= N; ++n) {

                    if (as_bool(logical_eq(get_base1(y,n,"y",1),1))) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), pow(CDF_polr((get_base1(cutpoints,1,"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__),alpha));
                    } else if (as_bool(logical_eq(get_base1(y,n,"y",1),J))) {
                        stan::math::assign(get_base1_lhs(ll,n,"ll",1), (1 - pow(CDF_polr((get_base1(cutpoints,(J - 1),"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__),alpha)));
                    } else {
                        std::stringstream errmsg_stream__;
                        errmsg_stream__ << "alpha not allowed with more than 2 outcome categories";
                        throw std::domain_error(errmsg_stream__.str());
                    }
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(log(ll));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pw_polr_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic,1>
    operator()(const std::vector<int>& y,
            const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta,
            const Eigen::Matrix<T2__, Eigen::Dynamic,1>& cutpoints,
            const int& link,
            const T4__& alpha, std::ostream* pstream__) const {
        return pw_polr(y, eta, cutpoints, link, alpha, pstream__);
    }
};

template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
make_cutpoints(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& probabilities,
                   const T1__& scale,
                   const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int C(0);
            (void) C;  // dummy to suppress unused var warning
            stan::math::fill(C, std::numeric_limits<int>::min());
            stan::math::assign(C,(rows(probabilities) - 1));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  cutpoints(static_cast<Eigen::VectorXd::Index>(C));
            (void) cutpoints;  // dummy to suppress unused var warning
            stan::math::initialize(cutpoints, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(cutpoints,DUMMY_VAR__);
            fun_scalar_t__ running_sum;
            (void) running_sum;  // dummy to suppress unused var warning
            stan::math::initialize(running_sum, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(running_sum,DUMMY_VAR__);
            stan::math::assign(running_sum,0);


            if (as_bool(logical_eq(link,1))) {
                for (int c = 1; c <= C; ++c) {

                    stan::math::assign(running_sum, (running_sum + get_base1(probabilities,c,"probabilities",1)));
                    stan::math::assign(get_base1_lhs(cutpoints,c,"cutpoints",1), logit(running_sum));
                }
            } else if (as_bool(logical_eq(link,2))) {
                for (int c = 1; c <= C; ++c) {

                    stan::math::assign(running_sum, (running_sum + get_base1(probabilities,c,"probabilities",1)));
                    stan::math::assign(get_base1_lhs(cutpoints,c,"cutpoints",1), inv_Phi(running_sum));
                }
            } else if (as_bool(logical_eq(link,3))) {
                for (int c = 1; c <= C; ++c) {

                    stan::math::assign(running_sum, (running_sum + get_base1(probabilities,c,"probabilities",1)));
                    stan::math::assign(get_base1_lhs(cutpoints,c,"cutpoints",1), -(log(-(log(running_sum)))));
                }
            } else if (as_bool(logical_eq(link,4))) {
                for (int c = 1; c <= C; ++c) {

                    stan::math::assign(running_sum, (running_sum + get_base1(probabilities,c,"probabilities",1)));
                    stan::math::assign(get_base1_lhs(cutpoints,c,"cutpoints",1), log(-(log1m(running_sum))));
                }
            } else if (as_bool(logical_eq(link,5))) {
                for (int c = 1; c <= C; ++c) {

                    stan::math::assign(running_sum, (running_sum + get_base1(probabilities,c,"probabilities",1)));
                    stan::math::assign(get_base1_lhs(cutpoints,c,"cutpoints",1), tan((stan::math::pi() * (running_sum - 0.5))));
                }
            } else {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(scale,cutpoints));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct make_cutpoints_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& probabilities,
                   const T1__& scale,
                   const int& link, std::ostream* pstream__) const {
        return make_cutpoints(probabilities, scale, link, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, class RNG>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
draw_ystar_rng(const T0__& lower,
                   const T1__& upper,
                   const T2__& eta,
                   const int& link, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int iter(0);
            (void) iter;  // dummy to suppress unused var warning
            stan::math::fill(iter, std::numeric_limits<int>::min());
            stan::math::assign(iter,0);
            fun_scalar_t__ ystar;
            (void) ystar;  // dummy to suppress unused var warning
            stan::math::initialize(ystar, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ystar,DUMMY_VAR__);
            stan::math::assign(ystar,stan::math::not_a_number());


            if (as_bool(logical_gte(lower,upper))) {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "lower must be less than upper";
                throw std::domain_error(errmsg_stream__.str());
            }
            if (as_bool(logical_eq(link,1))) {
                while (as_bool(logical_negation((primitive_value(logical_gt(ystar,lower)) && primitive_value(logical_lt(ystar,upper)))))) {
                    stan::math::assign(ystar, logistic_rng(eta,1, base_rng__));
                }
            } else if (as_bool(logical_eq(link,2))) {
                while (as_bool(logical_negation((primitive_value(logical_gt(ystar,lower)) && primitive_value(logical_lt(ystar,upper)))))) {
                    stan::math::assign(ystar, normal_rng(eta,1, base_rng__));
                }
            } else if (as_bool(logical_eq(link,3))) {
                while (as_bool(logical_negation((primitive_value(logical_gt(ystar,lower)) && primitive_value(logical_lt(ystar,upper)))))) {
                    stan::math::assign(ystar, gumbel_rng(eta,1, base_rng__));
                }
            } else if (as_bool(logical_eq(link,4))) {
                while (as_bool(logical_negation((primitive_value(logical_gt(ystar,lower)) && primitive_value(logical_lt(ystar,upper)))))) {
                    stan::math::assign(ystar, log(-(log1m(uniform_rng(0,1, base_rng__)))));
                }
            } else if (as_bool(logical_eq(link,5))) {
                while (as_bool(logical_negation((primitive_value(logical_gt(ystar,lower)) && primitive_value(logical_lt(ystar,upper)))))) {
                    stan::math::assign(ystar, cauchy_rng(eta,1, base_rng__));
                }
            } else {
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "invalid link";
                throw std::domain_error(errmsg_stream__.str());
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(ystar);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct draw_ystar_rng_functor__ {
    template <typename T0__, typename T1__, typename T2__, class RNG>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& lower,
                   const T1__& upper,
                   const T2__& eta,
                   const int& link, RNG& base_rng__, std::ostream* pstream__) const {
        return draw_ystar_rng(lower, upper, eta, link, base_rng__, pstream__);
    }
};

class model_polr : public prob_grad {
private:
    int N;
    int K;
    vector_d xbar;
    int dense_X;
    vector<matrix_d> X;
    int nnz_X;
    vector_d w_X;
    vector<int> v_X;
    vector<int> u_X;
    int J;
    vector<int> y;
    int prior_PD;
    int has_intercept;
    int family;
    int link;
    int prior_dist;
    int prior_dist_for_intercept;
    int prior_dist_for_aux;
    int has_weights;
    vector_d weights;
    int has_offset;
    vector_d offset;
    double regularization;
    vector_d prior_counts;
    int is_skewed;
    double shape;
    double rate;
    int do_residuals;
    double half_K;
    double sqrt_Nm1;
    int is_constant;
public:
    model_polr(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_polr(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_polr_namespace::model_polr";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        validate_non_negative_index("xbar", "K", K);
        xbar = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "xbar", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("xbar");
        pos__ = 0;
        size_t xbar_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < xbar_i_vec_lim__; ++i_vec__) {
            xbar[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "dense_X", "int", context__.to_vec());
        dense_X = int(0);
        vals_i__ = context__.vals_i("dense_X");
        pos__ = 0;
        dense_X = vals_i__[pos__++];
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(dense_X,N,K));
        validate_non_negative_index("X", "dense_X", dense_X);
        validate_non_negative_index("X", "N", N);
        validate_non_negative_index("X", "K", K);
        X = std::vector<matrix_d>(dense_X,matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(K)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = N;
        size_t X_n_mat_lim__ = K;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                size_t X_limit_0__ = dense_X;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
            }
        }
        context__.validate_dims("data initialization", "nnz_X", "int", context__.to_vec());
        nnz_X = int(0);
        vals_i__ = context__.vals_i("nnz_X");
        pos__ = 0;
        nnz_X = vals_i__[pos__++];
        validate_non_negative_index("w_X", "nnz_X", nnz_X);
        w_X = vector_d(static_cast<Eigen::VectorXd::Index>(nnz_X));
        context__.validate_dims("data initialization", "w_X", "vector_d", context__.to_vec(nnz_X));
        vals_r__ = context__.vals_r("w_X");
        pos__ = 0;
        size_t w_X_i_vec_lim__ = nnz_X;
        for (size_t i_vec__ = 0; i_vec__ < w_X_i_vec_lim__; ++i_vec__) {
            w_X[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "v_X", "int", context__.to_vec(nnz_X));
        validate_non_negative_index("v_X", "nnz_X", nnz_X);
        v_X = std::vector<int>(nnz_X,int(0));
        vals_i__ = context__.vals_i("v_X");
        pos__ = 0;
        size_t v_X_limit_0__ = nnz_X;
        for (size_t i_0__ = 0; i_0__ < v_X_limit_0__; ++i_0__) {
            v_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "u_X", "int", context__.to_vec((dense_X ? 0 : (N + 1) )));
        validate_non_negative_index("u_X", "(dense_X ? 0 : (N + 1) )", (dense_X ? 0 : (N + 1) ));
        u_X = std::vector<int>((dense_X ? 0 : (N + 1) ),int(0));
        vals_i__ = context__.vals_i("u_X");
        pos__ = 0;
        size_t u_X_limit_0__ = (dense_X ? 0 : (N + 1) );
        for (size_t i_0__ = 0; i_0__ < u_X_limit_0__; ++i_0__) {
            u_X[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
        validate_non_negative_index("y", "N", N);
        y = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
        prior_PD = int(0);
        vals_i__ = context__.vals_i("prior_PD");
        pos__ = 0;
        prior_PD = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_intercept", "int", context__.to_vec());
        has_intercept = int(0);
        vals_i__ = context__.vals_i("has_intercept");
        pos__ = 0;
        has_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "family", "int", context__.to_vec());
        family = int(0);
        vals_i__ = context__.vals_i("family");
        pos__ = 0;
        family = vals_i__[pos__++];
        context__.validate_dims("data initialization", "link", "int", context__.to_vec());
        link = int(0);
        vals_i__ = context__.vals_i("link");
        pos__ = 0;
        link = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist", "int", context__.to_vec());
        prior_dist = int(0);
        vals_i__ = context__.vals_i("prior_dist");
        pos__ = 0;
        prior_dist = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_intercept", "int", context__.to_vec());
        prior_dist_for_intercept = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_intercept");
        pos__ = 0;
        prior_dist_for_intercept = vals_i__[pos__++];
        context__.validate_dims("data initialization", "prior_dist_for_aux", "int", context__.to_vec());
        prior_dist_for_aux = int(0);
        vals_i__ = context__.vals_i("prior_dist_for_aux");
        pos__ = 0;
        prior_dist_for_aux = vals_i__[pos__++];
        context__.validate_dims("data initialization", "has_weights", "int", context__.to_vec());
        has_weights = int(0);
        vals_i__ = context__.vals_i("has_weights");
        pos__ = 0;
        has_weights = vals_i__[pos__++];
        validate_non_negative_index("weights", "(has_weights ? N : 0 )", (has_weights ? N : 0 ));
        weights = vector_d(static_cast<Eigen::VectorXd::Index>((has_weights ? N : 0 )));
        context__.validate_dims("data initialization", "weights", "vector_d", context__.to_vec((has_weights ? N : 0 )));
        vals_r__ = context__.vals_r("weights");
        pos__ = 0;
        size_t weights_i_vec_lim__ = (has_weights ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < weights_i_vec_lim__; ++i_vec__) {
            weights[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec());
        has_offset = int(0);
        vals_i__ = context__.vals_i("has_offset");
        pos__ = 0;
        has_offset = vals_i__[pos__++];
        validate_non_negative_index("offset", "(has_offset ? N : 0 )", (has_offset ? N : 0 ));
        offset = vector_d(static_cast<Eigen::VectorXd::Index>((has_offset ? N : 0 )));
        context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec((has_offset ? N : 0 )));
        vals_r__ = context__.vals_r("offset");
        pos__ = 0;
        size_t offset_i_vec_lim__ = (has_offset ? N : 0 );
        for (size_t i_vec__ = 0; i_vec__ < offset_i_vec_lim__; ++i_vec__) {
            offset[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "regularization", "double", context__.to_vec());
        regularization = double(0);
        vals_r__ = context__.vals_r("regularization");
        pos__ = 0;
        regularization = vals_r__[pos__++];
        validate_non_negative_index("prior_counts", "J", J);
        prior_counts = vector_d(static_cast<Eigen::VectorXd::Index>(J));
        context__.validate_dims("data initialization", "prior_counts", "vector_d", context__.to_vec(J));
        vals_r__ = context__.vals_r("prior_counts");
        pos__ = 0;
        size_t prior_counts_i_vec_lim__ = J;
        for (size_t i_vec__ = 0; i_vec__ < prior_counts_i_vec_lim__; ++i_vec__) {
            prior_counts[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "is_skewed", "int", context__.to_vec());
        is_skewed = int(0);
        vals_i__ = context__.vals_i("is_skewed");
        pos__ = 0;
        is_skewed = vals_i__[pos__++];
        context__.validate_dims("data initialization", "shape", "double", context__.to_vec());
        shape = double(0);
        vals_r__ = context__.vals_r("shape");
        pos__ = 0;
        shape = vals_r__[pos__++];
        context__.validate_dims("data initialization", "rate", "double", context__.to_vec());
        rate = double(0);
        vals_r__ = context__.vals_r("rate");
        pos__ = 0;
        rate = vals_r__[pos__++];
        context__.validate_dims("data initialization", "do_residuals", "int", context__.to_vec());
        do_residuals = int(0);
        vals_i__ = context__.vals_i("do_residuals");
        pos__ = 0;
        do_residuals = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"N",N,0);
        check_greater_or_equal(function__,"K",K,0);
        check_greater_or_equal(function__,"dense_X",dense_X,0);
        check_less_or_equal(function__,"dense_X",dense_X,1);
        check_greater_or_equal(function__,"nnz_X",nnz_X,0);
        for (int k0__ = 0; k0__ < nnz_X; ++k0__) {
            check_greater_or_equal(function__,"v_X[k0__]",v_X[k0__],0);
        }
        for (int k0__ = 0; k0__ < (dense_X ? 0 : (N + 1) ); ++k0__) {
            check_greater_or_equal(function__,"u_X[k0__]",u_X[k0__],0);
        }
        check_greater_or_equal(function__,"J",J,2);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],1);
            check_less_or_equal(function__,"y[k0__]",y[k0__],J);
        }
        check_greater_or_equal(function__,"prior_PD",prior_PD,0);
        check_less_or_equal(function__,"prior_PD",prior_PD,1);
        check_greater_or_equal(function__,"has_intercept",has_intercept,0);
        check_less_or_equal(function__,"has_intercept",has_intercept,1);
        check_greater_or_equal(function__,"family",family,1);
        check_greater_or_equal(function__,"link",link,1);
        check_greater_or_equal(function__,"prior_dist",prior_dist,0);
        check_less_or_equal(function__,"prior_dist",prior_dist,7);
        check_greater_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,0);
        check_less_or_equal(function__,"prior_dist_for_intercept",prior_dist_for_intercept,2);
        check_greater_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,0);
        check_less_or_equal(function__,"prior_dist_for_aux",prior_dist_for_aux,3);
        check_greater_or_equal(function__,"has_weights",has_weights,0);
        check_less_or_equal(function__,"has_weights",has_weights,1);
        check_greater_or_equal(function__,"has_offset",has_offset,0);
        check_less_or_equal(function__,"has_offset",has_offset,1);
        check_greater_or_equal(function__,"regularization",regularization,0);
        check_greater_or_equal(function__,"prior_counts",prior_counts,0);
        check_greater_or_equal(function__,"is_skewed",is_skewed,0);
        check_less_or_equal(function__,"is_skewed",is_skewed,1);
        check_greater_or_equal(function__,"shape",shape,0);
        check_greater_or_equal(function__,"rate",rate,0);
        check_greater_or_equal(function__,"do_residuals",do_residuals,0);
        check_less_or_equal(function__,"do_residuals",do_residuals,1);
        // initialize data variables
        half_K = double(0);
        stan::math::fill(half_K,DUMMY_VAR__);
        stan::math::assign(half_K,(0.5 * K));
        sqrt_Nm1 = double(0);
        stan::math::fill(sqrt_Nm1,DUMMY_VAR__);
        stan::math::assign(sqrt_Nm1,sqrt((N - 1.0)));
        is_constant = int(0);
        stan::math::fill(is_constant, std::numeric_limits<int>::min());
        stan::math::assign(is_constant,1);

        try {
            for (int j = 1; j <= J; ++j) {
                if (as_bool(logical_neq(get_base1(prior_counts,j,"prior_counts",1),1))) {
                    stan::math::assign(is_constant, 0);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        check_greater_or_equal(function__,"half_K",half_K,0);
        check_greater_or_equal(function__,"sqrt_Nm1",sqrt_Nm1,0);
        check_greater_or_equal(function__,"is_constant",is_constant,0);
        check_less_or_equal(function__,"is_constant",is_constant,1);

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += (J - 1);
        num_params_r__ += (K);
        ++num_params_r__;
        num_params_r__ += is_skewed;
    }

    ~model_polr() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("pi")))
            throw std::runtime_error("variable pi missing");
        vals_r__ = context__.vals_r("pi");
        pos__ = 0U;
        context__.validate_dims("initialization", "pi", "vector_d", context__.to_vec(J));
        // generate_declaration pi
        vector_d pi(static_cast<Eigen::VectorXd::Index>(J));
        for (int j1__ = 0U; j1__ < J; ++j1__)
            pi(j1__) = vals_r__[pos__++];
        try {
            writer__.simplex_unconstrain(pi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi: ") + e.what());
        }

        if (!(context__.contains_r("u")))
            throw std::runtime_error("variable u missing");
        vals_r__ = context__.vals_r("u");
        pos__ = 0U;
        context__.validate_dims("initialization", "u", "vector_d", context__.to_vec(K));
        // generate_declaration u
        vector_d u(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            u(j1__) = vals_r__[pos__++];
        try {
            writer__.unit_vector_unconstrain(u);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable u: ") + e.what());
        }

        if (!(context__.contains_r("R2")))
            throw std::runtime_error("variable R2 missing");
        vals_r__ = context__.vals_r("R2");
        pos__ = 0U;
        context__.validate_dims("initialization", "R2", "double", context__.to_vec());
        // generate_declaration R2
        double R2(0);
        R2 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,R2);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable R2: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec(is_skewed));
        // generate_declaration alpha
        std::vector<double> alpha(is_skewed,double(0));
        for (int i0__ = 0U; i0__ < is_skewed; ++i0__)
            alpha[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < is_skewed; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,alpha[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi;
        (void) pi;  // dummy to suppress unused var warning
        if (jacobian__)
            pi = in__.simplex_constrain(J,lp__);
        else
            pi = in__.simplex_constrain(J);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  u;
        (void) u;  // dummy to suppress unused var warning
        if (jacobian__)
            u = in__.unit_vector_constrain(K,lp__);
        else
            u = in__.unit_vector_constrain(K);

        T__ R2;
        (void) R2;  // dummy to suppress unused var warning
        if (jacobian__)
            R2 = in__.scalar_lub_constrain(0,1,lp__);
        else
            R2 = in__.scalar_lub_constrain(0,1);

        vector<T__> alpha;
        size_t dim_alpha_0__ = is_skewed;
        alpha.reserve(dim_alpha_0__);
        for (size_t k_0__ = 0; k_0__ < dim_alpha_0__; ++k_0__) {
            if (jacobian__)
                alpha.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                alpha.push_back(in__.scalar_lb_constrain(0));
        }


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  cutpoints(static_cast<Eigen::VectorXd::Index>((J - 1)));
        (void) cutpoints;  // dummy to suppress unused var warning
        stan::math::initialize(cutpoints, DUMMY_VAR__);
        stan::math::fill(cutpoints,DUMMY_VAR__);


        try {
            {
                T__ Delta_y;
                (void) Delta_y;  // dummy to suppress unused var warning
                stan::math::initialize(Delta_y, DUMMY_VAR__);
                stan::math::fill(Delta_y,DUMMY_VAR__);
                stan::math::assign(Delta_y,inv(sqrt((1 - R2))));


                if (as_bool(logical_gt(K,1))) {
                    stan::math::assign(beta, multiply(multiply(multiply(u,sqrt(R2)),Delta_y),sqrt_Nm1));
                } else {
                    stan::math::assign(get_base1_lhs(beta,1,"beta",1), (((get_base1(u,1,"u",1) * sqrt(R2)) * Delta_y) * sqrt_Nm1));
                }
                stan::math::assign(cutpoints, make_cutpoints(pi,Delta_y,link, pstream__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < (J - 1); ++i0__) {
            if (stan::math::is_uninitialized(cutpoints(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: cutpoints" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, DUMMY_VAR__);
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                if (as_bool((primitive_value(logical_eq(has_weights,0)) && primitive_value(logical_eq(prior_PD,0))))) {

                    if (as_bool(logical_eq(is_skewed,0))) {
                        lp_accum__.add(pw_polr(y,eta,cutpoints,link,1.0, pstream__));
                    } else {
                        lp_accum__.add(pw_polr(y,eta,cutpoints,link,get_base1(alpha,1,"alpha",1), pstream__));
                    }
                } else if (as_bool(logical_eq(prior_PD,0))) {

                    if (as_bool(logical_eq(is_skewed,0))) {
                        lp_accum__.add(dot_product(weights,pw_polr(y,eta,cutpoints,link,1.0, pstream__)));
                    } else {
                        lp_accum__.add(dot_product(weights,pw_polr(y,eta,cutpoints,link,get_base1(alpha,1,"alpha",1), pstream__)));
                    }
                }
                if (as_bool(logical_eq(is_constant,0))) {
                    lp_accum__.add(dirichlet_log(pi,prior_counts));
                }
                if (as_bool(logical_eq(prior_dist,1))) {
                    lp_accum__.add(beta_log(R2,half_K,regularization));
                }
                if (as_bool(logical_eq(is_skewed,1))) {
                    lp_accum__.add(gamma_log(alpha,shape,rate));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("pi");
        names__.push_back("u");
        names__.push_back("R2");
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("cutpoints");
        names__.push_back("mean_PPD");
        names__.push_back("residuals");
        names__.push_back("zeta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_skewed);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(J,2) ? J : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((do_residuals ? N : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J - 1));
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_polr_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d pi = in__.simplex_constrain(J);
        vector_d u = in__.unit_vector_constrain(K);
        double R2 = in__.scalar_lub_constrain(0,1);
        vector<double> alpha;
        size_t dim_alpha_0__ = is_skewed;
        for (size_t k_0__ = 0; k_0__ < dim_alpha_0__; ++k_0__) {
            alpha.push_back(in__.scalar_lb_constrain(0));
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(pi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(u[k_0__]);
        }
        vars__.push_back(R2);
        for (int k_0__ = 0; k_0__ < is_skewed; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d beta(static_cast<Eigen::VectorXd::Index>(K));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        vector_d cutpoints(static_cast<Eigen::VectorXd::Index>((J - 1)));
        (void) cutpoints;  // dummy to suppress unused var warning
        stan::math::initialize(cutpoints, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cutpoints,DUMMY_VAR__);


        try {
            {
                double Delta_y(0.0);
                (void) Delta_y;  // dummy to suppress unused var warning
                stan::math::initialize(Delta_y, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(Delta_y,DUMMY_VAR__);
                stan::math::assign(Delta_y,inv(sqrt((1 - R2))));


                if (as_bool(logical_gt(K,1))) {
                    stan::math::assign(beta, multiply(multiply(multiply(u,sqrt(R2)),Delta_y),sqrt_Nm1));
                } else {
                    stan::math::assign(get_base1_lhs(beta,1,"beta",1), (((get_base1(u,1,"u",1) * sqrt(R2)) * Delta_y) * sqrt_Nm1));
                }
                stan::math::assign(cutpoints, make_cutpoints(pi,Delta_y,link, pstream__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (J - 1); ++k_0__) {
            vars__.push_back(cutpoints[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector_d mean_PPD(static_cast<Eigen::VectorXd::Index>((logical_gt(J,2) ? J : 1 )));
        (void) mean_PPD;  // dummy to suppress unused var warning
        stan::math::initialize(mean_PPD, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mean_PPD,DUMMY_VAR__);
        stan::math::assign(mean_PPD,rep_vector(0,(logical_gt(J,2) ? J : 1 )));
        vector_d residuals(static_cast<Eigen::VectorXd::Index>((do_residuals ? N : 0 )));
        (void) residuals;  // dummy to suppress unused var warning
        stan::math::initialize(residuals, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(residuals,DUMMY_VAR__);
        vector_d zeta(static_cast<Eigen::VectorXd::Index>((J - 1)));
        (void) zeta;  // dummy to suppress unused var warning
        stan::math::initialize(zeta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(zeta,DUMMY_VAR__);


        try {
            if (as_bool(dense_X)) {
                stan::math::assign(zeta, add(cutpoints,dot_product(xbar,beta)));
            } else {
                stan::math::assign(zeta, cutpoints);
            }
            if (as_bool(logical_eq(J,2))) {
                stan::math::assign(zeta, minus(zeta));
            }
            {
                vector_d eta(static_cast<Eigen::VectorXd::Index>(N));
                (void) eta;  // dummy to suppress unused var warning
                stan::math::initialize(eta, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(eta,DUMMY_VAR__);


                if (as_bool(logical_gt(K,0))) {

                    if (as_bool(dense_X)) {
                        stan::math::assign(eta, multiply(get_base1(X,1,"X",1),beta));
                    } else {
                        stan::math::assign(eta, csr_matrix_times_vector(N,K,w_X,v_X,u_X,beta));
                    }
                } else {
                    stan::math::assign(eta, rep_vector(0.0,N));
                }
                if (as_bool(logical_eq(has_offset,1))) {
                    stan::math::assign(eta, add(eta,offset));
                }
                for (int n = 1; n <= N; ++n) {
                    {
                        int y_tilde(0);
                        (void) y_tilde;  // dummy to suppress unused var warning
                        stan::math::fill(y_tilde, std::numeric_limits<int>::min());
                        vector_d theta(static_cast<Eigen::VectorXd::Index>(J));
                        (void) theta;  // dummy to suppress unused var warning
                        stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(theta,DUMMY_VAR__);
                        double previous(0.0);
                        (void) previous;  // dummy to suppress unused var warning
                        stan::math::initialize(previous, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(previous,DUMMY_VAR__);


                        stan::math::assign(get_base1_lhs(theta,1,"theta",1), CDF_polr((get_base1(cutpoints,1,"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__));
                        stan::math::assign(previous, get_base1(theta,1,"theta",1));
                        if (as_bool(is_skewed)) {
                            stan::math::assign(get_base1_lhs(theta,1,"theta",1), pow(get_base1(theta,1,"theta",1),get_base1(alpha,1,"alpha",1)));
                        }
                        for (int j = 2; j <= (J - 1); ++j) {
                            {
                                double current(0.0);
                                (void) current;  // dummy to suppress unused var warning
                                stan::math::initialize(current, std::numeric_limits<double>::quiet_NaN());
                                stan::math::fill(current,DUMMY_VAR__);


                                stan::math::assign(current, CDF_polr((get_base1(cutpoints,j,"cutpoints",1) - get_base1(eta,n,"eta",1)),link, pstream__));
                                stan::math::assign(get_base1_lhs(theta,j,"theta",1), (current - previous));
                                stan::math::assign(previous, current);
                            }
                        }
                        if (as_bool(logical_eq(is_skewed,0))) {
                            stan::math::assign(get_base1_lhs(theta,J,"theta",1), (1 - previous));
                        } else {
                            stan::math::assign(get_base1_lhs(theta,J,"theta",1), (1 - pow(previous,get_base1(alpha,1,"alpha",1))));
                        }
                        if (as_bool((primitive_value(logical_lte(previous,0)) || primitive_value(logical_gte(previous,1))))) {

                        } else if (as_bool(logical_eq(J,2))) {

                            stan::math::assign(get_base1_lhs(mean_PPD,1,"mean_PPD",1), (get_base1(mean_PPD,1,"mean_PPD",1) + bernoulli_rng(get_base1(theta,J,"theta",1), base_rng__)));
                        } else {

                            stan::math::assign(y_tilde, categorical_rng(theta, base_rng__));
                            stan::math::assign(get_base1_lhs(mean_PPD,y_tilde,"mean_PPD",1), (get_base1(mean_PPD,y_tilde,"mean_PPD",1) + 1));
                        }
                        if (as_bool(do_residuals)) {
                            {
                                double ystar(0.0);
                                (void) ystar;  // dummy to suppress unused var warning
                                stan::math::initialize(ystar, std::numeric_limits<double>::quiet_NaN());
                                stan::math::fill(ystar,DUMMY_VAR__);


                                if (as_bool(logical_eq(get_base1(y,n,"y",1),1))) {
                                    stan::math::assign(ystar, draw_ystar_rng(stan::math::negative_infinity(),get_base1(cutpoints,1,"cutpoints",1),get_base1(eta,n,"eta",1),link, base_rng__, pstream__));
                                } else if (as_bool(logical_eq(get_base1(y,n,"y",1),J))) {
                                    stan::math::assign(ystar, draw_ystar_rng(get_base1(cutpoints,(J - 1),"cutpoints",1),stan::math::positive_infinity(),get_base1(eta,n,"eta",1),link, base_rng__, pstream__));
                                } else {
                                    stan::math::assign(ystar, draw_ystar_rng(get_base1(cutpoints,(get_base1(y,n,"y",1) - 1),"cutpoints",1),get_base1(cutpoints,get_base1(y,n,"y",1),"cutpoints",1),get_base1(eta,n,"eta",1),link, base_rng__, pstream__));
                                }
                                stan::math::assign(get_base1_lhs(residuals,n,"residuals",1), (ystar - get_base1(eta,n,"eta",1)));
                            }
                        }
                    }
                }
                stan::math::assign(mean_PPD, divide(mean_PPD,N));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < (logical_gt(J,2) ? J : 1 ); ++k_0__) {
            vars__.push_back(mean_PPD[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (do_residuals ? N : 0 ); ++k_0__) {
            vars__.push_back(residuals[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (J - 1); ++k_0__) {
            vars__.push_back(zeta[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_polr";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "R2";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= is_skewed; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (J - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cutpoints" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= (logical_gt(J,2) ? J : 1 ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mean_PPD" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (do_residuals ? N : 0 ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (J - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= (J - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "R2";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= is_skewed; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (J - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cutpoints" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= (logical_gt(J,2) ? J : 1 ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mean_PPD" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (do_residuals ? N : 0 ); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "residuals" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (J - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zeta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




#endif
