% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{get_request}
\alias{get_request}
\alias{post_request}
\title{STAC API request functions}
\usage{
get_request(q, ...)

post_request(q, ..., encode = c("json", "multipart", "form"))
}
\arguments{
\item{q}{a \code{rstac_query} object expressing a STAC query
criteria.}

\item{...}{config parameters to be passed to \link[httr:GET]{GET} or
\link[httr:POST]{POST} methods, such as \link[httr:add_headers]{add_headers} or
\link[httr:set_cookies]{set_cookies}.}

\item{encode}{a \code{character} informing the request body
Content-Type. Accepted types are \code{'json'} (\code{'application/json'}),
\code{'form'} (\code{'application/x-www-form-urlencoded'}),
and \code{'multipart'} (\code{'multipart/form-data'}). Defaults to
\code{'json'}.}
}
\value{
Either a \code{doc_catalog}, \code{doc_collection},
\code{doc_collections}, \code{doc_items} or \code{doc_item}
object depending on the subclass and search fields parameters of \code{q}
argument.
}
\description{
The \code{get_request} is function that makes HTTP GET
requests to STAC web services, retrieves, and parse the data.

The \code{post_request} is function that makes HTTP POST
requests to STAC web services, retrieves, and parse the data.
}
\examples{
\dontrun{
 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  get_request()

 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4-16D-2") \%>\%
  post_request()
}
}
\seealso{
\code{\link[=stac]{stac()}} \code{\link[=stac_search]{stac_search()}} \code{\link[=collections]{collections()}}
\code{\link[=items]{items()}}
}
