% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{matmult}
\alias{matmult}
\alias{\%*\%,dgRMatrix,matrix-method}
\alias{\%*\%,dgRMatrix,float32-method}
\alias{\%*\%,float32,dgRMatrix-method}
\alias{tcrossprod,dgRMatrix,matrix-method}
\alias{tcrossprod,dgRMatrix,float32-method}
\alias{\%*\%,matrix,dgCMatrix-method}
\alias{\%*\%,float32,dgCMatrix-method}
\alias{\%*\%,dgCMatrix,float32-method}
\alias{crossprod,matrix,dgCMatrix-method}
\alias{crossprod,float32,dgCMatrix-method}
\title{Multithreaded Sparse-Dense Matrix Multiplication}
\usage{
\S4method{\%*\%}{dgRMatrix,matrix}(x, y)

\S4method{\%*\%}{dgRMatrix,float32}(x, y)

\S4method{\%*\%}{float32,dgRMatrix}(x, y)

\S4method{tcrossprod}{dgRMatrix,matrix}(x, y)

\S4method{tcrossprod}{dgRMatrix,float32}(x, y)

\S4method{\%*\%}{matrix,dgCMatrix}(x, y)

\S4method{\%*\%}{float32,dgCMatrix}(x, y)

\S4method{\%*\%}{dgCMatrix,float32}(x, y)

\S4method{crossprod}{matrix,dgCMatrix}(x, y)

\S4method{crossprod}{float32,dgCMatrix}(x, y)
}
\arguments{
\item{x, y}{dense \code{matrix} and sparse
\code{Matrix::RsparseMatrix} / \code{Matrix::CsparseMatrix} matrices.}
}
\value{
A dense \code{matrix}
}
\description{
Multithreaded \code{\%*\%}, \code{crossprod}, \code{tcrossprod}
for sparse-dense matrix multiplication
}
\details{
Accelerates sparse-dense matrix multiplications using openmp. Applicable to the following pairs:
(\code{dgRMatrix}, \code{matrix}), (\code{matrix}, \code{dgRMatrix}),
(\code{dgCMatrix}, \code{matrix}), (\code{matrix}, \code{dgCMatrix}) combinations
}
\examples{
library(Matrix)
data("movielens100k")
k = 10
nc = ncol(movielens100k)
nr = nrow(movielens100k)
x_nc = matrix(rep(1:k, nc), nrow = nc)
x_nr = t(matrix(rep(1:k, nr), nrow = nr))
csc = movielens100k
csr = as(movielens100k, "RsparseMatrix")
dense = as.matrix(movielens100k)
identical(csr \%*\% x_nc, dense \%*\% x_nc)
identical(x_nr \%*\% csc, x_nr \%*\% dense)
}
