% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdtodoc.R
\name{document_create_from_tabfile}
\alias{document_create_from_tabfile}
\title{Upload a tabular document to RSpace}
\usage{
document_create_from_tabfile(
  path,
  file_type = NULL,
  document_name = NULL,
  template_id = NULL,
  folder_id = NULL,
  tags = NULL,
  attachments = NULL,
  existing_document_id = NULL,
  api_key = get_api_key()
)
}
\arguments{
\item{path}{tabular file to upload. Can be XLSX, CSV or TSV}

\item{file_type}{an optional character string to specify the file type. Will be guessed from the file name if not specified.}

\item{document_name}{specify the name of the RSpace entry. If not specified,
it will be the value in Title, Name, title, or name if that is one of the fields in the Excel document.
If that does not exist, it will be the file name.}

\item{template_id}{document id of the RSpace template used.
Will be overwritten by the template of \code{existing_document_id} if specified.
A basic document is created if no template is specified.}

\item{folder_id}{folder_id in which the document will be created (can be a notebook)}

\item{tags}{vector of tags to apply to the document (will include "rspacer" by default)}

\item{attachments}{attachments to attach to the fields in tibble/data.frame form (one attachment per row), e.g., \code{tibble(field = 7, path = "file.txt")}}

\item{existing_document_id}{document id of a document to be replaced, if NULL (the default) a new document will be created.}

\item{api_key}{RSpace API key}
}
\value{
Invisible JSON response from the API.
}
\description{
This function can upload tabular files to RSpace structured documents.
The file needs to have exactly two columns, one with the RSpace structured document fields and one with the content.
}
