\name{NEWS}
\title{News for Package \pkg{rslurm}}
\newcommand{\ghpr}{\href{https://github.com/sesync-ci/rslurm/pull/#1}{##1}}
\newcommand{\ghit}{\href{https://github.com/sesync-ci/rslurm/issues/#1}{##1}}

\section{Changes in version 0.3.3 from 2017-04-07}{
Minor update to repair README.
  \itemize{
    \item Create README from R/slurm.R.
  }
}

\section{Changes in version 0.3.2 from 2017-04-06}{
Minor update to include new feature and bug fixes.
  \itemize{
    \item "wait" argument adds option to slurm_apply and slurm_call to block the
      calling script until the submitted job completes. This option can be used to allow immediate processing of a submitted job's output (\ghpr{2}).
    \item Use ".RDS" file extension, rather than ".RData", for serialized objects (\ghpr{4}).
    \item Minor bug fixes (\ghpr{4}).
  }
}
\section{Changes in version 0.3.1 from 2016-06-18}{
Minor bug fix.
  \itemize{
    \item specify full path of `Rscript` when running batch scripts.
  }
}
\section{Changes in version 0.3.0 from 2016-05-27}{
Major update to the package interface and implementation.
  \itemize{
    \item First version on CRAN
    \item Added a `submit` argument to `slurm_apply` and `slurm_call`. If `submit = FALSE`, the submission scripts are created but not run. This is useful if the files need to be transferred from a local machine to the cluster and run at a later time.
    \item Added new optional arguments to `slurm_apply` and `slurm_call`, allowing users to give informative names to SLURM jobs (`jobname`) and set any options understood by `sbatch` (`slurm_options`).
    \item The `data_file` arugment to `slurm_apply` and `slurm_call` is replaced with `add_objects`, which accepts a vector of R object names from the active workspace and automatically saves them in a .RData file to be loaded on each node.
    \item `slurm_apply` and `slurm_call` now generate R and Bash scripts through [whisker](https://github.com/edwindj/whisker) templates. Advanced users may want to edit those templates in the `templates` folder of the installed R package (e.g. to set default *SBATCH* options in `submit.sh`).
    \item Files generated by the package (scripts, data files and output) are now saved in a subfolder named `_rslurm_[jobname]` in the current working directory.
    \item Minor updates, including reformatting the output of `print_job_status` and removing this package's dependency on `stringr`.
  }
}
\section{Changes in version 0.2.0 from 2015-11-23}{
  \itemize{
    \item Changed the `slurm_apply` function to use `parallel::mcMap` instead of `mcmapply`, which fixes a bug where list outputs (i.e. each function call returns a list) would be collapsed in a single list (rather than returned as a list of lists).
    \item Changed the interface so that the output type (table or raw) is now an argument of `get_slurm_out` rather than of `slurm_apply`, and defaults to `raw`.
    \item Added `cpus_per_node` argument to `slurm_apply`, indicating the number of parallel processes to be run on each node.
  }
}
\section{Changes in version 0.1.3 from 2015-07-13}{
  \itemize{
    \item Added the `slurm_call` function, which submits a single function evaluation on the cluster, with syntax similar to the base function `do.call`.
    \item `get_slurm_out` can now process the output even if some filese are missing, in which case it issues a warning.
  }
}
\section{Changes in version 0.1.2 from 2015-06-29}{
  \itemize{
    \item Added the optional argument `pkgs` to `slurm_apply`, indicating which packages should be loaded on each node (by default, all packages currently attached to the user's R session).
  }
}
\section{Changes in version 0.1.1 from 2015-06-24}{
  \itemize{
    \item Added the optional argument `output` to `slurm_apply`, which can take the value `table` (each function evaluation returns a row, output is a data frame) or `raw` (each function evaluation returns an arbitrary R object, output is a list).
    \item Fixed a bug in the chunk size calculation for `slurm_apply`.
  }
}
\section{Changes in version 0.1.0 2015-06-16}{
  \itemize{
    \item First version of the package released on Github.
  }
}
