% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_functions.R
\name{sentinel2_mask_function}
\alias{sentinel2_mask_function}
\title{Create a Sentinel-2 mask raster from the SCL band}
\usage{
sentinel2_mask_function(raster)
}
\arguments{
\item{raster}{The SCL band of a Sentinel-2 image}
}
\value{
A boolean raster to be used to mask a Sentinel-2 image
}
\description{
Create a Sentinel-2 mask raster from the SCL band
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aoi <- sf::st_point(c(-74.912131, 44.080410))
aoi <- sf::st_set_crs(sf::st_sfc(aoi), 4326)
aoi <- sf::st_buffer(sf::st_transform(aoi, 5070), 100)

sentinel2_image <- get_sentinel2_imagery(
  aoi,
  start_date = "2022-06-01",
  end_date = "2022-08-30",
  mask_function = sentinel2_mask_function
)
\dontshow{\}) # examplesIf}
}
