% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sed_comment.R
\name{sed_comment}
\alias{sed_comment}
\title{Add or remove comment characters to a line}
\usage{
sed_comment(stream, at, add = TRUE, type = c("R", "C", "Java", "html",
  "tex", "SAS"), warn = FALSE, ...)
}
\arguments{
\item{stream}{A character vector, each element typically (but not necessarily) containing the text
from a single line in a file, which can be generated via \code{\link{readLines}}.}

\item{at}{A vector of integers or a character string that designates the line(s) that will be commented.
If \code{at} is numeric, it designates the line(s) (or elements) in \code{stream} that will be commented.
The numeric value(s) of \code{at} must be in \code{[1:length(stream)]}. If \code{at} is a
character string, the line(s) in \code{stream} that contain the string \code{at} are commented.}

\item{add}{A logical indicating whether comments are added to a single
line (\code{TRUE}), or removed (\code{FALSE}).}

\item{type}{A character string uniquely indicating the programming language: R, C, Java, html, tex, and SAS.
Customized commenting can be achieved by providing a character vector of length 2, where \code{type[1]} designates
the beginning comment character and \code{type[2]} designates the ending comment character.}

\item{warn}{If \code{TRUE}, warning messages are produced if commenting (or uncommenting) fails due to mispecifification
of \code{at}.}

\item{\dots}{Additional named arguments to \code{\link{grep}}, which are applicable if \code{at} is a character string.
In other words, \code{\link{grep}} is used to search for the instances of \code{at}.}
}
\value{
The new \code{stream} with the commented (or uncommented) lines. If the commenting fails because \code{at} is
specified incorrectly, \code{stream} is returned unchanged.
}
\description{
Add or remove comment characters to a line
}
\details{
Some languages provide a way to comment multiple lines of code with a single pair of beginning and ending commenting
symbols.  However, \code{sed_comment} only adds/removes comment symbols to/from a single lines.
When comments are added by \code{sed_comment}, the comment symbols are placed at the beginning (and, if applicable, at the end) of
the selected lines. When comments are removed, the first instances of the beginning (and, if applicable, ending) comment symbols
are removed from the selected lines.
}
\examples{
######################################################################
# Let's create a stream to demonstrate the commenting symbol in each
# language
######################################################################
demoStream <- c("An R comment",
               "A C comment",
               "An html comment",
               "A tex comment",
               "A SAS comment",
               "A custom comment")

a <- sed_comment(demoStream, "R", type = "R")
a <- sed_comment(a, "C", type = "C")
a <- sed_comment(a, "html", type = "h")
a <- sed_comment(a, "tex", type = "t")
a <- sed_comment(a, "SAS", type = "S")
a <- sed_comment(a, "custom", type = c("&", ";"))

# Compare before and after
as.stream(demoStream)
a

######################################################################
# Various examples
######################################################################
aStream <- c("Here's a line to comment",
            "# A line to uncomment",
            "  <!-- Another commented line --> ",
            "And some comments * embedded in the line ;")
as.stream(aStream)

# Comment the first line in C style
stream <- sed_comment(aStream, "to comment", type = "C")

# Comment the first line with a custom style
a <- sed_comment(aStream, "to comment", type = c("&&", "##"))
a

# Remove the custom comments
a <- sed_comment(a, 1, add = FALSE, type = c("&&", "##"))
a

# Remove the R comment from the 2nd line
a <- sed_comment(a, 2, add = FALSE, type = "R")
a

# Remove the html comments
a <- sed_comment(a, "Another", add = FALSE, type = "html")
a

# Remove the SAS comments
sed_comment(a, "embedded", add = FALSE, type = "SAS")

# Comment every line in Java style
b <- sed_comment(aStream, "comment", type = "Java")
b

# Remove the Java comments from the second and fourth lines
sed_comment(b, c(2, 4), add = FALSE, type = "Java")
}
\seealso{
\code{\link{sed_insert}}, \code{\link{sed_replace}}, \code{\link{sed_substitute}}, \code{\link{streamEdit}}
}
\author{
Landon Sego
}
\keyword{misc}
