% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sed_replace.R
\name{sed_replace}
\alias{sed_replace}
\title{Delete or replace an entire line}
\usage{
sed_replace(stream, at, replacement, warn = FALSE, ...)
}
\arguments{
\item{stream}{A character vector, each element typically (but not necessarily) containing the text
from a single line in a file, which can be generated via \code{\link{readLines}}.}

\item{at}{A vector of integers or a character string that designates where \code{replacement}
is placed in \code{stream}.  If \code{at} is numeric, it designates the lines (or elements) in \code{stream}
that will be replaced with \code{replacement}.  The numeric value(s) of \code{at} must be in
\code{[1:length(stream)]}. If \code{at} is a
character string, the lines in \code{stream} that contain the string \code{at} are replaced with
\code{replacement}.}

\item{replacement}{A character string of length 1 (vectors not supported), that will be inserted
to replace the entire line. Or, if \code{replacement = NULL}, the entire line
is deleted.}

\item{warn}{If \code{TRUE}, warning messages are produced if replacement fails due to mispecifification
of \code{at}.}

\item{\dots}{Additional named arguments to \code{\link{grep}}, which are applicable if \code{at} is a character string.
In other words, \code{\link{grep}} is used to search for the instances of \code{at}.}
}
\value{
The new \code{stream} with the replacements. If the replacement fails because \code{after} is
specified incorrectly, \code{stream} is returned unchanged.
}
\description{
Delete or replace an entire line
}
\examples{
################################################################################
# Let's create an example stream we can edit
################################################################################
stream <- c("Here's a line",
           "Here's a line we'll delete",
           "Filler line",
           "A line we'll delete",
           "A line we'll entirely replace",
           "The last line")
as.stream(stream)

# Here's a deletion of lines 1 and 2 using line numbers
stream <- sed_replace(stream, 1:2, NULL)
stream

# Here's a line deletion using a search string
stream <- sed_replace(stream, "A line we'll delete", NULL)
stream

# A line replacement using line numbers
stream <- sed_replace(stream, 2, "A new filler line")
stream

# Here's a line replacement with a search string
stream <- sed_replace(stream, "entirely", "A replacement for the line")
stream

# And we can replace multiple lines too
stream <- sed_replace(stream, "line", "All the same")
stream
}
\seealso{
\code{\link{sed_insert}}, \code{\link{sed_substitute}}, \code{\link{sed_comment}}, \code{\link{streamEdit}}
}
\author{
Landon Sego
}
\keyword{misc}
