% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot,rtoi,Date-method}
\alias{plot,rtoi,Date-method}
\alias{plot,rtoi,character-method}
\alias{plot,character}
\alias{plot,records,ANY-method}
\alias{plot,records}
\alias{plot,rtoi,missing-method}
\alias{plot,rtoi,missing}
\title{Plot an \code{rtoi} object}
\usage{
\S4method{plot}{rtoi,Date}(
  x,
  y,
  ...,
  variable = "rgb",
  band_name = c("red", "green", "blue"),
  verbose = FALSE,
  xsize = 250,
  ysize = 250
)

\S4method{plot}{rtoi,character}(
  x,
  y,
  ...,
  variable = "rgb",
  product = "ALL",
  band_name = c("red", "green", "blue"),
  dates = NULL,
  verbose = FALSE,
  xsize = 250,
  ysize = 250
)

\S4method{plot}{records,ANY}(x, y, verbose = FALSE, ...)

\S4method{plot}{rtoi,missing}(x, y, verbose = FALSE, ...)
}
\arguments{
\item{x}{an \code{rtoi} or \code{records}.}

\item{y}{character argument. The valid values are "dates", "preview", or
"view".}

\item{...}{additional arguments.}

\item{variable}{character argument. The variable to be plotted. By default,
a color (RGB) variable is selected .}

\item{band_name}{character vector argument. Enables false color plots. By
default, usual bands are selected \code{c("red","green","blue")}.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{xsize}{the number of samples on the horizontal axis.}

\item{ysize}{the number of samples on the vertical axis.}

\item{product}{character argument. The product name to be plotted.}

\item{dates}{date vector argument. The dates to be plotted.}
}
\value{
\code{tmap} plot.
}
\description{
Plot (a map of) the values of an \code{rtoi} or \code{records} object.
}
\examples{
library(rsat)
 \dontrun{

# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

print(navarre)

# plot the calendar
plot(navarre, "dates")



# replace with your own "username" and "password"
set_credentials("username", "password")

# plot the quicklook images before the download
# needs credentials to download preview images
plot(navarre, y = "preview")

# select partially cloud free
rcds <- records(navarre)
rcds <- rcds[dates(rcds) \%in\% as.Date(c("20210310", "20210313"), "\%Y\%m\%d")]
records(navarre) <- rcds

plot(navarre, "preview")

file.copy(from=system.file("ex/Pamplona",package="rsat"),
         to=tempdir(),
         recursive = TRUE)
# plot already mosaicked rtoi ("view" mode)
pamplona <- read_rtoi(file.path(tempdir(),"Pamplona"))

rsat_list_data(pamplona)

# plot can compute the rgb image on the fly from mosaicek bands
plot(pamplona, "view", product="mod09ga")

# plot on the fly with false color
plot(pamplona, "view",
     product = "mod09ga",
     band_name = c("nir", "red", "green"))

file.copy(from=system.file("ex/PamplonaDerived",package="rsat"),
         to=tempdir(),
         recursive = TRUE)
# plot already mosaicked rtoi ("view" mode)
pamplona.derived <- read_rtoi(file.path(tempdir(),"PamplonaDerived"))

rsat_list_data(pamplona.derived)

# plot derived variables
plot(pamplona.derived, "view",
     product = "mod09ga",
     variable = "NDVI")

# Set the max and min value in plot
plot(pamplona.derived,"view",
     variable="NDVI",
     product="mod09ga",
     zlim=c(0,1))
}
}
