
# rsMove
[![CRAN version](https://www.r-pkg.org/badges/version/rsMove)](https://CRAN.R-project.org/package=rsMove)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/last-month/rsMove?color=brightgreen)](https://CRAN.R-project.org/package=rsMove)

### Why develop rsMove?

<p align="justify">
In the scope of movement ecology, Global Positioning Systems (GPS) have evolved significantly offering a unique insight into the animal behavior. But understanding this behavior is dependent on our ability to comprehend the underlying environmental conditions that guides it. In this context, remote sensing becomes a fundamental tool. It provides information on the spatial and temporal variability of the landscape and provides us the means to understand the impact of environmental change over animal behavior. However, linking remote sensing and animal movement can be troublesome due to the differences in the spatial and temporal scales at which they are acquired (<a href="https://movementecologyjournal.biomedcentral.com/articles/10.1186/s40462-015-0036-7">Neuman et al, 2015</a>). As a consequence, methods that are sensitive to the constraints imposed by remote sensing in the analysis of animal movement are required. <i>rsMove</i> answers to this issue providing tools to query and analyze movement data using remote sensing.
</p>

<br>

### Installation
This gitHub is used as a basis for the improvement of *rsMove*. A stable release is available on <a href="https://cran.r-project.org/package=rsMove">CRAN</a> and can installed with:
```R
install.packages('rsMove')
```
<br>

### Examples
<p align="justify">
 Please click <a href="https://cran.r-project.org/package=rsMove/vignettes/rsMove.html">here</a> for the package vignette.
</p>

<br>

### Bug reports & contact

For bug reports, please use <a href="https://github.com/RRemelgado/rsMove/issues/"</a>. Feature requests and other contributions are also welcome.

<br>

### What else are we doing?
<p align="justify">
The Department of Remote Sensing of the University of Würzburg has developed other R packages that might interest you:
</p>

* <a href="https://bleutner.github.io/RStoolbox/">RStoolbox</a>
* <a href="https://github.com/cran/moveVis/">moveVis</a>

<p align="justify">
Click <a href="http://remote-sensing.eu/">here</a> for news on our department.
</p>

<br>

### Aknowledgements
<p align="justify">
This initiative is part of the <a href="https://www.geographie.uni-wuerzburg.de/en/fernerkundung/research/completed-projects/opt4environment/">Opt4Environment</a> project and was funded by the German Aerospace Center (DLR) on behalf of the Federal Ministry for Economic Affairs and Energy (BMWi) with the research grant <b>50 EE 1403</b>. The movement data we used was provided by the Max Planck institute for Ornithology (MPIo). Click below to reach the involved parties.
</p>

<br>
<p align="justify">
<a href="https://www.geographie.uni-wuerzburg.de/en/fernerkundung/startseite/"><img width="150" height="100" src="https://www.uni-wuerzburg.de/typo3conf/ext/uw_sitepackage/Resources/Public/Images/uni-wuerzburg-logo.svg"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.dlr.de/eoc/en/desktopdefault.aspx/tabid-5278/8856_read-15911/"><img width="115" height="100" src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/f5/DLR_Logo.svg/744px-DLR_Logo.svg.png"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.bmwi.de/Navigation/DE/Home/home.html"><img width="220" height="100" src="https://www.bmwi.de/SiteGlobals/BMWI/StyleBundles/Bilder/bmwi_logo_de.null?__blob=normal&v=9"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.orn.mpg.de/en/"><img width="200" height="100" src="https://www.molgen.mpg.de/188611/mpi_Seew_LogoText-1355515314.gif"></a>
</p>

<br>
