% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveModel.R
\name{moveModel}
\alias{moveModel}
\title{moveModel}
\usage{
moveModel(p.data = p.data, a.data = a.data, label = NULL, fun = fun,
  nruns = 1)
}
\arguments{
\item{p.data}{Object of class \emph{data.frame} with environmental variables for presence samples.}

\item{a.data}{Object of class \emph{data.frame} with environmental variables for background samples.}

\item{label}{Region labels. If missing, "p.data" is assumed as one region.}

\item{fun}{A function with the modeling algorithm to use.}

\item{nruns}{Number of runs. Default is 1.}
}
\value{
A \emph{list}.
}
\description{
Spatially stratified predictive modeling.
}
\details{
{For n iterations, where n is the number of unique sample regions, 
the function uses one sample region for validation while the remaining ones 
are used for training. The background samples are split randomly at each 
iteration. The final accuracy, provided as a F1-score for both presence and 
background sampels, is derived from the total of true and false positives 
(\emph{$f1}). Additionaly, for each run, the function returns a model (\emph{$model}) 
which is trained using all the samples. This output can be passed to modelApply(). 
By default, the function uses a Random Forest classifier. However, the a user specified 
function can be passed using \emph{fun}.}
}
\examples{
\dontrun{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # read remote sensing data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 
 # read movement data
 moveData <- read.csv(system.file('extdata', 'konstanz_20130805-20130811.csv', package="rsMove"))
 moveData <- SpatialPointsDataFrame(moveData[,1:2], moveData, proj4string=crs(rsStk))

 # retrieve remote sensing data for samples
 rsQuery <- dataQuery(xy=moveData,img=rsStk, remove.dup=TRUE)
 
 # identify unique sample regions
 label <- labelSample(xy=rsQuery, rad=3000, pxr=rsStk)
 
 # select background samples
 ind <- which(label>0) # selected samples
 bSamples <- backSample(xy=moveData[ind,], rid=label[ind], img=rsStk, method='pca')
 
 # derive model predictions
 fun <- function(x,y) {train(x, y, method="rf", trControl=trainControl(method='oob'))}
 out <- moveModel(p.data=rsQuery@data, a.data=bSamples@data, label=label, fun=fun, nruns=1)

}
}
\seealso{
\code{\link{sampleMove}} \code{\link{labelSample}} \code{\link{backSample}} \code{\link{modelApply}} \code{\link[caret]{train}}
}
