% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaceDirSample.R
\name{spaceDirSample}
\alias{spaceDirSample}
\title{spaceDirSample}
\usage{
spaceDirSample(xy = xy, ot = ot, img = img, dir = dir, fun = NULL)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{ot}{Object of class \emph{Date}, \emph{POSIXlt} or \emph{POSIXct} with \emph{xy} observation dates.}

\item{img}{Object of class \emph{RasterLayer}.}

\item{dir}{One of \emph{fwd}, \emph{bwd} or \emph{both}. Default is \emph{both}.}

\item{fun}{Summary function.}
}
\value{
A \emph{list}.
}
\description{
Spatial forward and backward sampling of a raster using GPS tracking data.
}
\details{
{This function evaluates how do environmental conditions change in space 
along a movement track. Before an output is returned, the function looks for segments 
of consecutive samples that appear within the same pixel and provides mean values for 
their coordinates and observation times as well as the corresponding pixel value and 
the elapsed time during the segment (in minutes). this step avoids the replication of 
samples while preserving observation related to revisits to the same pixels. Then, for 
each observation, the function looks at it imediate neighbors to define spatial segments 
over which a statistical metric will be estimated. All the pixels between the two endpoints 
of the segment are considered in this process. By defaut, the slope of the linear regression 
between the first and the last observation is returned. The user can use the argument \emph{dir} #
to prompt the function to focus at previous (\emph{bwd}) or following (\emph{fwd}) observations or to 
look in both directions (\emph{both}). The output consists of a list containing two shapefiles, one 
\emph{SpatialPointsDataFrame} (\emph{$endpoints}) with the endpoints of each segment and a 
\emph{SpatialLinesDataFrame} (\emph{$segments}) representing each segment. The data frames provided 
with these shapefiles reports on:
\itemize{
 \item{\emph{x} - mean x coordinates}
 \item{\emph{y} - mean y coordinates}
 \item{\emph{timestamp} - mean observation time}
 \item{\emph{pixel.time} - elapsed time within a pixel for a given segment}
 \item{\emph{travel.distance} - distance between a segment endpoints}
 \item{\emph{travel.time} - elapsed time between a segment endpoints}
 \item{\emph{stat}: statistical metric}
}}
}
\examples{
{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # read movement data
 file <- system.file('extdata', 'konstanz_20130804.shp', package="rsMove")
 moveData <- shapefile(file)
 
 # observation time
 td <- as.Date(moveData@data$date)
 
 # read raster data
 r <- raster(system.file('extdata', 'tcb_1.tif', package="rsMove"))
 
 # perform directional sampling
 of <- function(x,y) {lm(y~x)$coefficients[2]}
 s.sample <- spaceDirSample(xy=moveData, ot=td, img=r, dir="bwd", fun=of)
 
}
}
\seealso{
\code{\link{timeDirSample}} \code{\link{dataQuery}}
}
