% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtx-utils.R
\name{congruence}
\alias{congruence}
\title{Coefficient of factor congruence (phi)}
\usage{
congruence(x, y = NULL)
}
\arguments{
\item{x}{A vector or matrix of factor loadings.}

\item{y}{A vector or matrix of factor loadings (may be NULL).}
}
\value{
A matrix of factor congruences.
}
\description{
The function \code{congruence(x, y)} computes the Tucker's
 congruence (phi) coefficients among two sets of factors.
}
\details{
Find the Tucker's coefficient of congruence between two sets of factor loadings.
 Factor congruences are the cosines of pairs of vectors defined by the loadings matrix
 and based at the origin. Thus, for loadings that differ only by a scaler
 (e.g. the size of the eigen value), the factor congruences will be 1.

 For factor loading vectors of X and Y the measure of factor congruence, phi, is
 \deqn{
 \phi = \frac{\sum X Y}{\sqrt{\sum(X^2)\sum(Y^2)}}
 .}{phi = sum(X Y)/sqrt(sum(X^2) sum(X^2)) }

 If \code{y=NULL} and \code{x} is a numeric matrix, the congruence
 coefficients between the columns of the matrix \code{x} are returned.
 The result is a symmetric matrix with ones on the diagonal. If two matrices
 are provided, they must have the same size and the result is a square matrix containing the
 congruence coefficients between all pairs of columns of the two matrices.
}
\examples{
 X <- getLoadings(PcaClassic(delivery))
 Y <- getLoadings(PcaHubert(delivery, k=3))
 round(congruence(X,Y),3)

}
\references{
L.R Tucker (1951). A method for synthesis of factor analysis studies. Personnel Research Section Report No. 984. Department of the Army, Washington, DC.
}
\author{
Valentin Todorov, \email{valentin.todorov@chello.at}
}
