% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_controller.R
\name{key_inspector_sqlite}
\alias{key_inspector_sqlite}
\title{Return all primary key columns as guess at preferred primary keys for a SQLite handle.}
\usage{
key_inspector_sqlite(db, tablename)
}
\arguments{
\item{db}{database handle}

\item{tablename}{character, name of table}
}
\value{
map of keys to keys
}
\description{
Return all primary key columns as guess at preferred primary keys for a SQLite handle.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbExecute(my_db, "
    CREATE TABLE orgtable (
      eid TEXT,
      date INTEGER,
      dept TEXT,
      location TEXT,
    PRIMARY KEY (eid, date)
    )
    ")
  print(key_inspector_sqlite(my_db, "orgtable"))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{describe_tables}
}
